/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.slidinglayout;

import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.tweenengine.BaseTween;
import aurelienribon.tweenengine.Timeline;
import aurelienribon.tweenengine.Tween;
import aurelienribon.tweenengine.TweenCallback;
import aurelienribon.tweenengine.TweenManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SLTransition {
    private final SLPanel panel;
    private final TweenManager tweenManager;
    private final List<SLKeyframe> keyframes = new ArrayList<SLKeyframe>();
    private int currentKeyframe;
    private Timeline timeline;

    public SLTransition(SLPanel panel, TweenManager tweenManager) {
        this.panel = panel;
        this.tweenManager = tweenManager;
    }

    public SLTransition push(SLKeyframe kf) {
        this.keyframes.add(kf);
        return this;
    }

    public boolean play() {
        if (!this.panel.isTransitionPlaying) {
            this.currentKeyframe = 0;
            this.play(this.keyframes.get(0), new SLKeyframe(this.panel.currentCfg, 0.0f));
            this.panel.isTransitionPlaying = true;
            return true;
        }
        return false;
    }

    private void play(SLKeyframe kf, SLKeyframe previousKf) {
        this.panel.currentCfg = kf.getCfg();
        kf.initialize(previousKf);
        this.tween(kf);
    }

    private void tween(final SLKeyframe kf) {
        if (this.timeline != null) {
            this.timeline.kill();
        }
        this.timeline = Timeline.createParallel();
        for (Component c : kf.getCmps()) {
            SLConfig.Tile t = kf.getTarget(c);
            int dx = c.getX() - t.x;
            int dy = c.getY() - t.y;
            int dw = c.getWidth() - t.w;
            int dh = c.getHeight() - t.h;
            boolean animXY = dx != 0 || dy != 0;
            boolean animWH = dw != 0 || dh != 0;
            float duration = kf.getDuration();
            if (animXY && animWH) {
                this.timeline.push((Tween)Tween.to((Object)c, (int)7, (float)duration).target(new float[]{t.x, t.y, t.w, t.h}).delay(kf.getDelay(c)));
                continue;
            }
            if (animXY) {
                this.timeline.push((Tween)Tween.to((Object)c, (int)3, (float)duration).target((float)t.x, (float)t.y).delay(kf.getDelay(c)));
                continue;
            }
            if (!animWH) continue;
            this.timeline.push((Tween)Tween.to((Object)c, (int)6, (float)duration).target((float)t.w, (float)t.h).delay(kf.getDelay(c)));
        }
        this.timeline.setCallback(new TweenCallback(){

            public void onEvent(int type, BaseTween<?> source) {
                for (Component c : kf.getCmpsToAddAfterTransition()) {
                    SLTransition.this.panel.add(c, new Integer(1));
                }
                for (Component c : kf.getCmpsToRemoveAfterTransition()) {
                    SLTransition.this.panel.remove(c);
                }
                if (kf.getCallback() != null) {
                    kf.getCallback().done();
                }
                if (SLTransition.this.currentKeyframe < SLTransition.this.keyframes.size() - 1) {
                    SLTransition.this.currentKeyframe++;
                    SLTransition.this.play((SLKeyframe)SLTransition.this.keyframes.get(SLTransition.this.currentKeyframe), (SLKeyframe)SLTransition.this.keyframes.get(SLTransition.this.currentKeyframe - 1));
                } else {
                    ((SLTransition)SLTransition.this).panel.isTransitionPlaying = false;
                }
            }
        });
        this.timeline.start(this.tweenManager);
    }
}

