/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.ArProperties;
import aurelienribon.ui.css.DeclarationSet;
import aurelienribon.ui.css.DeclarationSetProcessor;
import aurelienribon.ui.css.Property;
import aurelienribon.ui.utils.PaintUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JLabel;

public class Button
extends JButton {
    private Paint stroke = Color.RED;
    private Paint fill = Color.RED;
    private int strokeThickness = 0;
    private int cornerRadius = 0;
    private final JLabel label = new JLabel();

    public Button() {
        this.setOpaque(false);
        this.updateLabel();
    }

    public Paint getStroke() {
        return this.stroke;
    }

    public Paint getFill() {
        return this.fill;
    }

    public int getStrokeThickness() {
        return this.strokeThickness;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public void setStroke(Paint stroke) {
        this.stroke = stroke;
        this.repaint();
    }

    public void setFill(Paint fill) {
        this.fill = fill;
        this.repaint();
    }

    public void setStrokeThickness(int strokeThickness) {
        this.strokeThickness = strokeThickness;
        this.repaint();
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D gg = (Graphics2D)g.create();
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        double innerGap = (float)this.strokeThickness / 2.0f;
        double innerW = (double)w - innerGap * 2.0;
        double innerH = (double)h - innerGap * 2.0;
        RectangularShape rect = this.cornerRadius > 0 ? new RoundRectangle2D.Double(innerGap, innerGap, innerW, innerH, this.cornerRadius, this.cornerRadius) : new Rectangle2D.Double(innerGap, innerGap, innerW, innerH);
        gg.setPaint(PaintUtils.buildPaint(this.fill, innerGap, innerGap, innerW, innerH));
        gg.fill(rect);
        if (this.strokeThickness > 0) {
            gg.setStroke(new BasicStroke(this.strokeThickness));
            gg.setPaint(PaintUtils.buildPaint(this.stroke, 0.0, 0.0, w, h));
            gg.draw(rect);
        }
        this.updateLabel();
        Insets m = this.getMargin();
        gg.translate(m.left, m.top);
        this.label.setSize(w - m.left - m.right, h - m.top - m.bottom);
        this.label.paint(gg);
        gg.dispose();
    }

    private void updateLabel() {
        this.label.setForeground(this.getForeground());
        this.label.setFont(this.getFont());
        this.label.setText(this.getText());
        this.label.setIcon(this.getIcon());
        this.label.setHorizontalAlignment(this.getHorizontalAlignment());
        this.label.setVerticalAlignment(this.getVerticalAlignment());
        this.label.setHorizontalTextPosition(this.getHorizontalTextPosition());
        this.label.setVerticalTextPosition(this.getVerticalTextPosition());
    }

    public static class Processor
    implements DeclarationSetProcessor<Button>,
    ArProperties {
        @Override
        public void process(Button target, DeclarationSet ds) {
            Property p = stroke;
            if (ds.contains(p)) {
                target.setStroke(ds.getValue(p, Paint.class));
            }
            if (ds.contains(p = fill)) {
                target.setFill(ds.getValue(p, Paint.class));
            }
            if (ds.contains(p = corderRadius)) {
                target.setCornerRadius(ds.getValue(p, Integer.class));
            }
            if (ds.contains(p = strokeThickness)) {
                target.setStrokeThickness(ds.getValue(p, Integer.class));
            }
        }
    }
}

