/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.PaintedPanel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImagePreviewPanel
extends PaintedPanel {
    private BufferedImage image;
    private Rectangle region;

    public void setImage(BufferedImage bi) {
        this.image = bi;
        this.region = null;
        this.repaint();
    }

    public void setImage(URL url) throws IOException {
        this.setImage(ImageIO.read(url));
    }

    public void setImage(File file) throws IOException {
        this.setImage(ImageIO.read(file));
    }

    public void setRegion(int regionX, int regionY, int regionW, int regionH) {
        this.region = new Rectangle(regionX, regionY, regionW, regionH);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Rectangle getRegion() {
        return this.region;
    }

    public void clearImage() {
        this.image = null;
        this.region = null;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gg = (Graphics2D)g.create();
        int w = this.getWidth();
        int h = this.getHeight();
        float panelRatio = (float)w / (float)h;
        if (this.image != null && this.region == null) {
            float imgRatio = (float)this.image.getWidth() / (float)this.image.getHeight();
            if (imgRatio > panelRatio) {
                int tw = w;
                int th = w * this.image.getHeight() / this.image.getWidth();
                gg.drawImage(this.image, 0, (h - th) / 2, tw, th, null);
            } else {
                int tw = h * this.image.getWidth() / this.image.getHeight();
                int th = h;
                gg.drawImage(this.image, (w - tw) / 2, 0, tw, th, null);
            }
        } else if (this.image != null && this.region != null) {
            float imgRatio = (float)this.region.width / (float)this.region.height;
            if (imgRatio > panelRatio) {
                int tw = w;
                int th = w * this.image.getHeight() / this.image.getWidth();
                int tx = 0;
                int ty = (h - th) / 2;
                gg.drawImage(this.image, tx, ty, tx + tw, ty + th, this.region.x, this.region.y, this.region.x + this.region.width, this.region.y + this.region.width, null);
            } else {
                int tw = h * this.image.getWidth() / this.image.getHeight();
                int th = h;
                int tx = (w - tw) / 2;
                int ty = 0;
                gg.drawImage(this.image, tx, ty, tx + tw, ty + th, this.region.x, this.region.y, this.region.x + this.region.width, this.region.y + this.region.width, null);
            }
        }
        gg.dispose();
    }
}

