/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.ArProperties;
import aurelienribon.ui.components.TabPanelHeaderPanel;
import aurelienribon.ui.components.TabPanelHeaderSubPanel;
import aurelienribon.ui.components.TabPanelModel;
import aurelienribon.ui.components.TransparentPanel;
import aurelienribon.ui.css.DeclarationSet;
import aurelienribon.ui.css.DeclarationSetProcessor;
import aurelienribon.ui.css.Selector;
import aurelienribon.ui.css.Style;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class TabPanel
extends JPanel {
    public static final int LAYOUT_STACK = 0;
    public static final int LAYOUT_GRID = 1;
    private final Map<TabPanelModel.TabModel, String> cardsMap = new HashMap<TabPanelModel.TabModel, String>();
    private final TabPanelHeaderPanel headerPanel = new TabPanelHeaderPanel(0, new TabHeaderPanelCallbackImpl());
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel cardPanel = new TransparentPanel(this.cardLayout);
    private TabPanelModel model;
    private int cnt = 0;
    private Style style;
    private List<Selector.Atom> styleStack;

    public TabPanel() {
        this.setPreferredSize(new Dimension(50, 50));
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.cardPanel, "Center");
        this.setOpaque(false);
        this.setModel(new TabPanelModel());
        Style.registerCssClasses(this.cardPanel, ".-ar-content");
        Style.registerCssClasses(this.headerPanel, ".-ar-header");
    }

    public void setHeaderLayout(int layout) {
        if (layout < 0 || layout > 1) {
            return;
        }
        this.headerPanel.setTabsLayout(layout);
    }

    public int getHeaderLayout() {
        return this.headerPanel.getTabsLayout();
    }

    public void setModel(final TabPanelModel model) {
        this.cardPanel.removeAll();
        this.headerPanel.removeAllTabs();
        this.model = model;
        model.setCallback(new TabPanelModel.Callback(){

            @Override
            public void tabAdded(TabPanelModel.TabModel tm, int idx) {
                TabPanel.this.cardsMap.put(tm, "card" + TabPanel.this.cnt++);
                TabPanel.this.cardPanel.add(tm.component, TabPanel.this.cardsMap.get(tm));
                TabPanel.this.headerPanel.addTab(tm);
                if (model.getSelectedTabModel() == null) {
                    TabPanel.this.selectLastModel();
                }
                Style.registerCssClasses(tm.component, ".-ar-tabcontent");
                Style.apply(tm.component, TabPanel.this.style, TabPanel.this.styleStack);
            }

            @Override
            public void tabRemoved(TabPanelModel.TabModel tm, int idx) {
                TabPanel.this.cardsMap.remove(tm);
                TabPanel.this.cardPanel.remove(tm.component);
                TabPanel.this.headerPanel.removeTab(tm);
                if (model.getSelectedTabModel() == null) {
                    TabPanel.this.selectLastModel();
                }
                Style.unregisterCssClasses(tm.component, ".-ar-tabcontent");
            }

            @Override
            public void selectionChanged(TabPanelModel.TabModel tm, int idx) {
                TabPanel.this.cardLayout.show(TabPanel.this.cardPanel, (String)TabPanel.this.cardsMap.get(tm));
                TabPanel.this.headerPanel.reload();
                if (tm != null) {
                    tm.component.requestFocusInWindow();
                }
                for (TabPanelHeaderSubPanel subPanel : TabPanel.this.headerPanel.getSubPanels()) {
                    if (subPanel.getModel() == tm) {
                        subPanel.firePropertyChange("selected", false, true);
                        continue;
                    }
                    subPanel.firePropertyChange("selected", true, false);
                }
            }
        });
        for (TabPanelModel.TabModel tm : model.getTabModels()) {
            this.cardsMap.put(tm, "card" + this.cnt++);
            this.cardPanel.add(tm.component, this.cardsMap.get(tm));
            this.headerPanel.addTab(tm);
        }
        if (model.getSelectedTabModel() == null) {
            model.setSelection(0);
        }
    }

    public TabPanelModel getModel() {
        return this.model;
    }

    @Override
    public void setBackground(Color bg) {
        if (this.cardPanel != null) {
            this.cardPanel.setBackground(bg);
        }
    }

    @Override
    public void setBorder(Border border) {
        if (this.cardPanel != null) {
            this.cardPanel.setBorder(border);
        }
    }

    private void selectModel(TabPanelModel.TabModel tm) {
        this.model.setSelection(tm != null ? tm.component : null);
    }

    private void selectLastModel() {
        if (this.model.getTabModels().isEmpty()) {
            this.selectModel(null);
        } else {
            this.selectModel(this.model.getTabModels().get(this.model.getTabModels().size() - 1));
        }
    }

    public static class Processor
    implements DeclarationSetProcessor<TabPanel>,
    ArProperties {
        @Override
        public void process(TabPanel target, DeclarationSet ds) {
            target.style = ds.getStyle();
            target.styleStack = new ArrayList<Selector.Atom>(Style.getLastStack());
        }
    }

    private class TabHeaderPanelCallbackImpl
    implements TabPanelHeaderPanel.Callback {
        private TabHeaderPanelCallbackImpl() {
        }

        @Override
        public void selectTabRequested(TabPanelModel.TabModel tm) {
            TabPanel.this.selectModel(tm);
        }

        @Override
        public void closeTabRequested(TabPanelModel.TabModel tm) {
            if (tm.closable) {
                TabPanel.this.model.remove(tm.component);
            }
        }

        @Override
        public void closeAllTabsRequested() {
            for (int i = TabPanel.this.model.getTabModels().size() - 1; i >= 0; --i) {
                TabPanelModel.TabModel tm = TabPanel.this.model.getTabModels().get(i);
                if (!tm.closable) continue;
                TabPanel.this.model.remove(tm.component);
            }
        }

        @Override
        public void closeOtherTabsRequested(TabPanelModel.TabModel tm) {
            for (int i = TabPanel.this.model.getTabModels().size() - 1; i >= 0; --i) {
                TabPanelModel.TabModel tm2 = TabPanel.this.model.getTabModels().get(i);
                if (!tm2.closable || tm2 == tm) continue;
                TabPanel.this.model.remove(tm2.component);
            }
        }
    }
}

