/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.ArProperties;
import aurelienribon.ui.components.TabPanelHeaderSubPanel;
import aurelienribon.ui.components.TabPanelModel;
import aurelienribon.ui.css.DeclarationSet;
import aurelienribon.ui.css.DeclarationSetProcessor;
import aurelienribon.ui.css.Property;
import aurelienribon.ui.css.Selector;
import aurelienribon.ui.css.Style;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLayeredPane;

class TabPanelHeaderPanel
extends JLayeredPane {
    private static final int MAX_HEIGHT = 20;
    private static final int MIN_HEIGHT = 1;
    private static final int OVERLAP = 1;
    private static final int SELECTED_LAYER = Integer.MAX_VALUE;
    private final List<TabPanelHeaderSubPanel> subPanels = new ArrayList<TabPanelHeaderSubPanel>();
    private final Callback callback;
    private int tabsLayout;
    private Paint stroke = Color.RED;
    private Style style;
    private List<Selector.Atom> styleStack;

    public TabPanelHeaderPanel(int layout, Callback callback) {
        this.tabsLayout = layout;
        this.callback = callback;
        this.setOpaque(false);
        this.setHeight(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TabPanelHeaderPanel.this.reload();
            }
        });
    }

    public void setTabsLayout(int tabsLayout) {
        this.tabsLayout = tabsLayout;
        this.reload();
    }

    public int getTabsLayout() {
        return this.tabsLayout;
    }

    public List<TabPanelHeaderSubPanel> getSubPanels() {
        return Collections.unmodifiableList(this.subPanels);
    }

    public void addTab(TabPanelModel.TabModel tm) {
        TabPanelHeaderSubPanel subPanel = new TabPanelHeaderSubPanel(tm, new TabPanelHeaderSubPanel.Callback(){

            @Override
            public void selectRequested(TabPanelModel.TabModel tm) {
                TabPanelHeaderPanel.this.callback.selectTabRequested(tm);
            }

            @Override
            public void closeRequested(TabPanelModel.TabModel tm) {
                TabPanelHeaderPanel.this.callback.closeTabRequested(tm);
                TabPanelHeaderPanel.this.reload();
            }

            @Override
            public void closeAllRequested() {
                TabPanelHeaderPanel.this.callback.closeAllTabsRequested();
                TabPanelHeaderPanel.this.reload();
            }

            @Override
            public void closeOthersRequested(TabPanelModel.TabModel tm) {
                TabPanelHeaderPanel.this.callback.closeOtherTabsRequested(tm);
                TabPanelHeaderPanel.this.reload();
            }
        });
        this.add(subPanel);
        this.subPanels.add(subPanel);
        this.reload();
        this.setHeight(20);
        Style.registerCssClasses(subPanel, ".-ar-tab");
        if (this.style != null) {
            Style.apply(subPanel, this.style, this.styleStack);
        }
    }

    public void removeTab(TabPanelModel.TabModel model) {
        TabPanelHeaderSubPanel subPanel = this.findSubPanel(model);
        this.subPanels.remove(subPanel);
        this.remove(subPanel);
        if (this.subPanels.isEmpty()) {
            this.setHeight(1);
        }
        this.revalidate();
        this.repaint();
        Style.unregisterAllCssClasses(subPanel);
    }

    public void removeAllTabs() {
        this.subPanels.clear();
        this.removeAll();
        this.setHeight(1);
        this.revalidate();
        this.repaint();
    }

    public void reload() {
        int i;
        int layout = this.tabsLayout;
        if (layout == 0) {
            int totalWidth = 1;
            for (i = 0; i < this.subPanels.size(); ++i) {
                totalWidth += this.subPanels.get((int)i).getPreferredSize().width - 1;
            }
            if (totalWidth > this.getWidth()) {
                layout = 1;
            }
        }
        int width = 0;
        block5: for (i = 0; i < this.subPanels.size(); ++i) {
            TabPanelHeaderSubPanel subPanel = this.subPanels.get(i);
            this.setLayer(subPanel, subPanel.getModel().selected ? Integer.MAX_VALUE : i);
            switch (layout) {
                case 0: {
                    subPanel.setBounds(width, 0, subPanel.getPreferredSize().width, 20);
                    subPanel.revalidate();
                    subPanel.repaint();
                    width += subPanel.getPreferredSize().width - 1;
                    continue block5;
                }
                case 1: {
                    int w = i < this.subPanels.size() - 1 ? this.getWidth() / this.subPanels.size() : this.getWidth() - width;
                    subPanel.setBounds(width, 0, w, 20);
                    subPanel.revalidate();
                    subPanel.repaint();
                    width += subPanel.getWidth() - 1;
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gg = (Graphics2D)g.create();
        if (this.stroke != null) {
            gg.setPaint(this.stroke);
            gg.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
        gg.dispose();
    }

    private void setHeight(int h) {
        this.setMinimumSize(new Dimension(20, h));
        this.setPreferredSize(new Dimension(20, h));
        this.setMaximumSize(new Dimension(20, h));
        this.revalidate();
    }

    private TabPanelHeaderSubPanel findSubPanel(TabPanelModel.TabModel model) {
        for (TabPanelHeaderSubPanel subPanel : this.subPanels) {
            if (subPanel.getModel() != model) continue;
            return subPanel;
        }
        return null;
    }

    public static class Processor
    implements DeclarationSetProcessor<TabPanelHeaderPanel>,
    ArProperties {
        @Override
        public void process(TabPanelHeaderPanel target, DeclarationSet ds) {
            target.style = ds.getStyle();
            target.styleStack = new ArrayList<Selector.Atom>(Style.getLastStack());
            Property p = stroke;
            if (ds.contains(p)) {
                target.stroke = ds.getValue(p, Paint.class);
            }
        }
    }

    public static interface Callback {
        public void selectTabRequested(TabPanelModel.TabModel var1);

        public void closeTabRequested(TabPanelModel.TabModel var1);

        public void closeAllTabsRequested();

        public void closeOtherTabsRequested(TabPanelModel.TabModel var1);
    }
}

