/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;

public class TabPanelModel {
    private final List<TabModel> tabModels = new ArrayList<TabModel>();
    private Callback callback;

    public void add(Component cmp, String title) {
        this.add(cmp, title, null, true);
    }

    public void add(Component cmp, String title, ImageIcon icon) {
        this.add(cmp, title, icon, true);
    }

    public void add(Component cmp, String title, ImageIcon icon, boolean closable) {
        TabModel tm = new TabModel(cmp, title, icon, closable);
        this.tabModels.add(tm);
        if (this.callback != null) {
            this.callback.tabAdded(tm, this.tabModels.indexOf(tm));
        }
    }

    public void remove(Component cmp) {
        this.remove(this.tabModels.indexOf(this.findTabModel(cmp)));
    }

    public void remove(int idx) {
        if (idx >= 0 && idx < this.tabModels.size()) {
            TabModel tm = this.tabModels.remove(idx);
            if (this.callback != null) {
                this.callback.tabRemoved(tm, idx);
            }
        }
    }

    public int getTabsCount() {
        return this.tabModels.size();
    }

    public void setSelection(Component cmp) {
        this.setSelection(this.tabModels.indexOf(this.findTabModel(cmp)));
    }

    public void setSelection(int idx) {
        for (TabModel tm : this.tabModels) {
            tm.selected = false;
        }
        if (idx >= 0 && idx < this.tabModels.size()) {
            TabModel tm = this.tabModels.get(idx);
            tm.selected = true;
            if (this.callback != null) {
                this.callback.selectionChanged(tm, idx);
            }
        } else if (this.callback != null) {
            this.callback.selectionChanged(null, -1);
        }
    }

    List<TabModel> getTabModels() {
        return Collections.unmodifiableList(this.tabModels);
    }

    void setCallback(Callback callback) {
        this.callback = callback;
    }

    TabModel getSelectedTabModel() {
        for (TabModel tm : this.tabModels) {
            if (!tm.selected) continue;
            return tm;
        }
        return null;
    }

    private TabModel findTabModel(Component cmp) {
        for (TabModel tm : this.tabModels) {
            if (tm.component != cmp) continue;
            return tm;
        }
        return null;
    }

    static interface Callback {
        public void tabAdded(TabModel var1, int var2);

        public void tabRemoved(TabModel var1, int var2);

        public void selectionChanged(TabModel var1, int var2);
    }

    class TabModel {
        public final Component component;
        public String title;
        public ImageIcon icon;
        public boolean closable;
        public boolean selected = false;

        public TabModel(Component cmp, String title, ImageIcon icon, boolean closable) {
            this.component = cmp;
            this.title = title;
            this.icon = icon;
            this.closable = closable;
        }
    }
}

