/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css;

import aurelienribon.ui.css.Function;
import aurelienribon.ui.css.Property;
import aurelienribon.ui.css.Rule;
import aurelienribon.ui.css.Selector;
import aurelienribon.ui.css.Style;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DeclarationSet {
    private final Style style;
    private final List<Property> properties;
    private final Map<Property, List<Object>> propertiesValues;

    public static Map<String, DeclarationSet> dss(Style style, Object target, List<Selector.Atom> stack) {
        LinkedHashMap<String, DeclarationSet> dss = new LinkedHashMap<String, DeclarationSet>();
        ArrayList<String> pseudoClassesToTry = new ArrayList<String>();
        ArrayList<String> pseudoClassesTried = new ArrayList<String>();
        pseudoClassesToTry.add("");
        while (!pseudoClassesToTry.isEmpty()) {
            String pseudoClass = (String)pseudoClassesToTry.remove(0);
            pseudoClassesTried.add(pseudoClass);
            ArrayList<Property> properties = new ArrayList<Property>();
            HashMap<Property, List<Object>> propertiesValues = new HashMap<Property, List<Object>>();
            for (Rule rule : style.getRules()) {
                assert (rule != null);
                assert (rule.getDeclarations() != null);
                if (!DeclarationSet.isTargetValid(rule.getSelector(), target) || !DeclarationSet.isStackValid(rule.getSelector(), stack)) continue;
                String rulePseudoClass = rule.getSelector().getPseudoClass();
                if (!rulePseudoClass.equals(pseudoClass)) {
                    if (pseudoClassesTried.contains(rulePseudoClass)) continue;
                    pseudoClassesToTry.add(rulePseudoClass);
                    continue;
                }
                properties.addAll(rule.getDeclarations().getProperties());
                for (Property property : rule.getDeclarations().getProperties()) {
                    assert (rule.getDeclarations().getValue(property) != null);
                    ArrayList<Object> value = new ArrayList<Object>();
                    value.addAll(rule.getDeclarations().getValue(property));
                    propertiesValues.put(property, value);
                }
            }
            if (properties.isEmpty()) continue;
            DeclarationSet ds = new DeclarationSet(style, properties, propertiesValues);
            dss.put(pseudoClass, ds);
        }
        return dss;
    }

    public DeclarationSet(Style style, List<Property> properties, Map<Property, List<Object>> propertiesValues) {
        this.style = style;
        this.properties = Collections.unmodifiableList(new ArrayList<Property>(properties));
        this.propertiesValues = Collections.unmodifiableMap(new HashMap<Property, List<Object>>(propertiesValues));
    }

    public DeclarationSet(Style style, Object target, List<Selector.Atom> stack, String pseudoClass) {
        ArrayList<Property> tProperties = new ArrayList<Property>();
        HashMap tPropertiesValues = new HashMap();
        for (Rule rule : style.getRules()) {
            assert (rule != null);
            assert (rule.getDeclarations() != null);
            if (!rule.getSelector().getPseudoClass().equals(pseudoClass) || !DeclarationSet.isTargetValid(rule.getSelector(), target) || !DeclarationSet.isStackValid(rule.getSelector(), stack)) continue;
            tProperties.addAll(rule.getDeclarations().getProperties());
            for (Property property : rule.getDeclarations().getProperties()) {
                assert (rule.getDeclarations().getValue(property) != null);
                ArrayList<Object> value = new ArrayList<Object>();
                value.addAll(rule.getDeclarations().getValue(property));
                tPropertiesValues.put(property, value);
            }
        }
        this.style = style;
        this.properties = Collections.unmodifiableList(tProperties);
        this.propertiesValues = Collections.unmodifiableMap(tPropertiesValues);
    }

    public DeclarationSet(DeclarationSet ds, Property[] propertiesToKeep) {
        ArrayList<Property> tProperties = new ArrayList<Property>();
        HashMap<Property, List<Object>> tPropertiesValues = new HashMap<Property, List<Object>>();
        for (Property property : propertiesToKeep) {
            if (!ds.getProperties().contains(property)) continue;
            tProperties.add(property);
            tPropertiesValues.put(property, ds.getValue(property));
        }
        this.style = ds.getStyle();
        this.properties = Collections.unmodifiableList(new ArrayList(tProperties));
        this.propertiesValues = Collections.unmodifiableMap(new HashMap(tPropertiesValues));
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Map<Property, List<Object>> getPropertiesValues() {
        return this.propertiesValues;
    }

    public List<Object> getValue(Property property) {
        return this.propertiesValues.get(property);
    }

    public <T> T getValue(Property property, Class<T> paramClass) {
        return (T)this.getValue(property).get(0);
    }

    public <T> T getValue(Property property, Class<T> paramClass, Function function) {
        List<Object> params = this.getValue(property);
        Object param = this.getValue(property).get(0);
        if (paramClass.isInstance(param)) {
            return (T)param;
        }
        return (T)function.process(params);
    }

    public boolean contains(Property property) {
        return this.properties.contains(property);
    }

    public boolean isAfter(Property p1, Property p2) {
        return this.properties.indexOf(p1) > this.properties.indexOf(p2);
    }

    void replaceValueParam(Property property, int paramIdx, Object param) {
        this.propertiesValues.get(property).set(paramIdx, param);
    }

    private static boolean isTargetValid(Selector selector, Object target) {
        if (!selector.getLastAtom().getType().isAssignableFrom(target.getClass())) {
            return false;
        }
        List<String> targetClasses = Style.getRegisteredTargetClassNames(target);
        for (String clazz : selector.getLastAtom().getClasses()) {
            if (targetClasses.contains(clazz)) continue;
            return false;
        }
        return true;
    }

    private static boolean isStackValid(Selector selector, List<Selector.Atom> stack) {
        int previousStackIdx = -1;
        int stackIdx = -1;
        for (int i = 0; i < selector.getAtoms().size() - 1; ++i) {
            Selector.Atom selectorAtom = selector.getAtoms().get(i);
            stackIdx = DeclarationSet.getNextValidStackIdx(selectorAtom, stack, stackIdx + 1);
            if (stackIdx == -1) {
                return false;
            }
            if (selectorAtom.isStrictNext() && stackIdx - previousStackIdx != 1) {
                return false;
            }
            previousStackIdx = stackIdx;
        }
        return !selector.getLastAtom().isStrictNext() || stack.size() - stackIdx == 1;
    }

    private static int getNextValidStackIdx(Selector.Atom selectorAtom, List<Selector.Atom> stack, int from) {
        for (int i = from; i < stack.size(); ++i) {
            Selector.Atom stackAtom = stack.get(i);
            if (!selectorAtom.getType().isAssignableFrom(stackAtom.getType()) || !DeclarationSet.includes(stackAtom.getClasses(), selectorAtom.getClasses())) continue;
            return i;
        }
        return -1;
    }

    private static boolean includes(List<String> strs1, List<String> strs2) {
        for (String str : strs2) {
            if (strs1.contains(str)) continue;
            return false;
        }
        return true;
    }
}

