/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Selector {
    private final List<Atom> atoms = new ArrayList<Atom>();
    private final String pseudoClass;

    public Selector(String rawSelector) {
        rawSelector = rawSelector.trim();
        rawSelector = rawSelector.replaceAll("\\s+", " ");
        rawSelector = rawSelector.replaceAll("\\s*>\\s*", " >");
        int pcIdx = rawSelector.indexOf(":");
        if (pcIdx > -1) {
            this.pseudoClass = rawSelector.substring(pcIdx).trim();
            rawSelector = rawSelector.substring(0, pcIdx);
        } else {
            this.pseudoClass = "";
        }
        String[] parts = rawSelector.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            this.atoms.add(new Atom(parts[i]));
        }
    }

    public List<Atom> getAtoms() {
        return this.atoms;
    }

    public Atom getLastAtom() {
        return this.atoms.get(this.atoms.size() - 1);
    }

    public String getPseudoClass() {
        return this.pseudoClass;
    }

    public String toString() {
        String str = "";
        for (Atom atom : this.atoms) {
            str = str + atom.toString() + " > ";
        }
        return str.substring(0, str.length() - 3);
    }

    public static class Atom {
        private final Class<?> type;
        private final List<String> classes;
        private final boolean strictNext;

        public Atom(String str) {
            String[] parts;
            this.strictNext = str.startsWith(">");
            str = str.replaceAll(">", "");
            str = str.replaceAll("#", ".");
            String[] stringArray = parts = str.startsWith(".") ? str.substring(1).split("\\.") : str.split("\\.");
            if (parts[0].equals("*")) {
                this.type = Object.class;
                this.classes = Arrays.asList(parts).subList(1, parts.length);
            } else if (str.startsWith(".")) {
                this.type = Object.class;
                this.classes = Arrays.asList(parts);
            } else {
                try {
                    this.type = Class.forName(parts[0].replaceAll("-", "."));
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                this.classes = Arrays.asList(parts).subList(1, parts.length);
            }
        }

        public Atom(Class<?> type, List<String> classes) {
            this.type = type;
            this.classes = classes == null ? new ArrayList() : classes;
            this.strictNext = false;
        }

        public Class<?> getType() {
            return this.type;
        }

        public List<String> getClasses() {
            return this.classes;
        }

        public boolean isStrictNext() {
            return this.strictNext;
        }

        public String toString() {
            String str = this.type.getSimpleName();
            for (String c : this.classes) {
                str = str + " " + c;
            }
            return str;
        }
    }
}

