/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.graphics.g2d.tiled.TileAtlas;
import com.badlogic.gdx.graphics.g2d.tiled.TiledMap;
import com.badlogic.gdx.utils.Array;

public class TileAtlasLoader
extends AsynchronousAssetLoader<TileAtlas, TileAtlasParameter> {
    public TileAtlasLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, TileAtlasParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Missing TileAtlasParameter: " + fileName);
        }
    }

    @Override
    public TileAtlas loadSync(AssetManager manager, String fileName, TileAtlasParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Missing TileAtlasParameter: " + fileName);
        }
        return null;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, TileAtlasParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Missing TileAtlasParameter: " + fileName);
        }
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        deps.add(new AssetDescriptor<TiledMap>(parameter.tileMapFile, TiledMap.class));
        return deps;
    }

    public static class TileAtlasParameter
    extends AssetLoaderParameters<TileAtlas> {
        public String tileMapFile;
        public String inputDirectory;
    }
}

