/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.List;

public class Animation {
    final TextureRegion[] keyFrames;
    public final float frameDuration;
    public final float animationDuration;

    public Animation(float frameDuration, List keyFrames) {
        this.frameDuration = frameDuration;
        this.animationDuration = frameDuration * (float)keyFrames.size();
        this.keyFrames = new TextureRegion[keyFrames.size()];
        int n = keyFrames.size();
        for (int i = 0; i < n; ++i) {
            this.keyFrames[i] = (TextureRegion)keyFrames.get(i);
        }
    }

    public Animation(float frameDuration, TextureRegion ... keyFrames) {
        this.frameDuration = frameDuration;
        this.keyFrames = keyFrames;
        this.animationDuration = frameDuration * (float)keyFrames.length;
    }

    public TextureRegion getKeyFrame(float stateTime, boolean looping) {
        int frameNumber = (int)(stateTime / this.frameDuration);
        frameNumber = !looping ? Math.min(this.keyFrames.length - 1, frameNumber) : (frameNumber %= this.keyFrames.length);
        return this.keyFrames[frameNumber];
    }

    public boolean isAnimationFinished(float stateTime) {
        int frameNumber = (int)(stateTime / this.frameDuration);
        return this.keyFrames.length - 1 < frameNumber;
    }
}

