/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class Delay
extends Action {
    static final ActionResetingPool<Delay> pool = new ActionResetingPool<Delay>(4, 100){

        @Override
        protected Delay newObject() {
            return new Delay();
        }
    };
    protected Actor target;
    protected float taken;
    protected float duration;
    protected Action action;

    public static Delay $(Action action, float duration) {
        Delay delay = (Delay)pool.obtain();
        delay.duration = duration;
        delay.action = action;
        return delay;
    }

    public static Delay $(float duration) {
        Delay delay = (Delay)pool.obtain();
        delay.duration = duration;
        delay.action = null;
        return delay;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void setTarget(Actor actor) {
        if (this.action != null) {
            this.action.setTarget(actor);
        }
        this.target = actor;
        this.taken = 0.0f;
    }

    @Override
    public void act(float delta) {
        this.taken += delta;
        if (this.taken > this.duration) {
            this.callActionCompletedListener();
            if (this.action != null) {
                this.action.act(delta);
                if (this.action.isDone()) {
                    this.action.callActionCompletedListener();
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        if (this.action != null) {
            return this.taken > this.duration && this.action.isDone();
        }
        return this.taken > this.duration;
    }

    @Override
    public void finish() {
        pool.free(this);
        if (this.action != null) {
            this.action.finish();
        }
        super.finish();
    }

    @Override
    public Action copy() {
        if (this.action != null) {
            return Delay.$(this.action.copy(), this.duration);
        }
        return Delay.$(this.duration);
    }

    @Override
    public Actor getTarget() {
        return this.target;
    }
}

