/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class FadeOut
extends AnimationAction {
    private static final ActionResetingPool<FadeOut> pool = new ActionResetingPool<FadeOut>(4, 100){

        @Override
        protected FadeOut newObject() {
            return new FadeOut();
        }
    };
    protected float startAlpha = 0.0f;
    protected float deltaAlpha = 0.0f;

    public static FadeOut $(float duration) {
        FadeOut action = (FadeOut)pool.obtain();
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startAlpha = this.target.color.a;
        this.deltaAlpha = -this.target.color.a;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        this.target.color.a = this.done ? 0.0f : this.startAlpha + this.deltaAlpha * alpha;
    }

    @Override
    public void finish() {
        super.finish();
        pool.free(this);
    }

    @Override
    public Action copy() {
        FadeOut fadeOut = FadeOut.$(this.duration);
        if (this.interpolator != null) {
            fadeOut.setInterpolator(this.interpolator.copy());
        }
        return fadeOut;
    }
}

