/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class MoveBy
extends AnimationAction {
    private static final ActionResetingPool<MoveBy> pool = new ActionResetingPool<MoveBy>(4, 100){

        @Override
        protected MoveBy newObject() {
            return new MoveBy();
        }
    };
    protected float initialX;
    protected float initialY;
    protected float x;
    protected float y;
    protected float startX;
    protected float startY;
    protected float deltaX;
    protected float deltaY;

    public static MoveBy $(float x, float y, float duration) {
        MoveBy action = (MoveBy)pool.obtain();
        action.x = action.initialX = x;
        action.y = action.initialY = y;
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startX = this.target.x;
        this.startY = this.target.y;
        this.deltaX = this.x;
        this.deltaY = this.y;
        this.x = this.target.x + this.x;
        this.y = this.target.y + this.y;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        if (this.done) {
            this.target.x = this.x;
            this.target.y = this.y;
        } else {
            this.target.x = this.startX + this.deltaX * alpha;
            this.target.y = this.startY + this.deltaY * alpha;
        }
    }

    @Override
    public void finish() {
        super.finish();
        pool.free(this);
    }

    @Override
    public Action copy() {
        MoveBy moveBy = MoveBy.$(this.initialX, this.initialY, this.duration);
        if (this.interpolator != null) {
            moveBy.setInterpolator(this.interpolator.copy());
        }
        return moveBy;
    }
}

