/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.CompositeAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class Parallel
extends CompositeAction {
    static final ActionResetingPool<Parallel> pool = new ActionResetingPool<Parallel>(4, 100){

        @Override
        protected Parallel newObject() {
            return new Parallel();
        }
    };
    protected boolean[] finished;
    protected Actor target = null;

    public static Parallel $(Action ... actions) {
        int i;
        Parallel parallel = (Parallel)pool.obtain();
        parallel.actions.clear();
        if (parallel.finished == null || parallel.finished.length < actions.length) {
            parallel.finished = new boolean[actions.length];
        }
        int len = actions.length;
        for (i = 0; i < len; ++i) {
            parallel.finished[i] = false;
        }
        len = actions.length;
        for (i = 0; i < len; ++i) {
            parallel.actions.add(actions[i]);
        }
        return parallel;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        int len = this.actions.size();
        for (int i = 0; i < len; ++i) {
            ((Action)this.actions.get(i)).setTarget(actor);
        }
    }

    @Override
    public void act(float delta) {
        int len = this.actions.size();
        boolean allDone = true;
        for (int i = 0; i < len; ++i) {
            Action action = (Action)this.actions.get(i);
            if (!action.isDone()) {
                action.act(delta);
                allDone = false;
                continue;
            }
            if (this.finished[i]) continue;
            action.finish();
            this.finished[i] = true;
            allDone &= this.finished[i];
        }
        if (allDone) {
            this.callActionCompletedListener();
        }
    }

    @Override
    public boolean isDone() {
        int len = this.actions.size();
        for (int i = 0; i < len; ++i) {
            if (((Action)this.actions.get(i)).isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void finish() {
        pool.free(this);
        int len = this.actions.size();
        for (int i = 0; i < len; ++i) {
            if (this.finished[i]) continue;
            ((Action)this.actions.get(i)).finish();
        }
        super.finish();
    }

    @Override
    public Action copy() {
        int i;
        Parallel parallel = (Parallel)pool.obtain();
        parallel.actions.clear();
        if (parallel.finished == null || parallel.finished.length < this.actions.size()) {
            parallel.finished = new boolean[this.actions.size()];
        }
        int len = this.actions.size();
        for (i = 0; i < len; ++i) {
            parallel.finished[i] = false;
        }
        len = this.actions.size();
        for (i = 0; i < len; ++i) {
            parallel.actions.add(((Action)this.actions.get(i)).copy());
        }
        return parallel;
    }

    @Override
    public Actor getTarget() {
        return this.target;
    }
}

