/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class RotateBy
extends AnimationAction {
    private static final ActionResetingPool<RotateBy> pool = new ActionResetingPool<RotateBy>(4, 100){

        @Override
        protected RotateBy newObject() {
            return new RotateBy();
        }
    };
    protected float rotation;
    protected float startRotation;
    protected float deltaRotation;

    public static RotateBy $(float rotation, float duration) {
        RotateBy action = (RotateBy)pool.obtain();
        action.rotation = rotation;
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startRotation = this.target.rotation;
        this.deltaRotation = this.rotation;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        this.target.rotation = this.done ? this.startRotation + this.rotation : this.startRotation + this.deltaRotation * alpha;
    }

    @Override
    public void finish() {
        super.finish();
        pool.free(this);
    }

    @Override
    public Action copy() {
        RotateBy rotateBy = RotateBy.$(this.rotation, this.duration);
        if (this.interpolator != null) {
            rotateBy.setInterpolator(this.interpolator.copy());
        }
        return rotateBy;
    }
}

