/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.interpolators;

import com.badlogic.gdx.scenes.scene2d.Interpolator;
import com.badlogic.gdx.utils.Pool;

public class AccelerateInterpolator
implements Interpolator {
    private static final float DEFAULT_FACTOR = 1.0f;
    private static final Pool<AccelerateInterpolator> pool = new Pool<AccelerateInterpolator>(4, 100){

        @Override
        protected AccelerateInterpolator newObject() {
            return new AccelerateInterpolator();
        }
    };
    private float factor;
    private double doubledFactor;

    AccelerateInterpolator() {
    }

    public static AccelerateInterpolator $(float factor) {
        AccelerateInterpolator inter = pool.obtain();
        inter.factor = factor;
        inter.doubledFactor = factor * 2.0f;
        return inter;
    }

    public static AccelerateInterpolator $() {
        return AccelerateInterpolator.$(1.0f);
    }

    @Override
    public void finished() {
        pool.free(this);
    }

    @Override
    public float getInterpolation(float input) {
        if (this.factor == 1.0f) {
            return input * input;
        }
        return (float)Math.pow(input, this.doubledFactor);
    }

    @Override
    public Interpolator copy() {
        return AccelerateInterpolator.$(this.factor);
    }
}

