/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Cullable;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;

public class FlickScrollPane
extends WidgetGroup {
    private Actor widget;
    private final Rectangle widgetAreaBounds = new Rectangle();
    private final Rectangle widgetCullingArea = new Rectangle();
    private final Rectangle scissorBounds = new Rectangle();
    private final GestureDetector gestureDetector;
    private boolean scrollX;
    private boolean scrollY;
    float amountX;
    float amountY;
    private float maxX;
    private float maxY;
    float velocityX;
    float velocityY;
    float flingTimer;
    private Actor touchFocusedChild;
    private boolean overscroll = true;
    float flingTime = 1.0f;
    private float overscrollDistance = 50.0f;
    private float overscrollSpeedMin = 30.0f;
    private float overscrollSpeedMax = 200.0f;
    private Interpolation overscrollInterpolation = Interpolation.elasticOut;
    private boolean emptySpaceOnlyScroll;
    private boolean forceOverscrollX;
    private boolean forceOverscrollY;
    private boolean disableX;
    private boolean disableY;
    private boolean clamp = true;

    public FlickScrollPane() {
        this(null, null);
    }

    public FlickScrollPane(Actor widget) {
        this(widget, null);
    }

    public FlickScrollPane(Actor widget, String name) {
        super(name);
        this.widget = widget;
        if (widget != null) {
            this.setWidget(widget);
        }
        this.gestureDetector = new GestureDetector(new GestureDetector.GestureListener(){

            @Override
            public boolean pan(int x, int y, int deltaX, int deltaY) {
                FlickScrollPane.this.amountX -= (float)deltaX;
                FlickScrollPane.this.amountY += (float)deltaY;
                FlickScrollPane.this.clamp();
                FlickScrollPane.this.cancelTouchFocusedChild();
                return true;
            }

            @Override
            public boolean fling(float x, float y) {
                if (Math.abs(x) > 150.0f) {
                    FlickScrollPane.this.flingTimer = FlickScrollPane.this.flingTime;
                    FlickScrollPane.this.velocityX = x;
                    FlickScrollPane.this.cancelTouchFocusedChild();
                }
                if (Math.abs(y) > 150.0f) {
                    FlickScrollPane.this.flingTimer = FlickScrollPane.this.flingTime;
                    FlickScrollPane.this.velocityY = -y;
                    FlickScrollPane.this.cancelTouchFocusedChild();
                }
                return FlickScrollPane.this.flingTimer > 0.0f;
            }

            @Override
            public boolean touchDown(int x, int y, int pointer) {
                FlickScrollPane.this.flingTimer = 0.0f;
                return true;
            }

            @Override
            public boolean tap(int x, int y, int count) {
                return false;
            }

            @Override
            public boolean zoom(float originalDistance, float currentDistance) {
                return false;
            }

            @Override
            public boolean pinch(Vector2 initialFirstPointer, Vector2 initialSecondPointer, Vector2 firstPointer, Vector2 secondPointer) {
                return false;
            }

            @Override
            public boolean longPress(int x, int y) {
                return false;
            }
        });
        this.width = 150.0f;
        this.height = 150.0f;
    }

    void clamp() {
        if (!this.clamp) {
            return;
        }
        if (this.overscroll) {
            this.amountX = MathUtils.clamp(this.amountX, -this.overscrollDistance, this.maxX + this.overscrollDistance);
            this.amountY = MathUtils.clamp(this.amountY, -this.overscrollDistance, this.maxY + this.overscrollDistance);
        } else {
            this.amountX = MathUtils.clamp(this.amountX, 0.0f, this.maxX);
            this.amountY = MathUtils.clamp(this.amountY, 0.0f, this.maxY);
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.flingTimer > 0.0f) {
            float alpha = this.flingTimer / this.flingTime;
            this.amountX -= this.velocityX * alpha * delta;
            this.amountY -= this.velocityY * alpha * delta;
            this.clamp();
            if (this.amountX == -this.overscrollDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountX >= this.maxX + this.overscrollDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountY == -this.overscrollDistance) {
                this.velocityY = 0.0f;
            }
            if (this.amountY >= this.maxY + this.overscrollDistance) {
                this.velocityY = 0.0f;
            }
            this.flingTimer -= delta;
        }
        if (this.overscroll && !this.gestureDetector.isPanning()) {
            if (this.amountX < 0.0f) {
                this.amountX += (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -this.amountX / this.overscrollDistance) * delta;
                if (this.amountX > 0.0f) {
                    this.amountX = 0.0f;
                }
            } else if (this.amountX > this.maxX) {
                this.amountX -= (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -(this.maxX - this.amountX) / this.overscrollDistance) * delta;
                if (this.amountX < this.maxX) {
                    this.amountX = this.maxX;
                }
            }
            if (this.amountY < 0.0f) {
                this.amountY += (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -this.amountY / this.overscrollDistance) * delta;
                if (this.amountY > 0.0f) {
                    this.amountY = 0.0f;
                }
            } else if (this.amountY > this.maxY) {
                this.amountY -= (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -(this.maxY - this.amountY) / this.overscrollDistance) * delta;
                if (this.amountY < this.maxY) {
                    this.amountY = this.maxY;
                }
            }
        }
    }

    @Override
    public void layout() {
        float widgetHeight;
        float widgetWidth;
        Layout layout;
        if (this.widget == null) {
            return;
        }
        if (this.widget instanceof Layout) {
            layout = (Layout)((Object)this.widget);
            widgetWidth = layout.getPrefWidth();
            widgetHeight = layout.getPrefHeight();
        } else {
            widgetWidth = this.widget.width;
            widgetHeight = this.widget.height;
        }
        this.scrollX = !this.disableX && (widgetWidth > this.width || this.forceOverscrollX);
        this.scrollY = !this.disableY && (widgetHeight > this.height || this.forceOverscrollY);
        this.widget.width = this.disableX ? this.width : Math.max(this.width, widgetWidth);
        this.widget.height = this.disableY ? this.height : Math.max(this.height, widgetHeight);
        this.maxX = this.widget.width - this.width;
        this.maxY = this.widget.height - this.height;
        if (this.widget instanceof Layout) {
            layout = (Layout)((Object)this.widget);
            layout.invalidate();
            layout.validate();
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (this.widget == null) {
            return;
        }
        this.validate();
        this.applyTransform(batch);
        this.widget.y = (float)((int)(this.scrollY ? this.amountY : this.maxY)) - this.widget.height + this.height;
        this.widget.x = -((int)(this.scrollX ? this.amountX : 0.0f));
        if (this.widget instanceof Cullable) {
            this.widgetCullingArea.x = -this.widget.x;
            this.widgetCullingArea.y = -this.widget.y;
            this.widgetCullingArea.width = this.width;
            this.widgetCullingArea.height = this.height;
            ((Cullable)((Object)this.widget)).setCullingArea(this.widgetCullingArea);
        }
        this.widgetAreaBounds.set(0.0f, 0.0f, this.width, this.height);
        ScissorStack.calculateScissors(this.stage.getCamera(), batch.getTransformMatrix(), this.widgetAreaBounds, this.scissorBounds);
        if (ScissorStack.pushScissors(this.scissorBounds)) {
            this.drawChildren(batch, parentAlpha);
            ScissorStack.popScissors();
        }
        this.resetTransform(batch);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        super.touchDown(x, y, pointer);
        Actor actor = this.touchFocusedChild = this.stage.getTouchFocus(0) != this ? this.stage.getTouchFocus(0) : null;
        if (this.emptySpaceOnlyScroll && this.touchFocusedChild != null) {
            return false;
        }
        this.gestureDetector.touchDown((int)x, (int)y, pointer, 0);
        if (this.stage != null) {
            this.stage.setTouchFocus(this, 0);
        }
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        this.clamp();
        if (this.gestureDetector.touchUp((int)x, (int)y, pointer, 0)) {
            x = -2.1474836E9f;
            y = -2.1474836E9f;
        }
        if (this.touchFocusedChild != null && this.isDescendant(this.touchFocusedChild)) {
            this.point.x = x;
            this.point.y = y;
            this.toLocalCoordinates(this.touchFocusedChild, this.point);
            this.touchFocusedChild.touchUp(this.point.x, this.point.y, 0);
            this.touchFocusedChild = null;
        }
    }

    void cancelTouchFocusedChild() {
        if (this.touchFocusedChild == null) {
            return;
        }
        this.touchFocusedChild.touchUp(-2.1474836E9f, -2.1474836E9f, 0);
        this.touchFocusedChild = null;
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        this.gestureDetector.touchDragged((int)x, (int)y, pointer);
    }

    public void setScrollX(float pixels) {
        this.amountX = pixels;
    }

    public float getScrollX() {
        return this.amountX;
    }

    public void setScrollY(float pixels) {
        this.amountY = pixels;
    }

    public float getScrollY() {
        return this.amountY;
    }

    public float getScrollPercentX() {
        return this.amountX / this.maxX;
    }

    public void setScrollPercentX(float percentX) {
        this.amountX = this.maxX * percentX;
    }

    public float getScrollPercentY() {
        return this.amountY / this.maxY;
    }

    public void setScrollPercentY(float percentY) {
        this.amountY = this.maxY * percentY;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public void setWidget(Actor widget) {
        if (widget == null) {
            throw new IllegalArgumentException("widget cannot be null.");
        }
        if (this.widget != null) {
            super.removeActor(this.widget);
        }
        this.widget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
    }

    public Actor getWidget() {
        return this.widget;
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use FlickScrollPane#setWidget.");
    }

    @Override
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use FlickScrollPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use FlickScrollPane#setWidget.");
    }

    @Override
    public void removeActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget(null).");
    }

    @Override
    public void removeActorRecursive(Actor actor) {
        if (actor == this.widget) {
            this.setWidget(null);
        } else if (this.widget instanceof Group) {
            ((Group)this.widget).removeActorRecursive(actor);
        }
    }

    public boolean isPanning() {
        return this.gestureDetector.isPanning();
    }

    public boolean isFlinging() {
        return this.flingTimer > 0.0f;
    }

    public void setVelocityX(float velocityX) {
        this.velocityX = velocityX;
    }

    public float getVelocityX() {
        if (this.flingTimer <= 0.0f) {
            return 0.0f;
        }
        float alpha = this.flingTimer / this.flingTime;
        alpha = alpha * alpha * alpha;
        return this.velocityX * alpha * alpha * alpha;
    }

    public void setVelocityY(float velocityY) {
        this.velocityY = velocityY;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    @Override
    public float getPrefWidth() {
        if (this.widget instanceof Layout) {
            return ((Layout)((Object)this.widget)).getPrefWidth();
        }
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.widget instanceof Layout) {
            return ((Layout)((Object)this.widget)).getPrefHeight();
        }
        return 150.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public Actor hit(float x, float y) {
        if (x > 0.0f && x < this.width && y > 0.0f && y < this.height) {
            return super.hit(x, y);
        }
        return null;
    }

    public void setOverscroll(boolean overscroll) {
        this.overscroll = overscroll;
    }

    public void setupOverscroll(float distance, float speedMin, float speedMax) {
        this.overscrollDistance = distance;
        this.overscrollSpeedMin = speedMin;
        this.overscrollSpeedMax = speedMax;
    }

    public void setForceOverscroll(boolean x, boolean y) {
        this.forceOverscrollX = x;
        this.forceOverscrollY = y;
    }

    public void setFlingTime(float flingTime) {
        this.flingTime = flingTime;
    }

    public void setEmptySpaceOnlyScroll(boolean emptySpaceOnlyScroll) {
        this.emptySpaceOnlyScroll = emptySpaceOnlyScroll;
    }

    public void setScrollingDisabled(boolean x, boolean y) {
        this.disableX = x;
        this.disableY = y;
    }

    public void setClamp(boolean clamp) {
        this.clamp = clamp;
    }
}

