/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;

public class Label
extends Widget {
    private LabelStyle style;
    private final BitmapFont.TextBounds bounds = new BitmapFont.TextBounds();
    private CharSequence text;
    private BitmapFontCache cache;
    private float prefWidth;
    private float prefHeight;
    private int labelAlign = 8;
    private BitmapFont.HAlignment lineAlign = BitmapFont.HAlignment.LEFT;
    private boolean wrap;
    private float lastPrefHeight;

    public Label(Skin skin) {
        this((CharSequence)"", skin);
    }

    public Label(CharSequence text, Skin skin) {
        this(text, skin.getStyle(LabelStyle.class), null);
    }

    public Label(CharSequence text, String fontName, Color color, Skin skin) {
        this(text, new LabelStyle(skin.getFont(fontName), color), null);
    }

    public Label(CharSequence text, String fontName, String colorName, Skin skin) {
        this(text, new LabelStyle(skin.getFont(fontName), skin.getColor(colorName)), null);
    }

    public Label(CharSequence text, LabelStyle style) {
        this(text, style, null);
    }

    public Label(CharSequence text, LabelStyle style, String name) {
        super(name);
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.setStyle(style);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public void setStyle(LabelStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        if (style.font == null) {
            throw new IllegalArgumentException("Missing LabelStyle font.");
        }
        this.style = style;
        this.cache = new BitmapFontCache(style.font);
        if (style.fontColor != null) {
            this.cache.setColor(style.fontColor);
        }
        this.computeBounds();
        this.invalidateHierarchy();
    }

    public LabelStyle getStyle() {
        return this.style;
    }

    public void setText(CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null.");
        }
        if (text.equals(this.text)) {
            return;
        }
        this.text = text;
        this.computeBounds();
        this.invalidateHierarchy();
    }

    public CharSequence getText() {
        return this.text;
    }

    public BitmapFont.TextBounds getTextBounds() {
        return this.bounds;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
        this.computeBounds();
        this.invalidateHierarchy();
    }

    public void setAlignment(int wrapAlign) {
        this.setAlignment(wrapAlign, wrapAlign);
    }

    public void setAlignment(int labelAlign, int lineAlign) {
        this.labelAlign = labelAlign;
        this.lineAlign = (lineAlign & 8) != 0 ? BitmapFont.HAlignment.LEFT : ((lineAlign & 0x10) != 0 ? BitmapFont.HAlignment.RIGHT : BitmapFont.HAlignment.CENTER);
        this.invalidate();
    }

    public void setColor(float color) {
        this.cache.setColor(color);
    }

    public void setColor(Color tint) {
        this.cache.setColor(tint);
    }

    public void setColor(float r, float g, float b, float a) {
        this.cache.setColor(r, g, b, a);
    }

    public Color getColor() {
        return this.cache.getColor();
    }

    private void computeBounds() {
        if (this.wrap) {
            this.bounds.set(this.cache.getFont().getWrappedBounds(this.text, this.width));
        } else {
            this.bounds.set(this.cache.getFont().getMultiLineBounds(this.text));
        }
    }

    @Override
    public void layout() {
        float y;
        float prefHeight;
        this.computeBounds();
        if (this.wrap && (prefHeight = this.getPrefHeight()) != this.lastPrefHeight) {
            this.lastPrefHeight = prefHeight;
            this.invalidateHierarchy();
        }
        if ((this.labelAlign & 2) != 0) {
            y = this.cache.getFont().isFlipped() ? 0.0f : this.height - this.bounds.height;
            y += this.style.font.getDescent();
        } else if ((this.labelAlign & 4) != 0) {
            y = this.cache.getFont().isFlipped() ? this.height - this.bounds.height : 0.0f;
            y -= this.style.font.getDescent();
        } else {
            y = (this.height - this.bounds.height) / 2.0f;
        }
        if (!this.cache.getFont().isFlipped()) {
            y += this.bounds.height;
        }
        float x = (this.labelAlign & 8) != 0 ? 0.0f : ((this.labelAlign & 0x10) != 0 ? this.width - this.bounds.width : (this.width - this.bounds.width) / 2.0f);
        if (this.wrap) {
            this.cache.setWrappedText(this.text, x, y, this.bounds.width, this.lineAlign);
        } else {
            this.cache.setMultiLineText(this.text, x, y, this.bounds.width, this.lineAlign);
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.validate();
        this.cache.setPosition(this.x, this.y);
        this.cache.draw(batch, this.color.a * parentAlpha);
    }

    @Override
    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        return this.bounds.width;
    }

    @Override
    public float getPrefHeight() {
        return this.bounds.height - this.style.font.getDescent() * 2.0f;
    }

    public static class LabelStyle {
        public BitmapFont font;
        public Color fontColor;

        public LabelStyle() {
        }

        public LabelStyle(BitmapFont font, Color fontColor) {
            this.font = font;
            this.fontColor = fontColor;
        }

        public LabelStyle(LabelStyle style) {
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
        }
    }
}

