/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;

public class Skin
implements Disposable {
    ObjectMap<Class, ObjectMap<String, Object>> resources = new ObjectMap();
    ObjectMap<Class, ObjectMap<String, Object>> styles = new ObjectMap();
    Texture texture;

    public Skin() {
    }

    public Skin(FileHandle skinFile) {
        this.texture = new Texture(skinFile.parent().child(skinFile.nameWithoutExtension() + ".png"));
        this.load(skinFile);
    }

    public Skin(FileHandle skinFile, FileHandle textureFile) {
        this.texture = new Texture(textureFile);
        this.load(skinFile);
    }

    public Skin(FileHandle skinFile, Texture texture) {
        this.texture = texture;
        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.load(skinFile);
    }

    public void load(FileHandle skinFile) {
        try {
            this.getJsonLoader(skinFile).fromJson(Skin.class, skinFile);
        }
        catch (SerializationException ex) {
            throw new SerializationException("Error reading file: " + skinFile, ex);
        }
    }

    public void addResource(String name, Object resource) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        ObjectMap<String, Object> typeResources = this.resources.get(resource.getClass());
        if (typeResources == null) {
            typeResources = new ObjectMap();
            this.resources.put(resource.getClass(), typeResources);
        }
        typeResources.put(name, resource);
    }

    public <T> T getResource(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        ObjectMap<String, Object> typeResources = this.resources.get(type);
        if (typeResources == null) {
            throw new GdxRuntimeException("No " + type.getName() + " resource registered with name: " + name);
        }
        Object resource = typeResources.get(name);
        if (resource == null) {
            throw new GdxRuntimeException("No " + type.getName() + " resource registered with name: " + name);
        }
        return (T)resource;
    }

    public boolean hasResource(String name, Class type) {
        ObjectMap<String, Object> typeResources = this.resources.get(type);
        if (typeResources == null) {
            return false;
        }
        Object resource = typeResources.get(name);
        return resource != null;
    }

    public NinePatch getPatch(String name) {
        return this.getResource(name, NinePatch.class);
    }

    public Color getColor(String name) {
        return this.getResource(name, Color.class);
    }

    public BitmapFont getFont(String name) {
        return this.getResource(name, BitmapFont.class);
    }

    public TextureRegion getRegion(String name) {
        return this.getResource(name, TextureRegion.class);
    }

    public void addStyle(String name, Object style) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        ObjectMap<String, Object> typeStyles = this.styles.get(style.getClass());
        if (typeStyles == null) {
            typeStyles = new ObjectMap();
            this.styles.put(style.getClass(), typeStyles);
        }
        typeStyles.put(name, style);
    }

    public <T> T getStyle(Class<T> type) {
        return this.getStyle("default", type);
    }

    public <T> T getStyle(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        ObjectMap<String, Object> typeStyles = this.styles.get(type);
        if (typeStyles == null) {
            throw new GdxRuntimeException("No styles registered with type: " + type.getName());
        }
        Object style = typeStyles.get(name);
        if (style == null) {
            throw new GdxRuntimeException("No " + type.getName() + " style registered with name: " + name);
        }
        return (T)style;
    }

    public boolean hasStyle(String name, Class type) {
        ObjectMap<String, Object> typeStyles = this.styles.get(type);
        if (typeStyles == null) {
            return false;
        }
        Object style = typeStyles.get(name);
        return style != null;
    }

    public String findStyleName(Object style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        ObjectMap<String, Object> typeStyles = this.styles.get(style.getClass());
        if (typeStyles == null) {
            return null;
        }
        return typeStyles.findKey(style, true);
    }

    public void setEnabled(Actor actor, boolean enabled) {
        Object style;
        actor.touchable = enabled;
        Method method = Skin.findMethod(actor.getClass(), "getStyle");
        if (method == null) {
            return;
        }
        try {
            style = method.invoke((Object)actor, new Object[0]);
        }
        catch (Exception ignored) {
            return;
        }
        String name = this.findStyleName(style);
        if (name == null) {
            return;
        }
        name = name.replace("-disabled", "") + (enabled ? "" : "-disabled");
        style = this.getStyle(name, style.getClass());
        method = Skin.findMethod(actor.getClass(), "setStyle");
        if (method == null) {
            return;
        }
        try {
            method.invoke((Object)actor, style);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public NinePatch newTintedPatch(String patchName, String colorName) {
        return this.newTintedPatch(patchName, this.getColor(colorName));
    }

    public NinePatch newTintedPatch(String patchName, Color color) {
        return new NinePatch(this.getPatch(patchName), color);
    }

    public NinePatch newTintedRegion(String regionName, String colorName) {
        return this.newTintedRegion(regionName, this.getColor(colorName));
    }

    public NinePatch newTintedRegion(String regionName, Color color) {
        NinePatch patch = new NinePatch(this.getRegion(regionName));
        patch.setColor(color);
        return patch;
    }

    private static Method findMethod(Class type, String name) {
        for (Method method : type.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public void dispose() {
        this.texture.dispose();
        for (ObjectMap.Entry<Class, ObjectMap<String, Object>> entry : this.resources.entries()) {
            if (!Disposable.class.isAssignableFrom((Class)entry.key)) continue;
            for (Object resource : ((ObjectMap)entry.value).values()) {
                ((Disposable)resource).dispose();
            }
        }
    }

    public void save(FileHandle skinFile) {
        String text = this.getJsonLoader(null).prettyPrint(this, 130);
        Writer writer = skinFile.writer(false);
        try {
            writer.write(text);
            writer.close();
        }
        catch (IOException ex) {
            throw new GdxRuntimeException(ex);
        }
    }

    protected Json getJsonLoader(final FileHandle skinFile) {
        final Skin skin = this;
        Json json = new Json();
        json.setTypeName(null);
        json.setUsePrototypes(false);
        json.setSerializer(Skin.class, new Json.Serializer<Skin>(){

            @Override
            public void write(Json json, Skin skin2, Class valueType) {
                json.writeObjectStart();
                json.writeValue("resources", skin2.resources);
                for (ObjectMap.Entry<Class, ObjectMap<String, Object>> entry : Skin.this.resources.entries()) {
                    class AliasWriter
                    implements Json.Serializer {
                        final ObjectMap<String, ?> map;
                        final /* synthetic */ Skin this$0;

                        public AliasWriter(Skin skin, Class type) {
                            this.this$0 = skin;
                            this.map = skin.resources.get(type);
                        }

                        public void write(Json json, Object object, Class valueType) {
                            for (ObjectMap.Entry<String, ?> entry : this.map.entries()) {
                                if (!entry.value.equals(object)) continue;
                                json.writeValue(entry.key);
                                return;
                            }
                            throw new SerializationException(object.getClass().getSimpleName() + " not found: " + object);
                        }

                        public Object read(Json json, Object jsonData, Class type) {
                            throw new UnsupportedOperationException();
                        }
                    }
                    json.setSerializer((Class)entry.key, new AliasWriter(Skin.this, (Class)entry.key));
                }
                json.writeField(skin2, "styles");
                json.writeObjectEnd();
            }

            @Override
            public Skin read(Json json, Object jsonData, Class ignored) {
                ObjectMap map = (ObjectMap)jsonData;
                this.readTypeMap(json, (ObjectMap)map.get("resources"), true);
                this.readTypeMap(json, (ObjectMap)map.get("styles"), false);
                return skin;
            }

            private void readTypeMap(Json json, ObjectMap<String, ObjectMap> typeToValueMap, boolean isResource) {
                if (typeToValueMap == null) {
                    throw new SerializationException("Skin file is missing a \"" + (isResource ? "resources" : "styles") + "\" section.");
                }
                for (ObjectMap.Entry<String, ObjectMap> entry : typeToValueMap.entries()) {
                    String className = (String)entry.key;
                    ObjectMap valueMap = (ObjectMap)entry.value;
                    try {
                        this.readNamedObjects(json, Class.forName(className), valueMap, isResource);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new SerializationException(ex);
                    }
                }
            }

            private void readNamedObjects(Json json, Class type, ObjectMap<String, ObjectMap> valueMap, boolean isResource) {
                for (ObjectMap.Entry<String, ObjectMap> entry : valueMap.entries()) {
                    String name = (String)entry.key;
                    Object object = json.readValue(type, entry.value);
                    if (object == null) continue;
                    try {
                        if (isResource) {
                            Skin.this.addResource(name, object);
                            continue;
                        }
                        Skin.this.addStyle(name, object);
                    }
                    catch (Exception ex) {
                        throw new SerializationException("Error reading " + type.getSimpleName() + ": " + (String)entry.key, ex);
                    }
                }
            }
        });
        json.setSerializer(TextureRegion.class, new Json.Serializer<TextureRegion>(){

            @Override
            public void write(Json json, TextureRegion region, Class valueType) {
                json.writeObjectStart();
                json.writeValue("x", region.getRegionX());
                json.writeValue("y", region.getRegionY());
                json.writeValue("width", region.getRegionWidth());
                json.writeValue("height", region.getRegionHeight());
                json.writeObjectEnd();
            }

            @Override
            public TextureRegion read(Json json, Object jsonData, Class type) {
                if (jsonData instanceof String) {
                    return Skin.this.getResource((String)jsonData, TextureRegion.class);
                }
                int x = json.readValue("x", Integer.TYPE, jsonData);
                int y = json.readValue("y", Integer.TYPE, jsonData);
                int width = json.readValue("width", Integer.TYPE, jsonData);
                int height = json.readValue("height", Integer.TYPE, jsonData);
                return new TextureRegion(skin.texture, x, y, width, height);
            }
        });
        json.setSerializer(BitmapFont.class, new Json.Serializer<BitmapFont>(){

            @Override
            public void write(Json json, BitmapFont font, Class valueType) {
                json.writeObjectStart();
                json.writeValue("file", font.getData().getFontFile().toString().replace('\\', '/'));
                json.writeObjectEnd();
            }

            @Override
            public BitmapFont read(Json json, Object jsonData, Class type) {
                if (jsonData instanceof String) {
                    return Skin.this.getResource((String)jsonData, BitmapFont.class);
                }
                String path = json.readValue("file", String.class, jsonData);
                FileHandle fontFile = skinFile.parent().child(path);
                if (!fontFile.exists()) {
                    fontFile = Gdx.files.internal(path);
                }
                if (!fontFile.exists()) {
                    throw new SerializationException("Font file not found: " + fontFile);
                }
                String regionName = fontFile.nameWithoutExtension();
                try {
                    if (skin.hasResource(regionName, TextureRegion.class)) {
                        return new BitmapFont(fontFile, skin.getResource(regionName, TextureRegion.class), false);
                    }
                    FileHandle imageFile = fontFile.parent().child(regionName + ".png");
                    if (imageFile.exists()) {
                        return new BitmapFont(fontFile, imageFile, false);
                    }
                    return new BitmapFont(fontFile, false);
                }
                catch (RuntimeException ex) {
                    throw new SerializationException("Error loading bitmap font: " + fontFile, ex);
                }
            }
        });
        json.setSerializer(NinePatch.class, new Json.Serializer<NinePatch>(){

            @Override
            public void write(Json json, NinePatch ninePatch, Class valueType) {
                boolean singlePatch;
                TextureRegion[] patches = ninePatch.getPatches();
                boolean bl = singlePatch = patches[0] == null && patches[1] == null && patches[2] == null && patches[3] == null && patches[4] != null && patches[5] == null && patches[6] == null && patches[7] == null && patches[8] == null;
                if (ninePatch.getColor() != null) {
                    json.writeObjectStart();
                    json.writeValue("color", ninePatch.getColor());
                    if (singlePatch) {
                        json.writeValue("region", patches[4]);
                    } else {
                        json.writeValue("regions", patches);
                    }
                    json.writeObjectEnd();
                } else if (singlePatch) {
                    json.writeValue(patches[4]);
                } else {
                    json.writeValue(patches);
                }
            }

            @Override
            public NinePatch read(Json json, Object jsonData, Class type) {
                if (jsonData instanceof String) {
                    return Skin.this.getResource((String)jsonData, NinePatch.class);
                }
                if (jsonData instanceof Array) {
                    TextureRegion[] regions = json.readValue(TextureRegion[].class, jsonData);
                    if (regions.length == 1) {
                        return new NinePatch(regions[0]);
                    }
                    return new NinePatch(regions);
                }
                ObjectMap map = (ObjectMap)jsonData;
                NinePatch ninePatch = map.containsKey("regions") ? new NinePatch(json.readValue("regions", TextureRegion[].class, jsonData)) : (map.containsKey("region") ? new NinePatch(json.readValue("region", TextureRegion.class, jsonData)) : new NinePatch(json.readValue(TextureRegion.class, jsonData)));
                if (map.containsKey("color")) {
                    ninePatch.setColor(json.readValue("color", Color.class, jsonData));
                }
                return ninePatch;
            }
        });
        json.setSerializer(Color.class, new Json.Serializer<Color>(){

            @Override
            public void write(Json json, Color color, Class valueType) {
                json.writeObjectStart();
                json.writeFields(color);
                json.writeObjectEnd();
            }

            @Override
            public Color read(Json json, Object jsonData, Class type) {
                if (jsonData instanceof String) {
                    return Skin.this.getResource((String)jsonData, Color.class);
                }
                ObjectMap map = (ObjectMap)jsonData;
                float r = json.readValue("r", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float g = json.readValue("g", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float b = json.readValue("b", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float a = json.readValue("a", Float.TYPE, Float.valueOf(1.0f), jsonData).floatValue();
                return new Color(r, g, b, a);
            }
        });
        json.setSerializer(TintedNinePatch.class, new Json.Serializer(){

            public void write(Json json, Object tintedPatch, Class valueType) {
                json.writeObjectStart();
                json.writeField(tintedPatch, "name");
                json.writeField(tintedPatch, "color");
                json.writeObjectEnd();
            }

            public Object read(Json json, Object jsonData, Class type) {
                String name = json.readValue("name", String.class, jsonData);
                Color color = json.readValue("color", Color.class, jsonData);
                return new NinePatch(Skin.this.getResource(name, NinePatch.class), color);
            }
        });
        return json;
    }

    public static class TintedNinePatch
    extends NinePatch {
        public String name;
        public Color color;

        public TintedNinePatch(NinePatch ninePatch, Color color) {
            super(ninePatch, color);
        }
    }
}

