/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;

public abstract class WidgetGroup
extends Group
implements Layout {
    private boolean needsLayout = true;
    private boolean fillParent;

    public WidgetGroup() {
    }

    public WidgetGroup(String name) {
        super(name);
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public void validate() {
        if (this.fillParent && this.parent != null) {
            float parentHeight;
            float parentWidth;
            if (this.stage != null && this.parent == this.stage.getRoot()) {
                parentWidth = this.stage.width();
                parentHeight = this.stage.height();
            } else {
                parentWidth = this.parent.width;
                parentHeight = this.parent.height;
            }
            if (this.width != parentWidth || this.height != parentHeight) {
                this.width = parentWidth;
                this.height = parentHeight;
                this.invalidate();
            }
        }
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        this.layout();
    }

    public boolean needsLayout() {
        return this.needsLayout;
    }

    @Override
    public void invalidateHierarchy() {
        this.invalidate();
        if (this.parent instanceof Layout) {
            ((Layout)((Object)this.parent)).invalidateHierarchy();
        }
    }

    @Override
    protected void childrenChanged() {
        this.invalidateHierarchy();
    }

    @Override
    public void pack() {
        float newWidth = this.getPrefWidth();
        float newHeight = this.getPrefHeight();
        if (newWidth != this.width || newHeight != this.height) {
            this.width = newWidth;
            this.height = newHeight;
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public void setFillParent(boolean fillParent) {
        this.fillParent = fillParent;
    }

    @Override
    public void layout() {
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.validate();
        super.draw(batch, parentAlpha);
    }
}

