/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tablelayout;

import com.esotericsoftware.tablelayout.BaseTableLayout;
import com.esotericsoftware.tablelayout.Cell;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class Toolkit<C, T extends C, L extends BaseTableLayout> {
    private static final ArrayList<String> classPrefixes = new ArrayList();

    public abstract void addChild(C var1, C var2, String var3);

    public abstract void removeChild(C var1, C var2);

    public abstract int getMinWidth(C var1);

    public abstract int getMinHeight(C var1);

    public abstract int getPrefWidth(C var1);

    public abstract int getPrefHeight(C var1);

    public abstract int getMaxWidth(C var1);

    public abstract int getMaxHeight(C var1);

    public abstract void clearDebugRectangles(L var1);

    public abstract void addDebugRectangle(L var1, int var2, int var3, int var4, int var5, int var6);

    public abstract C newStack();

    public abstract L getLayout(T var1);

    public T newTable(T parent) {
        try {
            return (T)parent.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create an instance of: " + parent.getClass().getName());
        }
    }

    public void setWidget(L layout, Cell cell, C widget) {
        this.removeChild(((BaseTableLayout)layout).table, cell.widget);
        ((BaseTableLayout)layout).widgetToCell.remove(cell.widget);
        cell.widget = widget;
        if (cell.name != null) {
            ((BaseTableLayout)layout).nameToWidget.put(cell.name, widget);
        }
        ((BaseTableLayout)layout).widgetToCell.put(widget, cell);
        this.addChild(((BaseTableLayout)layout).table, widget, null);
    }

    int getWidgetWidth(L layout, C widget, String value) {
        if (value.equals("min")) {
            return this.getMinWidth(widget);
        }
        if (value.equals("pref")) {
            return this.getPrefWidth(widget);
        }
        if (value.equals("max")) {
            return this.getMaxWidth(widget);
        }
        return this.width(layout, value);
    }

    int getWidgetHeight(L layout, C widget, String value) {
        if (value.equals("min")) {
            return this.getMinHeight(widget);
        }
        if (value.equals("pref")) {
            return this.getPrefHeight(widget);
        }
        if (value.equals("max")) {
            return this.getMaxHeight(widget);
        }
        return this.height(layout, value);
    }

    protected String validateSize(String size) {
        return size;
    }

    public C newWidget(L layout, String className) {
        try {
            return this.wrap(layout, this.newInstance(layout, className));
        }
        catch (Exception ex) {
            int n = classPrefixes.size();
            for (int i = 0; i < n; ++i) {
                String prefix = classPrefixes.get(i);
                try {
                    return this.newInstance(layout, prefix + className);
                }
                catch (InvocationTargetException ex2) {
                    throw new RuntimeException(ex2);
                }
                catch (Exception ignored) {
                    continue;
                }
            }
            throw new RuntimeException("Error creating instance of class: " + className, ex);
        }
    }

    protected C newInstance(L layout, String className) throws Exception {
        return (C)Class.forName(className).newInstance();
    }

    public C wrap(L layout, Object object) {
        if (object instanceof BaseTableLayout) {
            return (C)((BaseTableLayout)object).getTable();
        }
        try {
            return (C)object;
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Unknown object type: " + object.getClass());
        }
    }

    public void setProperty(L layout, C object, String name, List<String> values) {
        try {
            this.invokeMethod(layout, object, name, values);
        }
        catch (NoSuchMethodException ex1) {
            try {
                this.invokeMethod(layout, object, "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), values);
            }
            catch (NoSuchMethodException ex2) {
                try {
                    Field field = object.getClass().getField(name);
                    Object value = this.convertType(layout, object, field.getType(), name, values.get(0));
                    if (value == null) {
                        throw ex1;
                    }
                    field.set(object, value);
                }
                catch (Exception ex3) {
                    throw new RuntimeException("No method, bean property, or field found: " + name + "\nClass: " + object.getClass() + "\nValues: " + values);
                }
            }
        }
    }

    public void setTableProperty(L layout, String name, List<String> values) {
        name = name.toLowerCase();
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            values.set(i, values.get(i).toLowerCase());
        }
        try {
            int i;
            if (name.equals("size")) {
                switch (values.size()) {
                    case 2: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            ((BaseTableLayout)layout).width = this.validateSize(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            ((BaseTableLayout)layout).height = this.validateSize(value);
                        }
                        return;
                    }
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            ((BaseTableLayout)layout).width = value = this.validateSize(value);
                            ((BaseTableLayout)layout).height = value;
                        }
                        return;
                    }
                }
            } else if (name.equals("width") || name.equals("w")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        ((BaseTableLayout)layout).width = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("height") || name.equals("h")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        ((BaseTableLayout)layout).height = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("padding") || name.equals("pad")) {
                switch (values.size()) {
                    case 4: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            ((BaseTableLayout)layout).padTop = this.validateSize(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            ((BaseTableLayout)layout).padLeft = this.validateSize(value);
                        }
                        if ((value = values.get(2)).length() > 0) {
                            ((BaseTableLayout)layout).padBottom = this.validateSize(value);
                        }
                        if ((value = values.get(3)).length() > 0) {
                            ((BaseTableLayout)layout).padRight = this.validateSize(value);
                        }
                        return;
                    }
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            ((BaseTableLayout)layout).padBottom = ((BaseTableLayout)layout).padRight = this.validateSize(value);
                            ((BaseTableLayout)layout).padLeft = ((BaseTableLayout)layout).padRight;
                            ((BaseTableLayout)layout).padTop = ((BaseTableLayout)layout).padRight;
                        }
                        return;
                    }
                }
            } else if (name.startsWith("padding") || name.startsWith("pad")) {
                name = name.replace("padding", "").replace("pad", "");
                if (values.size() == 1 && values.get(0).length() > 0) {
                    String value = this.validateSize(values.get(0));
                    if (name.equals("top") || name.equals("t")) {
                        ((BaseTableLayout)layout).padTop = value;
                    } else if (name.equals("left") || name.equals("l")) {
                        ((BaseTableLayout)layout).padLeft = value;
                    } else if (name.equals("bottom") || name.equals("b")) {
                        ((BaseTableLayout)layout).padBottom = value;
                    } else if (name.equals("right") || name.equals("r")) {
                        ((BaseTableLayout)layout).padRight = value;
                    } else {
                        throw new IllegalArgumentException("Unknown table padding property: " + name);
                    }
                    return;
                }
            } else if (name.equals("center")) {
                if (values.size() == 0) {
                    ((BaseTableLayout)layout).align |= 1;
                    return;
                }
            } else if (name.equals("left")) {
                if (values.size() == 0) {
                    ((BaseTableLayout)layout).align |= 8;
                    return;
                }
            } else if (name.equals("right")) {
                if (values.size() == 0) {
                    ((BaseTableLayout)layout).align |= 0x10;
                    return;
                }
            } else if (name.equals("top")) {
                if (values.size() == 0) {
                    ((BaseTableLayout)layout).align |= 2;
                    return;
                }
            } else if (name.equals("bottom")) {
                if (values.size() == 0) {
                    ((BaseTableLayout)layout).align |= 4;
                    return;
                }
            } else if (name.equals("align")) {
                ((BaseTableLayout)layout).align = 0;
                int n2 = values.size();
                for (i = 0; i < n2; ++i) {
                    String value = values.get(i);
                    if (value.equals("center") || value.equals("c")) {
                        ((BaseTableLayout)layout).align |= 1;
                        continue;
                    }
                    if (value.equals("left") || value.equals("l")) {
                        ((BaseTableLayout)layout).align |= 8;
                        continue;
                    }
                    if (value.equals("right") || value.equals("r")) {
                        ((BaseTableLayout)layout).align |= 0x10;
                        continue;
                    }
                    if (value.equals("top") || value.equals("t")) {
                        ((BaseTableLayout)layout).align |= 2;
                        continue;
                    }
                    if (value.equals("bottom") || value.equals("b")) {
                        ((BaseTableLayout)layout).align |= 4;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid table align value: " + value);
                }
                if (values.size() > 0) {
                    return;
                }
            } else {
                if (name.equals("debug")) {
                    ((BaseTableLayout)layout).debug = 0;
                    if (values.size() == 0) {
                        ((BaseTableLayout)layout).debug = 1;
                    }
                    int n3 = values.size();
                    for (i = 0; i < n3; ++i) {
                        String value = values.get(i);
                        if (value.equalsIgnoreCase("all")) {
                            ((BaseTableLayout)layout).debug |= 1;
                            continue;
                        }
                        if (value.equalsIgnoreCase("cell")) {
                            ((BaseTableLayout)layout).debug |= 4;
                            continue;
                        }
                        if (value.equalsIgnoreCase("table")) {
                            ((BaseTableLayout)layout).debug |= 2;
                            continue;
                        }
                        if (value.equalsIgnoreCase("widget")) {
                            ((BaseTableLayout)layout).debug |= 8;
                            continue;
                        }
                        if (value.equalsIgnoreCase("none")) {
                            ((BaseTableLayout)layout).debug = 0;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid table debug value: " + value);
                    }
                    return;
                }
                throw new IllegalArgumentException("Unknown table property: " + name);
            }
            throw new IllegalArgumentException("Invalid number of table property values (" + values.size() + "): " + values);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting table property: " + name, ex);
        }
    }

    public void setCellProperty(Cell c, String name, List<String> values) {
        name = name.toLowerCase();
        int n2 = values.size();
        for (int i = 0; i < n2; ++i) {
            values.set(i, values.get(i).toLowerCase());
        }
        try {
            int i;
            if (name.equals("expand")) {
                switch (values.size()) {
                    case 0: {
                        c.expandX = c.expandY = Integer.valueOf(1);
                        return;
                    }
                    case 1: {
                        String value = values.get(0);
                        if (value.equals("x")) {
                            c.expandX = 1;
                        } else if (value.equals("y")) {
                            c.expandY = 1;
                        } else {
                            c.expandX = c.expandY = Integer.valueOf(Integer.parseInt(value));
                        }
                        return;
                    }
                    case 2: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.expandX = Integer.parseInt(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.expandY = Integer.parseInt(value);
                        }
                        return;
                    }
                }
            } else if (name.equals("expandx")) {
                if (values.size() == 0) {
                    c.expandX = 1;
                    return;
                }
            } else if (name.equals("expandy")) {
                if (values.size() == 0) {
                    c.expandY = 1;
                    return;
                }
            } else if (name.equals("fillx")) {
                if (values.size() == 0) {
                    c.fillX = Float.valueOf(1.0f);
                    return;
                }
            } else if (name.equals("filly")) {
                if (values.size() == 0) {
                    c.fillY = Float.valueOf(1.0f);
                    return;
                }
            } else if (name.equals("fill")) {
                switch (values.size()) {
                    case 0: {
                        c.fillX = c.fillY = Float.valueOf(1.0f);
                        return;
                    }
                    case 1: {
                        String value = values.get(0);
                        if (value.equals("x")) {
                            c.fillX = Float.valueOf(1.0f);
                        } else if (value.equals("y")) {
                            c.fillY = Float.valueOf(1.0f);
                        } else {
                            c.fillX = c.fillY = Float.valueOf((float)Integer.parseInt(value) / 100.0f);
                        }
                        return;
                    }
                    case 2: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.fillX = Float.valueOf((float)Integer.parseInt(value) / 100.0f);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.fillY = Float.valueOf((float)Integer.parseInt(value) / 100.0f);
                        }
                        return;
                    }
                }
            } else if (name.equals("scale") || name.equals("scaling")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.equals("fit")) {
                        c.scaling = 2;
                    } else if (value.equals("fill")) {
                        c.scaling = 4;
                    } else if (value.equals("stretch")) {
                        c.scaling = 8;
                    } else {
                        throw new IllegalArgumentException("Invalid value: " + value);
                    }
                    return;
                }
            } else if (name.equals("size")) {
                switch (values.size()) {
                    case 2: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.prefWidth = c.maxWidth = this.validateSize(value);
                            c.minWidth = c.maxWidth;
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.prefHeight = c.maxHeight = this.validateSize(value);
                            c.minHeight = c.maxHeight;
                        }
                        return;
                    }
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.maxWidth = c.maxHeight = this.validateSize(value);
                            c.prefHeight = c.maxHeight;
                            c.prefWidth = c.maxHeight;
                            c.minHeight = c.maxHeight;
                            c.minWidth = c.maxHeight;
                        }
                        return;
                    }
                }
            } else if (name.equals("width") || name.equals("w")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.prefWidth = c.maxWidth = this.validateSize(value);
                        c.minWidth = c.maxWidth;
                    }
                    return;
                }
            } else if (name.equals("height") || name.equals("h")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.prefHeight = c.maxHeight = this.validateSize(value);
                        c.minHeight = c.maxHeight;
                    }
                    return;
                }
            } else if (name.equals("minsize") || name.equals("min")) {
                switch (values.size()) {
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.minWidth = c.minHeight = this.validateSize(value);
                        }
                        return;
                    }
                    case 2: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.minWidth = this.validateSize(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.minHeight = this.validateSize(value);
                        }
                        return;
                    }
                }
            } else if (name.equals("minwidth") || name.equals("minw")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.minWidth = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("minheight") || name.equals("minh")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.minHeight = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("prefsize") || name.equals("pref")) {
                switch (values.size()) {
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.prefWidth = c.prefHeight = this.validateSize(value);
                        }
                        return;
                    }
                    case 2: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.prefWidth = this.validateSize(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.prefHeight = this.validateSize(value);
                        }
                        return;
                    }
                }
            } else if (name.equals("prefwidth") || name.equals("prefw")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.prefWidth = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("prefheight") || name.equals("prefh")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.prefHeight = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("maxsize") || name.equals("max")) {
                switch (values.size()) {
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.maxWidth = c.maxHeight = this.validateSize(value);
                        }
                        return;
                    }
                    case 2: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.maxWidth = this.validateSize(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.maxHeight = this.validateSize(value);
                        }
                        return;
                    }
                }
            } else if (name.equals("maxwidth") || name.equals("maxw")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.maxWidth = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("maxheight") || name.equals("maxh")) {
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.length() > 0) {
                        c.maxHeight = this.validateSize(value);
                    }
                    return;
                }
            } else if (name.equals("padding") || name.equals("pad")) {
                switch (values.size()) {
                    case 4: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.padTop = this.validateSize(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.padLeft = this.validateSize(value);
                        }
                        if ((value = values.get(2)).length() > 0) {
                            c.padBottom = this.validateSize(value);
                        }
                        if ((value = values.get(3)).length() > 0) {
                            c.padRight = this.validateSize(value);
                        }
                        return;
                    }
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.padBottom = c.padRight = this.validateSize(value);
                            c.padLeft = c.padRight;
                            c.padTop = c.padRight;
                        }
                        return;
                    }
                }
            } else if (name.startsWith("padding") || name.startsWith("pad")) {
                name = name.replace("padding", "").replace("pad", "");
                if (values.size() == 1 && values.get(0).length() > 0) {
                    String value = this.validateSize(values.get(0));
                    if (name.equals("top") || name.equals("t")) {
                        c.padTop = value;
                    } else if (name.equals("left") || name.equals("l")) {
                        c.padLeft = value;
                    } else if (name.equals("bottom") || name.equals("b")) {
                        c.padBottom = value;
                    } else if (name.equals("right") || name.equals("r")) {
                        c.padRight = value;
                    } else {
                        throw new IllegalArgumentException("Unknown cell padding property: " + name);
                    }
                    return;
                }
            } else if (name.equals("spacing") || name.equals("space")) {
                switch (values.size()) {
                    case 4: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.spaceTop = this.validateSize(value);
                        }
                        if ((value = values.get(1)).length() > 0) {
                            c.spaceLeft = this.validateSize(value);
                        }
                        if ((value = values.get(2)).length() > 0) {
                            c.spaceBottom = this.validateSize(value);
                        }
                        if ((value = values.get(3)).length() > 0) {
                            c.spaceRight = this.validateSize(value);
                        }
                        return;
                    }
                    case 1: {
                        String value = values.get(0);
                        if (value.length() > 0) {
                            c.spaceBottom = c.spaceRight = this.validateSize(value);
                            c.spaceLeft = c.spaceRight;
                            c.spaceTop = c.spaceRight;
                        }
                        return;
                    }
                }
            } else if (name.startsWith("spacing") || name.startsWith("space")) {
                name = name.replace("spacing", "").replace("space", "");
                if (values.size() == 1 && values.get(0).length() > 0) {
                    String value = this.validateSize(values.get(0));
                    if (name.equals("top") || name.equals("t")) {
                        c.spaceTop = value;
                    } else if (name.equals("left") || name.equals("l")) {
                        c.spaceLeft = value;
                    } else if (name.equals("bottom") || name.equals("b")) {
                        c.spaceBottom = value;
                    } else if (name.equals("right") || name.equals("r")) {
                        c.spaceRight = value;
                    } else {
                        throw new IllegalArgumentException("Unknown cell spacing property: " + name);
                    }
                    return;
                }
            } else if (name.equals("center")) {
                if (values.size() == 0) {
                    Cell n2 = c;
                    n2.align = n2.align | 1;
                    return;
                }
            } else if (name.equals("left")) {
                if (values.size() == 0) {
                    Cell n2 = c;
                    n2.align = n2.align | 8;
                    return;
                }
            } else if (name.equals("right")) {
                if (values.size() == 0) {
                    Cell n2 = c;
                    n2.align = n2.align | 0x10;
                    return;
                }
            } else if (name.equals("top")) {
                if (values.size() == 0) {
                    Cell n2 = c;
                    n2.align = n2.align | 2;
                    return;
                }
            } else if (name.equals("bottom")) {
                if (values.size() == 0) {
                    Cell n2 = c;
                    n2.align = n2.align | 4;
                    return;
                }
            } else if (name.equals("align")) {
                c.align = 0;
                int n3 = values.size();
                for (i = 0; i < n3; ++i) {
                    Cell cell;
                    String value = values.get(i);
                    if (value.equals("center") || value.equals("c")) {
                        cell = c;
                        Integer.valueOf(cell.align | 1);
                        cell.align = cell.align;
                        continue;
                    }
                    if (value.equals("left") || value.equals("l")) {
                        cell = c;
                        Integer.valueOf(cell.align | 8);
                        cell.align = cell.align;
                        continue;
                    }
                    if (value.equals("right") || value.equals("r")) {
                        cell = c;
                        Integer.valueOf(cell.align | 0x10);
                        cell.align = cell.align;
                        continue;
                    }
                    if (value.equals("top") || value.equals("t")) {
                        cell = c;
                        Integer.valueOf(cell.align | 2);
                        cell.align = cell.align;
                        continue;
                    }
                    if (value.equals("bottom") || value.equals("b")) {
                        cell = c;
                        Integer.valueOf(cell.align | 4);
                        cell.align = cell.align;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid table align value: " + value);
                }
                if (values.size() > 0) {
                    return;
                }
            } else if (name.equals("ignore")) {
                switch (values.size()) {
                    case 1: {
                        c.ignore = Boolean.valueOf(values.get(0));
                        return;
                    }
                    case 0: {
                        c.ignore = true;
                        return;
                    }
                }
            } else if (name.equals("colspan")) {
                switch (values.size()) {
                    case 1: {
                        c.colspan = Integer.parseInt(values.get(0));
                        return;
                    }
                }
            } else {
                if (name.equals("uniform")) {
                    if (values.size() == 0) {
                        c.uniformX = c.uniformY = Boolean.valueOf(true);
                    }
                    int n4 = values.size();
                    for (i = 0; i < n4; ++i) {
                        String value = values.get(i);
                        if (value.equals("x")) {
                            c.uniformX = true;
                            continue;
                        }
                        if (value.equals("y")) {
                            c.uniformY = true;
                            continue;
                        }
                        if (value.equals("true")) {
                            c.uniformY = c.uniformY = Boolean.valueOf(true);
                            continue;
                        }
                        if (value.equals("false")) {
                            c.uniformY = null;
                            c.uniformY = null;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid value: " + value);
                    }
                    return;
                }
                throw new IllegalArgumentException("Unknown cell property.");
            }
            throw new IllegalArgumentException("Invalid number of cell property values (" + values.size() + "): " + values);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting cell property: " + name, ex);
        }
    }

    public int width(L layout, String value) {
        int length;
        if (value == null || (length = value.length()) == 0) {
            return this.width(0.0f);
        }
        if (value.charAt(length - 1) == '%' && length > 1) {
            return (int)((float)(((BaseTableLayout)layout).getLayoutWidth() * Integer.parseInt(value.substring(0, length - 1))) / 100.0f);
        }
        if (value.endsWith("px")) {
            return Integer.parseInt(value.substring(0, value.length() - 2));
        }
        return this.width(value == null ? 0.0f : (float)Integer.parseInt(value));
    }

    public int width(float value) {
        return (int)value;
    }

    public int height(L layout, String value) {
        int length;
        if (value == null || (length = value.length()) == 0) {
            return this.height(0.0f);
        }
        if (value.charAt(length - 1) == '%' && length > 1) {
            return (int)((float)(((BaseTableLayout)layout).getLayoutHeight() * Integer.parseInt(value.substring(0, length - 1))) / 100.0f);
        }
        if (value.endsWith("px")) {
            return Integer.parseInt(value.substring(0, value.length() - 2));
        }
        return this.height(value == null ? 0.0f : (float)Integer.parseInt(value));
    }

    public int height(float value) {
        return (int)value;
    }

    private void invokeMethod(L layout, Object object, String name, List<String> values) throws NoSuchMethodException {
        Object[] params = values.toArray();
        Class[] stringParamTypes = new Class[params.length];
        Method method2 = null;
        try {
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                stringParamTypes[i] = String.class;
            }
            method2 = object.getClass().getMethod(name, stringParamTypes);
        }
        catch (NoSuchMethodException ignored) {
            try {
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    stringParamTypes[i] = CharSequence.class;
                }
                method2 = object.getClass().getMethod(name, stringParamTypes);
            }
            catch (NoSuchMethodException ignored2) {
                // empty catch block
            }
        }
        if (method2 != null) {
            try {
                method2.invoke(object, params);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error invoking method: " + name, ex);
            }
            return;
        }
        block10: for (Method method2 : object.getClass().getMethods()) {
            Class<?>[] paramTypes;
            if (!method2.getName().equalsIgnoreCase(name) || (paramTypes = method2.getParameterTypes()).length != values.size()) continue;
            params = values.toArray();
            int nn = paramTypes.length;
            for (int ii = 0; ii < nn; ++ii) {
                Object value = this.convertType(layout, object, paramTypes[ii], name, (String)params[ii]);
                if (value == null) continue block10;
                params[ii] = value;
            }
            try {
                method2.invoke(object, params);
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error invoking method: " + name, ex);
            }
        }
        throw new NoSuchMethodException();
    }

    protected Object convertType(L layout, Object parentObject, Class memberType, String memberName, String value) {
        Field field;
        if (memberType == String.class || memberType == CharSequence.class) {
            return value;
        }
        try {
            if (memberType == Integer.TYPE || memberType == Integer.class) {
                return Integer.valueOf(value);
            }
            if (memberType == Float.TYPE || memberType == Float.class) {
                return Float.valueOf(value);
            }
            if (memberType == Long.TYPE || memberType == Long.class) {
                return Long.valueOf(value);
            }
            if (memberType == Double.TYPE || memberType == Double.class) {
                return Double.valueOf(value);
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        if (memberType == Boolean.TYPE || memberType == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (memberType == Character.TYPE || memberType == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        if (memberType == Short.TYPE || memberType == Short.class) {
            return Short.valueOf(value);
        }
        if (memberType == Byte.TYPE || memberType == Byte.class) {
            return Byte.valueOf(value);
        }
        try {
            field = Toolkit.getField(memberType, value);
            if (field != null && memberType == field.getType()) {
                return field.get(null);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            field = Toolkit.getField(parentObject.getClass(), value);
            if (field != null && memberType == field.getType()) {
                return field.get(null);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return null;
    }

    public static Field getField(Class type, String name) {
        try {
            Field field = type.getField(name);
            if (field != null) {
                return field;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        while (type != null && type != Object.class) {
            Field[] fields = type.getDeclaredFields();
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                if (!fields[i].getName().equalsIgnoreCase(name)) continue;
                return fields[i];
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static void addClassPrefix(String prefix) {
        classPrefixes.add(prefix);
    }
}

