/*
 * Copyright 2010 Mario Zechner (contact@badlogicgames.com), Nathan Sweet (admin@esotericsoftware.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package com.badlogic.gdxinvaders.simulation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class Explosion extends ModelInstance {
	public static final float EXPLOSION_LIVE_TIME = 1;
	public float aliveTime = 0;

	public Explosion (Model model, Vector3 position) {
		super(model, position);
	}

	public void update (float delta) {
		aliveTime += delta;
	}
	
	@Override
	public void getRenderables (Array<Renderable> renderables, Pool<Renderable> pool) {
		super.getRenderables(renderables, pool);
		Renderable r = renderables.get(renderables.size-1);
		r.meshPartOffset = 6 * (int)(15 * aliveTime / EXPLOSION_LIVE_TIME);
		r.meshPartSize = 6;
	}
}
