/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.10
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA
#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes that proxy
 * method calls from C++ to Java extensions.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
          weak_global = false;
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for 
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
      jenv->DeleteLocalRef(jobj);
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  namespace {
    jclass jclass_gdxBulletJNI = NULL;
    jmethodID director_methids[111];
  }
}

#include <stdint.h>


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <LinearMath/btTransform.h>


#include <LinearMath/btVector3.h>


#include <LinearMath/btQuaternion.h>


#include <LinearMath/btVector3.h>
#define Vector3_to_btVector3(e, t, s) \
	static jfieldID xField = NULL, yField = NULL, zField = NULL; \
	if (xField == NULL) { \
		jclass sc = e->GetObjectClass(s); \
		xField = e->GetFieldID(sc, "x", "F"); \
		yField = e->GetFieldID(sc, "y", "F"); \
		zField = e->GetFieldID(sc, "z", "F"); \
		e->DeleteLocalRef(sc); \
	} \
	t.setValue(e->GetFloatField(s, xField), e->GetFloatField(s, yField), e->GetFloatField(s, zField));
	
#define btVector3_to_Vector3(e, t, s) \
	static jfieldID xField = NULL, yField = NULL, zField = NULL; \
	if (xField == NULL) { \
		jclass tc = e->GetObjectClass(t); \
		xField = e->GetFieldID(tc, "x", "F"); \
		yField = e->GetFieldID(tc, "y", "F"); \
		zField = e->GetFieldID(tc, "z", "F"); \
		e->DeleteLocalRef(tc); \
	  } \
	  e->SetFloatField(t, xField, s.getX()); \
	  e->SetFloatField(t, yField, s.getY()); \
	  e->SetFloatField(t, zField, s.getZ());
	 


#include <LinearMath/btQuaternion.h>
SWIGINTERN inline void Quaternion_to_btQuaternion(JNIEnv * jenv, btQuaternion & target, jobject source) {
	static jfieldID xField = NULL, yField = NULL, zField = NULL, wField = NULL;
	if (xField == NULL) {
		jclass sourceClass = jenv->GetObjectClass(source);
		xField = jenv->GetFieldID(sourceClass, "x", "F");
		yField = jenv->GetFieldID(sourceClass, "y", "F");
		zField = jenv->GetFieldID(sourceClass, "z", "F");
		wField = jenv->GetFieldID(sourceClass, "w", "F");
		jenv->DeleteLocalRef(sourceClass);
	}
	
	target.setValue(
			jenv->GetFloatField(source, xField),
			jenv->GetFloatField(source, yField),
			jenv->GetFloatField(source, zField),
			jenv->GetFloatField(source, wField));
}

SWIGINTERN inline void btQuaternion_to_Quaternion(JNIEnv * jenv, jobject target, const btQuaternion & source) {
	static jfieldID xField = NULL, yField = NULL, zField = NULL, wField = NULL;
	if (xField == NULL) {
		jclass targetClass = jenv->GetObjectClass(target);
		xField = jenv->GetFieldID(targetClass, "x", "F");
		yField = jenv->GetFieldID(targetClass, "y", "F");
		zField = jenv->GetFieldID(targetClass, "z", "F");
		wField = jenv->GetFieldID(targetClass, "w", "F");
		jenv->DeleteLocalRef(targetClass);
	}
	
	jenv->SetFloatField(target, xField, source.getX());
	jenv->SetFloatField(target, yField, source.getY());
	jenv->SetFloatField(target, zField, source.getZ());
	jenv->SetFloatField(target, wField, source.getW());
}


#include <LinearMath/btMatrix3x3.h>
SWIGINTERN inline void Matrix3_to_btMatrix3(JNIEnv * jenv, btMatrix3x3 & target, jobject source) {	  
	static jfieldID valField = NULL;
	if (valField == NULL) {
		jclass sourceClass = jenv->GetObjectClass(source);
		valField = jenv->GetFieldID(sourceClass, "val", "[F");
		jenv->DeleteLocalRef(sourceClass);
	}
	
	jfloatArray valArray = (jfloatArray) jenv->GetObjectField(source, valField);
	jfloat * elements = jenv->GetFloatArrayElements(valArray, NULL);
	
	// Convert to column-major
	target.setValue(
	elements[0], elements[3], elements[6],
	elements[1], elements[4], elements[7],
	elements[2], elements[5], elements[8]);
	
	jenv->ReleaseFloatArrayElements(valArray, elements, JNI_ABORT);
	jenv->DeleteLocalRef(valArray);
}
SWIGINTERN inline void btMatrix3_to_Matrix3(JNIEnv * jenv, jobject target, const btMatrix3x3 & source) {
	static jfieldID valField = NULL;
	if (valField == NULL) {
		jclass targetClass = jenv->GetObjectClass(target);
		valField = jenv->GetFieldID(targetClass, "val", "[F");
		jenv->DeleteLocalRef(targetClass);
	}
	
	jfloatArray valArray = (jfloatArray) jenv->GetObjectField(target, valField);
	jfloat * elements = jenv->GetFloatArrayElements(valArray, NULL);
	
	// Convert to column-major
	elements[0] = (jfloat) source.getColumn(0).getX();
	elements[1] = (jfloat) source.getColumn(0).getY();
	elements[2] = (jfloat) source.getColumn(0).getZ();
	elements[3] = (jfloat) source.getColumn(1).getX();
	elements[4] = (jfloat) source.getColumn(1).getY();
	elements[5] = (jfloat) source.getColumn(1).getZ();
	elements[6] = (jfloat) source.getColumn(2).getX();
	elements[7] = (jfloat) source.getColumn(2).getY();
	elements[8] = (jfloat) source.getColumn(2).getZ();
	
	jenv->ReleaseFloatArrayElements(valArray, elements, 0);  
	jenv->DeleteLocalRef(valArray);
}


#include <LinearMath/btTransform.h>
SWIGINTERN inline void Matrix4_to_btTransform(JNIEnv * jenv, btTransform & target, jobject source) {
	static jfieldID valField = NULL;
	if (valField == NULL) {
		jclass sourceClass = jenv->GetObjectClass(source);
		valField = jenv->GetFieldID(sourceClass, "val", "[F");
		jenv->DeleteLocalRef(sourceClass);
	}
	
	jfloatArray valArray = (jfloatArray) jenv->GetObjectField(source, valField);
	jfloat * elements = jenv->GetFloatArrayElements(valArray, NULL);
	
	target.setFromOpenGLMatrix(elements);
	
	jenv->ReleaseFloatArrayElements(valArray, elements, JNI_ABORT);
	jenv->DeleteLocalRef(valArray);
}
	
SWIGINTERN inline void btTransform_to_Matrix4(JNIEnv * jenv, jobject target, const btTransform & source) {
	static jfieldID valField = NULL;
	if (valField == NULL) {
		jclass targetClass = jenv->GetObjectClass(target);
		valField = jenv->GetFieldID(targetClass, "val", "[F");
		jenv->DeleteLocalRef(targetClass);
	}
	
	jfloatArray valArray = (jfloatArray) jenv->GetObjectField(target, valField);
	jfloat * elements = jenv->GetFloatArrayElements(valArray, NULL);

	source.getOpenGLMatrix(elements);
	
	jenv->ReleaseFloatArrayElements(valArray, elements, 0);
	jenv->DeleteLocalRef(valArray);
}


#include <LinearMath/btQuadWord.h>


#include <LinearMath/btMatrix3x3.h>


#include <LinearMath/btAabbUtil2.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClass(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/gdxBulletJNI"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObject(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClass(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObject(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClass(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoRelease {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoRelease(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoRelease() {
		gdx_releasePoolObject(this->jenv, this->poolName, this->obj);
	  };
	};



	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Vector3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnVector3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClass(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticVector3", "Lcom/badlogic/gdx/math/Vector3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 & target, jobject source) {
		Vector3_to_btVector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 * target, jobject source) {
		gdx_setbtVector3FromVector3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 & source) {
		btVector3_to_Vector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 * source) {
		gdx_setVector3FrombtVector3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btVector3 back to Vector3
	 */
	class gdxAutoCommitVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	public:
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3) { };
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3) { };
	  virtual ~gdxAutoCommitVector3() {
	    gdx_setVector3FrombtVector3(this->jenv, this->jVector3, this->cbtVector3);
	  };
	};

	class gdxAutoCommitbtVector3AndReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3), poolName(poolName) { };
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtVector3AndReleaseVector3() {
	    gdx_setbtVector3FromVector3(this->jenv, this->cbtVector3, this->jVector3);
	    gdx_releasePoolObject(this->jenv, this->poolName, this->jVector3);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix4.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix4(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClass(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix4", "Lcom/badlogic/gdx/math/Matrix4;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform & target, jobject source) {
		Matrix4_to_btTransform(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform * target, jobject source) {
		gdx_setbtTransformFromMatrix4(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform & source) {
		btTransform_to_Matrix4(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform * source) {
		gdx_setMatrix4FrombtTransform(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btTransform back to Matrix4
	 */
	class gdxAutoCommitMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	public:
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform) { };
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform) { };
	  virtual ~gdxAutoCommitMatrix4() {
	    gdx_setMatrix4FrombtTransform(this->jenv, this->jMatrix4, this->cbtTransform);
	  };
	};

	class gdxAutoCommitbtTransformAndReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	  const char * poolName;
	public:
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform), poolName(poolName) { };
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtTransformAndReleaseMatrix4() {
	    gdx_setbtTransformFromMatrix4(this->jenv, this->cbtTransform, this->jMatrix4);
	    gdx_releasePoolObject(this->jenv, this->poolName, this->jMatrix4);
	  };
	};


#include <LinearMath/btIDebugDraw.h>


#include <LinearMath/btGeometryUtil.h>


#include <LinearMath/btRandom.h>


#include <LinearMath/btTransformUtil.h>


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Quaternion.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnQuaternion(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClass(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticQuaternion", "Lcom/badlogic/gdx/math/Quaternion;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion & target, jobject source) {
		Quaternion_to_btQuaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion * target, jobject source) {
		gdx_setbtQuaternionFromQuaternion(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion & source) {
		btQuaternion_to_Quaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion * source) {
		gdx_setQuaternionFrombtQuaternion(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btQuaternion back to Quaternion
	 */
	class gdxAutoCommitQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	public:
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion) { };
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion) { };
	  virtual ~gdxAutoCommitQuaternion() {
	    gdx_setQuaternionFrombtQuaternion(this->jenv, this->jQuaternion, this->cbtQuaternion);
	  };
	};

	class gdxAutoCommitbtQuaternionAndReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	  const char * poolName;
	public:
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion), poolName(poolName) { };
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtQuaternionAndReleaseQuaternion() {
	    gdx_setbtQuaternionFromQuaternion(this->jenv, this->cbtQuaternion, this->jQuaternion);
	    gdx_releasePoolObject(this->jenv, this->poolName, this->jQuaternion);
	  };
	};


#include <LinearMath/btConvexHull.h>


#include <LinearMath/btGrahamScan2dConvexHull.h>


#include <LinearMath/btPoolAllocator.h>


#include <LinearMath/btQuickprof.h>


#include <LinearMath/btConvexHullComputer.h>


#include <LinearMath/btAlignedObjectArray.h>


#include <LinearMath/btList.h>


#include <LinearMath/btAlignedAllocator.h>


#include <LinearMath/btHashMap.h>


#include <LinearMath/btStackAlloc.h>


#include <LinearMath/btMinMax.h>


#include <LinearMath/btMotionState.h>


#include <LinearMath/btDefaultMotionState.h>

SWIGINTERN void btDefaultMotionState_getGraphicsWorldTrans(btDefaultMotionState *self,btTransform &out){
		out = self->m_graphicsWorldTrans;
	}
SWIGINTERN void btDefaultMotionState_getCenterOfMassOffset(btDefaultMotionState *self,btTransform &out){
		out = self->m_centerOfMassOffset;
	}
SWIGINTERN void btDefaultMotionState_getStartWorldTrans(btDefaultMotionState *self,btTransform &out){
		out = self->m_startWorldTrans;
	}

#include <BulletCollision/NarrowPhaseCollision/btDiscreteCollisionDetectorInterface.h>


typedef btDiscreteCollisionDetectorInterface::Result Result;
typedef btDiscreteCollisionDetectorInterface::ClosestPointInput ClosestPointInput;


#include <BulletCollision/BroadphaseCollision/btBroadphaseProxy.h>


#include <BulletCollision/BroadphaseCollision/btBroadphaseInterface.h>


#include <BulletCollision/BroadphaseCollision/btDbvt.h>


#include <BulletCollision/BroadphaseCollision/btQuantizedBvh.h>


#include <BulletCollision/BroadphaseCollision/btDbvtBroadphase.h>


#include <BulletCollision/BroadphaseCollision/btSimpleBroadphase.h>


#include <BulletCollision/BroadphaseCollision/btMultiSapBroadphase.h>


#include <BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h>


#include <BulletCollision/BroadphaseCollision/btOverlappingPairCallback.h>


#include <BulletCollision/BroadphaseCollision/btAxisSweep3.h>


#include <BulletCollision/BroadphaseCollision/btDispatcher.h>


#include <BulletCollision/BroadphaseCollision/btOverlappingPairCache.h>


#include <BulletCollision/CollisionShapes/btCollisionShape.h>


#include <BulletCollision/CollisionShapes/btConvexShape.h>


#include <BulletCollision/CollisionShapes/btConvexInternalShape.h>


#include <BulletCollision/CollisionShapes/btPolyhedralConvexShape.h>


#include <BulletCollision/CollisionShapes/btConcaveShape.h>


#include <BulletCollision/CollisionShapes/btTriangleCallback.h>


#include <BulletCollision/CollisionShapes/btTriangleInfoMap.h>


#include <BulletCollision/CollisionShapes/btStaticPlaneShape.h>


#include <BulletCollision/CollisionShapes/btHeightfieldTerrainShape.h>

SWIGINTERN btHeightfieldTerrainShape *new_btHeightfieldTerrainShape__SWIG_0(int heightStickWidth,int heightStickLength,float const *heightfieldData,btScalar heightScale,btScalar minHeight,btScalar maxHeight,int upAxis,bool flipQuadEdges){
		return new btHeightfieldTerrainShape(heightStickWidth, heightStickLength, (void *)heightfieldData, heightScale, minHeight, maxHeight, upAxis, PHY_FLOAT, flipQuadEdges);
	}
SWIGINTERN btHeightfieldTerrainShape *new_btHeightfieldTerrainShape__SWIG_1(int heightStickWidth,int heightStickLength,short const *heightfieldData,btScalar heightScale,btScalar minHeight,btScalar maxHeight,int upAxis,bool flipQuadEdges){
		return new btHeightfieldTerrainShape(heightStickWidth, heightStickLength, (void *)heightfieldData, heightScale, minHeight, maxHeight, upAxis, PHY_SHORT, flipQuadEdges);
	}

#include <BulletCollision/CollisionShapes/btTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btBvhTriangleMeshShape.h>

SWIGINTERN btBvhTriangleMeshShape *new_btBvhTriangleMeshShape__SWIG_0(bool dummy,btStridingMeshInterface *meshInterface,bool useQuantizedAabbCompression,bool buildBvh=true){
		return new btBvhTriangleMeshShape(meshInterface, useQuantizedAabbCompression, buildBvh);
	}
SWIGINTERN btBvhTriangleMeshShape *new_btBvhTriangleMeshShape__SWIG_2(bool dummy,btStridingMeshInterface *meshInterface,bool useQuantizedAabbCompression,btVector3 const &bvhAabbMin,btVector3 const &bvhAabbMax,bool buildBvh=true){
		return new btBvhTriangleMeshShape(meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax, buildBvh);
	}

#include <BulletCollision/CollisionShapes/btBoxShape.h>


#include <BulletCollision/CollisionShapes/btCapsuleShape.h>


#include <BulletCollision/CollisionShapes/btBox2dShape.h>


#include <BulletCollision/CollisionShapes/btCollisionMargin.h>


#include <BulletCollision/CollisionShapes/btTriangleShape.h>


#include <BulletCollision/CollisionShapes/btSphereShape.h>


#include <BulletCollision/CollisionShapes/btStridingMeshInterface.h>


#include <BulletCollision/CollisionShapes/btMinkowskiSumShape.h>


#include <BulletCollision/CollisionShapes/btConvexPolyhedron.h>


#include <BulletCollision/CollisionShapes/btOptimizedBvh.h>


#include <BulletCollision/CollisionShapes/btTriangleBuffer.h>


#include <BulletCollision/CollisionShapes/btTriangleIndexVertexArray.h>

SWIGINTERN void btIndexedMesh_setTriangleIndexBase(btIndexedMesh *self,short *data){
		self->m_triangleIndexBase = (unsigned char*)data;
	}
SWIGINTERN void btIndexedMesh_setVertexBase(btIndexedMesh *self,float *data){
		self->m_vertexBase = (unsigned char*)data;
	}
SWIGINTERN void btIndexedMesh_setVertices(btIndexedMesh *self,float *vertices,int sizeInBytesOfEachVertex,int vertexCount,int positionOffsetInBytes){
		unsigned char *data = (unsigned char *)vertices;
		self->m_vertexBase = &(data[positionOffsetInBytes]);
		self->m_vertexStride = sizeInBytesOfEachVertex;
		self->m_numVertices = vertexCount;
		self->m_vertexType = PHY_FLOAT;
	}
SWIGINTERN void btIndexedMesh_setIndices(btIndexedMesh *self,short *indices,int indexOffset,int indexCount){
		self->m_triangleIndexBase = (unsigned char*)&(indices[indexOffset]);
		self->m_triangleIndexStride = 3 * sizeof(short);
		self->m_numTriangles = indexCount / 3;
		self->m_indexType = PHY_SHORT;
	}

#include <BulletCollision/CollisionShapes/btMaterial.h>


#include <BulletCollision/CollisionShapes/btScaledBvhTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btShapeHull.h>


#include <BulletCollision/CollisionShapes/btConvexHullShape.h>

SWIGINTERN btConvexHullShape *new_btConvexHullShape__SWIG_4(btShapeHull const *hull){
		btConvexHullShape *result = new btConvexHullShape(); 
		for (int i = 0; i < hull->numVertices(); i++) {
			result->addPoint(hull->getVertexPointer()[i]);
		}		
		return result;
	}

#include <BulletCollision/CollisionShapes/btTriangleIndexVertexMaterialArray.h>


#include <BulletCollision/CollisionShapes/btCylinderShape.h>


#include <BulletCollision/CollisionShapes/btTriangleMesh.h>


#include <BulletCollision/CollisionShapes/btConeShape.h>


#include <BulletCollision/CollisionShapes/btConvexTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btEmptyShape.h>


#include <BulletCollision/CollisionShapes/btMultimaterialTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btTetrahedronShape.h>


#include <BulletCollision/CollisionShapes/btUniformScalingShape.h>


#include <BulletCollision/CollisionShapes/btCompoundShape.h>


#include <BulletCollision/CollisionShapes/btConvexPointCloudShape.h>


#include <BulletCollision/CollisionShapes/btConvex2dShape.h>


#include <BulletCollision/CollisionDispatch/btCollisionObject.h>
#include <gdx/GdxCollisionObjectBridge.h>

SWIGINTERN void btCollisionObject_internalSetGdxBridge(btCollisionObject *self,GdxCollisionObjectBridge *bridge){
		self->setUserPointer(bridge);
	}
SWIGINTERN GdxCollisionObjectBridge *btCollisionObject_internalGetGdxBridge(btCollisionObject *self){
		return (GdxCollisionObjectBridge *)(self->getUserPointer());
	}
SWIGINTERN void btCollisionObject_getAnisotropicFriction__SWIG_1(btCollisionObject *self,btVector3 &out){
		out = self->getAnisotropicFriction();
	}
SWIGINTERN void btCollisionObject_getWorldTransform__SWIG_2(btCollisionObject *self,btTransform &out){
		out = self->getWorldTransform();
	}
SWIGINTERN void btCollisionObject_getInterpolationWorldTransform__SWIG_2(btCollisionObject *self,btTransform &out){
		out = self->getInterpolationWorldTransform();
	}
SWIGINTERN void btCollisionObject_getInterpolationLinearVelocity__SWIG_1(btCollisionObject *self,btVector3 &out){
		out = self->getInterpolationLinearVelocity();
	}
SWIGINTERN void btCollisionObject_getInterpolationAngularVelocity__SWIG_1(btCollisionObject *self,btVector3 &out){
		out = self->getInterpolationAngularVelocity();
	}

#include <BulletCollision/CollisionDispatch/btCollisionObjectWrapper.h>


#include <BulletCollision/CollisionDispatch/btEmptyCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btConvexConcaveCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btConvexPlaneCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btCollisionConfiguration.h>


#include <BulletCollision/CollisionDispatch/btDefaultCollisionConfiguration.h>


#include <BulletCollision/CollisionDispatch/btManifoldResult.h>


#include <BulletCollision/CollisionDispatch/btSphereSphereCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btBoxBoxCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btCollisionCreateFunc.h>


#include <BulletCollision/CollisionDispatch/btBox2dBox2dCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btUnionFind.h>


#include <BulletCollision/CollisionDispatch/btSphereTriangleCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btSimulationIslandManager.h>


#include <BulletCollision/CollisionDispatch/btGhostObject.h>


#include <BulletCollision/CollisionDispatch/btCollisionWorld.h>


typedef btCollisionWorld::LocalShapeInfo LocalShapeInfo;
typedef btCollisionWorld::LocalRayResult LocalRayResult;
typedef btCollisionWorld::RayResultCallback RayResultCallback;
typedef btCollisionWorld::ClosestRayResultCallback ClosestRayResultCallback;
typedef btCollisionWorld::AllHitsRayResultCallback AllHitsRayResultCallback;
typedef btCollisionWorld::LocalConvexResult LocalConvexResult;
typedef btCollisionWorld::ConvexResultCallback ConvexResultCallback;
typedef btCollisionWorld::ClosestConvexResultCallback ClosestConvexResultCallback;
typedef btCollisionWorld::ContactResultCallback ContactResultCallback;


#include <gdx/ClosestNotMeConvexResultCallback.h>


#include <gdx/ClosestNotMeRayResultCallback.h>


#include <BulletCollision/CollisionDispatch/btConvex2dConvex2dAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btBoxBoxDetector.h>


#include <BulletCollision/CollisionDispatch/btSphereBoxCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btCollisionDispatcher.h>


#include <BulletCollision/CollisionDispatch/btConvexConvexAlgorithm.h>


#include <BulletCollision/CollisionDispatch/SphereTriangleDetector.h>


#include <BulletCollision/CollisionDispatch/btInternalEdgeUtility.h>


#include <BulletCollision/CollisionDispatch/btCompoundCollisionAlgorithm.h>


#include <BulletCollision/NarrowPhaseCollision/btConvexCast.h>


#include <BulletCollision/NarrowPhaseCollision/btSubSimplexConvexCast.h>


#include <BulletCollision/NarrowPhaseCollision/btPolyhedralContactClipping.h>


#include <BulletCollision/NarrowPhaseCollision/btPersistentManifold.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkPairDetector.h>


#include <BulletCollision/NarrowPhaseCollision/btConvexPenetrationDepthSolver.h>


#include <BulletCollision/NarrowPhaseCollision/btMinkowskiPenetrationDepthSolver.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkConvexCast.h>


#include <BulletCollision/NarrowPhaseCollision/btManifoldPoint.h>

SWIGINTERN int btManifoldPoint_getUserValue(btManifoldPoint *self){
		int result;
		*(const void **)&result = self->m_userPersistentData;
		return result;
	}
SWIGINTERN void btManifoldPoint_setUserValue(btManifoldPoint *self,int value){
		self->m_userPersistentData = (void*)value;
	}

#include <BulletCollision/NarrowPhaseCollision/btContinuousConvexCollision.h>


#include <BulletCollision/NarrowPhaseCollision/btRaycastCallback.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkEpa2.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkEpaPenetrationDepthSolver.h>


#include <BulletCollision/NarrowPhaseCollision/btPointCollector.h>


#include <BulletCollision/NarrowPhaseCollision/btVoronoiSimplexSolver.h>


#include <BulletCollision/NarrowPhaseCollision/btSimplexSolverInterface.h>


#include <BulletCollision/CollisionShapes/btMultiSphereShape.h>


	btVector3* Vector3ArrayToBtVector3Array(JNIEnv * jenv, jobjectArray source) {
		static jfieldID xField = NULL, yField = NULL, zField = NULL;
		jint len = jenv->GetArrayLength(source);
		if (len <= 0)
			return NULL;
			
		btVector3* result = new btVector3[len];
			
		if (xField == NULL) {
			jobject vec = jenv->GetObjectArrayElement(source, 0);
			jclass sc = jenv->GetObjectClass(vec);
			xField = jenv->GetFieldID(sc, "x", "F");
			yField = jenv->GetFieldID(sc, "y", "F");
			zField = jenv->GetFieldID(sc, "z", "F");
			jenv->DeleteLocalRef(sc);
		}
		
		for (int i = 0; i < len; i++) {
			jobject vec = jenv->GetObjectArrayElement(source, i);
			result[i].setValue(jenv->GetFloatField(vec, xField), jenv->GetFloatField(vec, yField), jenv->GetFloatField(vec, zField));
		}
		return result;
	}
	
	class gdxAutoDeleteBtVector3Array {
	private:
	  btVector3* array;
	public:
	  gdxAutoDeleteBtVector3Array(btVector3* arr) : 
	    array(arr) { }
	  virtual ~gdxAutoDeleteBtVector3Array() {
		  if (array != NULL)
			  delete[] array;
	  }
	};


#include <gdx/ContactListener.h>
bool custom_ContactListener_setEvents(ContactListener *listener);


	// Inline (cached) method to retrieve the type's jclass
	SWIGINTERN inline jclass gdx_getClassbtManifoldPoint(JNIEnv * jenv) {
		static jclass cls = NULL;
		if (cls == NULL)
			cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/btManifoldPoint"));
		return cls;
	}
	
	// Inline method to get the termporary instance
	SWIGINTERN inline jobject gdx_getTempbtManifoldPoint(JNIEnv * jenv, void *cPtr, bool ownMem) {
	  static jobject ret = NULL;
	  static jclass clazz = gdx_getClassbtManifoldPoint(jenv);
	  if (ret == NULL) {
	    jfieldID field = jenv->GetStaticFieldID(clazz, "temp", "com/badlogic/gdx/physics/bullet/btManifoldPoint");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(clazz, field));
	  }
	  
	  static jmethodID reuseMethod = NULL;
	  if (reuseMethod == NULL)
		  reuseMethod = (jmethodID) jenv->GetMethodID(clazz, "reset", "(JZ)V");
	  
	  long ptr;
	  *(const void **)&ptr = cPtr;
	  jenv->CallVoidMethod(ret, reuseMethod, ptr, (jboolean)ownMem);
	  return ret;
	}

	// Inline method to obtain an instance from the pool
	SWIGINTERN inline jobject gdx_obtainbtManifoldPoint(JNIEnv * jenv, jclass clazz, void *cPtr, bool ownMem) {
		static jmethodID obtainMethod = NULL;
		if (obtainMethod == NULL)
			obtainMethod = (jmethodID) jenv->GetStaticMethodID(clazz, "obtain", "(JZ)Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;");
		
		long ptr;
		*(const void **)&ptr = cPtr; 
		jobject ret = jenv->CallStaticObjectMethod(clazz, obtainMethod, ptr, (jboolean)ownMem);
		
		return ret;
	}
	
	// Inline method to free an instance from the pool
	SWIGINTERN inline void gdx_freebtManifoldPoint(JNIEnv * jenv, const jclass clazz, const jobject obj) {
		static jmethodID freeMethod = NULL;
		if (freeMethod == NULL)
			freeMethod = (jmethodID) jenv->GetStaticMethodID(clazz, "free", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;)V");
		
		jenv->CallStaticVoidMethod(clazz, freeMethod, obj);
		
		jenv->DeleteLocalRef(obj);
	}
	
	// Simple raii class to auto free the instance from the pool 
	class gdxAutoFreebtManifoldPoint {
	private:
		JNIEnv * jenv;
		jobject jbtManifoldPoint;
		jclass jclazz;
	public:
		gdxAutoFreebtManifoldPoint(JNIEnv * jenv, jclass jclazz, jobject jbtManifoldPoint) : 
			jenv(jenv), jbtManifoldPoint(jbtManifoldPoint), jclazz(jclazz) { }
		virtual ~gdxAutoFreebtManifoldPoint() {
			gdx_freebtManifoldPoint(this->jenv, this->jclazz, this->jbtManifoldPoint);
		}
	};

SWIGINTERN bool ContactListener_setEvents(ContactListener *self){
		return custom_ContactListener_setEvents(self);
	}

#include <gdx/ContactCache.h>

 /*SWIG_JavaArrayArgout##Bool(jenv, jarr$argnum, (bool *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Schar(jenv, jarr$argnum, (signed char *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Uchar(jenv, jarr$argnum, (unsigned char *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Short(jenv, jarr$argnum, (short *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Ushort(jenv, jarr$argnum, (unsigned short *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Int(jenv, jarr$argnum, (int *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Uint(jenv, jarr$argnum, (unsigned int *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Long(jenv, jarr$argnum, (long *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Ulong(jenv, jarr$argnum, (unsigned long *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Longlong(jenv, jarr$argnum, (long long *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Float(jenv, jarr$argnum, (float *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Double(jenv, jarr$argnum, (double *)$1, $input);*/ 
SWIGINTERN int btAlignedObjectArray_Sl_btBroadphasePair_Sg__getCollisionObjects(btAlignedObjectArray< btBroadphasePair > *self,int result[],int max,int other){
		static btManifoldArray marr;
		const int n = self->size();
		int count = 0;
		int obj0, obj1;
		for (int i = 0; i < n; i++) {
			const btBroadphasePair& collisionPair = (*self)[i];
			if (collisionPair.m_algorithm) {
				marr.resize(0);
				collisionPair.m_algorithm->getAllContactManifolds(marr);
				const int s = marr.size();
				for (int j = 0; j < s; j++) {
					btPersistentManifold *manifold = marr[j];
					if (manifold->getNumContacts() > 0) {
						*(const btCollisionObject **)&obj0 = manifold->getBody0();
						*(const btCollisionObject **)&obj1 = manifold->getBody1();
						if (obj0 == other)
							result[count++] = obj1;
						else if (obj1 == other)
							result[count++] = obj0;
						else continue;
						if (count >= max)
							return count;
					}
				}
			}
		}
		return count;
	}
SWIGINTERN int btAlignedObjectArray_Sl_btBroadphasePair_Sg__getCollisionObjectsValue(btAlignedObjectArray< btBroadphasePair > *self,int result[],int max,int other){
		static btManifoldArray marr;
		const int n = self->size();
		int count = 0;
		int obj0, obj1;
		for (int i = 0; i < n; i++) {
			const btBroadphasePair& collisionPair = (*self)[i];
			if (collisionPair.m_algorithm) {
				marr.resize(0);
				collisionPair.m_algorithm->getAllContactManifolds(marr);
				const int s = marr.size();
				for (int j = 0; j < s; j++) {
					btPersistentManifold *manifold = marr[j];
					if (manifold->getNumContacts() > 0) {
						*(const btCollisionObject **)&obj0 = manifold->getBody0();
						*(const btCollisionObject **)&obj1 = manifold->getBody1();
						if (obj0 == other)
							result[count++] = ((GdxCollisionObjectBridge*)manifold->getBody1()->getUserPointer())->userValue;
						else if (obj1 == other)
							result[count++] = ((GdxCollisionObjectBridge*)manifold->getBody0()->getUserPointer())->userValue;
						else continue;
						if (count >= max)
							return count;
					}
				}
			}
		}
		return count;
	}

#include <BulletDynamics/Dynamics/btRigidBody.h>
typedef btRigidBody::btRigidBodyConstructionInfo btRigidBodyConstructionInfo;

SWIGINTERN btRigidBodyConstructionInfo *new_btRigidBodyConstructionInfo__SWIG_0(bool dummy,btScalar mass,btMotionState *motionState,btCollisionShape *collisionShape,btVector3 const &localInertia=btVector3(0,0,0)){
		return new btRigidBodyConstructionInfo(mass, motionState, collisionShape, localInertia); 
	}

	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClass(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix3", "Lcom/badlogic/gdx/math/Matrix3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 & target, jobject source) {
		Matrix3_to_btMatrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 * target, jobject source) {
		gdx_setbtMatrix3x3FromMatrix3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 & source) {
		btMatrix3_to_Matrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 * source) {
		gdx_setMatrix3FrombtMatrix3x3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btMatrix3x3 back to Matrix3
	 */
	class gdxAutoCommitMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	public:
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3) { };
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3) { };
	  virtual ~gdxAutoCommitMatrix3() {
	    gdx_setMatrix3FrombtMatrix3x3(this->jenv, this->jMatrix3, this->cbtMatrix3x3);
	  };
	};

	class gdxAutoCommitbtMatrix3x3AndReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3), poolName(poolName) { };
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtMatrix3x3AndReleaseMatrix3() {
	    gdx_setbtMatrix3x3FromMatrix3(this->jenv, this->cbtMatrix3x3, this->jMatrix3);
	    gdx_releasePoolObject(this->jenv, this->poolName, this->jMatrix3);
	  };
	};

SWIGINTERN btRigidBody *new_btRigidBody__SWIG_0(bool dummy,btRigidBodyConstructionInfo const &constructionInfo){
		return new btRigidBody(constructionInfo); 
	}
SWIGINTERN btRigidBody *new_btRigidBody__SWIG_1(bool dummy,btScalar mass,btMotionState *motionState,btCollisionShape *collisionShape,btVector3 const &localInertia=btVector3(0,0,0)){
		return new btRigidBody(mass, motionState, collisionShape, localInertia);
	}

#include <BulletDynamics/ConstraintSolver/btTypedConstraint.h>


typedef btTypedConstraint::btConstraintInfo2 btConstraintInfo2;


#include <BulletDynamics/Dynamics/btDynamicsWorld.h>


#include <gdx/InternalTickCallback.h>


#include <BulletDynamics/Dynamics/btSimpleDynamicsWorld.h>


#include <BulletDynamics/Dynamics/btActionInterface.h>


#include <BulletDynamics/Dynamics/btDiscreteDynamicsWorld.h>


#include <BulletDynamics/Character/btCharacterControllerInterface.h>


#include <BulletDynamics/Character/btKinematicCharacterController.h>


#include <BulletDynamics/ConstraintSolver/btContactSolverInfo.h>


#include <BulletDynamics/ConstraintSolver/btConstraintSolver.h>


#include <BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolver.h>


#include <BulletDynamics/ConstraintSolver/btSolverBody.h>


#include <BulletDynamics/ConstraintSolver/btSliderConstraint.h>


#include <BulletDynamics/ConstraintSolver/btPoint2PointConstraint.h>


#include <BulletDynamics/ConstraintSolver/btJacobianEntry.h>


#include <BulletDynamics/ConstraintSolver/btSolve2LinearConstraint.h>


#include <BulletDynamics/ConstraintSolver/btGeneric6DofConstraint.h>


#include <BulletDynamics/ConstraintSolver/btUniversalConstraint.h>


#include <BulletDynamics/ConstraintSolver/btContactConstraint.h>


#include <BulletDynamics/ConstraintSolver/btConeTwistConstraint.h>


#include <BulletDynamics/ConstraintSolver/btGeneric6DofSpringConstraint.h>


#include <BulletDynamics/ConstraintSolver/btHingeConstraint.h>


#include <BulletDynamics/ConstraintSolver/btSolverConstraint.h>


#include <BulletDynamics/ConstraintSolver/btHinge2Constraint.h>


#include <BulletDynamics/Vehicle/btVehicleRaycaster.h>


#include <BulletDynamics/Vehicle/btWheelInfo.h>


#include <BulletDynamics/Vehicle/btRaycastVehicle.h>
typedef btRaycastVehicle::btVehicleTuning btVehicleTuning; // FIXME This should be done by nestedworkaround


#include <BulletSoftBody/btSoftBodySolvers.h>


#include <BulletSoftBody/btDefaultSoftBodySolver.h>


#include <BulletSoftBody/btSparseSDF.h>


#include <BulletSoftBody/btSoftBody.h>

SWIGINTERN btSoftBody *new_btSoftBody__SWIG_2(btSoftBodyWorldInfo *worldInfo,float *vertices,int vertexSize,int posOffset,int normalOffset,short *indices,int indexOffset,int numVertices,short *indexMap,int indexMapOffset){		
		int poffset = posOffset / sizeof(btScalar);
		int noffset = normalOffset / sizeof(btScalar);
		int size = vertexSize / sizeof(btScalar);
		btAlignedObjectArray<btVector3>	points;
		
		btSoftBody *result = new btSoftBody(worldInfo);
		btSoftBody::Material* pm = result->appendMaterial();
		pm->m_kLST = 1;
		pm->m_kAST = 1;
		pm->m_kVST = 1;
		pm->m_flags = btSoftBody::fMaterial::Default;
		
		const btScalar margin = result->getCollisionShape()->getMargin();
		int nodeCount = 0;
		result->m_nodes.resize(numVertices);
		for (int i = 0; i < numVertices; i++) {
			const float * const &verts = &vertices[indices[indexOffset+i]*size+poffset];
			btVector3 point(verts[0], verts[1], verts[2]);
			int idx = -1;
			for (int j = 0; j < nodeCount; j++) {
				if (result->m_nodes[j].m_x==point) {
					idx = j;
					break;
				}
			}
			if (idx < 0) {
				btSoftBody::Node &node = result->m_nodes[nodeCount];
				memset(&node,0,sizeof(btSoftBody::Node));
				node.m_x = point;
				node.m_q = node.m_x;
				node.m_im = 1;
				node.m_leaf = result->m_ndbvt.insert(btDbvtVolume::FromCR(node.m_x,margin),&node);
				node.m_material = pm;
				if (noffset >= 0) {
					node.m_n.m_floats[0] = vertices[indices[indexOffset+i]*size+noffset];
					node.m_n.m_floats[1] = vertices[indices[indexOffset+i]*size+noffset+1];
					node.m_n.m_floats[2] = vertices[indices[indexOffset+i]*size+noffset+2];
				}
				points.push_back(point);
				idx = nodeCount;
				nodeCount++;
			}
			indexMap[indexMapOffset+i] = (short)idx; 
		}
		result->m_nodes.resize(nodeCount);
		
		//const int vertexCount = points.size();
		//btSoftBody *result = new btSoftBody(worldInfo, vertexCount, &points[0], 0);
		
		btAlignedObjectArray<bool> chks;
		chks.resize(nodeCount * nodeCount, false);
		for(int i=0; i<numVertices; i+=3)
		{
			const int idx[]={indexMap[indexMapOffset+i],indexMap[indexMapOffset+i+1],indexMap[indexMapOffset+i+2]};

			for(int j=2,k=0;k<3;j=k++)
			{
				if(!chks[((idx[k])*nodeCount+(idx[j]))])
				{
					chks[((idx[k])*nodeCount+(idx[j]))]=true;
					chks[((idx[j])*nodeCount+(idx[k]))]=true;
					result->appendLink(idx[j],idx[k]);
				}
			}

			result->appendFace(idx[0],idx[1],idx[2]);
		}
		
		result->updateBounds();
		return result;
	}
SWIGINTERN int btSoftBody_getNodeCount(btSoftBody *self){
		return self->m_nodes.size();
	}
SWIGINTERN btSoftBody::Node *btSoftBody_getNode(btSoftBody *self,int idx){
		return &(self->m_nodes[idx]);
	}
SWIGINTERN void btSoftBody_getVertices__SWIG_0(btSoftBody *self,btScalar *buffer,int vertexCount,int vertexSize,int posOffset){
		int offset = posOffset / (sizeof(btScalar));
		int size = vertexSize / (sizeof(btScalar));
		for (int i = 0; i < vertexCount; i++) {
			const int o = i*size+offset;
			const float *src = self->m_nodes[i].m_x.m_floats;
			buffer[o] = src[0];
			buffer[o+1] = src[1];
			buffer[o+2] = src[2];
		}
	}
SWIGINTERN void btSoftBody_getVertices__SWIG_1(btSoftBody *self,float *vertices,int vertexSize,int posOffset,short *indices,int indexOffset,int numVertices,short *indexMap,int indexMapOffset){
		int poffset = posOffset / (sizeof(btScalar));
		int size = vertexSize / (sizeof(btScalar));
		for (int i = 0; i < numVertices; i++) {
			const int vidx = indices[indexOffset+i]*size+poffset;
			const int pidx = indexMap[indexMapOffset+i];
			const float * const &point = self->m_nodes[pidx].m_x.m_floats;
			vertices[vidx  ] = point[0];
			vertices[vidx+1] = point[1];
			vertices[vidx+2] = point[2];
		}
	}
SWIGINTERN void btSoftBody_getVertices__SWIG_2(btSoftBody *self,float *vertices,int vertexSize,int posOffset,int normalOffset,short *indices,int indexOffset,int numVertices,short *indexMap,int indexMapOffset){
		int poffset = posOffset / (sizeof(btScalar));
		int noffset = normalOffset / (sizeof(btScalar));
		int size = vertexSize / (sizeof(btScalar));
		for (int i = 0; i < numVertices; i++) {
			const int vidx = indices[indexOffset+i]*size+poffset;
			const int nidx = indices[indexOffset+i]*size+noffset;
			const int pidx = indexMap[indexMapOffset+i];
			const float * const &point = self->m_nodes[pidx].m_x.m_floats;
			const float * const &normal = self->m_nodes[pidx].m_n.m_floats;
			vertices[vidx  ] = point[0];
			vertices[vidx+1] = point[1];
			vertices[vidx+2] = point[2];
			vertices[nidx  ] = normal[0];
			vertices[nidx+1] = normal[1];
			vertices[nidx+2] = normal[2];
		}
	}
SWIGINTERN int btSoftBody_getFaceCount(btSoftBody *self){
		return self->m_faces.size();
	}
SWIGINTERN btSoftBody::Face *btSoftBody_getFace(btSoftBody *self,int idx){
		return &(self->m_faces[idx]);
	}
SWIGINTERN void btSoftBody_getIndices(btSoftBody *self,short *buffer,int triangleCount){
		const size_t nodeSize = sizeof(btSoftBody::Node);
		const intptr_t nodeOffset = (intptr_t)(&self->m_nodes[0]);
		for (int i = 0; i < triangleCount; i++) {
			const int idx = i * 3;
			buffer[idx] = ((intptr_t)(self->m_faces[i].m_n[0]) - nodeOffset) / nodeSize;
			buffer[idx+1] = ((intptr_t)(self->m_faces[i].m_n[1]) - nodeOffset) / nodeSize;
			buffer[idx+2] = ((intptr_t)(self->m_faces[i].m_n[2]) - nodeOffset) / nodeSize;
		}
	}
SWIGINTERN void btSoftBody_setConfig_kVCF(btSoftBody *self,btScalar v){ self->m_cfg.kVCF = v; }
SWIGINTERN void btSoftBody_setConfig_kDP(btSoftBody *self,btScalar v){ self->m_cfg.kDP = v; }
SWIGINTERN void btSoftBody_setConfig_kDG(btSoftBody *self,btScalar v){ self->m_cfg.kDG = v; }
SWIGINTERN void btSoftBody_setConfig_kLF(btSoftBody *self,btScalar v){ self->m_cfg.kLF = v; }
SWIGINTERN void btSoftBody_setConfig_kPR(btSoftBody *self,btScalar v){ self->m_cfg.kPR = v; }
SWIGINTERN void btSoftBody_setConfig_kVC(btSoftBody *self,btScalar v){ self->m_cfg.kVC = v; }
SWIGINTERN void btSoftBody_setConfig_kDF(btSoftBody *self,btScalar v){ self->m_cfg.kDF = v; }
SWIGINTERN void btSoftBody_setConfig_kMT(btSoftBody *self,btScalar v){ self->m_cfg.kMT = v; }
SWIGINTERN void btSoftBody_setConfig_kCHR(btSoftBody *self,btScalar v){ self->m_cfg.kCHR = v; }
SWIGINTERN void btSoftBody_setConfig_kKHR(btSoftBody *self,btScalar v){ self->m_cfg.kKHR = v; }
SWIGINTERN void btSoftBody_setConfig_kSHR(btSoftBody *self,btScalar v){ self->m_cfg.kSHR = v; }
SWIGINTERN void btSoftBody_setConfig_kAHR(btSoftBody *self,btScalar v){ self->m_cfg.kAHR = v; }
SWIGINTERN void btSoftBody_setConfig_kSRHR_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSRHR_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSKHR_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSKHR_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSSHR_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSSHR_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSR_SPLT_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSR_SPLT_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSK_SPLT_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSK_SPLT_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSS_SPLT_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSS_SPLT_CL = v; }
SWIGINTERN void btSoftBody_setConfig_maxvolume(btSoftBody *self,btScalar v){ self->m_cfg.maxvolume = v; }
SWIGINTERN void btSoftBody_setConfig_timescale(btSoftBody *self,btScalar v){ self->m_cfg.timescale = v; }
SWIGINTERN void btSoftBody_setConfig_viterations(btSoftBody *self,int v){ self->m_cfg.viterations = v; }
SWIGINTERN void btSoftBody_setConfig_piterations(btSoftBody *self,int v){ self->m_cfg.piterations = v; }
SWIGINTERN void btSoftBody_setConfig_diterations(btSoftBody *self,int v){ self->m_cfg.diterations = v; }
SWIGINTERN void btSoftBody_setConfig_citerations(btSoftBody *self,int v){ self->m_cfg.citerations = v; }
SWIGINTERN void btSoftBody_setConfig_collisions(btSoftBody *self,int v){ self->m_cfg.collisions = v; }

	typedef btSoftBody::sCti sCti;
	typedef btSoftBody::sMedium sMedium;
	typedef btSoftBody::Element Element;
	typedef btSoftBody::Material Material;
	typedef btSoftBody::Feature Feature;
	typedef btSoftBody::Node Node;
	typedef btSoftBody::Link Link;
	typedef btSoftBody::Face Face;
	//typedef btSoftBody::eAeroModel eAeroModel;
	//typedef btSoftBody::Config Config;


#include <BulletSoftBody/btSoftBodyConcaveCollisionAlgorithm.h>


#include <BulletSoftBody/btSoftBodyData.h>


#include <BulletSoftBody/btSoftBodyHelpers.h>


#include <BulletSoftBody/btSoftBodyInternals.h>


#include <BulletSoftBody/btSoftBodyRigidBodyCollisionConfiguration.h>


#include <BulletSoftBody/btSoftBodySolverVertexBuffer.h>


#include <BulletSoftBody/btSoftRigidCollisionAlgorithm.h>


#include <BulletSoftBody/btSoftRigidDynamicsWorld.h>


#include <BulletSoftBody/btSoftSoftCollisionAlgorithm.h>



// Begin dummy implementations for missing Bullet methods

#ifndef BT_NO_PROFILE
void CProfileIterator::Enter_Largest_Child()
{
}
#endif

void btMultiSapBroadphase::quicksort(btBroadphasePairArray& a, int lo, int hi)
{
}

bool btGeometryUtil::isInside(btAlignedObjectArray<btVector3> const&, btVector3 const&, float)
{
	return false;
}

// End dummy implementations for missing Bullet methods



#include <BulletWorldImporter/btWorldImporter.h>
#include <BulletWorldImporter/btBulletWorldImporter.h>

SWIGINTERN char const *btWorldImporter_getNameForPointer__SWIG_1(btWorldImporter *self,unsigned long cPtr){
		return self->getNameForPointer((void*)cPtr);
	}
SWIGINTERN bool btBulletWorldImporter_loadFileFromMemory__SWIG_1(btBulletWorldImporter *self,unsigned char *memoryBuffer,int len){
		return self->loadFileFromMemory((char *)memoryBuffer, len);
	}


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "gdxBullet_wrap.h"

SwigDirector_btIDebugDraw::SwigDirector_btIDebugDraw(JNIEnv *jenv) : btIDebugDraw(), Swig::Director(jenv) {
}

SwigDirector_btIDebugDraw::~SwigDirector_btIDebugDraw() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btIDebugDraw::drawLine(btVector3 const &from, btVector3 const &to, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jfrom = 0 ;
  jlong jto = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::drawLine.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jfrom = (btVector3 *) &from; 
    *(btVector3 **)&jto = (btVector3 *) &to; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[0], swigjobj, jfrom, jto, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawLine(btVector3 const &from, btVector3 const &to, btVector3 const &fromColor, btVector3 const &toColor) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jfrom = 0 ;
  jlong jto = 0 ;
  jlong jfromColor = 0 ;
  jlong jtoColor = 0 ;
  
  if (!swig_override[1]) {
    btIDebugDraw::drawLine(from,to,fromColor,toColor);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jfrom = (btVector3 *) &from; 
    *(btVector3 **)&jto = (btVector3 *) &to; 
    *(btVector3 **)&jfromColor = (btVector3 *) &fromColor; 
    *(btVector3 **)&jtoColor = (btVector3 *) &toColor; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[1], swigjobj, jfrom, jto, jfromColor, jtoColor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawSphere(btScalar radius, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jlong jtransform = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[2]) {
    btIDebugDraw::drawSphere(radius,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    *(btTransform **)&jtransform = (btTransform *) &transform; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[2], swigjobj, jradius, jtransform, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawSphere(btVector3 const &p, btScalar radius, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jp = 0 ;
  jfloat jradius  ;
  jlong jcolor = 0 ;
  
  if (!swig_override[3]) {
    btIDebugDraw::drawSphere(p,radius,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jp = (btVector3 *) &p; 
    jradius = (jfloat) radius;
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[3], swigjobj, jp, jradius, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawTriangle(btVector3 const &v0, btVector3 const &v1, btVector3 const &v2, btVector3 const &arg3, btVector3 const &arg4, btVector3 const &arg5, btVector3 const &color, btScalar alpha) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jv0 = 0 ;
  jlong jv1 = 0 ;
  jlong jv2 = 0 ;
  jlong jarg3 = 0 ;
  jlong jarg4 = 0 ;
  jlong jarg5 = 0 ;
  jlong jcolor = 0 ;
  jfloat jalpha  ;
  
  if (!swig_override[4]) {
    btIDebugDraw::drawTriangle(v0,v1,v2,arg3,arg4,arg5,color,alpha);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jv0 = (btVector3 *) &v0; 
    *(btVector3 **)&jv1 = (btVector3 *) &v1; 
    *(btVector3 **)&jv2 = (btVector3 *) &v2; 
    *(btVector3 **)&jarg3 = (btVector3 *) &arg3; 
    *(btVector3 **)&jarg4 = (btVector3 *) &arg4; 
    *(btVector3 **)&jarg5 = (btVector3 *) &arg5; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jalpha = (jfloat) alpha;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[4], swigjobj, jv0, jv1, jv2, jarg3, jarg4, jarg5, jcolor, jalpha);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawTriangle(btVector3 const &v0, btVector3 const &v1, btVector3 const &v2, btVector3 const &color, btScalar arg4) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jv0 = 0 ;
  jlong jv1 = 0 ;
  jlong jv2 = 0 ;
  jlong jcolor = 0 ;
  jfloat jarg4  ;
  
  if (!swig_override[5]) {
    btIDebugDraw::drawTriangle(v0,v1,v2,color,arg4);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jv0 = (btVector3 *) &v0; 
    *(btVector3 **)&jv1 = (btVector3 *) &v1; 
    *(btVector3 **)&jv2 = (btVector3 *) &v2; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jarg4 = (jfloat) arg4;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[5], swigjobj, jv0, jv1, jv2, jcolor, jarg4);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawContactPoint(btVector3 const &PointOnB, btVector3 const &normalOnB, btScalar distance, int lifeTime, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jPointOnB = 0 ;
  jlong jnormalOnB = 0 ;
  jfloat jdistance  ;
  jint jlifeTime  ;
  jlong jcolor = 0 ;
  
  if (!swig_override[6]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::drawContactPoint.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jPointOnB = (btVector3 *) &PointOnB; 
    *(btVector3 **)&jnormalOnB = (btVector3 *) &normalOnB; 
    jdistance = (jfloat) distance;
    jlifeTime = (jint) lifeTime;
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[6], swigjobj, jPointOnB, jnormalOnB, jdistance, jlifeTime, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::reportErrorWarning(char const *warningString) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jwarningString = 0 ;
  
  if (!swig_override[7]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::reportErrorWarning.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jwarningString = 0;
    if (warningString) {
      jwarningString = jenv->NewStringUTF((const char *)warningString);
      if (!jwarningString) return ;
    }
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[7], swigjobj, jwarningString);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::draw3dText(btVector3 const &location, char const *textString) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jlocation = 0 ;
  jstring jtextString = 0 ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::draw3dText.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jlocation = (btVector3 *) &location; 
    jtextString = 0;
    if (textString) {
      jtextString = jenv->NewStringUTF((const char *)textString);
      if (!jtextString) return ;
    }
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[8], swigjobj, jlocation, jtextString);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::setDebugMode(int debugMode) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jdebugMode  ;
  
  if (!swig_override[9]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::setDebugMode.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdebugMode = (jint) debugMode;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[9], swigjobj, jdebugMode);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

int SwigDirector_btIDebugDraw::getDebugMode() const {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::getDebugMode.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[10], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btIDebugDraw::drawAabb(btVector3 const &from, btVector3 const &to, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jfrom = 0 ;
  jlong jto = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[11]) {
    btIDebugDraw::drawAabb(from,to,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jfrom = (btVector3 *) &from; 
    *(btVector3 **)&jto = (btVector3 *) &to; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[11], swigjobj, jfrom, jto, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawTransform(btTransform const &transform, btScalar orthoLen) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtransform = 0 ;
  jfloat jorthoLen  ;
  
  if (!swig_override[12]) {
    btIDebugDraw::drawTransform(transform,orthoLen);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btTransform **)&jtransform = (btTransform *) &transform; 
    jorthoLen = (jfloat) orthoLen;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[12], swigjobj, jtransform, jorthoLen);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawArc(btVector3 const &center, btVector3 const &normal, btVector3 const &axis, btScalar radiusA, btScalar radiusB, btScalar minAngle, btScalar maxAngle, btVector3 const &color, bool drawSect, btScalar stepDegrees) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcenter = 0 ;
  jlong jnormal = 0 ;
  jlong jaxis = 0 ;
  jfloat jradiusA  ;
  jfloat jradiusB  ;
  jfloat jminAngle  ;
  jfloat jmaxAngle  ;
  jlong jcolor = 0 ;
  jboolean jdrawSect  ;
  jfloat jstepDegrees  ;
  
  if (!swig_override[13]) {
    btIDebugDraw::drawArc(center,normal,axis,radiusA,radiusB,minAngle,maxAngle,color,drawSect,stepDegrees);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jcenter = (btVector3 *) &center; 
    *(btVector3 **)&jnormal = (btVector3 *) &normal; 
    *(btVector3 **)&jaxis = (btVector3 *) &axis; 
    jradiusA = (jfloat) radiusA;
    jradiusB = (jfloat) radiusB;
    jminAngle = (jfloat) minAngle;
    jmaxAngle = (jfloat) maxAngle;
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jdrawSect = (jboolean) drawSect;
    jstepDegrees = (jfloat) stepDegrees;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[13], swigjobj, jcenter, jnormal, jaxis, jradiusA, jradiusB, jminAngle, jmaxAngle, jcolor, jdrawSect, jstepDegrees);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawSpherePatch(btVector3 const &center, btVector3 const &up, btVector3 const &axis, btScalar radius, btScalar minTh, btScalar maxTh, btScalar minPs, btScalar maxPs, btVector3 const &color, btScalar stepDegrees) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcenter = 0 ;
  jlong jup = 0 ;
  jlong jaxis = 0 ;
  jfloat jradius  ;
  jfloat jminTh  ;
  jfloat jmaxTh  ;
  jfloat jminPs  ;
  jfloat jmaxPs  ;
  jlong jcolor = 0 ;
  jfloat jstepDegrees  ;
  
  if (!swig_override[15]) {
    btIDebugDraw::drawSpherePatch(center,up,axis,radius,minTh,maxTh,minPs,maxPs,color,stepDegrees);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jcenter = (btVector3 *) &center; 
    *(btVector3 **)&jup = (btVector3 *) &up; 
    *(btVector3 **)&jaxis = (btVector3 *) &axis; 
    jradius = (jfloat) radius;
    jminTh = (jfloat) minTh;
    jmaxTh = (jfloat) maxTh;
    jminPs = (jfloat) minPs;
    jmaxPs = (jfloat) maxPs;
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jstepDegrees = (jfloat) stepDegrees;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[15], swigjobj, jcenter, jup, jaxis, jradius, jminTh, jmaxTh, jminPs, jmaxPs, jcolor, jstepDegrees);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawBox(btVector3 const &bbMin, btVector3 const &bbMax, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbbMin = 0 ;
  jlong jbbMax = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[17]) {
    btIDebugDraw::drawBox(bbMin,bbMax,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jbbMin = (btVector3 *) &bbMin; 
    *(btVector3 **)&jbbMax = (btVector3 *) &bbMax; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[17], swigjobj, jbbMin, jbbMax, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawBox(btVector3 const &bbMin, btVector3 const &bbMax, btTransform const &trans, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbbMin = 0 ;
  jlong jbbMax = 0 ;
  jlong jtrans = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[18]) {
    btIDebugDraw::drawBox(bbMin,bbMax,trans,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jbbMin = (btVector3 *) &bbMin; 
    *(btVector3 **)&jbbMax = (btVector3 *) &bbMax; 
    *(btTransform **)&jtrans = (btTransform *) &trans; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[18], swigjobj, jbbMin, jbbMax, jtrans, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawCapsule(btScalar radius, btScalar halfHeight, int upAxis, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jhalfHeight  ;
  jint jupAxis  ;
  jlong jtransform = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[19]) {
    btIDebugDraw::drawCapsule(radius,halfHeight,upAxis,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jhalfHeight = (jfloat) halfHeight;
    jupAxis = (jint) upAxis;
    *(btTransform **)&jtransform = (btTransform *) &transform; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[19], swigjobj, jradius, jhalfHeight, jupAxis, jtransform, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawCylinder(btScalar radius, btScalar halfHeight, int upAxis, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jhalfHeight  ;
  jint jupAxis  ;
  jlong jtransform = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[20]) {
    btIDebugDraw::drawCylinder(radius,halfHeight,upAxis,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jhalfHeight = (jfloat) halfHeight;
    jupAxis = (jint) upAxis;
    *(btTransform **)&jtransform = (btTransform *) &transform; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[20], swigjobj, jradius, jhalfHeight, jupAxis, jtransform, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawCone(btScalar radius, btScalar height, int upAxis, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  jint jupAxis  ;
  jlong jtransform = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[21]) {
    btIDebugDraw::drawCone(radius,height,upAxis,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jupAxis = (jint) upAxis;
    *(btTransform **)&jtransform = (btTransform *) &transform; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[21], swigjobj, jradius, jheight, jupAxis, jtransform, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawPlane(btVector3 const &planeNormal, btScalar planeConst, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jplaneNormal = 0 ;
  jfloat jplaneConst  ;
  jlong jtransform = 0 ;
  jlong jcolor = 0 ;
  
  if (!swig_override[22]) {
    btIDebugDraw::drawPlane(planeNormal,planeConst,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btVector3 **)&jplaneNormal = (btVector3 *) &planeNormal; 
    jplaneConst = (jfloat) planeConst;
    *(btTransform **)&jtransform = (btTransform *) &transform; 
    *(btVector3 **)&jcolor = (btVector3 *) &color; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[22], swigjobj, jplaneNormal, jplaneConst, jtransform, jcolor);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "drawLine", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawLine", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawSphere", "(FLcom/badlogic/gdx/physics/bullet/btTransform;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawSphere", "(Lcom/badlogic/gdx/physics/bullet/btVector3;FLcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawTriangle", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;F)V", NULL 
    },
    {
      "drawTriangle", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;F)V", NULL 
    },
    {
      "drawContactPoint", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;FILcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "reportErrorWarning", "(Ljava/lang/String;)V", NULL 
    },
    {
      "draw3dText", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Ljava/lang/String;)V", NULL 
    },
    {
      "setDebugMode", "(I)V", NULL 
    },
    {
      "getDebugMode", "()I", NULL 
    },
    {
      "drawAabb", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawTransform", "(Lcom/badlogic/gdx/physics/bullet/btTransform;F)V", NULL 
    },
    {
      "drawArc", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;FFFFLcom/badlogic/gdx/physics/bullet/btVector3;ZF)V", NULL 
    },
    {
      "drawArc", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;FFFFLcom/badlogic/gdx/physics/bullet/btVector3;Z)V", NULL 
    },
    {
      "drawSpherePatch", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;FFFFFLcom/badlogic/gdx/physics/bullet/btVector3;F)V", NULL 
    },
    {
      "drawSpherePatch", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;FFFFFLcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawBox", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawBox", "(Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btVector3;Lcom/badlogic/gdx/physics/bullet/btTransform;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawCapsule", "(FFILcom/badlogic/gdx/physics/bullet/btTransform;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawCylinder", "(FFILcom/badlogic/gdx/physics/bullet/btTransform;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawCone", "(FFILcom/badlogic/gdx/physics/bullet/btTransform;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    },
    {
      "drawPlane", "(Lcom/badlogic/gdx/physics/bullet/btVector3;FLcom/badlogic/gdx/physics/bullet/btTransform;Lcom/badlogic/gdx/physics/bullet/btVector3;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/btIDebugDraw");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 23; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btMotionState::SwigDirector_btMotionState(JNIEnv *jenv) : btMotionState(), Swig::Director(jenv) {
}

SwigDirector_btMotionState::~SwigDirector_btMotionState() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btMotionState::getWorldTransform(btTransform &worldTrans) const {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jworldTrans = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btMotionState::getWorldTransform.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jworldTrans = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jworldTrans, worldTrans);
    gdxAutoCommitbtTransformAndReleaseMatrix4 auto_commit_worldTrans(jenv, jworldTrans, &worldTrans, "poolMatrix4");
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[23], swigjobj, jworldTrans);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btMotionState::setWorldTransform(btTransform const &worldTrans) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jworldTrans = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btMotionState::setWorldTransform.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jworldTrans = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jworldTrans, worldTrans);
    gdxPoolAutoRelease autoRelease_jworldTrans(jenv, "poolMatrix4", jworldTrans);
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[24], swigjobj, jworldTrans);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btMotionState::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getWorldTransform", "(Lcom/badlogic/gdx/math/Matrix4;)V", NULL 
    },
    {
      "setWorldTransform", "(Lcom/badlogic/gdx/math/Matrix4;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/btMotionState");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_RayResultCallback::SwigDirector_RayResultCallback(JNIEnv *jenv) : RayResultCallback(), Swig::Director(jenv) {
}

SwigDirector_RayResultCallback::~SwigDirector_RayResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_RayResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return RayResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[25], swigjobj, jproxy0);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_RayResultCallback::addSingleResult(LocalRayResult &rayResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrayResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RayResultCallback::addSingleResult.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(LocalRayResult **)&jrayResult = (LocalRayResult *) &rayResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[26], swigjobj, jrayResult, jnormalInWorldSpace);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_RayResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/LocalRayResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/RayResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ClosestRayResultCallback::SwigDirector_ClosestRayResultCallback(JNIEnv *jenv, btVector3 const &rayFromWorld, btVector3 const &rayToWorld) : ClosestRayResultCallback(rayFromWorld, rayToWorld), Swig::Director(jenv) {
}

SwigDirector_ClosestRayResultCallback::~SwigDirector_ClosestRayResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ClosestRayResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return RayResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[27], swigjobj, jproxy0);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ClosestRayResultCallback::addSingleResult(LocalRayResult &rayResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrayResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    return ClosestRayResultCallback::addSingleResult(rayResult,normalInWorldSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(LocalRayResult **)&jrayResult = (LocalRayResult *) &rayResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[28], swigjobj, jrayResult, jnormalInWorldSpace);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ClosestRayResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/LocalRayResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/ClosestRayResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AllHitsRayResultCallback::SwigDirector_AllHitsRayResultCallback(JNIEnv *jenv, btVector3 const &rayFromWorld, btVector3 const &rayToWorld) : AllHitsRayResultCallback(rayFromWorld, rayToWorld), Swig::Director(jenv) {
}

SwigDirector_AllHitsRayResultCallback::~SwigDirector_AllHitsRayResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_AllHitsRayResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return RayResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[29], swigjobj, jproxy0);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_AllHitsRayResultCallback::addSingleResult(LocalRayResult &rayResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrayResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    return AllHitsRayResultCallback::addSingleResult(rayResult,normalInWorldSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(LocalRayResult **)&jrayResult = (LocalRayResult *) &rayResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[30], swigjobj, jrayResult, jnormalInWorldSpace);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_AllHitsRayResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/LocalRayResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/AllHitsRayResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ConvexResultCallback::SwigDirector_ConvexResultCallback(JNIEnv *jenv) : ConvexResultCallback(), Swig::Director(jenv) {
}

SwigDirector_ConvexResultCallback::~SwigDirector_ConvexResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ConvexResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return ConvexResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[31], swigjobj, jproxy0);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ConvexResultCallback::addSingleResult(LocalConvexResult &convexResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jconvexResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ConvexResultCallback::addSingleResult.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(LocalConvexResult **)&jconvexResult = (LocalConvexResult *) &convexResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[32], swigjobj, jconvexResult, jnormalInWorldSpace);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ConvexResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/LocalConvexResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/ConvexResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ClosestConvexResultCallback::SwigDirector_ClosestConvexResultCallback(JNIEnv *jenv, btVector3 const &convexFromWorld, btVector3 const &convexToWorld) : ClosestConvexResultCallback(convexFromWorld, convexToWorld), Swig::Director(jenv) {
}

SwigDirector_ClosestConvexResultCallback::~SwigDirector_ClosestConvexResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ClosestConvexResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return ConvexResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[33], swigjobj, jproxy0);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ClosestConvexResultCallback::addSingleResult(LocalConvexResult &convexResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jconvexResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    return ClosestConvexResultCallback::addSingleResult(convexResult,normalInWorldSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(LocalConvexResult **)&jconvexResult = (LocalConvexResult *) &convexResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[34], swigjobj, jconvexResult, jnormalInWorldSpace);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ClosestConvexResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/LocalConvexResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/ClosestConvexResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ContactResultCallback::SwigDirector_ContactResultCallback(JNIEnv *jenv) : ContactResultCallback(), Swig::Director(jenv) {
}

SwigDirector_ContactResultCallback::~SwigDirector_ContactResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ContactResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return ContactResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[35], swigjobj, jproxy0);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ContactResultCallback::addSingleResult(btManifoldPoint &cp, btCollisionObjectWrapper const *colObj0Wrap, int partId0, int index0, btCollisionObjectWrapper const *colObj1Wrap, int partId1, int index1) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactResultCallback::addSingleResult.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *((btCollisionObjectWrapper **)&jcolObj0Wrap) = (btCollisionObjectWrapper *) colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObjectWrapper **)&jcolObj1Wrap) = (btCollisionObjectWrapper *) colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[36], swigjobj, jcp, jcolObj0Wrap, jpartId0, jindex0, jcolObj1Wrap, jpartId1, jindex1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ContactResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;IILcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;II)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/ContactResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ContactListener::SwigDirector_ContactListener(JNIEnv *jenv, bool dummy) : ContactListener(dummy), Swig::Director(jenv) {
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObjectWrapper const *colObj0Wrap, int partId0, int index0, btCollisionObjectWrapper const *colObj1Wrap, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    *((btCollisionObjectWrapper **)&jcolObj0Wrap) = (btCollisionObjectWrapper *) colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObjectWrapper **)&jcolObj1Wrap) = (btCollisionObjectWrapper *) colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[37], swigjobj, jcp, jcolObj0Wrap, jpartId0, jindex0, jcolObj1Wrap, jpartId1, jindex1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObject const *colObj0, int partId0, int index0, btCollisionObject const *colObj1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[38], swigjobj, jcp, jcolObj0, jpartId0, jindex0, jcolObj1, jpartId1, jindex1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, int userValue0, int partId0, int index0, int userValue1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[39], swigjobj, jcp, juserValue0, jpartId0, jindex0, juserValue1, jpartId1, jindex1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObjectWrapper const *colObj0Wrap, int partId0, int index0, bool match0, btCollisionObjectWrapper const *colObj1Wrap, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    *((btCollisionObjectWrapper **)&jcolObj0Wrap) = (btCollisionObjectWrapper *) colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *((btCollisionObjectWrapper **)&jcolObj1Wrap) = (btCollisionObjectWrapper *) colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[40], swigjobj, jcp, jcolObj0Wrap, jpartId0, jindex0, jmatch0, jcolObj1Wrap, jpartId1, jindex1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObject const *colObj0, int partId0, int index0, bool match0, btCollisionObject const *colObj1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[4]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[41], swigjobj, jcp, jcolObj0, jpartId0, jindex0, jmatch0, jcolObj1, jpartId1, jindex1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, int userValue0, int partId0, int index0, bool match0, int userValue1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[42], swigjobj, jcp, juserValue0, jpartId0, jindex0, jmatch0, juserValue1, jpartId1, jindex1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObjectWrapper const *colObj0Wrap, int partId0, int index0, btCollisionObjectWrapper const *colObj1Wrap, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[6]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObjectWrapper **)&jcolObj0Wrap) = (btCollisionObjectWrapper *) colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObjectWrapper **)&jcolObj1Wrap) = (btCollisionObjectWrapper *) colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[43], swigjobj, jcolObj0Wrap, jpartId0, jindex0, jcolObj1Wrap, jpartId1, jindex1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObject const *colObj0, int partId0, int index0, btCollisionObject const *colObj1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[7]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[44], swigjobj, jcolObj0, jpartId0, jindex0, jcolObj1, jpartId1, jindex1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(int userValue0, int partId0, int index0, int userValue1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[45], swigjobj, juserValue0, jpartId0, jindex0, juserValue1, jpartId1, jindex1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObjectWrapper const *colObj0Wrap, int partId0, int index0, bool match0, btCollisionObjectWrapper const *colObj1Wrap, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[9]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObjectWrapper **)&jcolObj0Wrap) = (btCollisionObjectWrapper *) colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *((btCollisionObjectWrapper **)&jcolObj1Wrap) = (btCollisionObjectWrapper *) colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[46], swigjobj, jcolObj0Wrap, jpartId0, jindex0, jmatch0, jcolObj1Wrap, jpartId1, jindex1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObject const *colObj0, int partId0, int index0, bool match0, btCollisionObject const *colObj1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[47], swigjobj, jcolObj0, jpartId0, jindex0, jmatch0, jcolObj1, jpartId1, jindex1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(int userValue0, int partId0, int index0, bool match0, int userValue1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[11]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[48], swigjobj, juserValue0, jpartId0, jindex0, jmatch0, juserValue1, jpartId1, jindex1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[12]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[49], swigjobj, jcp, jcolObj0, jcolObj1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, int userValue0, int userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jint juserValue0  ;
  jint juserValue1  ;
  
  if (!swig_override[13]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    juserValue0 = (jint) userValue0;
    juserValue1 = (jint) userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[50], swigjobj, jcp, juserValue0, juserValue1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, btCollisionObject const *colObj0, bool match0, btCollisionObject const *colObj1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1  ;
  
  if (!swig_override[14]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[51], swigjobj, jcp, jcolObj0, jmatch0, jcolObj1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, int userValue0, bool match0, int userValue1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcp = 0 ;
  jint juserValue0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[15]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jccp = gdx_getClassbtManifoldPoint(jenv);
    jcp = gdx_obtainbtManifoldPoint(jenv, jccp, (void*)&cp, false);
    gdxAutoFreebtManifoldPoint autoRelease_jcp(jenv, jccp, jcp);
    juserValue0 = (jint) userValue0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[52], swigjobj, jcp, juserValue0, jmatch0, juserValue1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[16]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[53], swigjobj, jcolObj0, jcolObj1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(int userValue0, int userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jint juserValue1  ;
  
  if (!swig_override[17]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    juserValue1 = (jint) userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[54], swigjobj, juserValue0, juserValue1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btCollisionObject const *colObj0, bool match0, btCollisionObject const *colObj1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1  ;
  
  if (!swig_override[18]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[55], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(int userValue0, bool match0, int userValue1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[19]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[56], swigjobj, juserValue0, jmatch0, juserValue1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactDestroyed(int manifoldPointUserValue) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jmanifoldPointUserValue  ;
  
  if (!swig_override[20]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactDestroyed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmanifoldPointUserValue = (jint) manifoldPointUserValue;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[57], swigjobj, jmanifoldPointUserValue);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btPersistentManifold *manifold) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  
  if (!swig_override[21]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[58], swigjobj, jmanifold);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[22]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[59], swigjobj, jcolObj0, jcolObj1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(int const &userValue0, int const &userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jint juserValue1 = 0 ;
  
  if (!swig_override[23]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    juserValue1 = (jint)userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[60], swigjobj, juserValue0, juserValue1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btPersistentManifold *manifold, bool const &match0, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  jboolean jmatch0 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[24]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jmatch0 = (jboolean)match0;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[61], swigjobj, jmanifold, jmatch0, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btCollisionObject const *colObj0, bool const &match0, btCollisionObject const *colObj1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0 = 0 ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[25]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean)match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[62], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(int const &userValue0, bool const &match0, int const &userValue1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jboolean jmatch0 = 0 ;
  jint juserValue1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[26]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    jmatch0 = (jboolean)match0;
    juserValue1 = (jint)userValue1;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[63], swigjobj, juserValue0, jmatch0, juserValue1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btPersistentManifold *manifold) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  
  if (!swig_override[27]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[64], swigjobj, jmanifold);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[28]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[65], swigjobj, jcolObj0, jcolObj1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(int const &userValue0, int const &userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jint juserValue1 = 0 ;
  
  if (!swig_override[29]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    juserValue1 = (jint)userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[66], swigjobj, juserValue0, juserValue1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btPersistentManifold *manifold, bool const &match0, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  jboolean jmatch0 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[30]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jmatch0 = (jboolean)match0;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[67], swigjobj, jmanifold, jmatch0, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btCollisionObject const *colObj0, bool const &match0, btCollisionObject const *colObj1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0 = 0 ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[31]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean)match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[68], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(int const &userValue0, bool const &match0, int const &userValue1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jboolean jmatch0 = 0 ;
  jint juserValue1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[32]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    jmatch0 = (jboolean)match0;
    juserValue1 = (jint)userValue1;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[69], swigjobj, juserValue0, jmatch0, juserValue1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;IILcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;II)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;IILcom/badlogic/gdx/physics/bullet/btCollisionObject;II)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;IIIIII)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;IIZLcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;IIZLcom/badlogic/gdx/physics/bullet/btCollisionObject;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;IIIZIIIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;IILcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;II)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;IILcom/badlogic/gdx/physics/bullet/btCollisionObject;II)Z", NULL 
    },
    {
      "onContactAdded", "(IIIIII)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;IIZLcom/badlogic/gdx/physics/bullet/btCollisionObjectWrapper;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;IIZLcom/badlogic/gdx/physics/bullet/btCollisionObject;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(IIIZIIIZ)Z", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;II)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/btManifoldPoint;IZIZ)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;)V", NULL 
    },
    {
      "onContactProcessed", "(II)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactProcessed", "(IZIZ)V", NULL 
    },
    {
      "onContactDestroyed", "(I)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/btPersistentManifold;)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;)V", NULL 
    },
    {
      "onContactStarted", "(II)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/btPersistentManifold;ZZ)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactStarted", "(IZIZ)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/btPersistentManifold;)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/btCollisionObject;)V", NULL 
    },
    {
      "onContactEnded", "(II)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/btPersistentManifold;ZZ)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactEnded", "(IZIZ)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/ContactListener");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 33; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ContactCache::SwigDirector_ContactCache(JNIEnv *jenv, bool dummy) : ContactCache(dummy), Swig::Director(jenv) {
}

void SwigDirector_ContactCache::onContactStarted(btPersistentManifold *manifold, bool const &match0, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  jboolean jmatch0 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactCache::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jmatch0 = (jboolean)match0;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[70], swigjobj, jmanifold, jmatch0, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactCache::onContactEnded(btCollisionObject const *colObj0, bool const &match0, btCollisionObject const *colObj1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0 = 0 ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactCache::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean)match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[71], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactCache::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/btPersistentManifold;ZZ)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/btCollisionObject;Z)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/ContactCache");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_InternalTickCallback::SwigDirector_InternalTickCallback(JNIEnv *jenv, btDynamicsWorld *dynamicsWorld, bool isPreTick) : InternalTickCallback(dynamicsWorld, isPreTick), Swig::Director(jenv) {
}

void SwigDirector_InternalTickCallback::onInternalTick(btDynamicsWorld *dynamicsWorld, btScalar timeStep) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdynamicsWorld = 0 ;
  jfloat jtimeStep  ;
  
  if (!swig_override[0]) {
    InternalTickCallback::onInternalTick(dynamicsWorld,timeStep);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btDynamicsWorld **)&jdynamicsWorld) = (btDynamicsWorld *) dynamicsWorld; 
    jtimeStep = (jfloat) timeStep;
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[72], swigjobj, jdynamicsWorld, jtimeStep);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_InternalTickCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onInternalTick", "(Lcom/badlogic/gdx/physics/bullet/btDynamicsWorld;F)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/InternalTickCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btBulletWorldImporter::SwigDirector_btBulletWorldImporter(JNIEnv *jenv, btDynamicsWorld *world) : btBulletWorldImporter(world), Swig::Director(jenv) {
}

SwigDirector_btBulletWorldImporter::~SwigDirector_btBulletWorldImporter() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btBulletWorldImporter::deleteAllData() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    btWorldImporter::deleteAllData();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[73], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btBulletWorldImporter::setDynamicsWorldInfo(btVector3 const &gravity, btContactSolverInfo const &solverInfo) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jgravity = 0 ;
  jlong jsolverInfo = 0 ;
  
  if (!swig_override[1]) {
    btWorldImporter::setDynamicsWorldInfo(gravity,solverInfo);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jgravity = gdx_takePoolObject(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jgravity, gravity);
    gdxPoolAutoRelease autoRelease_jgravity(jenv, "poolVector3", jgravity);
    *(btContactSolverInfo **)&jsolverInfo = (btContactSolverInfo *) &solverInfo; 
    jenv->CallStaticVoidMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[74], swigjobj, jgravity, jsolverInfo);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

btRigidBody *SwigDirector_btBulletWorldImporter::createRigidBody(bool isDynamic, btScalar mass, btTransform const &startTransform, btCollisionShape *shape, char const *bodyName) {
  btRigidBody *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jboolean jisDynamic  ;
  jfloat jmass  ;
  jobject jstartTransform = 0 ;
  jlong jshape = 0 ;
  jstring jbodyName = 0 ;
  
  if (!swig_override[2]) {
    return btWorldImporter::createRigidBody(isDynamic,mass,startTransform,shape,bodyName);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jisDynamic = (jboolean) isDynamic;
    jmass = (jfloat) mass;
    jstartTransform = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jstartTransform, startTransform);
    gdxPoolAutoRelease autoRelease_jstartTransform(jenv, "poolMatrix4", jstartTransform);
    *((btCollisionShape **)&jshape) = (btCollisionShape *) shape; 
    jbodyName = 0;
    if (bodyName) {
      jbodyName = jenv->NewStringUTF((const char *)bodyName);
      if (!jbodyName) return c_result;
    }
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[75], swigjobj, jisDynamic, jmass, jstartTransform, jshape, jbodyName);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btRigidBody **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionObject *SwigDirector_btBulletWorldImporter::createCollisionObject(btTransform const &startTransform, btCollisionShape *shape, char const *bodyName) {
  btCollisionObject *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jstartTransform = 0 ;
  jlong jshape = 0 ;
  jstring jbodyName = 0 ;
  
  if (!swig_override[3]) {
    return btWorldImporter::createCollisionObject(startTransform,shape,bodyName);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jstartTransform = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jstartTransform, startTransform);
    gdxPoolAutoRelease autoRelease_jstartTransform(jenv, "poolMatrix4", jstartTransform);
    *((btCollisionShape **)&jshape) = (btCollisionShape *) shape; 
    jbodyName = 0;
    if (bodyName) {
      jbodyName = jenv->NewStringUTF((const char *)bodyName);
      if (!jbodyName) return c_result;
    }
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[76], swigjobj, jstartTransform, jshape, jbodyName);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionObject **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createPlaneShape(btVector3 const &planeNormal, btScalar planeConstant) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jplaneNormal = 0 ;
  jfloat jplaneConstant  ;
  
  if (!swig_override[4]) {
    return btWorldImporter::createPlaneShape(planeNormal,planeConstant);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jplaneNormal = gdx_takePoolObject(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jplaneNormal, planeNormal);
    gdxPoolAutoRelease autoRelease_jplaneNormal(jenv, "poolVector3", jplaneNormal);
    jplaneConstant = (jfloat) planeConstant;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[77], swigjobj, jplaneNormal, jplaneConstant);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createBoxShape(btVector3 const &halfExtents) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jhalfExtents = 0 ;
  
  if (!swig_override[5]) {
    return btWorldImporter::createBoxShape(halfExtents);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jhalfExtents = gdx_takePoolObject(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jhalfExtents, halfExtents);
    gdxPoolAutoRelease autoRelease_jhalfExtents(jenv, "poolVector3", jhalfExtents);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[78], swigjobj, jhalfExtents);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createSphereShape(btScalar radius) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  
  if (!swig_override[6]) {
    return btWorldImporter::createSphereShape(radius);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[79], swigjobj, jradius);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCapsuleShapeX(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[7]) {
    return btWorldImporter::createCapsuleShapeX(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[80], swigjobj, jradius, jheight);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCapsuleShapeY(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[8]) {
    return btWorldImporter::createCapsuleShapeY(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[81], swigjobj, jradius, jheight);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCapsuleShapeZ(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[9]) {
    return btWorldImporter::createCapsuleShapeZ(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[82], swigjobj, jradius, jheight);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCylinderShapeX(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[10]) {
    return btWorldImporter::createCylinderShapeX(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[83], swigjobj, jradius, jheight);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCylinderShapeY(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[11]) {
    return btWorldImporter::createCylinderShapeY(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[84], swigjobj, jradius, jheight);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCylinderShapeZ(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[12]) {
    return btWorldImporter::createCylinderShapeZ(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[85], swigjobj, jradius, jheight);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btTriangleIndexVertexArray *SwigDirector_btBulletWorldImporter::createTriangleMeshContainer() {
  btTriangleIndexVertexArray *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[13]) {
    return btWorldImporter::createTriangleMeshContainer();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[86], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btTriangleIndexVertexArray **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btBvhTriangleMeshShape *SwigDirector_btBulletWorldImporter::createBvhTriangleMeshShape(btStridingMeshInterface *trimesh, btOptimizedBvh *bvh) {
  btBvhTriangleMeshShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtrimesh = 0 ;
  jlong jbvh = 0 ;
  
  if (!swig_override[14]) {
    return btWorldImporter::createBvhTriangleMeshShape(trimesh,bvh);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterface **)&jtrimesh) = (btStridingMeshInterface *) trimesh; 
    *((btOptimizedBvh **)&jbvh) = (btOptimizedBvh *) bvh; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[87], swigjobj, jtrimesh, jbvh);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btBvhTriangleMeshShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createConvexTriangleMeshShape(btStridingMeshInterface *trimesh) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtrimesh = 0 ;
  
  if (!swig_override[15]) {
    return btWorldImporter::createConvexTriangleMeshShape(trimesh);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterface **)&jtrimesh) = (btStridingMeshInterface *) trimesh; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[88], swigjobj, jtrimesh);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGImpactMeshShape *SwigDirector_btBulletWorldImporter::createGimpactShape(btStridingMeshInterface *trimesh) {
  btGImpactMeshShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtrimesh = 0 ;
  
  if (!swig_override[16]) {
    return btWorldImporter::createGimpactShape(trimesh);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterface **)&jtrimesh) = (btStridingMeshInterface *) trimesh; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[89], swigjobj, jtrimesh);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btGImpactMeshShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btStridingMeshInterfaceData *SwigDirector_btBulletWorldImporter::createStridingMeshInterfaceData(btStridingMeshInterfaceData *interfaceData) {
  btStridingMeshInterfaceData *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jinterfaceData = 0 ;
  
  if (!swig_override[17]) {
    return btWorldImporter::createStridingMeshInterfaceData(interfaceData);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterfaceData **)&jinterfaceData) = (btStridingMeshInterfaceData *) interfaceData; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[90], swigjobj, jinterfaceData);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btStridingMeshInterfaceData **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btConvexHullShape *SwigDirector_btBulletWorldImporter::createConvexHullShape() {
  btConvexHullShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[18]) {
    return btWorldImporter::createConvexHullShape();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[91], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btConvexHullShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCompoundShape *SwigDirector_btBulletWorldImporter::createCompoundShape() {
  btCompoundShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[19]) {
    return btWorldImporter::createCompoundShape();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[92], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btCompoundShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScaledBvhTriangleMeshShape *SwigDirector_btBulletWorldImporter::createScaledTrangleMeshShape(btBvhTriangleMeshShape *meshShape, btVector3 const &localScalingbtBvhTriangleMeshShape) {
  btScaledBvhTriangleMeshShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmeshShape = 0 ;
  jobject jlocalScalingbtBvhTriangleMeshShape = 0 ;
  
  if (!swig_override[20]) {
    return btWorldImporter::createScaledTrangleMeshShape(meshShape,localScalingbtBvhTriangleMeshShape);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBvhTriangleMeshShape **)&jmeshShape) = (btBvhTriangleMeshShape *) meshShape; 
    jlocalScalingbtBvhTriangleMeshShape = gdx_takePoolObject(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jlocalScalingbtBvhTriangleMeshShape, localScalingbtBvhTriangleMeshShape);
    gdxPoolAutoRelease autoRelease_jlocalScalingbtBvhTriangleMeshShape(jenv, "poolVector3", jlocalScalingbtBvhTriangleMeshShape);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[93], swigjobj, jmeshShape, jlocalScalingbtBvhTriangleMeshShape);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btScaledBvhTriangleMeshShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btTriangleIndexVertexArray *SwigDirector_btBulletWorldImporter::createMeshInterface(btStridingMeshInterfaceData &meshData) {
  btTriangleIndexVertexArray *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmeshData = 0 ;
  
  if (!swig_override[21]) {
    return btWorldImporter::createMeshInterface(meshData);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btStridingMeshInterfaceData **)&jmeshData = (btStridingMeshInterfaceData *) &meshData; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[94], swigjobj, jmeshData);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btTriangleIndexVertexArray **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btOptimizedBvh *SwigDirector_btBulletWorldImporter::createOptimizedBvh() {
  btOptimizedBvh *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[22]) {
    return btWorldImporter::createOptimizedBvh();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[95], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btOptimizedBvh **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btTriangleInfoMap *SwigDirector_btBulletWorldImporter::createTriangleInfoMap() {
  btTriangleInfoMap *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[23]) {
    return btWorldImporter::createTriangleInfoMap();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[96], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btTriangleInfoMap **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btPoint2PointConstraint *SwigDirector_btBulletWorldImporter::createPoint2PointConstraint(btRigidBody &rbA, btRigidBody &rbB, btVector3 const &pivotInA, btVector3 const &pivotInB) {
  btPoint2PointConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jpivotInA = 0 ;
  jobject jpivotInB = 0 ;
  
  if (!swig_override[24]) {
    return btWorldImporter::createPoint2PointConstraint(rbA,rbB,pivotInA,pivotInB);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jpivotInA = gdx_takePoolObject(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jpivotInA, pivotInA);
    gdxPoolAutoRelease autoRelease_jpivotInA(jenv, "poolVector3", jpivotInA);
    jpivotInB = gdx_takePoolObject(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jpivotInB, pivotInB);
    gdxPoolAutoRelease autoRelease_jpivotInB(jenv, "poolVector3", jpivotInB);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[97], swigjobj, jrbA, jrbB, jpivotInA, jpivotInB);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btPoint2PointConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btPoint2PointConstraint *SwigDirector_btBulletWorldImporter::createPoint2PointConstraint(btRigidBody &rbA, btVector3 const &pivotInA) {
  btPoint2PointConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jobject jpivotInA = 0 ;
  
  if (!swig_override[25]) {
    return btWorldImporter::createPoint2PointConstraint(rbA,pivotInA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    jpivotInA = gdx_takePoolObject(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jpivotInA, pivotInA);
    gdxPoolAutoRelease autoRelease_jpivotInA(jenv, "poolVector3", jpivotInA);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[98], swigjobj, jrbA, jpivotInA);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btPoint2PointConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btHingeConstraint *SwigDirector_btBulletWorldImporter::createHingeConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &rbAFrame, btTransform const &rbBFrame, bool useReferenceFrameA) {
  btHingeConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jrbAFrame = 0 ;
  jobject jrbBFrame = 0 ;
  jboolean juseReferenceFrameA  ;
  
  if (!swig_override[26]) {
    return btWorldImporter::createHingeConstraint(rbA,rbB,rbAFrame,rbBFrame,useReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jrbAFrame = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoRelease autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    jrbBFrame = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbBFrame, rbBFrame);
    gdxPoolAutoRelease autoRelease_jrbBFrame(jenv, "poolMatrix4", jrbBFrame);
    juseReferenceFrameA = (jboolean) useReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[99], swigjobj, jrbA, jrbB, jrbAFrame, jrbBFrame, juseReferenceFrameA);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btHingeConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btHingeConstraint *SwigDirector_btBulletWorldImporter::createHingeConstraint(btRigidBody &rbA, btTransform const &rbAFrame, bool useReferenceFrameA) {
  btHingeConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jobject jrbAFrame = 0 ;
  jboolean juseReferenceFrameA  ;
  
  if (!swig_override[28]) {
    return btWorldImporter::createHingeConstraint(rbA,rbAFrame,useReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    jrbAFrame = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoRelease autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    juseReferenceFrameA = (jboolean) useReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[101], swigjobj, jrbA, jrbAFrame, juseReferenceFrameA);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btHingeConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btConeTwistConstraint *SwigDirector_btBulletWorldImporter::createConeTwistConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &rbAFrame, btTransform const &rbBFrame) {
  btConeTwistConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jrbAFrame = 0 ;
  jobject jrbBFrame = 0 ;
  
  if (!swig_override[30]) {
    return btWorldImporter::createConeTwistConstraint(rbA,rbB,rbAFrame,rbBFrame);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jrbAFrame = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoRelease autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    jrbBFrame = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbBFrame, rbBFrame);
    gdxPoolAutoRelease autoRelease_jrbBFrame(jenv, "poolMatrix4", jrbBFrame);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[103], swigjobj, jrbA, jrbB, jrbAFrame, jrbBFrame);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btConeTwistConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btConeTwistConstraint *SwigDirector_btBulletWorldImporter::createConeTwistConstraint(btRigidBody &rbA, btTransform const &rbAFrame) {
  btConeTwistConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jobject jrbAFrame = 0 ;
  
  if (!swig_override[31]) {
    return btWorldImporter::createConeTwistConstraint(rbA,rbAFrame);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    jrbAFrame = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoRelease autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[104], swigjobj, jrbA, jrbAFrame);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btConeTwistConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGeneric6DofConstraint *SwigDirector_btBulletWorldImporter::createGeneric6DofConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &frameInA, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btGeneric6DofConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jframeInA = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[32]) {
    return btWorldImporter::createGeneric6DofConstraint(rbA,rbB,frameInA,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInA = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInA, frameInA);
    gdxPoolAutoRelease autoRelease_jframeInA(jenv, "poolMatrix4", jframeInA);
    jframeInB = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoRelease autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[105], swigjobj, jrbA, jrbB, jframeInA, jframeInB, juseLinearReferenceFrameA);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btGeneric6DofConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGeneric6DofConstraint *SwigDirector_btBulletWorldImporter::createGeneric6DofConstraint(btRigidBody &rbB, btTransform const &frameInB, bool useLinearReferenceFrameB) {
  btGeneric6DofConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbB = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameB  ;
  
  if (!swig_override[33]) {
    return btWorldImporter::createGeneric6DofConstraint(rbB,frameInB,useLinearReferenceFrameB);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInB = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoRelease autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameB = (jboolean) useLinearReferenceFrameB;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[106], swigjobj, jrbB, jframeInB, juseLinearReferenceFrameB);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btGeneric6DofConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGeneric6DofSpringConstraint *SwigDirector_btBulletWorldImporter::createGeneric6DofSpringConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &frameInA, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btGeneric6DofSpringConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jframeInA = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[34]) {
    return btWorldImporter::createGeneric6DofSpringConstraint(rbA,rbB,frameInA,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInA = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInA, frameInA);
    gdxPoolAutoRelease autoRelease_jframeInA(jenv, "poolMatrix4", jframeInA);
    jframeInB = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoRelease autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[107], swigjobj, jrbA, jrbB, jframeInA, jframeInB, juseLinearReferenceFrameA);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btGeneric6DofSpringConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btSliderConstraint *SwigDirector_btBulletWorldImporter::createSliderConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &frameInA, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btSliderConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jframeInA = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[35]) {
    return btWorldImporter::createSliderConstraint(rbA,rbB,frameInA,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInA = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInA, frameInA);
    gdxPoolAutoRelease autoRelease_jframeInA(jenv, "poolMatrix4", jframeInA);
    jframeInB = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoRelease autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[108], swigjobj, jrbA, jrbB, jframeInA, jframeInB, juseLinearReferenceFrameA);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btSliderConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btSliderConstraint *SwigDirector_btBulletWorldImporter::createSliderConstraint(btRigidBody &rbB, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btSliderConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbB = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[36]) {
    return btWorldImporter::createSliderConstraint(rbB,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInB = gdx_takePoolObject(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoRelease autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[109], swigjobj, jrbB, jframeInB, juseLinearReferenceFrameA);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(btSliderConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_btBulletWorldImporter::convertAllObjects(bParse::btBulletFile *file) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jfile = 0 ;
  
  if (!swig_override[37]) {
    return btBulletWorldImporter::convertAllObjects(file);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((bParse::btBulletFile **)&jfile) = (bParse::btBulletFile *) file; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_gdxBulletJNI, Swig::director_methids[110], swigjobj, jfile);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btBulletWorldImporter::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "deleteAllData", "()V", NULL 
    },
    {
      "setDynamicsWorldInfo", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/physics/bullet/btContactSolverInfo;)V", NULL 
    },
    {
      "createRigidBody", "(ZFLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/physics/bullet/btCollisionShape;Ljava/lang/String;)Lcom/badlogic/gdx/physics/bullet/btRigidBody;", NULL 
    },
    {
      "createCollisionObject", "(Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/physics/bullet/btCollisionShape;Ljava/lang/String;)Lcom/badlogic/gdx/physics/bullet/btCollisionObject;", NULL 
    },
    {
      "createPlaneShape", "(Lcom/badlogic/gdx/math/Vector3;F)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createBoxShape", "(Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createSphereShape", "(F)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createCapsuleShapeX", "(FF)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createCapsuleShapeY", "(FF)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createCapsuleShapeZ", "(FF)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createCylinderShapeX", "(FF)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createCylinderShapeY", "(FF)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createCylinderShapeZ", "(FF)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createTriangleMeshContainer", "()Lcom/badlogic/gdx/physics/bullet/btTriangleIndexVertexArray;", NULL 
    },
    {
      "createBvhTriangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/btStridingMeshInterface;Lcom/badlogic/gdx/physics/bullet/btOptimizedBvh;)Lcom/badlogic/gdx/physics/bullet/btBvhTriangleMeshShape;", NULL 
    },
    {
      "createConvexTriangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/btStridingMeshInterface;)Lcom/badlogic/gdx/physics/bullet/btCollisionShape;", NULL 
    },
    {
      "createGimpactShape", "(Lcom/badlogic/gdx/physics/bullet/btStridingMeshInterface;)Lcom/badlogic/gdx/physics/bullet/SWIGTYPE_p_btGImpactMeshShape;", NULL 
    },
    {
      "createStridingMeshInterfaceData", "(Lcom/badlogic/gdx/physics/bullet/btStridingMeshInterfaceData;)Lcom/badlogic/gdx/physics/bullet/btStridingMeshInterfaceData;", NULL 
    },
    {
      "createConvexHullShape", "()Lcom/badlogic/gdx/physics/bullet/btConvexHullShape;", NULL 
    },
    {
      "createCompoundShape", "()Lcom/badlogic/gdx/physics/bullet/btCompoundShape;", NULL 
    },
    {
      "createScaledTrangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/btBvhTriangleMeshShape;Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/btScaledBvhTriangleMeshShape;", NULL 
    },
    {
      "createMeshInterface", "(Lcom/badlogic/gdx/physics/bullet/btStridingMeshInterfaceData;)Lcom/badlogic/gdx/physics/bullet/btTriangleIndexVertexArray;", NULL 
    },
    {
      "createOptimizedBvh", "()Lcom/badlogic/gdx/physics/bullet/btOptimizedBvh;", NULL 
    },
    {
      "createTriangleInfoMap", "()Lcom/badlogic/gdx/physics/bullet/btTriangleInfoMap;", NULL 
    },
    {
      "createPoint2PointConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/btPoint2PointConstraint;", NULL 
    },
    {
      "createPoint2PointConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/btPoint2PointConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/btHingeConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/btHingeConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/btHingeConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/btHingeConstraint;", NULL 
    },
    {
      "createConeTwistConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/btConeTwistConstraint;", NULL 
    },
    {
      "createConeTwistConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/btConeTwistConstraint;", NULL 
    },
    {
      "createGeneric6DofConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/btGeneric6DofConstraint;", NULL 
    },
    {
      "createGeneric6DofConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/btGeneric6DofConstraint;", NULL 
    },
    {
      "createGeneric6DofSpringConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/btGeneric6DofSpringConstraint;", NULL 
    },
    {
      "createSliderConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/btSliderConstraint;", NULL 
    },
    {
      "createSliderConstraint", "(Lcom/badlogic/gdx/physics/bullet/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/btSliderConstraint;", NULL 
    },
    {
      "convertAllObjects", "(Lcom/badlogic/gdx/physics/bullet/SWIGTYPE_p_bParse__btBulletFile;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/btBulletWorldImporter");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 38; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGetVersion(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)btGetVersion();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSqrt(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btSqrt(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btFabs(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btFabs(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCos(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btCos(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSin(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btSin(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTan(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btTan(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAcos(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btAcos(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAsin(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btAsin(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAtan(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btAtan(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAtan2(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btAtan2(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btExp(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btExp(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btLog(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btLog(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPow(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btPow(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btFmod(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btFmod(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAtan2Fast(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btAtan2Fast(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btFuzzyZero(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jboolean jresult = 0 ;
  btScalar arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (bool)btFuzzyZero(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btEqual(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jboolean jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (bool)btEqual(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGreaterEqual(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jboolean jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (bool)btGreaterEqual(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIsNegative(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jint jresult = 0 ;
  btScalar arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (int)btIsNegative(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btRadians(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btRadians(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDegrees(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btDegrees(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btFsel(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btScalar)btFsel(arg1,arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMachineIsLittleEndian(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)btMachineIsLittleEndian();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSelect_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)btSelect(arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSelect_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  unsigned int arg1 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)btSelect(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSelect_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2, jfloat jarg3) {
  jfloat jresult = 0 ;
  unsigned int arg1 ;
  float arg2 ;
  float arg3 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (float)jarg2; 
  arg3 = (float)jarg3; 
  result = (float)btSelect(arg1,arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSwapEndian_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (unsigned int)btSwapEndian(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSwapEndian_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  unsigned short arg1 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned short)jarg1; 
  result = (unsigned short)btSwapEndian(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSwapEndian_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jshort jarg1) {
  jint jresult = 0 ;
  short arg1 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (short)jarg1; 
  result = (unsigned short)btSwapEndian(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSwapEndianFloat(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  float arg1 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (float)jarg1; 
  result = (unsigned int)btSwapEndianFloat(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btUnswapEndianFloat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jfloat jresult = 0 ;
  unsigned int arg1 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (float)btUnswapEndianFloat(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSwapEndianDouble(JNIEnv *jenv, jclass jcls, jdouble jarg1, jobject jarg2) {
  double arg1 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btSwapEndianDouble(arg1,arg2);
  
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btUnswapEndianDouble(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jdouble jresult = 0 ;
  unsigned char *arg1 = (unsigned char *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (unsigned char*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (double)btUnswapEndianDouble((unsigned char const *)arg1);
  jresult = (jdouble)result; 
  
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btNormalizeAngle(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btNormalizeAngle(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTypedObject(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btTypedObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btTypedObject *)new btTypedObject(arg1);
  *(btTypedObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTypedObject_1objectType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedObject *arg1 = (btTypedObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedObject **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_objectType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTypedObject_1objectType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedObject *arg1 = (btTypedObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedObject **)&jarg1; 
  result = (int) ((arg1)->m_objectType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTypedObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedObject *arg1 = (btTypedObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedObject **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransform *)new btTransform();
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btTransform *)new btTransform((btQuaternion const &)*arg1,(btVector3 const &)*arg2);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = (btTransform *)new btTransform((btQuaternion const &)*arg1);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(btMatrix3x3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btTransform *)new btTransform((btMatrix3x3 const &)*arg1,(btVector3 const &)*arg2);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMatrix3x3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3 const & reference is null");
    return 0;
  } 
  result = (btTransform *)new btTransform((btMatrix3x3 const &)*arg1);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransform *arg1 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return 0;
  } 
  result = (btTransform *)new btTransform((btTransform const &)*arg1);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1mult(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransform **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg3 = *(btTransform **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  (arg1)->mult((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1getBasis_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = (btMatrix3x3 *) &(arg1)->getBasis();
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1getOrigin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = (btVector3 *) &(arg1)->getOrigin();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1getRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = ((btTransform const *)arg1)->getRotation();
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1setFromOpenGLMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  (arg1)->setFromOpenGLMatrix((btScalar const *)arg2);
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1getOpenGLMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  ((btTransform const *)arg1)->getOpenGLMatrix(arg2);
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1setOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->setOrigin((btVector3 const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1invXform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = ((btTransform const *)arg1)->invXform((btVector3 const &)*arg2);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1setBasis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3 const & reference is null");
    return ;
  } 
  (arg1)->setBasis((btMatrix3x3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return ;
  } 
  (arg1)->setRotation((btQuaternion const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1setIdentity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btTransform *arg1 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  (arg1)->setIdentity();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1inverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = ((btTransform const *)arg1)->inverse();
  *(btTransform **)&jresult = new btTransform((const btTransform &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1inverseTimes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransform **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return 0;
  } 
  result = ((btTransform const *)arg1)->inverseTimes((btTransform const &)*arg2);
  *(btTransform **)&jresult = new btTransform((const btTransform &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1getIdentity(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransform *) &btTransform::getIdentity();
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData & reference is null");
    return ;
  } 
  ((btTransform const *)arg1)->serialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1serializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData & reference is null");
    return ;
  } 
  ((btTransform const *)arg1)->serializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerialize((btTransformFloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformDoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformDoubleData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble((btTransformDoubleData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransform_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat((btTransformFloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransform *arg1 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransform **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformFloatData_1basis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btMatrix3x3FloatData arg2 ;
  btMatrix3x3FloatData *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  argp2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btMatrix3x3FloatData");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->m_basis = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformFloatData_1basis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btMatrix3x3FloatData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  result =  ((arg1)->m_basis);
  *(btMatrix3x3FloatData **)&jresult = new btMatrix3x3FloatData((const btMatrix3x3FloatData &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformFloatData_1origin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_origin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformFloatData_1origin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_origin);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransformFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransformFloatData *)new btTransformFloatData();
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTransformFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransformFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformDoubleData_1basis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btMatrix3x3DoubleData arg2 ;
  btMatrix3x3DoubleData *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  argp2 = *(btMatrix3x3DoubleData **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btMatrix3x3DoubleData");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->m_basis = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformDoubleData_1basis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btMatrix3x3DoubleData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  result =  ((arg1)->m_basis);
  *(btMatrix3x3DoubleData **)&jresult = new btMatrix3x3DoubleData((const btMatrix3x3DoubleData &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformDoubleData_1origin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_origin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformDoubleData_1origin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_origin);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransformDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransformDoubleData *)new btTransformDoubleData();
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTransformDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *arg2 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    btScalar *b = (btScalar *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btScalar *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *)(btScalar *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutFloat(jenv, (float *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btVector3_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector3 *)new btVector3();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btVector3_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = (btVector3 *)new btVector3((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1dot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)((btVector3 const *)arg1)->dot((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1length2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar)((btVector3 const *)arg1)->length2();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar)((btVector3 const *)arg1)->length();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1distance2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)((btVector3 const *)arg1)->distance2((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1distance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)((btVector3 const *)arg1)->distance((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1safeNormalize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btVector3 *) &(arg1)->safeNormalize();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1normalize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btVector3 *) &(arg1)->normalize();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1normalized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = ((btVector3 const *)arg1)->normalized();
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1rotate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg3 = (btScalar)jarg3; 
  result = ((btVector3 const *)arg1)->rotate((btVector3 const &)*arg2,arg3);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)((btVector3 const *)arg1)->angle((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1absolute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = ((btVector3 const *)arg1)->absolute();
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1cross(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = ((btVector3 const *)arg1)->cross((btVector3 const &)*arg2);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1triple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)((btVector3 const *)arg1)->triple((btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1minAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->minAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1maxAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->maxAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1furthestAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->furthestAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1closestAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->closestAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setInterpolate3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jfloat jarg4) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = (btScalar)jarg4; 
  (arg1)->setInterpolate3((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1lerp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = ((btVector3 const *)arg1)->lerp((btVector3 const &)*arg2,(btScalar const &)*arg3);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1getX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->getX();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1getY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->getY();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1getZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->getZ();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setX(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setY(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setZ(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setW(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setW(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1x(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->x();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1y(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->y();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1z(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->z();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1w(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->w();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->setMax((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->setMin((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1getSkewSymmetricMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  btVector3 *arg4 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  arg4 = *(btVector3 **)&jarg4; 
  ((btVector3 const *)arg1)->getSkewSymmetricMatrix(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1setZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  (arg1)->setZero();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1isZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (bool)((btVector3 const *)arg1)->isZero();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1fuzzyZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (bool)((btVector3 const *)arg1)->fuzzyZero();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData & reference is null");
    return ;
  } 
  ((btVector3 const *)arg1)->serialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerialize((btVector3FloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1serializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData & reference is null");
    return ;
  } 
  ((btVector3 const *)arg1)->serializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat((btVector3FloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1serializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3DoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3DoubleData & reference is null");
    return ;
  } 
  ((btVector3 const *)arg1)->serializeDouble(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3DoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3DoubleData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble((btVector3DoubleData const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1maxDot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  long arg3 ;
  btScalar *arg4 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (long)jarg3; 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  result = (long)((btVector3 const *)arg1)->maxDot((btVector3 const *)arg2,arg3,*arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1minDot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  long arg3 ;
  btScalar *arg4 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (long)jarg3; 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  result = (long)((btVector3 const *)arg1)->minDot((btVector3 const *)arg2,arg3,*arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3_1dot3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = ((btVector3 const *)arg1)->dot3((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btVector3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)btDot((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDistance2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)btDistance2((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)btDistance((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAngle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)btAngle((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCross(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = btCross((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = (btScalar)btTriple((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_lerp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = lerp((btVector3 const &)*arg1,(btVector3 const &)*arg2,(float const &)*arg3);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btVector4_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector4 *)new btVector4();
  *(btVector4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btVector4_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btVector4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  result = (btVector4 *)new btVector4((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
  *(btVector4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector4_1absolute4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  btVector4 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = ((btVector4 const *)arg1)->absolute4();
  *(btVector4 **)&jresult = new btVector4((const btVector4 &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector4_1getW(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (btScalar)((btVector4 const *)arg1)->getW();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector4_1maxAxis4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (int)((btVector4 const *)arg1)->maxAxis4();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector4_1minAxis4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (int)((btVector4 const *)arg1)->minAxis4();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector4_1closestAxis4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (int)((btVector4 const *)arg1)->closestAxis4();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector4_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5) {
  btVector4 *arg1 = (btVector4 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btVector4(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector4 *arg1 = (btVector4 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector4 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSwapScalarEndian(JNIEnv *jenv, jclass jcls, jfloat jarg1, jlong jarg2) {
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp1 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  arg2 = *(btScalar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btSwapScalarEndian((float const &)*arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSwapVector3Endian(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 & reference is null");
    return ;
  } 
  btSwapVector3Endian((btVector3 const &)*arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btUnSwapVector3Endian(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btVector3 *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 & reference is null");
    return ;
  } 
  btUnSwapVector3Endian(*arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3FloatData_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btVector3FloatData *arg1 = (btVector3FloatData *) 0 ;
  float *arg2 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3FloatData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    float *b = (float *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((float *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3FloatData_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btVector3FloatData *arg1 = (btVector3FloatData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3FloatData **)&jarg1; 
  result = (float *)(float *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutFloat(jenv, (float *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btVector3FloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector3FloatData *)new btVector3FloatData();
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btVector3FloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector3FloatData *arg1 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3FloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3DoubleData_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  btVector3DoubleData *arg1 = (btVector3DoubleData *) 0 ;
  double *arg2 ;
  jdouble *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3DoubleData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, (double **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    double *b = (double *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((double *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, (double *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jdoubleArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btVector3DoubleData_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  btVector3DoubleData *arg1 = (btVector3DoubleData *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3DoubleData **)&jarg1; 
  result = (double *)(double *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutDouble(jenv, (double *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btVector3DoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector3DoubleData *)new btVector3DoubleData();
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btVector3DoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector3DoubleData *arg1 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3DoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuaternion_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuaternion *)new btQuaternion();
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuaternion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  result = (btQuaternion *)new btQuaternion((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuaternion_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = (btQuaternion *)new btQuaternion((btVector3 const &)*arg1,(btScalar const &)*arg2);
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuaternion_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = (btQuaternion *)new btQuaternion((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3);
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  (arg1)->setRotation((btVector3 const &)*arg2,(btScalar const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1setEuler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setEuler((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1setEulerZYX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setEulerZYX((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1dot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = (btScalar)((btQuaternion const *)arg1)->dot((btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1length2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar)((btQuaternion const *)arg1)->length2();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar)((btQuaternion const *)arg1)->length();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1normalize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btQuaternion *) &(arg1)->normalize();
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1normalized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = ((btQuaternion const *)arg1)->normalized();
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = (btScalar)((btQuaternion const *)arg1)->angle((btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1getAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar)((btQuaternion const *)arg1)->getAngle();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1getAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = ((btQuaternion const *)arg1)->getAxis();
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1inverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = ((btQuaternion const *)arg1)->inverse();
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1farthest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = ((btQuaternion const *)arg1)->farthest((btQuaternion const &)*arg2);
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1nearest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = ((btQuaternion const *)arg1)->nearest((btQuaternion const &)*arg2);
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1slerp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = ((btQuaternion const *)arg1)->slerp((btQuaternion const &)*arg2,(btScalar const &)*arg3);
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1getIdentity(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuaternion *) &btQuaternion::getIdentity();
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuaternion_1getW(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar *) &((btQuaternion const *)arg1)->getW();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btQuaternion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuaternion **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_dot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = (btScalar)dot((btQuaternion const &)*arg1,(btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = (btScalar)length((btQuaternion const &)*arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAngle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = (btScalar)btAngle((btQuaternion const &)*arg1,(btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_inverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  result = inverse((btQuaternion const &)*arg1);
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_slerp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  arg2 = *(btQuaternion **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = slerp((btQuaternion const &)*arg1,(btQuaternion const &)*arg2,(float const &)*arg3);
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_quatRotate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternion const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = quatRotate((btQuaternion const &)*arg1,(btVector3 const &)*arg2);
  *(btVector3 **)&jresult = new btVector3((const btVector3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_shortestArcQuat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return 0;
  } 
  result = shortestArcQuat((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_shortestArcQuatNormalize2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 & reference is null");
    return 0;
  } 
  result = shortestArcQuatNormalize2(*arg1,*arg2);
  *(btQuaternion **)&jresult = new btQuaternion((const btQuaternion &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_AabbExpand(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  AabbExpand(*arg1,*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_TestPointAgainstAabb2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (bool)TestPointAgainstAabb2((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_TestAabbAgainstAabb2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (bool)TestAabbAgainstAabb2((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_TestTriangleAgainstAabb2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (bool)TestTriangleAgainstAabb2((btVector3 const *)arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOutcode(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jint jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (int)btOutcode((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btRayAabb2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlongArray jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jfloat jarg6, jfloat jarg7) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int *arg3 ;
  btVector3 *arg4 ;
  btScalar *arg5 = 0 ;
  btScalar arg6 ;
  btScalar arg7 ;
  jlong *jarr3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  if (jarg3 && jenv->GetArrayLength(jarg3) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return 0;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr3, (unsigned int **)&arg3, jarg3)) return 0; 
  arg4 = *(btVector3 **)&jarg4; 
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  result = (bool)btRayAabb2((btVector3 const &)*arg1,(btVector3 const &)*arg2,(unsigned int const (*))arg3,(btVector3 const (*))arg4,*arg5,arg6,arg7);
  jresult = (jboolean)result; 
  SWIG_JavaArrayArgoutUint(jenv, jarr3, (unsigned int *)arg3, jarg3); 
  delete [] arg3; 
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btRayAabb(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg6) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  result = (bool)btRayAabb((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,*arg5,*arg6);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformAabb_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btTransform *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btTransformAabb((btVector3 const &)*arg1,arg2,(btTransform const &)*arg3,*arg4,*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformAabb_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btTransformAabb((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,*arg5,*arg6);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_testQuantizedAabbAgainstQuantizedAabb(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  unsigned short *arg1 = (unsigned short *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  unsigned short *arg3 = (unsigned short *) 0 ;
  unsigned short *arg4 = (unsigned short *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (unsigned short*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg3 = (unsigned short*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg4 = (unsigned short*)jenv->GetDirectBufferAddress(jarg4);
    if (arg4 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (unsigned int)testQuantizedAabbAgainstQuantizedAabb((unsigned short const *)arg1,(unsigned short const *)arg2,(unsigned short const *)arg3,(unsigned short const *)arg4);
  jresult = (jlong)result; 
  
  
  
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIDebugDraw **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawLine_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawLine((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawLine_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawLine((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawLineSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawLine((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSphere_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btTransform *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = *(btTransform **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawSphere(arg2,(btTransform const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSphereSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btTransform *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = *(btTransform **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawSphere(arg2,(btTransform const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSphere_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = (btScalar)jarg3; 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawSphere((btVector3 const &)*arg2,arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSphereSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = (btScalar)jarg3; 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawSphere((btVector3 const &)*arg2,arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawTriangle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_, jfloat jarg9) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  btVector3 *arg8 = 0 ;
  btScalar arg9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  (void)jarg8_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg7 = *(btVector3 **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg8 = *(btVector3 **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg9 = (btScalar)jarg9; 
  (arg1)->drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,(btVector3 const &)*arg7,(btVector3 const &)*arg8,arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawTriangleSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_, jfloat jarg9) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  btVector3 *arg8 = 0 ;
  btScalar arg9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  (void)jarg8_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg7 = *(btVector3 **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg8 = *(btVector3 **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg9 = (btScalar)jarg9; 
  (arg1)->btIDebugDraw::drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,(btVector3 const &)*arg7,(btVector3 const &)*arg8,arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawTriangle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jfloat jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btScalar arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg6 = (btScalar)jarg6; 
  (arg1)->drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawTriangleSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jfloat jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btScalar arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg6 = (btScalar)jarg6; 
  (arg1)->btIDebugDraw::drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawContactPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jfloat jarg4, jint jarg5, jlong jarg6, jobject jarg6_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  int arg5 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg6_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = (btScalar)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawContactPoint((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1reportErrorWarning(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->reportErrorWarning((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1draw3dText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->draw3dText((btVector3 const &)*arg2,(char const *)arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1setDebugMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setDebugMode(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1getDebugMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  result = (int)((btIDebugDraw const *)arg1)->getDebugMode();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawAabb((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawAabbSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawAabb((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btTransform *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btTransform **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg3 = (btScalar)jarg3; 
  (arg1)->drawTransform((btTransform const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawTransformSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btTransform *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btTransform **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg3 = (btScalar)jarg3; 
  (arg1)->btIDebugDraw::drawTransform((btTransform const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawArc_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jlong jarg9, jobject jarg9_, jboolean jarg10, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg9_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = *(btVector3 **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg10 = jarg10 ? true : false; 
  arg11 = (btScalar)jarg11; 
  (arg1)->drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawArcSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jlong jarg9, jobject jarg9_, jboolean jarg10, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg9_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = *(btVector3 **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg10 = jarg10 ? true : false; 
  arg11 = (btScalar)jarg11; 
  (arg1)->btIDebugDraw::drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawArc_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jlong jarg9, jobject jarg9_, jboolean jarg10) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg9_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = *(btVector3 **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg10 = jarg10 ? true : false; 
  (arg1)->drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawArcSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jlong jarg9, jobject jarg9_, jboolean jarg10) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg9_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = *(btVector3 **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg10 = jarg10 ? true : false; 
  (arg1)->btIDebugDraw::drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSpherePatch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jlong jarg10, jobject jarg10_, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg10_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  arg10 = *(btVector3 **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg11 = (btScalar)jarg11; 
  (arg1)->drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSpherePatchSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jlong jarg10, jobject jarg10_, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg10_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  arg10 = *(btVector3 **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg11 = (btScalar)jarg11; 
  (arg1)->btIDebugDraw::drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSpherePatch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jlong jarg10, jobject jarg10_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg10_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  arg10 = *(btVector3 **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawSpherePatchSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jlong jarg10, jobject jarg10_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg10_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  arg10 = *(btVector3 **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawBox_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawBoxSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btVector3 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawBox_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btTransform **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawBoxSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = *(btVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg4 = *(btTransform **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawCapsule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btTransform **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawCapsule(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawCapsuleSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btTransform **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawCapsule(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawCylinder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btTransform **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawCylinder(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawCylinderSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btTransform **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawCylinder(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawCone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btTransform **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawCone(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawConeSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btTransform **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg6 = *(btVector3 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawCone(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawPlane(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = (btScalar)jarg3; 
  arg4 = *(btTransform **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->drawPlane((btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1drawPlaneSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  arg3 = (btScalar)jarg3; 
  arg4 = *(btTransform **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransform const & reference is null");
    return ;
  } 
  arg5 = *(btVector3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3 const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::drawPlane((btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btIDebugDraw(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btIDebugDraw *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btIDebugDraw *)new SwigDirector_btIDebugDraw(jenv);
  *(btIDebugDraw **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btIDebugDraw *obj = *((btIDebugDraw **)&objarg);
  (void)jcls;
  SwigDirector_btIDebugDraw *director = (SwigDirector_btIDebugDraw *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIDebugDraw_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btIDebugDraw *obj = *((btIDebugDraw **)&objarg);
  SwigDirector_btIDebugDraw *director = (SwigDirector_btIDebugDraw *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGeometryUtil_1getPlaneEquationsFromVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > & reference is null");
    return ;
  } 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > & reference is null");
    return ;
  } 
  btGeometryUtil::getPlaneEquationsFromVertices(*arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGeometryUtil_1getVerticesFromPlaneEquations(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return ;
  } 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > & reference is null");
    return ;
  } 
  btGeometryUtil::getVerticesFromPlaneEquations((btAlignedObjectArray< btVector3 > const &)*arg1,*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGeometryUtil_1isInside(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (bool)btGeometryUtil::isInside((btAlignedObjectArray< btVector3 > const &)*arg1,(btVector3 const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGeometryUtil_1isPointInsidePlanes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (bool)btGeometryUtil::isPointInsidePlanes((btAlignedObjectArray< btVector3 > const &)*arg1,(btVector3 const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGeometryUtil_1areVerticesBehindPlane(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  arg3 = (btScalar)jarg3; 
  result = (bool)btGeometryUtil::areVerticesBehindPlane((btVector3 const &)*arg1,(btAlignedObjectArray< btVector3 > const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btGeometryUtil(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGeometryUtil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGeometryUtil *)new btGeometryUtil();
  *(btGeometryUtil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btGeometryUtil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeometryUtil *arg1 = (btGeometryUtil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeometryUtil **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_GEN_1srand(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  unsigned int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  GEN_srand(arg1);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_GEN_1rand(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)GEN_rand();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAabbSupport(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btAabbSupport((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformUtil_1integrateTransform(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jfloat jarg4, jobject jarg5) {
  btTransform *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  btTransform *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btTransformUtil::integrateTransform((btTransform const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformUtil_1calculateVelocityQuaternion(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jobject jarg6, jobject jarg7) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btQuaternion *arg3 = 0 ;
  btQuaternion *arg4 = 0 ;
  btScalar arg5 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btQuaternion local_arg3;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitQuaternion auto_commit_arg3(jenv, jarg3, &local_arg3);
  btQuaternion local_arg4;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitQuaternion auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  btTransformUtil::calculateVelocityQuaternion((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btQuaternion const &)*arg3,(btQuaternion const &)*arg4,arg5,*arg6,*arg7);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformUtil_1calculateDiffAxisAngleQuaternion(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jlong jarg4) {
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btTransformUtil::calculateDiffAxisAngleQuaternion((btQuaternion const &)*arg1,(btQuaternion const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformUtil_1calculateVelocity(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5) {
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btTransformUtil::calculateVelocity((btTransform const &)*arg1,(btTransform const &)*arg2,arg3,*arg4,*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTransformUtil_1calculateDiffAxisAngle(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jlong jarg4) {
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btTransformUtil::calculateDiffAxisAngle((btTransform const &)*arg1,(btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTransformUtil(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransformUtil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransformUtil *)new btTransformUtil();
  *(btTransformUtil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTransformUtil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransformUtil *arg1 = (btTransformUtil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransformUtil **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btConvexSeparatingDistanceUtil(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btConvexSeparatingDistanceUtil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btConvexSeparatingDistanceUtil *)new btConvexSeparatingDistanceUtil(arg1,arg2);
  *(btConvexSeparatingDistanceUtil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexSeparatingDistanceUtil_1getConservativeSeparatingDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  result = (btScalar)(arg1)->getConservativeSeparatingDistance();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexSeparatingDistanceUtil_1updateSeparatingDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->updateSeparatingDistance((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexSeparatingDistanceUtil_1initSeparatingDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5) {
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->initSeparatingDistance((btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,(btTransform const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btConvexSeparatingDistanceUtil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1HullResult(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  HullResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (HullResult *)new HullResult();
  *(HullResult **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mPolygons_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->mPolygons = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mPolygons_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (bool) ((arg1)->mPolygons);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mNumOutputVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mNumOutputVertices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mNumOutputVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mNumOutputVertices);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1OutputVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->m_OutputVertices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1OutputVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->m_OutputVertices);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mNumFaces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mNumFaces = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mNumFaces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mNumFaces);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mNumIndices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mNumIndices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1mNumIndices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mNumIndices);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1Indices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< unsigned int > *arg2 = (btAlignedObjectArray< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = *(btAlignedObjectArray< unsigned int > **)&jarg2; 
  if (arg1) (arg1)->m_Indices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullResult_1Indices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (btAlignedObjectArray< unsigned int > *)& ((arg1)->m_Indices);
  *(btAlignedObjectArray< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1HullResult(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  HullResult *arg1 = (HullResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(HullResult **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1HullDesc_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  HullDesc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (HullDesc *)new HullDesc();
  *(HullDesc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1HullDesc_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  HullFlag arg1 ;
  unsigned int arg2 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  unsigned int arg4 ;
  HullDesc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (HullFlag)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  arg4 = (unsigned int)jarg4; 
  result = (HullDesc *)new HullDesc(arg1,arg2,(btVector3 const *)arg3,arg4);
  *(HullDesc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1HullDesc_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  HullFlag arg1 ;
  unsigned int arg2 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  HullDesc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (HullFlag)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  result = (HullDesc *)new HullDesc(arg1,arg2,(btVector3 const *)arg3);
  *(HullDesc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1HasHullFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  HullFlag arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (HullFlag)jarg2; 
  result = (bool)((HullDesc const *)arg1)->HasHullFlag(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1SetHullFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  HullFlag arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (HullFlag)jarg2; 
  (arg1)->SetHullFlag(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1ClearHullFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  HullFlag arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (HullFlag)jarg2; 
  (arg1)->ClearHullFlag(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mFlags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mFlags = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mFlags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mFlags);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mVcount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mVcount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mVcount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mVcount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->mVertices = (btVector3 const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (btVector3 *) ((arg1)->mVertices);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mVertexStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mVertexStride = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mVertexStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mVertexStride);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mNormalEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->mNormalEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mNormalEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (btScalar) ((arg1)->mNormalEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mMaxVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mMaxVertices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mMaxVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mMaxVertices);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mMaxFaces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mMaxFaces = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullDesc_1mMaxFaces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mMaxFaces);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1HullDesc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(HullDesc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPlane_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPlane *arg1 = (btPlane *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPlane **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPlane_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPlane *arg1 = (btPlane *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPlane **)&jarg1; 
  result = (btVector3 *)& ((arg1)->normal);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPlane_1dist_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btPlane *arg1 = (btPlane *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPlane **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->dist = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPlane_1dist_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btPlane *arg1 = (btPlane *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPlane **)&jarg1; 
  result = (btScalar) ((arg1)->dist);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btPlane_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btPlane *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = (btPlane *)new btPlane((btVector3 const &)*arg1,arg2);
  *(btPlane **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btPlane_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btPlane *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btPlane *)new btPlane();
  *(btPlane **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btPlane(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPlane *arg1 = (btPlane *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPlane **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1ConvexH_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ConvexH *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ConvexH *)new ConvexH();
  *(ConvexH **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1ConvexH(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ConvexH **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ConvexH_1vertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->vertices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ConvexH_1vertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->vertices);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ConvexH_1edges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< ConvexH::HalfEdge > *arg2 = (btAlignedObjectArray< ConvexH::HalfEdge > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  arg2 = *(btAlignedObjectArray< ConvexH::HalfEdge > **)&jarg2; 
  if (arg1) (arg1)->edges = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ConvexH_1edges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< ConvexH::HalfEdge > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  result = (btAlignedObjectArray< ConvexH::HalfEdge > *)& ((arg1)->edges);
  *(btAlignedObjectArray< ConvexH::HalfEdge > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ConvexH_1facets_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btPlane > *arg2 = (btAlignedObjectArray< btPlane > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btPlane > **)&jarg2; 
  if (arg1) (arg1)->facets = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ConvexH_1facets_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btPlane > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  result = (btAlignedObjectArray< btPlane > *)& ((arg1)->facets);
  *(btAlignedObjectArray< btPlane > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1ConvexH_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  ConvexH *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (ConvexH *)new ConvexH(arg1,arg2,arg3);
  *(ConvexH **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1x_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->x = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1x_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->x);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1y_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->y = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1y_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->y);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1z_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->z = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1z_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->z);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1w_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->w = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_int4_1w_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->w);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1int4_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (int4 *)new int4();
  *(int4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1int4_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int4 *)new int4(arg1,arg2,arg3,arg4);
  *(int4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1int4(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int4 *arg1 = (int4 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int4 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1PHullResult(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  PHullResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (PHullResult *)new PHullResult();
  *(PHullResult **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mVcount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mVcount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mVcount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mVcount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mIndexCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mIndexCount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mIndexCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mIndexCount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mFaceCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mFaceCount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mFaceCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mFaceCount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->mVertices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1mVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (btVector3 *) ((arg1)->mVertices);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1Indices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  TUIntArray *arg2 = (TUIntArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = *(TUIntArray **)&jarg2; 
  if (arg1) (arg1)->m_Indices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_PHullResult_1Indices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  TUIntArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (TUIntArray *)& ((arg1)->m_Indices);
  *(TUIntArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1PHullResult(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PHullResult **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullLibrary_1vertexIndexMapping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  btAlignedObjectArray< int > *arg2 = (btAlignedObjectArray< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullLibrary **)&jarg1; 
  arg2 = *(btAlignedObjectArray< int > **)&jarg2; 
  if (arg1) (arg1)->m_vertexIndexMapping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullLibrary_1vertexIndexMapping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  btAlignedObjectArray< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullLibrary **)&jarg1; 
  result = (btAlignedObjectArray< int > *)& ((arg1)->m_vertexIndexMapping);
  *(btAlignedObjectArray< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullLibrary_1CreateConvexHull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  HullDesc *arg2 = 0 ;
  HullResult *arg3 = 0 ;
  HullError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(HullLibrary **)&jarg1; 
  arg2 = *(HullDesc **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "HullDesc const & reference is null");
    return 0;
  } 
  arg3 = *(HullResult **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "HullResult & reference is null");
    return 0;
  } 
  result = (HullError)(arg1)->CreateConvexHull((HullDesc const &)*arg2,*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_HullLibrary_1ReleaseResult(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  HullResult *arg2 = 0 ;
  HullError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(HullLibrary **)&jarg1; 
  arg2 = *(HullResult **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "HullResult & reference is null");
    return 0;
  } 
  result = (HullError)(arg1)->ReleaseResult(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1HullLibrary(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  HullLibrary *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (HullLibrary *)new HullLibrary();
  *(HullLibrary **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1HullLibrary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(HullLibrary **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1GrahamVector3(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  int arg2 ;
  GrahamVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (int)jarg2; 
  result = (GrahamVector3 *)new GrahamVector3((btVector3 const &)*arg1,arg2);
  *(GrahamVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_GrahamVector3_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_GrahamVector3_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  result = (btScalar) ((arg1)->m_angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_GrahamVector3_1orgIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_orgIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_GrahamVector3_1orgIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  result = (int) ((arg1)->m_orgIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1GrahamVector3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GrahamVector3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAngleCompareFunc_1anchor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAngleCompareFunc *arg1 = (btAngleCompareFunc *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAngleCompareFunc **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_anchor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAngleCompareFunc_1anchor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAngleCompareFunc *arg1 = (btAngleCompareFunc *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngleCompareFunc **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_anchor);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAngleCompareFunc(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btAngleCompareFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btAngleCompareFunc *)new btAngleCompareFunc((btVector3 const &)*arg1);
  *(btAngleCompareFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btAngleCompareFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAngleCompareFunc *arg1 = (btAngleCompareFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAngleCompareFunc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_GrahamScanConvexHull2D(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3) {
  btAlignedObjectArray< GrahamVector3 > *arg1 = 0 ;
  btAlignedObjectArray< GrahamVector3 > *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< GrahamVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< GrahamVector3 > & reference is null");
    return ;
  } 
  arg2 = *(btAlignedObjectArray< GrahamVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< GrahamVector3 > & reference is null");
    return ;
  } 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  GrahamScanConvexHull2D(*arg1,*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btPoolAllocator(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  btPoolAllocator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (btPoolAllocator *)new btPoolAllocator(arg1,arg2);
  *(btPoolAllocator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btPoolAllocator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPoolAllocator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1getFreeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getFreeCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1getUsedCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getUsedCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1getMaxCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getMaxCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1allocate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)(arg1)->allocate(arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1validPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)(arg1)->validPtr(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1freeMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  (arg1)->freeMemory(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1getElementSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getElementSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPoolAllocator_1getPoolAddress_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (unsigned char *)(arg1)->getPoolAddress();
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1vertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->vertices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1vertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->vertices);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1edges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btConvexHullComputer::Edge > *arg2 = (btAlignedObjectArray< btConvexHullComputer::Edge > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btConvexHullComputer::Edge > **)&jarg2; 
  if (arg1) (arg1)->edges = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1edges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btConvexHullComputer::Edge > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  result = (btAlignedObjectArray< btConvexHullComputer::Edge > *)& ((arg1)->edges);
  *(btAlignedObjectArray< btConvexHullComputer::Edge > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1faces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< int > *arg2 = (btAlignedObjectArray< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  arg2 = *(btAlignedObjectArray< int > **)&jarg2; 
  if (arg1) (arg1)->faces = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1faces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  result = (btAlignedObjectArray< int > *)& ((arg1)->faces);
  *(btAlignedObjectArray< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1compute_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jfloat jarg5, jfloat jarg6) {
  jfloat jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  float *arg2 = (float *) 0 ;
  int arg3 ;
  int arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  result = (btScalar)(arg1)->compute((float const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jfloat)result; 
  
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexHullComputer_1compute_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jfloat jarg5, jfloat jarg6) {
  jfloat jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  double *arg2 = (double *) 0 ;
  int arg3 ;
  int arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  {
    arg2 = (double*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  result = (btScalar)(arg1)->compute((double const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jfloat)result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btConvexHullComputer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexHullComputer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexHullComputer *)new btConvexHullComputer();
  *(btConvexHullComputer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btConvexHullComputer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btGEN_1Link_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGEN_Link *)new btGEN_Link();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btGEN_1Link_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_Link **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  result = (btGEN_Link *)new btGEN_Link(arg1,arg2);
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1Link_1getNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (btGEN_Link *)((btGEN_Link const *)arg1)->getNext();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1Link_1getPrev(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (btGEN_Link *)((btGEN_Link const *)arg1)->getPrev();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1Link_1isHead(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (bool)((btGEN_Link const *)arg1)->isHead();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1Link_1isTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (bool)((btGEN_Link const *)arg1)->isTail();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1Link_1insertBefore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_Link **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->insertBefore(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1Link_1insertAfter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_Link **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->insertAfter(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1Link_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  (arg1)->remove();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btGEN_1Link(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGEN_Link **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btGEN_1List(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGEN_List *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGEN_List *)new btGEN_List();
  *(btGEN_List **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1List_1getHead(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_List **)&jarg1; 
  result = (btGEN_Link *)((btGEN_List const *)arg1)->getHead();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1List_1getTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_List **)&jarg1; 
  result = (btGEN_Link *)((btGEN_List const *)arg1)->getTail();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1List_1addHead(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_List **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->addHead(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btGEN_1List_1addTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_List **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->addTail(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btGEN_1List(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGEN_List **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAlignedAllocInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  size_t arg1 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)btAlignedAllocInternal(arg1,arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAlignedFreeInternal(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  btAlignedFreeInternal(arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAlignedAllocSetCustom(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  btAllocFunc *arg1 = (btAllocFunc *) 0 ;
  btFreeFunc *arg2 = (btFreeFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAllocFunc **)&jarg1; 
  arg2 = *(btFreeFunc **)&jarg2; 
  btAlignedAllocSetCustom(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAlignedAllocSetCustomAligned(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  btAlignedAllocFunc *arg1 = (btAlignedAllocFunc *) 0 ;
  btAlignedFreeFunc *arg2 = (btAlignedFreeFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedAllocFunc **)&jarg1; 
  arg2 = *(btAlignedFreeFunc **)&jarg2; 
  btAlignedAllocSetCustomAligned(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashString_1string_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btHashString *arg1 = (btHashString *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->m_string = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_string, (const char *)arg2);
    } else {
      arg1->m_string = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashString_1string_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  result = (char *) ((arg1)->m_string);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashString_1hash_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btHashString *arg1 = (btHashString *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_hash = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashString_1hash_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  result = (unsigned int) ((arg1)->m_hash);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btHashString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  btHashString *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (btHashString *)new btHashString((char const *)arg1);
  *(btHashString **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashString_1portableStringCompare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)((btHashString const *)arg1)->portableStringCompare((char const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashString_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  btHashString *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btHashString **)&jarg1; 
  arg2 = *(btHashString **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btHashString const & reference is null");
    return 0;
  } 
  result = (bool)((btHashString const *)arg1)->equals((btHashString const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btHashString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashString *arg1 = (btHashString *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashString **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_BT_1HASH_1NULL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)BT_HASH_NULL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btHashInt(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btHashInt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btHashInt *)new btHashInt(arg1);
  *(btHashInt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashInt_1getUid1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btHashInt *arg1 = (btHashInt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashInt **)&jarg1; 
  result = (int)((btHashInt const *)arg1)->getUid1();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashInt_1setUid1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btHashInt *arg1 = (btHashInt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashInt **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setUid1(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashInt_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btHashInt *arg1 = (btHashInt *) 0 ;
  btHashInt *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btHashInt **)&jarg1; 
  arg2 = *(btHashInt **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btHashInt const & reference is null");
    return 0;
  } 
  result = (bool)((btHashInt const *)arg1)->equals((btHashInt const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashInt_1getHash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashInt *arg1 = (btHashInt *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashInt **)&jarg1; 
  result = (unsigned int)((btHashInt const *)arg1)->getHash();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btHashInt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashInt *arg1 = (btHashInt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashInt **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btHashPtr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  btHashPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (btHashPtr *)new btHashPtr((void const *)arg1);
  *(btHashPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashPtr_1getPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashPtr **)&jarg1; 
  result = (void *)((btHashPtr const *)arg1)->getPointer();
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashPtr_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  btHashPtr *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btHashPtr **)&jarg1; 
  arg2 = *(btHashPtr **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btHashPtr const & reference is null");
    return 0;
  } 
  result = (bool)((btHashPtr const *)arg1)->equals((btHashPtr const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashPtr_1getHash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashPtr **)&jarg1; 
  result = (unsigned int)((btHashPtr const *)arg1)->getHash();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btHashPtr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashPtr **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBlock_1previous_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBlock *arg1 = (btBlock *) 0 ;
  btBlock *arg2 = (btBlock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBlock **)&jarg1; 
  arg2 = *(btBlock **)&jarg2; 
  if (arg1) (arg1)->previous = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBlock_1previous_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBlock *arg1 = (btBlock *) 0 ;
  btBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBlock **)&jarg1; 
  result = (btBlock *) ((arg1)->previous);
  *(btBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBlock_1address_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btBlock *arg1 = (btBlock *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBlock **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->address = arg2;
    } else {
      arg1->address = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBlock_1address_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBlock *arg1 = (btBlock *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBlock **)&jarg1; 
  result = (unsigned char *) ((arg1)->address);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBlock(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBlock *)new btBlock();
  *(btBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBlock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBlock *arg1 = (btBlock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBlock **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btStackAlloc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  btStackAlloc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (btStackAlloc *)new btStackAlloc(arg1);
  *(btStackAlloc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btStackAlloc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStackAlloc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStackAlloc_1create(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  (arg1)->create(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStackAlloc_1destroy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  (arg1)->destroy();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStackAlloc_1getAvailableMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  result = (int)((btStackAlloc const *)arg1)->getAvailableMemory();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStackAlloc_1allocate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jobject jresult = 0 ;
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  unsigned int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (unsigned char *)(arg1)->allocate(arg2);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStackAlloc_1beginBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  btBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  result = (btBlock *)(arg1)->beginBlock();
  *(btBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStackAlloc_1endBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  btBlock *arg2 = (btBlock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStackAlloc **)&jarg1; 
  arg2 = *(btBlock **)&jarg2; 
  (arg1)->endBlock(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btMotionState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMotionState *arg1 = (btMotionState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMotionState **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMotionState_1getWorldTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMotionState *arg1 = (btMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btMotionState const *)arg1)->getWorldTransform(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMotionState_1setWorldTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMotionState *arg1 = (btMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setWorldTransform((btTransform const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btMotionState(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMotionState *)new SwigDirector_btMotionState(jenv);
  *(btMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMotionState_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btMotionState *obj = *((btMotionState **)&objarg);
  (void)jcls;
  SwigDirector_btMotionState *director = (SwigDirector_btMotionState *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMotionState_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btMotionState *obj = *((btMotionState **)&objarg);
  SwigDirector_btMotionState *director = (SwigDirector_btMotionState *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1graphicsWorldTrans_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_graphicsWorldTrans = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1graphicsWorldTrans_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_graphicsWorldTrans);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1centerOfMassOffset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_centerOfMassOffset = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1centerOfMassOffset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_centerOfMassOffset);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1startWorldTrans_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_startWorldTrans = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1startWorldTrans_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_startWorldTrans);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1userPointer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->m_userPointer = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1userPointer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (void *) ((arg1)->m_userPointer);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDefaultMotionState_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btDefaultMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btDefaultMotionState *)new btDefaultMotionState((btTransform const &)*arg1,(btTransform const &)*arg2);
  *(btDefaultMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDefaultMotionState_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btTransform *arg1 = 0 ;
  btDefaultMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btDefaultMotionState *)new btDefaultMotionState((btTransform const &)*arg1);
  *(btDefaultMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDefaultMotionState_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDefaultMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDefaultMotionState *)new btDefaultMotionState();
  *(btDefaultMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1getGraphicsWorldTrans(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btDefaultMotionState_getGraphicsWorldTrans(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1getCenterOfMassOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btDefaultMotionState_getCenterOfMassOffset(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDefaultMotionState_1getStartWorldTrans(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btDefaultMotionState_getStartWorldTrans(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDefaultMotionState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1Result(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Result *arg1 = (Result *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Result **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Result_1setShapeIdentifiersA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  Result *arg1 = (Result *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Result **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->setShapeIdentifiersA(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Result_1setShapeIdentifiersB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  Result *arg1 = (Result *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Result **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->setShapeIdentifiersB(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Result_1addContactPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  Result *arg1 = (Result *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Result **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->addContactPoint((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1ClosestPointInput(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ClosestPointInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ClosestPointInput *)new ClosestPointInput();
  *(ClosestPointInput **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1transformA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_transformA = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1transformA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_transformA);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1transformB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_transformB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1transformB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_transformB);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1maximumDistanceSquared_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maximumDistanceSquared = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1maximumDistanceSquared_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  result = (btScalar) ((arg1)->m_maximumDistanceSquared);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1stackAlloc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btStackAlloc *arg2 = (btStackAlloc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  arg2 = *(btStackAlloc **)&jarg2; 
  if (arg1) (arg1)->m_stackAlloc = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_ClosestPointInput_1stackAlloc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  btStackAlloc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ClosestPointInput **)&jarg1; 
  result = (btStackAlloc *) ((arg1)->m_stackAlloc);
  *(btStackAlloc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1ClosestPointInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ClosestPointInput *arg1 = (ClosestPointInput *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ClosestPointInput **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1clientObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->m_clientObject = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1clientObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (void *) ((arg1)->m_clientObject);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1collisionFilterGroup_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->m_collisionFilterGroup = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1collisionFilterGroup_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (short) ((arg1)->m_collisionFilterGroup);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1collisionFilterMask_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->m_collisionFilterMask = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1collisionFilterMask_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (short) ((arg1)->m_collisionFilterMask);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1multiSapParentProxy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->m_multiSapParentProxy = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1multiSapParentProxy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (void *) ((arg1)->m_multiSapParentProxy);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1uniqueId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_uniqueId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1uniqueId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (int) ((arg1)->m_uniqueId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1aabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1aabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMin);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1aabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMax = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1aabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMax);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1getUid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (int)((btBroadphaseProxy const *)arg1)->getUid();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBroadphaseProxy_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphaseProxy *)new btBroadphaseProxy();
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBroadphaseProxy_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jshort jarg4, jshort jarg5, jlong jarg6) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  short arg4 ;
  short arg5 ;
  void *arg6 = (void *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(void **)&jarg3; 
  arg4 = (short)jarg4; 
  arg5 = (short)jarg5; 
  arg6 = *(void **)&jarg6; 
  result = (btBroadphaseProxy *)new btBroadphaseProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBroadphaseProxy_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jshort jarg4, jshort jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  short arg4 ;
  short arg5 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(void **)&jarg3; 
  arg4 = (short)jarg4; 
  arg5 = (short)jarg5; 
  result = (btBroadphaseProxy *)new btBroadphaseProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isPolyhedral(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isPolyhedral(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isConvex(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isConvex(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isNonMoving(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isNonMoving(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isConcave(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isConcave(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isCompound(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isCompound(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isSoftBody(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isSoftBody(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isInfinite(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isInfinite(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseProxy_1isConvex2d(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isConvex2d(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBroadphaseProxy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBroadphasePair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphasePair *)new btBroadphasePair();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBroadphasePair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePair const & reference is null");
    return 0;
  } 
  result = (btBroadphasePair *)new btBroadphasePair((btBroadphasePair const &)*arg1);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBroadphasePair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = 0 ;
  btBroadphaseProxy *arg2 = 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseProxy **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseProxy & reference is null");
    return 0;
  } 
  arg2 = *(btBroadphaseProxy **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseProxy & reference is null");
    return 0;
  } 
  result = (btBroadphasePair *)new btBroadphasePair(*arg1,*arg2);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphasePair_1pProxy0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  if (arg1) (arg1)->m_pProxy0 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphasePair_1pProxy0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (btBroadphaseProxy *) ((arg1)->m_pProxy0);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphasePair_1pProxy1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  if (arg1) (arg1)->m_pProxy1 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphasePair_1pProxy1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (btBroadphaseProxy *) ((arg1)->m_pProxy1);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphasePair_1algorithm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btCollisionAlgorithm *arg2 = (btCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = *(btCollisionAlgorithm **)&jarg2; 
  if (arg1) (arg1)->m_algorithm = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphasePair_1algorithm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (btCollisionAlgorithm *) ((arg1)->m_algorithm);
  *(btCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBroadphasePair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphasePair **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBroadphasePairSortPredicate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphasePairSortPredicate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphasePairSortPredicate *)new btBroadphasePairSortPredicate();
  *(btBroadphasePairSortPredicate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBroadphasePairSortPredicate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphasePairSortPredicate *arg1 = (btBroadphasePairSortPredicate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphasePairSortPredicate **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBroadphaseAabbCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseAabbCallback *arg1 = (btBroadphaseAabbCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseAabbCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseAabbCallback_1process(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btBroadphaseAabbCallback *arg1 = (btBroadphaseAabbCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseAabbCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  result = (bool)(arg1)->process((btBroadphaseProxy const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseRayCallback_1rayDirectionInverse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_rayDirectionInverse = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseRayCallback_1rayDirectionInverse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_rayDirectionInverse);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseRayCallback_1signs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  unsigned int *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, (unsigned int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned int *b = (unsigned int *) arg1->m_signs;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, (unsigned int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseRayCallback_1signs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  unsigned int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  result = (unsigned int *)(unsigned int *) ((arg1)->m_signs);
  jresult = SWIG_JavaArrayOutUint(jenv, (unsigned int *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseRayCallback_1lambda_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_lambda_max = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseRayCallback_1lambda_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  result = (btScalar) ((arg1)->m_lambda_max);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBroadphaseRayCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBroadphaseInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1createProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4, jlong jarg5, jshort jarg6, jshort jarg7, jlong jarg8, jobject jarg8_, jlong jarg9) {
  jlong jresult = 0 ;
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  void *arg5 = (void *) 0 ;
  short arg6 ;
  short arg7 ;
  btDispatcher *arg8 = (btDispatcher *) 0 ;
  void *arg9 = (void *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg8_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = (short)jarg6; 
  arg7 = (short)jarg7; 
  arg8 = *(btDispatcher **)&jarg8; 
  arg9 = *(void **)&jarg9; 
  result = (btBroadphaseProxy *)(arg1)->createProxy((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1destroyProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->destroyProxy(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1setAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btDispatcher *arg5 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btDispatcher **)&jarg5; 
  (arg1)->setAabb(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1getAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btBroadphaseInterface const *)arg1)->getAabb(arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1aabbTest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseAabbCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseAabbCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseAabbCallback & reference is null");
    return ;
  } 
  (arg1)->aabbTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1calculateOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->calculateOverlappingPairs(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1getBroadphaseAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btBroadphaseInterface const *)arg1)->getBroadphaseAabb(*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1resetPool(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->resetPool(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBroadphaseInterface_1printStats(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  (arg1)->printStats();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Center(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = ((btDbvtAabbMm const *)arg1)->Center();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Lengths(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = ((btDbvtAabbMm const *)arg1)->Lengths();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Extents(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = ((btDbvtAabbMm const *)arg1)->Extents();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Mins(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &((btDbvtAabbMm const *)arg1)->Mins();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Maxs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &((btDbvtAabbMm const *)arg1)->Maxs();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1FromCE(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btDbvtAabbMm::FromCE((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1FromCR(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = btDbvtAabbMm::FromCR((btVector3 const &)*arg1,arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1FromMM(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btDbvtAabbMm::FromMM((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1FromPoints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int arg2 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = btDbvtAabbMm::FromPoints((btVector3 const *)arg1,arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1FromPoints_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  btVector3 **arg1 = (btVector3 **) 0 ;
  int arg2 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3 ***)&jarg1; 
  arg2 = (int)jarg2; 
  result = btDbvtAabbMm::FromPoints((btVector3 const **)arg1,arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Expand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->Expand((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1SignedExpand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->SignedExpand((btVector3 const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Contain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (bool)((btDbvtAabbMm const *)arg1)->Contain((btDbvtAabbMm const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1Classify(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jint jarg4) {
  jint jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)((btDbvtAabbMm const *)arg1)->Classify((btVector3 const &)*arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1ProjectMinimum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3) {
  jfloat jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  result = (btScalar)((btDbvtAabbMm const *)arg1)->ProjectMinimum((btVector3 const &)*arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Intersect_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (bool)Intersect((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Intersect_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)Intersect((btDbvtAabbMm const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Proximity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (btScalar)Proximity((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Select(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  btDbvtAabbMm *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg3 = *(btDbvtAabbMm **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (int)Select((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2,(btDbvtAabbMm const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_Merge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  btDbvtAabbMm *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return ;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return ;
  } 
  arg3 = *(btDbvtAabbMm **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm & reference is null");
    return ;
  } 
  Merge((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2,*arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_NotEqual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (bool)NotEqual((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1tMins(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &(arg1)->tMins();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtAabbMm_1tMaxs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &(arg1)->tMaxs();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDbvtAabbMm(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvtAabbMm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvtAabbMm *)new btDbvtAabbMm();
  *(btDbvtAabbMm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDbvtAabbMm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtNode_1volume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtVolume *arg2 = (btDbvtVolume *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvtVolume **)&jarg2; 
  if (arg1) (arg1)->volume = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtNode_1volume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtVolume *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btDbvtVolume *)& ((arg1)->volume);
  *(btDbvtVolume **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtNode_1parent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->parent = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtNode_1parent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->parent);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtNode_1isleaf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (bool)((btDbvtNode const *)arg1)->isleaf();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtNode_1isinternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (bool)((btDbvtNode const *)arg1)->isinternal();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDbvtNode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvtNode *)new btDbvtNode();
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDbvtNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvtNode **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1root_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_root = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1root_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_root);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1free_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_free = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1free_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_free);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1lkhd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_lkhd = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1lkhd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (int) ((arg1)->m_lkhd);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1leaves_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_leaves = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1leaves_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (int) ((arg1)->m_leaves);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1opath_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_opath = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1opath_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (unsigned int) ((arg1)->m_opath);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1stkStack_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvt::sStkNN > *arg2 = (btAlignedObjectArray< btDbvt::sStkNN > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btDbvt::sStkNN > **)&jarg2; 
  if (arg1) (arg1)->m_stkStack = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1stkStack_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvt::sStkNN > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btAlignedObjectArray< btDbvt::sStkNN > *)& ((arg1)->m_stkStack);
  *(btAlignedObjectArray< btDbvt::sStkNN > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1rayTestStack_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvtNode const * > *arg2 = (btAlignedObjectArray< btDbvtNode const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btDbvtNode const * > **)&jarg2; 
  if (arg1) (arg1)->m_rayTestStack = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1rayTestStack_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvtNode const * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btAlignedObjectArray< btDbvtNode const * > *)& ((arg1)->m_rayTestStack);
  *(btAlignedObjectArray< btDbvtNode const * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDbvt(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvt *)new btDbvt();
  *(btDbvt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDbvt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (bool)((btDbvt const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1optimizeBottomUp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  (arg1)->optimizeBottomUp();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1optimizeTopDown_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->optimizeTopDown(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1optimizeTopDown_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  (arg1)->optimizeTopDown();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1optimizeIncremental(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->optimizeIncremental(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1insert(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtVolume *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtVolume **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtVolume const & reference is null");
    return 0;
  } 
  arg3 = *(void **)&jarg3; 
  result = (btDbvtNode *)(arg1)->insert((btDbvtVolume const &)*arg2,arg3);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1update_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->update(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1update_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  (arg1)->update(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1update_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvtVolume *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = *(btDbvtVolume **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtVolume & reference is null");
    return ;
  } 
  (arg1)->update(arg2,*arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1update_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jfloat jarg5) {
  jboolean jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvtVolume *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = *(btDbvtVolume **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtVolume & reference is null");
    return 0;
  } 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  result = (bool)(arg1)->update(arg2,*arg3,(btVector3 const &)*arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1update_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4) {
  jboolean jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvtVolume *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = *(btDbvtVolume **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtVolume & reference is null");
    return 0;
  } 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (bool)(arg1)->update(arg2,*arg3,(btVector3 const &)*arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1update_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jfloat jarg4) {
  jboolean jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvtVolume *arg3 = 0 ;
  btScalar arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = *(btDbvtVolume **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtVolume & reference is null");
    return 0;
  } 
  arg4 = (btScalar)jarg4; 
  result = (bool)(arg1)->update(arg2,*arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  (arg1)->remove(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvt::IWriter *arg2 = (btDbvt::IWriter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvt::IWriter **)&jarg2; 
  ((btDbvt const *)arg1)->write(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvt *arg2 = 0 ;
  btDbvt::IClone *arg3 = (btDbvt::IClone *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvt **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt & reference is null");
    return ;
  } 
  arg3 = *(btDbvt::IClone **)&jarg3; 
  ((btDbvt const *)arg1)->clone(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvt *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvt **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt & reference is null");
    return ;
  } 
  ((btDbvt const *)arg1)->clone(*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1maxdepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (int)btDbvt::maxdepth((btDbvtNode const *)arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1countLeaves(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (int)btDbvt::countLeaves((btDbvtNode const *)arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1extractLeaves(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btAlignedObjectArray< btDbvtNode const * > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btDbvtNode const * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btDbvtNode const * > & reference is null");
    return ;
  } 
  btDbvt::extractLeaves((btDbvtNode const *)arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1benchmark(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  btDbvt::benchmark();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1enumNodes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvt::ICollide *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvt::ICollide **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  btDbvt::enumNodes((btDbvtNode const *)arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1enumLeaves(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvt::ICollide *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvt::ICollide **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  btDbvt::enumLeaves((btDbvtNode const *)arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1collideTT(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvtNode *arg3 = (btDbvtNode *) 0 ;
  btDbvt::ICollide *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = *(btDbvtNode **)&jarg3; 
  arg4 = *(btDbvt::ICollide **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  (arg1)->collideTT((btDbvtNode const *)arg2,(btDbvtNode const *)arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1collideTTpersistentStack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvtNode *arg3 = (btDbvtNode *) 0 ;
  btDbvt::ICollide *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = *(btDbvtNode **)&jarg3; 
  arg4 = *(btDbvt::ICollide **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  (arg1)->collideTTpersistentStack((btDbvtNode const *)arg2,(btDbvtNode const *)arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1collideTV(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvtVolume *arg3 = 0 ;
  btDbvt::ICollide *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = *(btDbvtVolume **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtVolume const & reference is null");
    return ;
  } 
  arg4 = *(btDbvt::ICollide **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  ((btDbvt const *)arg1)->collideTV((btDbvtNode const *)arg2,(btDbvtVolume const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1rayTest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btDbvt::ICollide *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btDbvt::ICollide **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  btDbvt::rayTest((btDbvtNode const *)arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1rayTestInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jlongArray jarg6, jfloat jarg7, jobject jarg8, jobject jarg9, jlong jarg10) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  unsigned int *arg6 ;
  btScalar arg7 ;
  btVector3 *arg8 = 0 ;
  btVector3 *arg9 = 0 ;
  btDbvt::ICollide *arg10 = 0 ;
  jlong *jarr6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  if (jarg6 && jenv->GetArrayLength(jarg6) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr6, (unsigned int **)&arg6, jarg6)) return ; 
  arg7 = (btScalar)jarg7; 
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  arg10 = *(btDbvt::ICollide **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  ((btDbvt const *)arg1)->rayTestInternal((btDbvtNode const *)arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6,arg7,(btVector3 const &)*arg8,(btVector3 const &)*arg9,*arg10);
  SWIG_JavaArrayArgoutUint(jenv, jarr6, (unsigned int *)arg6, jarg6); 
  delete [] arg6; 
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1collideKDOP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jint jarg4, jlong jarg5) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btScalar *arg3 = (btScalar *) 0 ;
  int arg4 ;
  btDbvt::ICollide *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    arg3 = (btScalar*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (int)jarg4; 
  arg5 = *(btDbvt::ICollide **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  btDbvt::collideKDOP((btDbvtNode const *)arg1,(btVector3 const *)arg2,(float const *)arg3,arg4,*arg5);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1collideOCL_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jint jarg5, jlong jarg6, jboolean jarg7) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btScalar *arg3 = (btScalar *) 0 ;
  btVector3 *arg4 = 0 ;
  int arg5 ;
  btDbvt::ICollide *arg6 = 0 ;
  bool arg7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    arg3 = (btScalar*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (int)jarg5; 
  arg6 = *(btDbvt::ICollide **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  arg7 = jarg7 ? true : false; 
  btDbvt::collideOCL((btDbvtNode const *)arg1,(btVector3 const *)arg2,(float const *)arg3,(btVector3 const &)*arg4,arg5,*arg6,arg7);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1collideOCL_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jint jarg5, jlong jarg6) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btScalar *arg3 = (btScalar *) 0 ;
  btVector3 *arg4 = 0 ;
  int arg5 ;
  btDbvt::ICollide *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    arg3 = (btScalar*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (int)jarg5; 
  arg6 = *(btDbvt::ICollide **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  btDbvt::collideOCL((btDbvtNode const *)arg1,(btVector3 const *)arg2,(float const *)arg3,(btVector3 const &)*arg4,arg5,*arg6);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1collideTU(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvt::ICollide *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvt::ICollide **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::ICollide & reference is null");
    return ;
  } 
  btDbvt::collideTU((btDbvtNode const *)arg1,*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1nearest(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jfloat jarg3, jint jarg4, jint jarg5) {
  jint jresult = 0 ;
  int *arg1 = (int *) 0 ;
  btDbvt::sStkNPS *arg2 = (btDbvt::sStkNPS *) 0 ;
  btScalar arg3 ;
  int arg4 ;
  int arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (int*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg2 = *(btDbvt::sStkNPS **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (int)btDbvt::nearest((int const *)arg1,(btDbvt::sStkNPS const *)arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvt_1allocate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btAlignedObjectArray< int > *arg1 = 0 ;
  btAlignedObjectArray< btDbvt::sStkNPS > *arg2 = 0 ;
  btDbvt::sStkNPS *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< int > & reference is null");
    return 0;
  } 
  arg2 = *(btAlignedObjectArray< btDbvt::sStkNPS > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btDbvt::sStkNPS > & reference is null");
    return 0;
  } 
  arg3 = *(btDbvt::sStkNPS **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvt::sStkNPS const & reference is null");
    return 0;
  } 
  result = (int)btDbvt::allocate(*arg1,*arg2,(btDbvt::sStkNPS const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1escapeIndexOrTriangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndexOrTriangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1escapeIndexOrTriangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndexOrTriangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1isLeafNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (bool)((btQuantizedBvhNode const *)arg1)->isLeafNode();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1getEscapeIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int)((btQuantizedBvhNode const *)arg1)->getEscapeIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1getTriangleIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int)((btQuantizedBvhNode const *)arg1)->getTriangleIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNode_1getPartId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int)((btQuantizedBvhNode const *)arg1)->getPartId();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuantizedBvhNode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhNode *)new btQuantizedBvhNode();
  *(btQuantizedBvhNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btQuantizedBvhNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1aabbMinOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMinOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1aabbMinOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMinOrg);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1aabbMaxOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMaxOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1aabbMaxOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMaxOrg);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1escapeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1escapeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1subPart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subPart = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1subPart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_subPart);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1triangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1triangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 20-1);
      arg1->m_padding[20-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNode_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btOptimizedBvhNode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOptimizedBvhNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOptimizedBvhNode *)new btOptimizedBvhNode();
  *(btOptimizedBvhNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btOptimizedBvhNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1rootNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_rootNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1rootNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (int) ((arg1)->m_rootNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1subtreeSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subtreeSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1subtreeSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (int) ((arg1)->m_subtreeSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInInt(jenv, &jarr2, (int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    int *b = (int *) arg1->m_padding;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutInt(jenv, jarr2, (int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_padding);
  jresult = SWIG_JavaArrayOutInt(jenv, (int *)result, 3); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBvhSubtreeInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBvhSubtreeInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBvhSubtreeInfo *)new btBvhSubtreeInfo();
  *(btBvhSubtreeInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfo_1setAabbFromQuantizeNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  btQuantizedBvhNode *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  arg2 = *(btQuantizedBvhNode **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuantizedBvhNode const & reference is null");
    return ;
  } 
  (arg1)->setAabbFromQuantizeNode((btQuantizedBvhNode const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBvhSubtreeInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btNodeOverlapCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btNodeOverlapCallback *arg1 = (btNodeOverlapCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btNodeOverlapCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btNodeOverlapCallback_1processNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btNodeOverlapCallback *arg1 = (btNodeOverlapCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btNodeOverlapCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->processNode(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuantizedBvh(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvh *)new btQuantizedBvh();
  *(btQuantizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btQuantizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1setQuantizationValues_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->setQuantizationValues((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1setQuantizationValues_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setQuantizationValues((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1getLeafNodeArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  QuantizedNodeArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (QuantizedNodeArray *) &(arg1)->getLeafNodeArray();
  *(QuantizedNodeArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1buildInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  (arg1)->buildInternal();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1reportAabbOverlappingNodex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btNodeOverlapCallback *arg2 = (btNodeOverlapCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btNodeOverlapCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btQuantizedBvh const *)arg1)->reportAabbOverlappingNodex(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1reportRayOverlappingNodex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btNodeOverlapCallback *arg2 = (btNodeOverlapCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btNodeOverlapCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btQuantizedBvh const *)arg1)->reportRayOverlappingNodex(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1reportBoxCastOverlappingNodex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btNodeOverlapCallback *arg2 = (btNodeOverlapCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btNodeOverlapCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  ((btQuantizedBvh const *)arg1)->reportBoxCastOverlappingNodex(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1quantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btQuantizedBvh const *)arg1)->quantize(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1quantizeWithClamp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btQuantizedBvh const *)arg1)->quantizeWithClamp(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1unQuantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = ((btQuantizedBvh const *)arg1)->unQuantize((unsigned short const *)arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1setTraversalMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btQuantizedBvh::btTraversalMode arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = (btQuantizedBvh::btTraversalMode)jarg2; 
  (arg1)->setTraversalMode(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1getQuantizedNodeArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  QuantizedNodeArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (QuantizedNodeArray *) &(arg1)->getQuantizedNodeArray();
  *(QuantizedNodeArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1getSubtreeInfoArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  BvhSubtreeInfoArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (BvhSubtreeInfoArray *) &(arg1)->getSubtreeInfoArray();
  *(BvhSubtreeInfoArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (unsigned int)((btQuantizedBvh const *)arg1)->calculateSerializeBufferSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1serialize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (bool)((btQuantizedBvh const *)arg1)->serialize(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1deSerializeInPlace(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  unsigned int arg2 ;
  bool arg3 ;
  btQuantizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (btQuantizedBvh *)btQuantizedBvh::deSerializeInPlace(arg1,arg2,arg3);
  *(btQuantizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1getAlignmentSerializationPadding(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)btQuantizedBvh::getAlignmentSerializationPadding();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1calculateSerializeBufferSizeNew(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (int)((btQuantizedBvh const *)arg1)->calculateSerializeBufferSizeNew();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1serialize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btQuantizedBvh const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btQuantizedBvhFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btQuantizedBvhFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuantizedBvhFloatData & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btQuantizedBvhDoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btQuantizedBvhDoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuantizedBvhDoubleData & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvh_1isQuantized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (bool)(arg1)->isQuantized();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1rootNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_rootNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1rootNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (int) ((arg1)->m_rootNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1subtreeSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subtreeSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1subtreeSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (int) ((arg1)->m_subtreeSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhSubtreeInfoData_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBvhSubtreeInfoData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBvhSubtreeInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBvhSubtreeInfoData *)new btBvhSubtreeInfoData();
  *(btBvhSubtreeInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBvhSubtreeInfoData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1aabbMinOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMinOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1aabbMinOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_aabbMinOrg);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1aabbMaxOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMaxOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1aabbMaxOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_aabbMaxOrg);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1escapeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1escapeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1subPart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subPart = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1subPart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (int) ((arg1)->m_subPart);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1triangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1triangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 4-1);
      arg1->m_pad[4-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeFloatData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btOptimizedBvhNodeFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOptimizedBvhNodeFloatData *)new btOptimizedBvhNodeFloatData();
  *(btOptimizedBvhNodeFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btOptimizedBvhNodeFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1aabbMinOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMinOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1aabbMinOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_aabbMinOrg);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1aabbMaxOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMaxOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1aabbMaxOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_aabbMaxOrg);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1escapeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1escapeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1subPart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subPart = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1subPart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_subPart);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1triangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1triangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 4-1);
      arg1->m_pad[4-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOptimizedBvhNodeDoubleData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btOptimizedBvhNodeDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOptimizedBvhNodeDoubleData *)new btOptimizedBvhNodeDoubleData();
  *(btOptimizedBvhNodeDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btOptimizedBvhNodeDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNodeData_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNodeData_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNodeData_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNodeData_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNodeData_1escapeIndexOrTriangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndexOrTriangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhNodeData_1escapeIndexOrTriangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndexOrTriangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuantizedBvhNodeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhNodeData *)new btQuantizedBvhNodeData();
  *(btQuantizedBvhNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btQuantizedBvhNodeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1bvhAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1bvhAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_bvhAabbMin);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1bvhAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMax = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1bvhAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_bvhAabbMax);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1bvhQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_bvhQuantization = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1bvhQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_bvhQuantization);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1curNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_curNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1curNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_curNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1useQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useQuantization = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1useQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_useQuantization);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1numContiguousLeafNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numContiguousLeafNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1numContiguousLeafNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numContiguousLeafNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1numQuantizedContiguousNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numQuantizedContiguousNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1numQuantizedContiguousNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numQuantizedContiguousNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1contiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btOptimizedBvhNodeFloatData *arg2 = (btOptimizedBvhNodeFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btOptimizedBvhNodeFloatData **)&jarg2; 
  if (arg1) (arg1)->m_contiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1contiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btOptimizedBvhNodeFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btOptimizedBvhNodeFloatData *) ((arg1)->m_contiguousNodesPtr);
  *(btOptimizedBvhNodeFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1quantizedContiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btQuantizedBvhNodeData *arg2 = (btQuantizedBvhNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btQuantizedBvhNodeData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedContiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1quantizedContiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btQuantizedBvhNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btQuantizedBvhNodeData *) ((arg1)->m_quantizedContiguousNodesPtr);
  *(btQuantizedBvhNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1subTreeInfoPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btBvhSubtreeInfoData *arg2 = (btBvhSubtreeInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btBvhSubtreeInfoData **)&jarg2; 
  if (arg1) (arg1)->m_subTreeInfoPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1subTreeInfoPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btBvhSubtreeInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btBvhSubtreeInfoData *) ((arg1)->m_subTreeInfoPtr);
  *(btBvhSubtreeInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1traversalMode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_traversalMode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1traversalMode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_traversalMode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1numSubtreeHeaders_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numSubtreeHeaders = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhFloatData_1numSubtreeHeaders_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numSubtreeHeaders);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuantizedBvhFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhFloatData *)new btQuantizedBvhFloatData();
  *(btQuantizedBvhFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btQuantizedBvhFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1bvhAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1bvhAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_bvhAabbMin);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1bvhAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMax = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1bvhAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_bvhAabbMax);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1bvhQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_bvhQuantization = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1bvhQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_bvhQuantization);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1curNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_curNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1curNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_curNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1useQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useQuantization = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1useQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_useQuantization);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1numContiguousLeafNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numContiguousLeafNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1numContiguousLeafNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_numContiguousLeafNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1numQuantizedContiguousNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numQuantizedContiguousNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1numQuantizedContiguousNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_numQuantizedContiguousNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1contiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btOptimizedBvhNodeDoubleData *arg2 = (btOptimizedBvhNodeDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btOptimizedBvhNodeDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_contiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1contiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btOptimizedBvhNodeDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btOptimizedBvhNodeDoubleData *) ((arg1)->m_contiguousNodesPtr);
  *(btOptimizedBvhNodeDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1quantizedContiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btQuantizedBvhNodeData *arg2 = (btQuantizedBvhNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btQuantizedBvhNodeData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedContiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1quantizedContiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btQuantizedBvhNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btQuantizedBvhNodeData *) ((arg1)->m_quantizedContiguousNodesPtr);
  *(btQuantizedBvhNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1traversalMode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_traversalMode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1traversalMode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_traversalMode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1numSubtreeHeaders_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numSubtreeHeaders = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1numSubtreeHeaders_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_numSubtreeHeaders);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1subTreeInfoPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btBvhSubtreeInfoData *arg2 = (btBvhSubtreeInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btBvhSubtreeInfoData **)&jarg2; 
  if (arg1) (arg1)->m_subTreeInfoPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btQuantizedBvhDoubleData_1subTreeInfoPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btBvhSubtreeInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btBvhSubtreeInfoData *) ((arg1)->m_subTreeInfoPtr);
  *(btBvhSubtreeInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btQuantizedBvhDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhDoubleData *)new btQuantizedBvhDoubleData();
  *(btQuantizedBvhDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btQuantizedBvhDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtProxy_1leaf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtProxy *arg1 = (btDbvtProxy *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtProxy **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->leaf = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtProxy_1leaf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtProxy *arg1 = (btDbvtProxy *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtProxy **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->leaf);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtProxy_1links_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtProxy *arg1 = (btDbvtProxy *) 0 ;
  btDbvtProxy **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtProxy **)&jarg1; 
  arg2 = *(btDbvtProxy ***)&jarg2; 
  {
    size_t ii;
    btDbvtProxy * *b = (btDbvtProxy * *) arg1->links;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btDbvtProxy * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtProxy_1links_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtProxy *arg1 = (btDbvtProxy *) 0 ;
  btDbvtProxy **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtProxy **)&jarg1; 
  result = (btDbvtProxy **)(btDbvtProxy **) ((arg1)->links);
  *(btDbvtProxy ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtProxy_1stage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtProxy *arg1 = (btDbvtProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->stage = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtProxy_1stage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtProxy *arg1 = (btDbvtProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtProxy **)&jarg1; 
  result = (int) ((arg1)->stage);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDbvtProxy(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jshort jarg4, jshort jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  short arg4 ;
  short arg5 ;
  btDbvtProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(void **)&jarg3; 
  arg4 = (short)jarg4; 
  arg5 = (short)jarg5; 
  result = (btDbvtProxy *)new btDbvtProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btDbvtProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDbvtProxy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvtProxy *arg1 = (btDbvtProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvtProxy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1sets_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btDbvt *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = *(btDbvt **)&jarg2; 
  {
    size_t ii;
    btDbvt *b = (btDbvt *) arg1->m_sets;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btDbvt *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1sets_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btDbvt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (btDbvt *)(btDbvt *) ((arg1)->m_sets);
  *(btDbvt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1stageRoots_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btDbvtProxy **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = *(btDbvtProxy ***)&jarg2; 
  {
    size_t ii;
    btDbvtProxy * *b = (btDbvtProxy * *) arg1->m_stageRoots;
    for (ii = 0; ii < (size_t)btDbvtBroadphase::STAGECOUNT+1; ii++) b[ii] = *((btDbvtProxy * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1stageRoots_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btDbvtProxy **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (btDbvtProxy **)(btDbvtProxy **) ((arg1)->m_stageRoots);
  *(btDbvtProxy ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1paircache_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btOverlappingPairCache *arg2 = (btOverlappingPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = *(btOverlappingPairCache **)&jarg2; 
  if (arg1) (arg1)->m_paircache = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1paircache_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (btOverlappingPairCache *) ((arg1)->m_paircache);
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1prediction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_prediction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1prediction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (btScalar) ((arg1)->m_prediction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1stageCurrent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_stageCurrent = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1stageCurrent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_stageCurrent);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1fupdates_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_fupdates = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1fupdates_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_fupdates);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1dupdates_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_dupdates = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1dupdates_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_dupdates);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1cupdates_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_cupdates = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1cupdates_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_cupdates);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1newpairs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_newpairs = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1newpairs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_newpairs);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1fixedleft_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_fixedleft = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1fixedleft_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_fixedleft);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1updates_1call_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_updates_call = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1updates_1call_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (unsigned int) ((arg1)->m_updates_call);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1updates_1done_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_updates_done = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1updates_1done_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (unsigned int) ((arg1)->m_updates_done);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1updates_1ratio_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_updates_ratio = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1updates_1ratio_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (btScalar) ((arg1)->m_updates_ratio);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1pid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_pid = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1pid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_pid);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1cid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_cid = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1cid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_cid);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1gid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_gid = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1gid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (int) ((arg1)->m_gid);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1releasepaircache_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_releasepaircache = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1releasepaircache_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (bool) ((arg1)->m_releasepaircache);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1deferedcollide_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_deferedcollide = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1deferedcollide_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (bool) ((arg1)->m_deferedcollide);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1needcleanup_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_needcleanup = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1needcleanup_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (bool) ((arg1)->m_needcleanup);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDbvtBroadphase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btDbvtBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (btDbvtBroadphase *)new btDbvtBroadphase(arg1);
  *(btDbvtBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDbvtBroadphase_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvtBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvtBroadphase *)new btDbvtBroadphase();
  *(btDbvtBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDbvtBroadphase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1collide(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->collide(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1optimize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  (arg1)->optimize();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1performDeferredRemoval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->performDeferredRemoval(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1setVelocityPrediction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setVelocityPrediction(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1getVelocityPrediction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  result = (btScalar)((btDbvtBroadphase const *)arg1)->getVelocityPrediction();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1setAabbForceUpdate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  btDbvtBroadphase *arg1 = (btDbvtBroadphase *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btDispatcher *arg5 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(btDbvtBroadphase **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btDispatcher **)&jarg5; 
  (arg1)->setAabbForceUpdate(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDbvtBroadphase_1benchmark(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btDbvtBroadphase::benchmark(arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphaseProxy_1nextFree_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_nextFree = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphaseProxy_1nextFree_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  result = (int) ((arg1)->m_nextFree);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btSimpleBroadphaseProxy_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSimpleBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSimpleBroadphaseProxy *)new btSimpleBroadphaseProxy();
  *(btSimpleBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btSimpleBroadphaseProxy_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jlong jarg4, jshort jarg5, jshort jarg6, jlong jarg7) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  void *arg4 = (void *) 0 ;
  short arg5 ;
  short arg6 ;
  void *arg7 = (void *) 0 ;
  btSimpleBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  arg4 = *(void **)&jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (short)jarg6; 
  arg7 = *(void **)&jarg7; 
  result = (btSimpleBroadphaseProxy *)new btSimpleBroadphaseProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6,arg7);
  *(btSimpleBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphaseProxy_1SetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->SetNextFree(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphaseProxy_1GetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  result = (int)((btSimpleBroadphaseProxy const *)arg1)->GetNextFree();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btSimpleBroadphaseProxy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btSimpleBroadphase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  int arg1 ;
  btOverlappingPairCache *arg2 = (btOverlappingPairCache *) 0 ;
  btSimpleBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (int)jarg1; 
  arg2 = *(btOverlappingPairCache **)&jarg2; 
  result = (btSimpleBroadphase *)new btSimpleBroadphase(arg1,arg2);
  *(btSimpleBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btSimpleBroadphase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btSimpleBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btSimpleBroadphase *)new btSimpleBroadphase(arg1);
  *(btSimpleBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btSimpleBroadphase_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSimpleBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSimpleBroadphase *)new btSimpleBroadphase();
  *(btSimpleBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btSimpleBroadphase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphase_1aabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  btSimpleBroadphaseProxy *arg2 = (btSimpleBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  arg2 = *(btSimpleBroadphaseProxy **)&jarg2; 
  result = (bool)btSimpleBroadphase::aabbOverlap(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphase_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphase_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphase_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphase_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSimpleBroadphase_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1getBroadphaseArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btSapBroadphaseArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  result = (btSapBroadphaseArray *) &(arg1)->getBroadphaseArray();
  *(btSapBroadphaseArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btMultiSapBroadphase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1addToChildBroadphase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btMultiSapBroadphase::btMultiSapProxy *arg2 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btBroadphaseInterface *arg4 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  arg2 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  arg4 = *(btBroadphaseInterface **)&jarg4; 
  (arg1)->addToChildBroadphase(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1buildTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->buildTree((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMultiSapBroadphase_1quicksort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btBroadphasePairArray *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  arg2 = *(btBroadphasePairArray **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePairArray & reference is null");
    return ;
  } 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->quicksort(*arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCollisionAlgorithmConstructionInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCollisionAlgorithmConstructionInfo *)new btCollisionAlgorithmConstructionInfo();
  *(btCollisionAlgorithmConstructionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCollisionAlgorithmConstructionInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int arg2 ;
  btCollisionAlgorithmConstructionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btCollisionAlgorithmConstructionInfo *)new btCollisionAlgorithmConstructionInfo(arg1,arg2);
  *(btCollisionAlgorithmConstructionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionAlgorithmConstructionInfo_1dispatcher1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  if (arg1) (arg1)->m_dispatcher1 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionAlgorithmConstructionInfo_1dispatcher1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btDispatcher *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  result = (btDispatcher *) ((arg1)->m_dispatcher1);
  *(btDispatcher **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionAlgorithmConstructionInfo_1manifold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btPersistentManifold *arg2 = (btPersistentManifold *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  arg2 = *(btPersistentManifold **)&jarg2; 
  if (arg1) (arg1)->m_manifold = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionAlgorithmConstructionInfo_1manifold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  result = (btPersistentManifold *) ((arg1)->m_manifold);
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCollisionAlgorithmConstructionInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionAlgorithm_1processCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btDispatcherInfo *arg4 = 0 ;
  btManifoldResult *arg5 = (btManifoldResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = *(btDispatcherInfo **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDispatcherInfo const & reference is null");
    return ;
  } 
  arg5 = *(btManifoldResult **)&jarg5; 
  (arg1)->processCollision((btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3,(btDispatcherInfo const &)*arg4,arg5);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionAlgorithm_1calculateTimeOfImpact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jfloat jresult = 0 ;
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  btDispatcherInfo *arg4 = 0 ;
  btManifoldResult *arg5 = (btManifoldResult *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  arg4 = *(btDispatcherInfo **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDispatcherInfo const & reference is null");
    return 0;
  } 
  arg5 = *(btManifoldResult **)&jarg5; 
  result = (btScalar)(arg1)->calculateTimeOfImpact(arg2,arg3,(btDispatcherInfo const &)*arg4,arg5);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionAlgorithm_1getAllContactManifolds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  btManifoldArray *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  arg2 = *(btManifoldArray **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btManifoldArray & reference is null");
    return ;
  } 
  (arg1)->getAllContactManifolds(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btOverlappingPairCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCallback_1addOverlappingPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (btBroadphasePair *)(arg1)->addOverlappingPair(arg2,arg3);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCallback_1removeOverlappingPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg4 = (btDispatcher *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  arg4 = *(btDispatcher **)&jarg4; 
  result = (void *)(arg1)->removeOverlappingPair(arg2,arg3,arg4);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCallback_1removeOverlappingPairsContainingProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->removeOverlappingPairsContainingProxy(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gOverlappingPairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gOverlappingPairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gOverlappingPairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gOverlappingPairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalShort_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4, jint jarg5, jlong jarg6, jobject jarg6_, jboolean jarg7) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  unsigned short arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  bool arg7 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  arg5 = (unsigned short)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  arg7 = jarg7 ? true : false; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6,arg7);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalShort_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4, jint jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  unsigned short arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  arg5 = (unsigned short)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalShort_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  unsigned short arg5 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  arg5 = (unsigned short)jarg5; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalShort_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btAxisSweep3InternalShort(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1getNumHandles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  result = (unsigned short)((btAxisSweep3Internal< unsigned short > const *)arg1)->getNumHandles();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1addHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jshort jarg5, jshort jarg6, jlong jarg7, jobject jarg7_, jlong jarg8) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  void *arg4 = (void *) 0 ;
  short arg5 ;
  short arg6 ;
  btDispatcher *arg7 = (btDispatcher *) 0 ;
  void *arg8 = (void *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg7_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(void **)&jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (short)jarg6; 
  arg7 = *(btDispatcher **)&jarg7; 
  arg8 = *(void **)&jarg8; 
  result = (unsigned short)(arg1)->addHandle((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,arg6,arg7,arg8);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1removeHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short arg2 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->removeHandle(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1updateHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btDispatcher *arg5 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btDispatcher **)&jarg5; 
  (arg1)->updateHandle(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1getHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short arg2 ;
  btAxisSweep3Internal< unsigned short >::Handle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  result = (btAxisSweep3Internal< unsigned short >::Handle *)((btAxisSweep3Internal< unsigned short > const *)arg1)->getHandle(arg2);
  *(btAxisSweep3Internal< unsigned short >::Handle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1quantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btAxisSweep3Internal< unsigned short > const *)arg1)->quantize(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1unQuantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btAxisSweep3Internal< unsigned short > const *)arg1)->unQuantize(arg2,*arg3,*arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1setOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btOverlappingPairCallback *arg2 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = *(btOverlappingPairCallback **)&jarg2; 
  (arg1)->setOverlappingPairUserCallback(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalShort_1getOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btOverlappingPairCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  result = (btOverlappingPairCallback *)((btAxisSweep3Internal< unsigned short > const *)arg1)->getOverlappingPairUserCallback();
  *(btOverlappingPairCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalInt_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jobject jarg6_, jboolean jarg7) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  unsigned int arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  bool arg7 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  arg5 = (unsigned int)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  arg7 = jarg7 ? true : false; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6,arg7);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalInt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  unsigned int arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  arg5 = (unsigned int)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalInt_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  unsigned int arg5 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  arg5 = (unsigned int)jarg5; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3InternalInt_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btAxisSweep3InternalInt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1getNumHandles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  result = (unsigned int)((btAxisSweep3Internal< unsigned int > const *)arg1)->getNumHandles();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1addHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jshort jarg5, jshort jarg6, jlong jarg7, jobject jarg7_, jlong jarg8) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  void *arg4 = (void *) 0 ;
  short arg5 ;
  short arg6 ;
  btDispatcher *arg7 = (btDispatcher *) 0 ;
  void *arg8 = (void *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg7_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(void **)&jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (short)jarg6; 
  arg7 = *(btDispatcher **)&jarg7; 
  arg8 = *(void **)&jarg8; 
  result = (unsigned int)(arg1)->addHandle((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,arg6,arg7,arg8);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1removeHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int arg2 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->removeHandle(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1updateHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btDispatcher *arg5 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btDispatcher **)&jarg5; 
  (arg1)->updateHandle(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1getHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int arg2 ;
  btAxisSweep3Internal< unsigned int >::Handle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (btAxisSweep3Internal< unsigned int >::Handle *)((btAxisSweep3Internal< unsigned int > const *)arg1)->getHandle(arg2);
  *(btAxisSweep3Internal< unsigned int >::Handle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1quantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int *arg2 = (unsigned int *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  {
    arg2 = (unsigned int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btAxisSweep3Internal< unsigned int > const *)arg1)->quantize(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1unQuantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btAxisSweep3Internal< unsigned int > const *)arg1)->unQuantize(arg2,*arg3,*arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1setOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btOverlappingPairCallback *arg2 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = *(btOverlappingPairCallback **)&jarg2; 
  (arg1)->setOverlappingPairUserCallback(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btAxisSweep3InternalInt_1getOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btOverlappingPairCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  result = (btOverlappingPairCallback *)((btAxisSweep3Internal< unsigned int > const *)arg1)->getOverlappingPairUserCallback();
  *(btOverlappingPairCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  bool arg5 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btAxisSweep3_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btAxisSweep3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3 *arg1 = (btAxisSweep3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1bt32BitAxisSweep3_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  bool arg5 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1bt32BitAxisSweep3_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1bt32BitAxisSweep3_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1bt32BitAxisSweep3_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1bt32BitAxisSweep3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  bt32BitAxisSweep3 *arg1 = (bt32BitAxisSweep3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(bt32BitAxisSweep3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btDispatcherInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDispatcherInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDispatcherInfo *)new btDispatcherInfo();
  *(btDispatcherInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1timeStep_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_timeStep = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1timeStep_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_timeStep);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1stepCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_stepCount = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1stepCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (int) ((arg1)->m_stepCount);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1dispatchFunc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_dispatchFunc = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1dispatchFunc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (int) ((arg1)->m_dispatchFunc);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1timeOfImpact_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_timeOfImpact = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1timeOfImpact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_timeOfImpact);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1useContinuous_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useContinuous = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1useContinuous_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_useContinuous);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1debugDraw_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  if (arg1) (arg1)->m_debugDraw = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1debugDraw_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btIDebugDraw *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btIDebugDraw *) ((arg1)->m_debugDraw);
  *(btIDebugDraw **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1enableSatConvex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_enableSatConvex = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1enableSatConvex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_enableSatConvex);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1enableSPU_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_enableSPU = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1enableSPU_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_enableSPU);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1useEpa_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useEpa = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1useEpa_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_useEpa);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1allowedCcdPenetration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_allowedCcdPenetration = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1allowedCcdPenetration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_allowedCcdPenetration);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1useConvexConservativeDistanceUtil_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useConvexConservativeDistanceUtil = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1useConvexConservativeDistanceUtil_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_useConvexConservativeDistanceUtil);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1convexConservativeDistanceThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_convexConservativeDistanceThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1convexConservativeDistanceThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_convexConservativeDistanceThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1stackAllocator_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btStackAlloc *arg2 = (btStackAlloc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = *(btStackAlloc **)&jarg2; 
  if (arg1) (arg1)->m_stackAllocator = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcherInfo_1stackAllocator_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btStackAlloc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btStackAlloc *) ((arg1)->m_stackAllocator);
  *(btStackAlloc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDispatcherInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btDispatcher(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDispatcher **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1findAlgorithm_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btPersistentManifold *arg4 = (btPersistentManifold *) 0 ;
  btCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = *(btPersistentManifold **)&jarg4; 
  result = (btCollisionAlgorithm *)(arg1)->findAlgorithm((btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3,arg4);
  *(btCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1findAlgorithm_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  result = (btCollisionAlgorithm *)(arg1)->findAlgorithm((btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3);
  *(btCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1getNewManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  result = (btPersistentManifold *)(arg1)->getNewManifold((btCollisionObject const *)arg2,(btCollisionObject const *)arg3);
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1releaseManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPersistentManifold *arg2 = (btPersistentManifold *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btPersistentManifold **)&jarg2; 
  (arg1)->releaseManifold(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1clearManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPersistentManifold *arg2 = (btPersistentManifold *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btPersistentManifold **)&jarg2; 
  (arg1)->clearManifold(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1needsCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  result = (bool)(arg1)->needsCollision((btCollisionObject const *)arg2,(btCollisionObject const *)arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1needsResponse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  result = (bool)(arg1)->needsResponse((btCollisionObject const *)arg2,(btCollisionObject const *)arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1dispatchAllCollisionPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btOverlappingPairCache *arg2 = (btOverlappingPairCache *) 0 ;
  btDispatcherInfo *arg3 = 0 ;
  btDispatcher *arg4 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btOverlappingPairCache **)&jarg2; 
  arg3 = *(btDispatcherInfo **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDispatcherInfo const & reference is null");
    return ;
  } 
  arg4 = *(btDispatcher **)&jarg4; 
  (arg1)->dispatchAllCollisionPairs(arg2,(btDispatcherInfo const &)*arg3,arg4);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1getNumManifolds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  result = (int)((btDispatcher const *)arg1)->getNumManifolds();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1getManifoldByIndexInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int arg2 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btPersistentManifold *)(arg1)->getManifoldByIndexInternal(arg2);
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1getInternalManifoldPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPersistentManifold **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  result = (btPersistentManifold **)(arg1)->getInternalManifoldPointer();
  *(btPersistentManifold ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1getInternalManifoldPool_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPoolAllocator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  result = (btPoolAllocator *)(arg1)->getInternalManifoldPool();
  *(btPoolAllocator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1allocateCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)(arg1)->allocateCollisionAlgorithm(arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btDispatcher_1freeCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  (arg1)->freeCollisionAlgorithm(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btOverlapCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlapCallback *arg1 = (btOverlapCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlapCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlapCallback_1processOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btOverlapCallback *arg1 = (btOverlapCallback *) 0 ;
  btBroadphasePair *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOverlapCallback **)&jarg1; 
  arg2 = *(btBroadphasePair **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePair & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->processOverlap(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlapFilterCallback *arg1 = (btOverlapFilterCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlapFilterCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlapFilterCallback_1needBroadphaseCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btOverlapFilterCallback *arg1 = (btOverlapFilterCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlapFilterCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)((btOverlapFilterCallback const *)arg1)->needBroadphaseCollision(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gRemovePairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gRemovePairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gRemovePairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gRemovePairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gAddedPairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gAddedPairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gAddedPairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gAddedPairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gFindPairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gFindPairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_gFindPairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gFindPairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_BT_1NULL_1PAIR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)BT_NULL_PAIR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btOverlappingPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1getOverlappingPairArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphasePairArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePairArray *) &(arg1)->getOverlappingPairArray();
  *(btBroadphasePairArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1cleanOverlappingPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphasePair *arg2 = 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphasePair **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePair & reference is null");
    return ;
  } 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->cleanOverlappingPair(*arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1getNumOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (int)((btOverlappingPairCache const *)arg1)->getNumOverlappingPairs();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1cleanProxyFromPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->cleanProxyFromPairs(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1setOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btOverlapFilterCallback *arg2 = (btOverlapFilterCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btOverlapFilterCallback **)&jarg2; 
  (arg1)->setOverlapFilterCallback(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1processAllOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btOverlapCallback *arg2 = (btOverlapCallback *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btOverlapCallback **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->processAllOverlappingPairs(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1findPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (btBroadphasePair *)(arg1)->findPair(arg2,arg3);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1hasDeferredRemoval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (bool)(arg1)->hasDeferredRemoval();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1setInternalGhostPairCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btOverlappingPairCallback *arg2 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btOverlappingPairCallback **)&jarg2; 
  (arg1)->setInternalGhostPairCallback(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btOverlappingPairCache_1sortOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->sortOverlappingPairs(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btHashedOverlappingPairCache(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btHashedOverlappingPairCache *)new btHashedOverlappingPairCache();
  *(btHashedOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btHashedOverlappingPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashedOverlappingPairCache_1needsBroadphaseCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)((btHashedOverlappingPairCache const *)arg1)->needsBroadphaseCollision(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashedOverlappingPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashedOverlappingPairCache_1getOverlappingPairArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btBroadphasePairArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePairArray *) &(arg1)->getOverlappingPairArray();
  *(btBroadphasePairArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashedOverlappingPairCache_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (int)((btHashedOverlappingPairCache const *)arg1)->GetCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHashedOverlappingPairCache_1getOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btOverlapFilterCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (btOverlapFilterCallback *)(arg1)->getOverlapFilterCallback();
  *(btOverlapFilterCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btSortedOverlappingPairCache(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSortedOverlappingPairCache *)new btSortedOverlappingPairCache();
  *(btSortedOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btSortedOverlappingPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSortedOverlappingPairCache_1needsBroadphaseCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)((btSortedOverlappingPairCache const *)arg1)->needsBroadphaseCollision(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSortedOverlappingPairCache_1getOverlappingPairArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btBroadphasePairArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePairArray *) &(arg1)->getOverlappingPairArray();
  *(btBroadphasePairArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSortedOverlappingPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSortedOverlappingPairCache_1getOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btOverlapFilterCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  result = (btOverlapFilterCallback *)(arg1)->getOverlapFilterCallback();
  *(btOverlapFilterCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btNullPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btNullPairCache *arg1 = (btNullPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btNullPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btNullPairCache(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btNullPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btNullPairCache *)new btNullPairCache();
  *(btNullPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btNullPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btNullPairCache *arg1 = (btNullPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btNullPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCollisionShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btCollisionShape const *)arg1)->getAabb((btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getBoundingSphere(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btScalar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btCollisionShape const *)arg1)->getBoundingSphere(*arg2,*arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getAngularMotionDisc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (btScalar)((btCollisionShape const *)arg1)->getAngularMotionDisc();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getContactBreakingThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jfloat jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)((btCollisionShape const *)arg1)->getContactBreakingThreshold(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1calculateTemporalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jobject jarg6, jobject jarg7) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  ((btCollisionShape const *)arg1)->calculateTemporalAabb((btTransform const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,*arg6,*arg7);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isPolyhedral(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isPolyhedral();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isConvex2d(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isConvex2d();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isConvex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isConvex();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isNonMoving(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isNonMoving();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isConcave(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isConcave();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isCompound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isCompound();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isSoftBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isSoftBody();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1isInfinite(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isInfinite();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1setLocalScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLocalScaling((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getLocalScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (btVector3 *) &((btCollisionShape const *)arg1)->getLocalScaling();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1calculateLocalInertia(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jobject jarg3) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btCollisionShape const *)arg1)->calculateLocalInertia(arg2,*arg3);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (char *)((btCollisionShape const *)arg1)->getName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getShapeType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (int)((btCollisionShape const *)arg1)->getShapeType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getAnisotropicRollingFrictionDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = ((btCollisionShape const *)arg1)->getAnisotropicRollingFrictionDirection();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1setMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMargin(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (btScalar)((btCollisionShape const *)arg1)->getMargin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1setUserPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  (arg1)->setUserPointer(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1getUserPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (void *)((btCollisionShape const *)arg1)->getUserPointer();
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (int)((btCollisionShape const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btCollisionShape const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShape_1serializeSingleShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btSerializer *arg2 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = *(btSerializer **)&jarg2; 
  ((btCollisionShape const *)arg1)->serializeSingleShape(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShapeData_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->m_name;
    if (arg2) {
      arg1->m_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_name, (const char *)arg2);
    } else {
      arg1->m_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShapeData_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  result = (char *) ((arg1)->m_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShapeData_1shapeType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_shapeType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShapeData_1shapeType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  result = (int) ((arg1)->m_shapeType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCollisionShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCollisionShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCollisionShapeData *)new btCollisionShapeData();
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCollisionShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btConvexShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1localGetSupportingVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportingVertex((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1localGetSupportingVertexWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportingVertexWithoutMargin((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1localGetSupportVertexWithoutMarginNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportVertexWithoutMarginNonVirtual((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1localGetSupportVertexNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportVertexNonVirtual((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1getMarginNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  result = (btScalar)((btConvexShape const *)arg1)->getMarginNonVirtual();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1getAabbNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btConvexShape const *)arg1)->getAabbNonVirtual((btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1project(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jlong jarg5) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btConvexShape const *)arg1)->project((btTransform const &)*arg2,(btVector3 const &)*arg3,*arg4,*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1batchedUnitVectorGetSupportingVertexWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btConvexShape **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  arg4 = (int)jarg4; 
  ((btConvexShape const *)arg1)->batchedUnitVectorGetSupportingVertexWithoutMargin((btVector3 const *)arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1getAabbSlow(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btConvexShape const *)arg1)->getAabbSlow((btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1getNumPreferredPenetrationDirections(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  result = (int)((btConvexShape const *)arg1)->getNumPreferredPenetrationDirections();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexShape_1getPreferredPenetrationDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btConvexShape const *)arg1)->getPreferredPenetrationDirection(arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btConvexInternalShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1getImplicitShapeDimensions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  result = (btVector3 *) &((btConvexInternalShape const *)arg1)->getImplicitShapeDimensions();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1setImplicitShapeDimensions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setImplicitShapeDimensions((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setSafeMargin(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSafeMargin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->setSafeMargin((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setSafeMargin((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1getLocalScalingNV(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  result = (btVector3 *) &((btConvexInternalShape const *)arg1)->getLocalScalingNV();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShape_1getMarginNV(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  result = (btScalar)((btConvexInternalShape const *)arg1)->getMarginNV();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1collisionShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_collisionShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1collisionShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (btCollisionShapeData *)& ((arg1)->m_collisionShapeData);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1localScaling_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_localScaling = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1localScaling_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_localScaling);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1implicitShapeDimensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_implicitShapeDimensions = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1implicitShapeDimensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_implicitShapeDimensions);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1collisionMargin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_collisionMargin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1collisionMargin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (float) ((arg1)->m_collisionMargin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_padding = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (int) ((arg1)->m_padding);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btConvexInternalShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexInternalShapeData *)new btConvexInternalShapeData();
  *(btConvexInternalShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btConvexInternalShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConvexInternalAabbCachingShape_1recalcLocalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btConvexInternalAabbCachingShape *arg1 = (btConvexInternalAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalAabbCachingShape **)&jarg1; 
  (arg1)->recalcLocalAabb();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btConvexInternalAabbCachingShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexInternalAabbCachingShape *arg1 = (btConvexInternalAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexInternalAabbCachingShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btPolyhedralConvexShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1initializePolyhedralFeatures_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->initializePolyhedralFeatures(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1initializePolyhedralFeatures_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (bool)(arg1)->initializePolyhedralFeatures();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1getConvexPolyhedron(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  btConvexPolyhedron *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (btConvexPolyhedron *)((btPolyhedralConvexShape const *)arg1)->getConvexPolyhedron();
  *(btConvexPolyhedron **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1getNumVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (int)((btPolyhedralConvexShape const *)arg1)->getNumVertices();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1getNumEdges(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (int)((btPolyhedralConvexShape const *)arg1)->getNumEdges();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1getEdge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jobject jarg4) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btPolyhedralConvexShape const *)arg1)->getEdge(arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1getVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btPolyhedralConvexShape const *)arg1)->getVertex(arg2,*arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1getNumPlanes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (int)((btPolyhedralConvexShape const *)arg1)->getNumPlanes();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1getPlane(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btPolyhedralConvexShape const *)arg1)->getPlane(*arg2,*arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexShape_1isInside(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (bool)((btPolyhedralConvexShape const *)arg1)->isInside((btVector3 const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexAabbCachingShape_1getNonvirtualAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5) {
  btPolyhedralConvexAabbCachingShape *arg1 = (btPolyhedralConvexAabbCachingShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexAabbCachingShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  ((btPolyhedralConvexAabbCachingShape const *)arg1)->getNonvirtualAabb((btTransform const &)*arg2,*arg3,*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btPolyhedralConvexAabbCachingShape_1recalcLocalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btPolyhedralConvexAabbCachingShape *arg1 = (btPolyhedralConvexAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexAabbCachingShape **)&jarg1; 
  (arg1)->recalcLocalAabb();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btPolyhedralConvexAabbCachingShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPolyhedralConvexAabbCachingShape *arg1 = (btPolyhedralConvexAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPolyhedralConvexAabbCachingShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btConcaveShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConcaveShape *arg1 = (btConcaveShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConcaveShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btConcaveShape_1processAllTriangles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btConcaveShape *arg1 = (btConcaveShape *) 0 ;
  btTriangleCallback *arg2 = (btTriangleCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConcaveShape **)&jarg1; 
  arg2 = *(btTriangleCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btConcaveShape const *)arg1)->processAllTriangles(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleCallback *arg1 = (btTriangleCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleCallback_1processTriangle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btTriangleCallback *arg1 = (btTriangleCallback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleCallback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->processTriangle(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btInternalTriangleIndexCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInternalTriangleIndexCallback *arg1 = (btInternalTriangleIndexCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInternalTriangleIndexCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btInternalTriangleIndexCallback_1internalProcessTriangleIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btInternalTriangleIndexCallback *arg1 = (btInternalTriangleIndexCallback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btInternalTriangleIndexCallback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->internalProcessTriangleIndex(arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTriangleInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfo *)new btTriangleInfo();
  *(btTriangleInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_flags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (int) ((arg1)->m_flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1edgeV0V1Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeV0V1Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1edgeV0V1Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeV0V1Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1edgeV1V2Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeV1V2Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1edgeV1V2Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeV1V2Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1edgeV2V0Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeV2V0Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfo_1edgeV2V0Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeV2V0Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1convexEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_convexEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1convexEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_convexEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1planarEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_planarEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1planarEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_planarEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1equalVertexThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_equalVertexThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1equalVertexThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_equalVertexThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1edgeDistanceThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeDistanceThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1edgeDistanceThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeDistanceThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1maxEdgeAngleThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxEdgeAngleThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1maxEdgeAngleThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxEdgeAngleThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1zeroAreaThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_zeroAreaThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1zeroAreaThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_zeroAreaThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTriangleInfoMap(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfoMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfoMap *)new btTriangleInfoMap();
  *(btTriangleInfoMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleInfoMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (int)((btTriangleInfoMap const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btTriangleInfoMap const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMap_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btTriangleInfoMapData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = *(btTriangleInfoMapData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTriangleInfoMapData & reference is null");
    return ;
  } 
  (arg1)->deSerialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_flags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (int) ((arg1)->m_flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1edgeV0V1Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeV0V1Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1edgeV0V1Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (float) ((arg1)->m_edgeV0V1Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1edgeV1V2Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeV1V2Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1edgeV1V2Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (float) ((arg1)->m_edgeV1V2Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1edgeV2V0Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeV2V0Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoData_1edgeV2V0Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (float) ((arg1)->m_edgeV2V0Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTriangleInfoData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfoData *)new btTriangleInfoData();
  *(btTriangleInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleInfoData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1hashTablePtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_hashTablePtr = arg2;
    } else {
      arg1->m_hashTablePtr = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1hashTablePtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int *) ((arg1)->m_hashTablePtr);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1nextPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_nextPtr = arg2;
    } else {
      arg1->m_nextPtr = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1nextPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int *) ((arg1)->m_nextPtr);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1valueArrayPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  btTriangleInfoData *arg2 = (btTriangleInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = *(btTriangleInfoData **)&jarg2; 
  if (arg1) (arg1)->m_valueArrayPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1valueArrayPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  btTriangleInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (btTriangleInfoData *) ((arg1)->m_valueArrayPtr);
  *(btTriangleInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1keyArrayPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_keyArrayPtr = arg2;
    } else {
      arg1->m_keyArrayPtr = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1keyArrayPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int *) ((arg1)->m_keyArrayPtr);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1convexEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_convexEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1convexEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_convexEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1planarEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_planarEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1planarEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_planarEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1equalVertexThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_equalVertexThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1equalVertexThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_equalVertexThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1edgeDistanceThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeDistanceThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1edgeDistanceThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_edgeDistanceThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1zeroAreaThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_zeroAreaThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1zeroAreaThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_zeroAreaThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1nextSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_nextSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1nextSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_nextSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1hashTableSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_hashTableSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1hashTableSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_hashTableSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1numValues_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numValues = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1numValues_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_numValues);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1numKeys_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numKeys = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1numKeys_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_numKeys);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleInfoMapData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTriangleInfoMapData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfoMapData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfoMapData *)new btTriangleInfoMapData();
  *(btTriangleInfoMapData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleInfoMapData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btStaticPlaneShape(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btStaticPlaneShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = (btStaticPlaneShape *)new btStaticPlaneShape((btVector3 const &)*arg1,arg2);
  *(btStaticPlaneShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btStaticPlaneShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStaticPlaneShape *arg1 = (btStaticPlaneShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStaticPlaneShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShape_1getPlaneNormal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btStaticPlaneShape *arg1 = (btStaticPlaneShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShape **)&jarg1; 
  result = (btVector3 *) &((btStaticPlaneShape const *)arg1)->getPlaneNormal();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShape_1getPlaneConstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btStaticPlaneShape *arg1 = (btStaticPlaneShape *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShape **)&jarg1; 
  result = (btScalar *) &((btStaticPlaneShape const *)arg1)->getPlaneConstant();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1collisionShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_collisionShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1collisionShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (btCollisionShapeData *)& ((arg1)->m_collisionShapeData);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1localScaling_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_localScaling = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1localScaling_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_localScaling);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1planeNormal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_planeNormal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1planeNormal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_planeNormal);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1planeConstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_planeConstant = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1planeConstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (float) ((arg1)->m_planeConstant);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 4-1);
      arg1->m_pad[4-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStaticPlaneShapeData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btStaticPlaneShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btStaticPlaneShapeData *)new btStaticPlaneShapeData();
  *(btStaticPlaneShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btStaticPlaneShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btHeightfieldTerrainShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHeightfieldTerrainShape_1setUseDiamondSubdivision_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseDiamondSubdivision(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHeightfieldTerrainShape_1setUseDiamondSubdivision_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  (arg1)->setUseDiamondSubdivision();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHeightfieldTerrainShape_1setUseZigzagSubdivision_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseZigzagSubdivision(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btHeightfieldTerrainShape_1setUseZigzagSubdivision_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  (arg1)->setUseZigzagSubdivision();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btHeightfieldTerrainShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jobject jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jint jarg7, jboolean jarg8) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  float *arg3 = (float *) 0 ;
  btScalar arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  int arg7 ;
  bool arg8 ;
  btHeightfieldTerrainShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (float*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = jarg8 ? true : false; 
  result = (btHeightfieldTerrainShape *)new_btHeightfieldTerrainShape__SWIG_0(arg1,arg2,(float const *)arg3,arg4,arg5,arg6,arg7,arg8);
  *(btHeightfieldTerrainShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btHeightfieldTerrainShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jobject jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jint jarg7, jboolean jarg8) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  short *arg3 = (short *) 0 ;
  btScalar arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  int arg7 ;
  bool arg8 ;
  btHeightfieldTerrainShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (short*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = jarg8 ? true : false; 
  result = (btHeightfieldTerrainShape *)new_btHeightfieldTerrainShape__SWIG_1(arg1,arg2,(short const *)arg3,arg4,arg5,arg6,arg7,arg8);
  *(btHeightfieldTerrainShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShape_1localGetSupportingVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTriangleMeshShape const *)arg1)->localGetSupportingVertex((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShape_1localGetSupportingVertexWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTriangleMeshShape const *)arg1)->localGetSupportingVertexWithoutMargin((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShape_1recalcLocalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  (arg1)->recalcLocalAabb();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShape_1getMeshInterface_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btStridingMeshInterface *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  result = (btStridingMeshInterface *)(arg1)->getMeshInterface();
  *(btStridingMeshInterface **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShape_1getLocalAabbMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  result = (btVector3 *) &((btTriangleMeshShape const *)arg1)->getLocalAabbMin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShape_1getLocalAabbMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  result = (btVector3 *) &((btTriangleMeshShape const *)arg1)->getLocalAabbMax();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBvhTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1getOwnsBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (bool)((btBvhTriangleMeshShape const *)arg1)->getOwnsBvh();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1performRaycast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleCallback *arg2 = (btTriangleCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btTriangleCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->performRaycast(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1performConvexcast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleCallback *arg2 = (btTriangleCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btTriangleCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->performConvexcast(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1refitTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->refitTree((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1partialRefitTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->partialRefitTree((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1getOptimizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btOptimizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (btOptimizedBvh *)(arg1)->getOptimizedBvh();
  *(btOptimizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1setOptimizedBvh_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btOptimizedBvh *arg2 = (btOptimizedBvh *) 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btOptimizedBvh **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setOptimizedBvh(arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1setOptimizedBvh_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btOptimizedBvh *arg2 = (btOptimizedBvh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btOptimizedBvh **)&jarg2; 
  (arg1)->setOptimizedBvh(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1buildOptimizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  (arg1)->buildOptimizedBvh();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1usesQuantizedAabbCompression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (bool)((btBvhTriangleMeshShape const *)arg1)->usesQuantizedAabbCompression();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1setTriangleInfoMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleInfoMap *arg2 = (btTriangleInfoMap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btTriangleInfoMap **)&jarg2; 
  (arg1)->setTriangleInfoMap(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1getTriangleInfoMap_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleInfoMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (btTriangleInfoMap *)((btBvhTriangleMeshShape const *)arg1)->getTriangleInfoMap();
  *(btTriangleInfoMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1serializeSingleBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btSerializer *arg2 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btSerializer **)&jarg2; 
  ((btBvhTriangleMeshShape const *)arg1)->serializeSingleBvh(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBvhTriangleMeshShape_1serializeSingleTriangleInfoMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btSerializer *arg2 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btSerializer **)&jarg2; 
  ((btBvhTriangleMeshShape const *)arg1)->serializeSingleTriangleInfoMap(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBvhTriangleMeshShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  bool arg4 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_0(arg1,arg2,arg3,arg4);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBvhTriangleMeshShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_0(arg1,arg2,arg3);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBvhTriangleMeshShape_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3, jobject jarg4, jobject jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  bool arg6 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = jarg6 ? true : false; 
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_2(arg1,arg2,arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBvhTriangleMeshShape_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_2(arg1,arg2,arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1collisionShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_collisionShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1collisionShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btCollisionShapeData *)& ((arg1)->m_collisionShapeData);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1meshInterface_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btStridingMeshInterfaceData *arg2 = (btStridingMeshInterfaceData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btStridingMeshInterfaceData **)&jarg2; 
  if (arg1) (arg1)->m_meshInterface = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1meshInterface_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btStridingMeshInterfaceData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btStridingMeshInterfaceData *)& ((arg1)->m_meshInterface);
  *(btStridingMeshInterfaceData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1quantizedFloatBvh_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhFloatData *arg2 = (btQuantizedBvhFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btQuantizedBvhFloatData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedFloatBvh = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1quantizedFloatBvh_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btQuantizedBvhFloatData *) ((arg1)->m_quantizedFloatBvh);
  *(btQuantizedBvhFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1quantizedDoubleBvh_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhDoubleData *arg2 = (btQuantizedBvhDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btQuantizedBvhDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedDoubleBvh = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1quantizedDoubleBvh_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btQuantizedBvhDoubleData *) ((arg1)->m_quantizedDoubleBvh);
  *(btQuantizedBvhDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1triangleInfoMap_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btTriangleInfoMapData *arg2 = (btTriangleInfoMapData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btTriangleInfoMapData **)&jarg2; 
  if (arg1) (arg1)->m_triangleInfoMap = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1triangleInfoMap_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btTriangleInfoMapData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btTriangleInfoMapData *) ((arg1)->m_triangleInfoMap);
  *(btTriangleInfoMapData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1collisionMargin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_collisionMargin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1collisionMargin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (float) ((arg1)->m_collisionMargin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1pad3_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad3, (const char *)arg2, 4-1);
      arg1->m_pad3[4-1] = 0;
    } else {
      arg1->m_pad3[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleMeshShapeData_1pad3_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTriangleMeshShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleMeshShapeData *)new btTriangleMeshShapeData();
  *(btTriangleMeshShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleMeshShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBoxShape_1getHalfExtentsWithMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBoxShape **)&jarg1; 
  result = ((btBoxShape const *)arg1)->getHalfExtentsWithMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBoxShape_1getHalfExtentsWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBoxShape **)&jarg1; 
  result = (btVector3 *) &((btBoxShape const *)arg1)->getHalfExtentsWithoutMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBoxShape(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btBoxShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btBoxShape *)new btBoxShape((btVector3 const &)*arg1);
  *(btBoxShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBoxShape_1getPlaneEquation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  btVector4 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBoxShape **)&jarg1; 
  arg2 = *(btVector4 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 & reference is null");
    return ;
  } 
  arg3 = (int)jarg3; 
  ((btBoxShape const *)arg1)->getPlaneEquation(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBoxShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBoxShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCapsuleShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btCapsuleShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btCapsuleShape *)new btCapsuleShape(arg1,arg2);
  *(btCapsuleShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShape_1getUpAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShape **)&jarg1; 
  result = (int)((btCapsuleShape const *)arg1)->getUpAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShape_1getRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShape **)&jarg1; 
  result = (btScalar)((btCapsuleShape const *)arg1)->getRadius();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShape_1getHalfHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShape **)&jarg1; 
  result = (btScalar)((btCapsuleShape const *)arg1)->getHalfHeight();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCapsuleShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCapsuleShapeX(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btCapsuleShapeX *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btCapsuleShapeX *)new btCapsuleShapeX(arg1,arg2);
  *(btCapsuleShapeX **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCapsuleShapeX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShapeX *arg1 = (btCapsuleShapeX *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShapeX **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCapsuleShapeZ(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btCapsuleShapeZ *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btCapsuleShapeZ *)new btCapsuleShapeZ(arg1,arg2);
  *(btCapsuleShapeZ **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCapsuleShapeZ(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShapeZ *arg1 = (btCapsuleShapeZ *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShapeZ **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShapeData_1convexInternalShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  btConvexInternalShapeData *arg2 = (btConvexInternalShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  arg2 = *(btConvexInternalShapeData **)&jarg2; 
  if (arg1) (arg1)->m_convexInternalShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShapeData_1convexInternalShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  btConvexInternalShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  result = (btConvexInternalShapeData *)& ((arg1)->m_convexInternalShapeData);
  *(btConvexInternalShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShapeData_1upAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_upAxis = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShapeData_1upAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  result = (int) ((arg1)->m_upAxis);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCapsuleShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCapsuleShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCapsuleShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCapsuleShapeData *)new btCapsuleShapeData();
  *(btCapsuleShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCapsuleShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBox2dShape_1getHalfExtentsWithMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = ((btBox2dShape const *)arg1)->getHalfExtentsWithMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBox2dShape_1getHalfExtentsWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *) &((btBox2dShape const *)arg1)->getHalfExtentsWithoutMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btBox2dShape(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btBox2dShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btBox2dShape *)new btBox2dShape((btVector3 const &)*arg1);
  *(btBox2dShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBox2dShape_1getVertexCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (int)((btBox2dShape const *)arg1)->getVertexCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBox2dShape_1getVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *)((btBox2dShape const *)arg1)->getVertices();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBox2dShape_1getNormals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *)((btBox2dShape const *)arg1)->getNormals();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBox2dShape_1getCentroid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *) &((btBox2dShape const *)arg1)->getCentroid();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btBox2dShape_1getPlaneEquation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector4 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBox2dShape **)&jarg1; 
  arg2 = *(btVector4 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 & reference is null");
    return ;
  } 
  arg3 = (int)jarg3; 
  ((btBox2dShape const *)arg1)->getPlaneEquation(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btBox2dShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBox2dShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleShape_1vertices1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleShape **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_vertices1;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleShape_1vertices1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_vertices1);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleShape_1getVertexPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &(arg1)->getVertexPtr(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTriangleShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleShape *)new btTriangleShape();
  *(btTriangleShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btTriangleShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btTriangleShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btTriangleShape *)new btTriangleShape((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  *(btTriangleShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleShape_1calcNormal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btTriangleShape const *)arg1)->calcNormal(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btTriangleShape_1getPlaneEquation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jobject jarg4) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btTriangleShape const *)arg1)->getPlaneEquation(arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btTriangleShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btSphereShape(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btSphereShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btSphereShape *)new btSphereShape(arg1);
  *(btSphereShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSphereShape_1getRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSphereShape *arg1 = (btSphereShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSphereShape **)&jarg1; 
  result = (btScalar)((btSphereShape const *)arg1)->getRadius();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btSphereShape_1setUnscaledRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSphereShape *arg1 = (btSphereShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSphereShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setUnscaledRadius(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btSphereShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSphereShape *arg1 = (btSphereShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSphereShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btStridingMeshInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1InternalProcessAllTriangles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btInternalTriangleIndexCallback *arg2 = (btInternalTriangleIndexCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(btInternalTriangleIndexCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btStridingMeshInterface const *)arg1)->InternalProcessAllTriangles(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1calculateAabbBruteForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->calculateAabbBruteForce(*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1getLockedVertexIndexBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  (arg1)->getLockedVertexIndexBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1getLockedVertexIndexBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  (arg1)->getLockedVertexIndexBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1getLockedReadOnlyVertexIndexBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  ((btStridingMeshInterface const *)arg1)->getLockedReadOnlyVertexIndexBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1getLockedReadOnlyVertexIndexBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  ((btStridingMeshInterface const *)arg1)->getLockedReadOnlyVertexIndexBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1unLockVertexBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->unLockVertexBase(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1unLockReadOnlyVertexBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  ((btStridingMeshInterface const *)arg1)->unLockReadOnlyVertexBase(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1getNumSubParts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (int)((btStridingMeshInterface const *)arg1)->getNumSubParts();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1preallocateVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->preallocateVertices(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1preallocateIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->preallocateIndices(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1hasPremadeAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (bool)((btStridingMeshInterface const *)arg1)->hasPremadeAabb();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1setPremadeAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btStridingMeshInterface const *)arg1)->setPremadeAabb((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1getPremadeAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  ((btStridingMeshInterface const *)arg1)->getPremadeAabb(arg2,arg3);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1getScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (btVector3 *) &((btStridingMeshInterface const *)arg1)->getScaling();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1setScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setScaling((btVector3 const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (int)((btStridingMeshInterface const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btStridingMeshInterface_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btStridingMeshInterface const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIntIndexData_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIntIndexData *arg1 = (btIntIndexData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIntIndexData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_value = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btIntIndexData_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIntIndexData *arg1 = (btIntIndexData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIntIndexData **)&jarg1; 
  result = (int) ((arg1)->m_value);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btIntIndexData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btIntIndexData *)new btIntIndexData();
  *(btIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btIntIndexData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIntIndexData *arg1 = (btIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIntIndexData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexData_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->m_value = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexData_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  result = (short) ((arg1)->m_value);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 2-1);
      arg1->m_pad[2-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btShortIntIndexData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btShortIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btShortIntIndexData *)new btShortIntIndexData();
  *(btShortIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btShortIntIndexData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexTripletData_1values_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshortArray jarg2) {
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  short *arg2 ;
  jshort *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInShort(jenv, &jarr2, (short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    short *b = (short *) arg1->m_values;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutShort(jenv, jarr2, (short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jshortArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexTripletData_1values_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshortArray jresult = 0 ;
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  result = (short *)(short *) ((arg1)->m_values);
  jresult = SWIG_JavaArrayOutShort(jenv, (short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexTripletData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 2-1);
      arg1->m_pad[2-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btShortIntIndexTripletData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btShortIntIndexTripletData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btShortIntIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btShortIntIndexTripletData *)new btShortIntIndexTripletData();
  *(btShortIntIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btShortIntIndexTripletData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCharIndexTripletData_1values_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshortArray jarg2) {
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  unsigned char *arg2 ;
  jshort *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUchar(jenv, &jarr2, (unsigned char **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned char *b = (unsigned char *) arg1->m_values;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned char *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUchar(jenv, jarr2, (unsigned char *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jshortArray JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCharIndexTripletData_1values_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshortArray jresult = 0 ;
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  result = (unsigned char *)(unsigned char *) ((arg1)->m_values);
  jresult = SWIG_JavaArrayOutUchar(jenv, (unsigned char *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCharIndexTripletData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->m_pad = arg2;
}


SWIGEXPORT jchar JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btCharIndexTripletData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  result = (char) ((arg1)->m_pad);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_new_1btCharIndexTripletData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCharIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCharIndexTripletData *)new btCharIndexTripletData();
  *(btCharIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_delete_1btCharIndexTripletData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1vertices3f_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_vertices3f = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1vertices3f_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btVector3FloatData *) ((arg1)->m_vertices3f);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1vertices3d_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_vertices3d = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1vertices3d_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btVector3DoubleData *) ((arg1)->m_vertices3d);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1indices32_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btIntIndexData *arg2 = (btIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btIntIndexData **)&jarg2; 
  if (arg1) (arg1)->m_indices32 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1indices32_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btIntIndexData *) ((arg1)->m_indices32);
  *(btIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_13indices16_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexTripletData *arg2 = (btShortIntIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btShortIntIndexTripletData **)&jarg2; 
  if (arg1) (arg1)->m_3indices16 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_13indices16_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btShortIntIndexTripletData *) ((arg1)->m_3indices16);
  *(btShortIntIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_13indices8_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btCharIndexTripletData *arg2 = (btCharIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btCharIndexTripletData **)&jarg2; 
  if (arg1) (arg1)->m_3indices8 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_13indices8_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btCharIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btCharIndexTripletData *) ((arg1)->m_3indices8);
  *(btCharIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1indices16_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexData *arg2 = (btShortIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btShortIntIndexData **)&jarg2; 
  if (arg1) (arg1)->m_indices16 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1indices16_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btShortIntIndexData *) ((arg1)->m_indices16);
  *(btShortIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1numTriangles_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numTriangles = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1numTriangles_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (int) ((arg1)->m_numTriangles);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_gdxBulletJNI_btMeshPartData_1numVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1