/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.math.FastMath;

public class Environment {
    private float airAbsorbGainHf = 0.99426f;
    private float roomRolloffFactor = 0.0f;
    private float decayTime = 1.49f;
    private float decayHFRatio = 0.54f;
    private float density = 1.0f;
    private float diffusion = 0.3f;
    private float gain = 0.316f;
    private float gainHf = 0.022f;
    private float lateReverbDelay = 0.088f;
    private float lateReverbGain = 0.768f;
    private float reflectDelay = 0.162f;
    private float reflectGain = 0.052f;
    private boolean decayHfLimit = true;
    public static final Environment Garage = new Environment(1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.5f, 0.751f, 0.0039f, 0.661f, 0.0137f);
    public static final Environment Dungeon = new Environment(0.75f, 1.0f, 1.0f, 0.75f, 1.6f, 1.0f, 0.95f, 0.0026f, 0.93f, 0.0103f);
    public static final Environment Cavern = new Environment(0.5f, 1.0f, 1.0f, 0.5f, 2.25f, 1.0f, 0.908f, 0.0103f, 0.93f, 0.041f);
    public static final Environment AcousticLab = new Environment(0.5f, 1.0f, 1.0f, 1.0f, 0.28f, 1.0f, 0.87f, 0.002f, 0.81f, 0.008f);
    public static final Environment Closet = new Environment(1.0f, 1.0f, 1.0f, 1.0f, 0.15f, 1.0f, 0.6f, 0.0025f, 0.5f, 6.0E-4f);

    private static final float eaxDbToAmp(float eaxDb) {
        float dB = eaxDb / 2000.0f;
        return FastMath.pow(10.0f, dB);
    }

    public Environment() {
    }

    public Environment(Environment source) {
        this.airAbsorbGainHf = source.airAbsorbGainHf;
        this.roomRolloffFactor = source.roomRolloffFactor;
        this.decayTime = source.decayTime;
        this.decayHFRatio = source.decayHFRatio;
        this.density = source.density;
        this.diffusion = source.diffusion;
        this.gain = source.gain;
        this.gainHf = source.gainHf;
        this.lateReverbDelay = source.lateReverbDelay;
        this.lateReverbGain = source.lateReverbGain;
        this.reflectDelay = source.reflectDelay;
        this.reflectGain = source.reflectGain;
        this.decayHfLimit = source.decayHfLimit;
    }

    public Environment(float density, float diffusion, float gain, float gainHf, float decayTime, float decayHf, float reflGain, float reflDelay, float lateGain, float lateDelay) {
        this.decayTime = decayTime;
        this.decayHFRatio = decayHf;
        this.density = density;
        this.diffusion = diffusion;
        this.gain = gain;
        this.gainHf = gainHf;
        this.lateReverbDelay = lateDelay;
        this.lateReverbGain = lateGain;
        this.reflectDelay = reflDelay;
        this.reflectGain = reflGain;
    }

    public Environment(float[] e) {
        if (e.length != 28) {
            throw new IllegalArgumentException("Not an EAX preset");
        }
        this.diffusion = e[2];
        this.gain = Environment.eaxDbToAmp(e[3]);
        this.gainHf = Environment.eaxDbToAmp(e[4]) / Environment.eaxDbToAmp(e[5]);
        this.decayTime = e[6];
        this.decayHFRatio = e[7] / e[8];
        this.reflectGain = Environment.eaxDbToAmp(e[9]);
        this.reflectDelay = e[10];
        this.lateReverbGain = Environment.eaxDbToAmp(e[14]);
        this.lateReverbDelay = e[15];
        this.airAbsorbGainHf = Environment.eaxDbToAmp(e[23]);
        this.roomRolloffFactor = e[26];
    }

    public float getAirAbsorbGainHf() {
        return this.airAbsorbGainHf;
    }

    public void setAirAbsorbGainHf(float airAbsorbGainHf) {
        this.airAbsorbGainHf = airAbsorbGainHf;
    }

    public float getDecayHFRatio() {
        return this.decayHFRatio;
    }

    public void setDecayHFRatio(float decayHFRatio) {
        this.decayHFRatio = decayHFRatio;
    }

    public boolean isDecayHfLimit() {
        return this.decayHfLimit;
    }

    public void setDecayHfLimit(boolean decayHfLimit) {
        this.decayHfLimit = decayHfLimit;
    }

    public float getDecayTime() {
        return this.decayTime;
    }

    public void setDecayTime(float decayTime) {
        this.decayTime = decayTime;
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public float getDiffusion() {
        return this.diffusion;
    }

    public void setDiffusion(float diffusion) {
        this.diffusion = diffusion;
    }

    public float getGain() {
        return this.gain;
    }

    public void setGain(float gain) {
        this.gain = gain;
    }

    public float getGainHf() {
        return this.gainHf;
    }

    public void setGainHf(float gainHf) {
        this.gainHf = gainHf;
    }

    public float getLateReverbDelay() {
        return this.lateReverbDelay;
    }

    public void setLateReverbDelay(float lateReverbDelay) {
        this.lateReverbDelay = lateReverbDelay;
    }

    public float getLateReverbGain() {
        return this.lateReverbGain;
    }

    public void setLateReverbGain(float lateReverbGain) {
        this.lateReverbGain = lateReverbGain;
    }

    public float getReflectDelay() {
        return this.reflectDelay;
    }

    public void setReflectDelay(float reflectDelay) {
        this.reflectDelay = reflectDelay;
    }

    public float getReflectGain() {
        return this.reflectGain;
    }

    public void setReflectGain(float reflectGain) {
        this.reflectGain = reflectGain;
    }

    public float getRoomRolloffFactor() {
        return this.roomRolloffFactor;
    }

    public void setRoomRolloffFactor(float roomRolloffFactor) {
        this.roomRolloffFactor = roomRolloffFactor;
    }
}

