/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnimationTrack
extends AbstractCinematicEvent {
    private static final Logger log = Logger.getLogger(AnimationTrack.class.getName());
    protected AnimChannel channel;
    protected String animationName;
    protected String modelName;

    public AnimationTrack() {
    }

    public AnimationTrack(Spatial model, String animationName) {
        this.modelName = model.getName();
        this.animationName = animationName;
    }

    public AnimationTrack(Spatial model, String animationName, float initialDuration) {
        super(initialDuration);
        this.modelName = model.getName();
        this.animationName = animationName;
    }

    public AnimationTrack(Spatial model, String animationName, LoopMode loopMode) {
        super(loopMode);
        this.modelName = model.getName();
        this.animationName = animationName;
    }

    public AnimationTrack(Spatial model, String animationName, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.modelName = model.getName();
        this.animationName = animationName;
    }

    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        if (this.channel == null) {
            Object s = cinematic.getEventData("modelChannels", this.modelName);
            if (s != null && s instanceof AnimChannel) {
                this.channel = (AnimChannel)s;
            } else if (s == null) {
                Spatial model = cinematic.getScene().getChild(this.modelName);
                if (model != null) {
                    this.channel = model.getControl(AnimControl.class).createChannel();
                    cinematic.putEventData("modelChannels", this.modelName, this.channel);
                } else {
                    log.log(Level.WARNING, "spatial {0} not found in the scene, cannot perform animation", this.modelName);
                }
            }
        }
    }

    public void onPlay() {
        this.channel.getControl().setEnabled(true);
        if (this.playState == PlayState.Stopped) {
            this.channel.setAnim(this.animationName);
            this.channel.setSpeed(this.speed);
        }
    }

    public void onUpdate(float tpf) {
    }

    public void onStop() {
        this.channel.getControl().setEnabled(false);
        this.channel.setTime(0.0f);
    }

    public void onPause() {
        this.channel.getControl().setEnabled(false);
    }

    public void setLoopMode(LoopMode loopMode) {
        super.setLoopMode(loopMode);
        this.channel.setLoopMode(loopMode);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.modelName, "modelName", "");
        oc.write(this.animationName, "animationName", "");
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.modelName = ic.readString("modelName", "");
        this.animationName = ic.readString("animationName", "");
    }
}

