/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Skeleton;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.debug.SkeletonPoints;
import com.jme3.scene.debug.SkeletonWire;

public class SkeletonDebugger
extends Node {
    private SkeletonWire wires;
    private SkeletonPoints points;
    private Skeleton skeleton;

    public SkeletonDebugger(String name, Skeleton skeleton) {
        super(name);
        this.skeleton = skeleton;
        this.wires = new SkeletonWire(skeleton);
        this.points = new SkeletonPoints(skeleton);
        this.attachChild(new Geometry(name + "_wires", this.wires));
        this.attachChild(new Geometry(name + "_points", this.points));
        this.setQueueBucket(RenderQueue.Bucket.Transparent);
    }

    public SkeletonDebugger() {
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        this.wires.updateGeometry();
        this.points.updateGeometry();
    }

    public SkeletonPoints getPoints() {
        return this.points;
    }

    public SkeletonWire getWires() {
        return this.wires;
    }
}

