/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.VirtualTrack;
import com.jme3.util.TempVars;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationNode {
    private static final Logger LOGGER = Logger.getLogger(SimulationNode.class.getName());
    private String name;
    private List<SimulationNode> children = new ArrayList<SimulationNode>();
    private List<Constraint> constraints;
    private List<Animation> animations;
    private Spatial spatial;
    private Skeleton skeleton;
    private AnimControl animControl;
    private Transform spatialStartTransform;
    private Map<Bone, Transform> boneStartTransforms;

    public SimulationNode(Long featureOMA, BlenderContext blenderContext) {
        this(featureOMA, blenderContext, true);
    }

    private SimulationNode(Long featureOMA, BlenderContext blenderContext, boolean rootNode) {
        Node spatial = (Node)blenderContext.getLoadedFeature(featureOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (blenderContext.getMarkerValue("armature-node", spatial) != null) {
            this.skeleton = blenderContext.getSkeleton(featureOMA);
            Node nodeWithAnimationControl = blenderContext.getControlledNode(this.skeleton);
            this.animControl = nodeWithAnimationControl.getControl(AnimControl.class);
            this.boneStartTransforms = new HashMap<Bone, Transform>();
            for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
                Bone bone = this.skeleton.getBone(i);
                this.boneStartTransforms.put(bone, new Transform(bone.getWorldBindPosition(), bone.getWorldBindRotation(), bone.getWorldBindScale()));
            }
        } else {
            if (rootNode && spatial.getParent() != null) {
                throw new IllegalStateException("Given spatial must be a root node!");
            }
            this.spatial = spatial;
            this.spatialStartTransform = spatial.getLocalTransform().clone();
        }
        this.name = '>' + spatial.getName() + '<';
        this.constraints = this.findConstraints(featureOMA, blenderContext);
        if (this.constraints == null) {
            this.constraints = new ArrayList<Constraint>();
        }
        if (this.skeleton != null) {
            for (int i = 1; i < this.skeleton.getBoneCount(); ++i) {
                BoneContext boneContext = blenderContext.getBoneContext(this.skeleton.getBone(i));
                List<Constraint> boneConstraints = this.findConstraints(boneContext.getBoneOma(), blenderContext);
                if (boneConstraints == null) continue;
                this.constraints.addAll(boneConstraints);
            }
            BoneContext boneContext = blenderContext.getBoneContext(this.skeleton.getBone(1));
            Long boneOma = boneContext.getBoneOma();
            this.animations = blenderContext.getAnimData(boneOma) == null ? null : blenderContext.getAnimData((Long)boneOma).anims;
        } else {
            this.animations = blenderContext.getAnimData(featureOMA) == null ? null : blenderContext.getAnimData((Long)featureOMA).anims;
            for (Spatial child : spatial.getChildren()) {
                if (!(child instanceof Node)) continue;
                this.children.add(new SimulationNode((Long)blenderContext.getMarkerValue("oma", child), blenderContext, false));
            }
        }
        LOGGER.info("Removing invalid constraints.");
        ArrayList<Constraint> validConstraints = new ArrayList<Constraint>(this.constraints.size());
        for (Constraint constraint : this.constraints) {
            if (constraint.validate()) {
                validConstraints.add(constraint);
                continue;
            }
            LOGGER.log(Level.WARNING, "Constraint {0} is invalid and will not be applied.", constraint.name);
        }
        this.constraints = validConstraints;
    }

    public boolean contains(Constraint constraint) {
        boolean result = false;
        if (this.constraints != null && this.constraints.size() > 0) {
            for (Constraint c : this.constraints) {
                if (!c.equals(constraint)) continue;
                return true;
            }
        }
        return result;
    }

    private void reset() {
        if (this.spatial != null) {
            this.spatial.setLocalTransform(this.spatialStartTransform);
            for (SimulationNode child : this.children) {
                child.reset();
            }
        } else if (this.skeleton != null) {
            for (Map.Entry<Bone, Transform> entry : this.boneStartTransforms.entrySet()) {
                Transform t = entry.getValue();
                entry.getKey().setBindTransforms(t.getTranslation(), t.getRotation(), t.getScale());
            }
            this.skeleton.reset();
        }
    }

    private void simulateSpatial() {
        if (this.constraints != null && this.constraints.size() > 0) {
            boolean applyStaticConstraints = true;
            if (this.animations != null) {
                for (Animation animation : this.animations) {
                    float[] animationTimeBoundaries = this.computeAnimationTimeBoundaries(animation);
                    int maxFrame = (int)animationTimeBoundaries[0];
                    float maxTime = animationTimeBoundaries[1];
                    VirtualTrack vTrack = new VirtualTrack(maxFrame, maxTime);
                    for (Track track : animation.getTracks()) {
                        for (int frame = 0; frame < maxFrame; ++frame) {
                            this.spatial.setLocalTranslation(((SpatialTrack)track).getTranslations()[frame]);
                            this.spatial.setLocalRotation(((SpatialTrack)track).getRotations()[frame]);
                            this.spatial.setLocalScale(((SpatialTrack)track).getScales()[frame]);
                            for (Constraint constraint : this.constraints) {
                                constraint.apply(frame);
                                vTrack.setTransform(frame, this.spatial.getLocalTransform());
                            }
                        }
                        SpatialTrack newTrack = vTrack.getAsSpatialTrack();
                        if (newTrack != null) {
                            // empty if block
                        }
                        applyStaticConstraints = false;
                    }
                }
            }
            if (applyStaticConstraints) {
                for (Constraint constraint : this.constraints) {
                    constraint.apply(0);
                }
            }
        }
        for (SimulationNode child : this.children) {
            child.simulate();
        }
    }

    private void simulateSkeleton() {
        if (this.constraints != null && this.constraints.size() > 0) {
            boolean applyStaticConstraints = true;
            if (this.animations != null) {
                TempVars vars = TempVars.get();
                AnimChannel animChannel = this.animControl.createChannel();
                for (Animation animation : this.animations) {
                    float[] animationTimeBoundaries = this.computeAnimationTimeBoundaries(animation);
                    int maxFrame = (int)animationTimeBoundaries[0];
                    float maxTime = animationTimeBoundaries[1];
                    HashMap<Integer, VirtualTrack> tracks = new HashMap<Integer, VirtualTrack>();
                    HashMap<Integer, Transform> previousTransforms = new HashMap<Integer, Transform>();
                    for (int frame = 0; frame < maxFrame; ++frame) {
                        Transform previousTransform;
                        this.reset();
                        for (Track track : animation.getTracks()) {
                            float time = ((BoneTrack)track).getTimes()[frame];
                            Integer boneIndex = ((BoneTrack)track).getTargetBoneIndex();
                            track.setTime(time, 1.0f, this.animControl, animChannel, vars);
                            this.skeleton.updateWorldVectors();
                            previousTransform = (Transform)previousTransforms.get(boneIndex);
                            if (previousTransform != null) continue;
                            Bone bone = this.skeleton.getBone(boneIndex);
                            previousTransform = new Transform();
                            previousTransform.setTranslation(bone.getLocalPosition());
                            previousTransform.setRotation(bone.getLocalRotation());
                            previousTransform.setScale(bone.getLocalScale());
                            previousTransforms.put(boneIndex, previousTransform);
                        }
                        for (Constraint constraint : this.constraints) {
                            constraint.apply(frame);
                        }
                        for (Track track : animation.getTracks()) {
                            Integer boneIndex = ((BoneTrack)track).getTargetBoneIndex();
                            Bone bone = this.skeleton.getBone(boneIndex);
                            previousTransform = (Transform)previousTransforms.get(boneIndex);
                            VirtualTrack vTrack = (VirtualTrack)tracks.get(boneIndex);
                            if (vTrack == null) {
                                vTrack = new VirtualTrack(maxFrame, maxTime);
                                tracks.put(boneIndex, vTrack);
                            }
                            Vector3f bonePositionDifference = bone.getLocalPosition().subtract(previousTransform.getTranslation());
                            Quaternion boneRotationDifference = bone.getLocalRotation().mult(previousTransform.getRotation().inverse()).normalizeLocal();
                            Vector3f boneScaleDifference = bone.getLocalScale().divide(previousTransform.getScale());
                            if (frame > 0) {
                                bonePositionDifference = vTrack.translations.get(frame - 1).add(bonePositionDifference);
                                boneRotationDifference = vTrack.rotations.get(frame - 1).mult(boneRotationDifference);
                                boneScaleDifference = vTrack.scales.get(frame - 1).mult(boneScaleDifference);
                            }
                            vTrack.setTransform(frame, new Transform(bonePositionDifference, boneRotationDifference, boneScaleDifference));
                            previousTransform.setTranslation(bone.getLocalPosition());
                            previousTransform.setRotation(bone.getLocalRotation());
                            previousTransform.setScale(bone.getLocalScale());
                        }
                    }
                    for (Map.Entry trackEntry : tracks.entrySet()) {
                        BoneTrack newTrack = ((VirtualTrack)trackEntry.getValue()).getAsBoneTrack((Integer)trackEntry.getKey());
                        if (newTrack != null) {
                            for (Track track : animation.getTracks()) {
                                if (((BoneTrack)track).getTargetBoneIndex() == ((Integer)trackEntry.getKey()).intValue()) break;
                            }
                        }
                        applyStaticConstraints = false;
                    }
                }
                vars.release();
                this.animControl.clearChannels();
                this.reset();
            }
            if (applyStaticConstraints) {
                for (Constraint constraint : this.constraints) {
                    constraint.apply(0);
                }
            }
        }
    }

    public void simulate() {
        this.reset();
        if (this.spatial != null) {
            this.simulateSpatial();
        } else {
            this.simulateSkeleton();
        }
        this.reset();
    }

    private float[] computeAnimationTimeBoundaries(Animation animation) {
        int maxFrame = Integer.MIN_VALUE;
        float maxTime = Float.MIN_VALUE;
        for (Track track : animation.getTracks()) {
            if (track instanceof BoneTrack) {
                maxFrame = Math.max(maxFrame, ((BoneTrack)track).getTranslations().length);
                maxTime = Math.max(maxTime, ((BoneTrack)track).getTimes()[((BoneTrack)track).getTimes().length - 1]);
                continue;
            }
            if (track instanceof SpatialTrack) {
                maxFrame = Math.max(maxFrame, ((SpatialTrack)track).getTranslations().length);
                maxTime = Math.max(maxTime, ((SpatialTrack)track).getTimes()[((SpatialTrack)track).getTimes().length - 1]);
                continue;
            }
            throw new IllegalStateException("Unsupported track type for simuation: " + track);
        }
        return new float[]{maxFrame, maxTime};
    }

    private List<Constraint> findConstraints(Long ownerOMA, BlenderContext blenderContext) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : blenderContext.getAllConstraints()) {
            if (constraint.ownerOMA.longValue() != ownerOMA.longValue()) continue;
            if (constraint.isImplemented()) {
                result.add(constraint);
                continue;
            }
            LOGGER.log(Level.WARNING, "Constraint named: ''{0}'' of type ''{1}'' is not implemented and will NOT be applied!", new Object[]{constraint.name, constraint.getConstraintTypeName()});
        }
        return result.size() > 0 ? result : null;
    }

    public String toString() {
        return this.name;
    }
}

