/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.ArmatureModifier;
import com.jme3.scene.plugins.blender.modifiers.ArrayModifier;
import com.jme3.scene.plugins.blender.modifiers.MirrorModifier;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.modifiers.ObjectAnimationModifier;
import com.jme3.scene.plugins.blender.modifiers.ParticlesModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ModifierHelper.class.getName());

    public ModifierHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public Collection<Modifier> readModifiers(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        HashSet<String> alreadyReadModifiers = new HashSet<String>();
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        Structure modifiersListBase = (Structure)objectStructure.getFieldValue("modifiers");
        List<Structure> modifiers = modifiersListBase.evaluateListBase(blenderContext);
        for (Structure modifierStructure : modifiers) {
            String modifierType = modifierStructure.getType();
            if (!Modifier.canBeAppliedMultipleTimes(modifierType) && alreadyReadModifiers.contains(modifierType)) {
                LOGGER.log(Level.WARNING, "Modifier {0} can only be applied once to object: {1}", new Object[]{modifierType, objectStructure.getName()});
                continue;
            }
            Modifier modifier = null;
            if ("ArrayModifierData".equals(modifierStructure.getType())) {
                modifier = new ArrayModifier(modifierStructure, blenderContext);
            } else if ("MirrorModifierData".equals(modifierStructure.getType())) {
                modifier = new MirrorModifier(modifierStructure, blenderContext);
            } else if ("ArmatureModifierData".equals(modifierStructure.getType())) {
                modifier = new ArmatureModifier(objectStructure, modifierStructure, blenderContext);
            } else if ("ParticleSystemModifierData".equals(modifierStructure.getType())) {
                modifier = new ParticlesModifier(modifierStructure, blenderContext);
            }
            if (modifier != null) {
                if (modifier.isModifying()) {
                    result.add(modifier);
                    alreadyReadModifiers.add(modifierType);
                    continue;
                }
                LOGGER.log(Level.WARNING, "The modifier {0} will cause no changes in the model. It will be ignored!", modifierStructure.getName());
                continue;
            }
            LOGGER.log(Level.WARNING, "Unsupported modifier type: {0}", modifierStructure.getType());
        }
        Modifier modifier = this.blenderVersion <= 249 ? this.readAnimationModifier249(objectStructure, blenderContext) : this.readAnimationModifier250(objectStructure, blenderContext);
        if (modifier != null) {
            result.add(modifier);
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }

    private Modifier readAnimationModifier249(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        Structure ipoStructure;
        IpoHelper ipoHelper;
        Ipo ipo;
        ObjectAnimationModifier result = null;
        Pointer pIpo = (Pointer)objectStructure.getFieldValue("ipo");
        if (pIpo.isNotNull() && (ipo = (ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class)).fromIpoStructure(ipoStructure = pIpo.fetchData(blenderContext.getInputStream()).get(0), blenderContext)) != null) {
            result = new ObjectAnimationModifier(ipo, objectStructure.getName(), objectStructure.getOldMemoryAddress(), blenderContext);
        }
        return result;
    }

    private Modifier readAnimationModifier250(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        Structure animData;
        Pointer pAction;
        ObjectAnimationModifier result = null;
        Pointer pAnimData = (Pointer)objectStructure.getFieldValue("adt");
        if (pAnimData.isNotNull() && (pAction = (Pointer)(animData = pAnimData.fetchData(blenderContext.getInputStream()).get(0)).getFieldValue("action")).isNotNull()) {
            Structure actionStructure = pAction.fetchData(blenderContext.getInputStream()).get(0);
            IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
            Ipo ipo = ipoHelper.fromAction(actionStructure, blenderContext);
            if (ipo != null) {
                result = new ObjectAnimationModifier(ipo, actionStructure.getName(), objectStructure.getOldMemoryAddress(), blenderContext);
            }
        }
        return result;
    }
}

