/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.AppSettings;
import com.jme3.system.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Natives {
    private static final Logger logger = Logger.getLogger(Natives.class.getName());
    private static final byte[] buf = new byte[1024];
    private static File workingDir = new File("").getAbsoluteFile();

    public static void setExtractionDir(String name) {
        workingDir = new File(name).getAbsoluteFile();
    }

    protected static void extractNativeLib(String sysName, String name) throws IOException {
        Natives.extractNativeLib(sysName, name, false, true);
    }

    protected static void extractNativeLib(String sysName, String name, boolean load) throws IOException {
        Natives.extractNativeLib(sysName, name, load, true);
    }

    protected static void extractNativeLib(String sysName, String name, boolean load, boolean warning) throws IOException {
        long sourceLastModified;
        long targetLastModified;
        String fullname = System.mapLibraryName(name);
        String path = "native/" + sysName + "/" + fullname;
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null) {
            if (!warning) {
                logger.log(Level.WARNING, "Cannot locate native library: {0}/{1}", new String[]{sysName, fullname});
            }
            return;
        }
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        File targetFile = new File(workingDir, fullname);
        if (targetFile.exists() && (targetLastModified = targetFile.lastModified()) + 1000L > (sourceLastModified = conn.getLastModified())) {
            logger.log(Level.FINE, "Not copying library {0}. Latest already extracted.", fullname);
        }
        try {
            int len;
            FileOutputStream out = new FileOutputStream(targetFile);
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            targetFile.setLastModified(conn.getLastModified());
        }
        catch (FileNotFoundException ex) {
            if (ex.getMessage().contains("used by another process")) {
                return;
            }
            throw ex;
        }
        finally {
            if (load) {
                logger.log(Level.INFO, "Load native library {0}", targetFile.getAbsolutePath());
                System.load(targetFile.getAbsolutePath());
            }
        }
        logger.log(Level.FINE, "Copied {0} to {1}", new Object[]{fullname, targetFile});
    }

    private static String getExtractionDir() {
        URL temp = Natives.class.getResource("");
        if (temp != null) {
            StringBuilder sb = new StringBuilder(temp.toString());
            if (sb.indexOf("jar:") == 0) {
                sb.delete(0, 4);
                sb.delete(sb.indexOf("!"), sb.length());
                sb.delete(sb.lastIndexOf("/") + 1, sb.length());
            }
            try {
                return new URL(sb.toString()).toString();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    protected static boolean isUsingNativeBullet() {
        try {
            Class<?> clazz = Class.forName("com.jme3.bullet.util.NativeMeshUtil");
            return clazz != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    protected static void extractNativeLibs(Platform platform, AppSettings settings) throws IOException {
        String renderer = settings.getRenderer();
        String audioRenderer = settings.getAudioRenderer();
        boolean needLWJGL = false;
        boolean needOAL = false;
        boolean needJInput = false;
        boolean needNativeBullet = Natives.isUsingNativeBullet();
        if (renderer != null && renderer.startsWith("LWJGL")) {
            needLWJGL = true;
        }
        if (audioRenderer != null && audioRenderer.equals("LWJGL")) {
            needLWJGL = true;
            needOAL = true;
        }
        needJInput = settings.useJoysticks();
        if (needLWJGL) {
            logger.log(Level.INFO, "Extraction Directory #1: {0}", Natives.getExtractionDir());
            logger.log(Level.INFO, "Extraction Directory #2: {0}", workingDir.toString());
            System.setProperty("org.lwjgl.librarypath", workingDir.toString());
        }
        switch (platform) {
            case Windows64: {
                if (needLWJGL) {
                    Natives.extractNativeLib("windows", "lwjgl64");
                }
                if (needOAL) {
                    Natives.extractNativeLib("windows", "OpenAL64");
                }
                if (needJInput) {
                    Natives.extractNativeLib("windows", "jinput-dx8_64");
                    Natives.extractNativeLib("windows", "jinput-raw_64");
                }
                if (!needNativeBullet) break;
                Natives.extractNativeLib("windows", "bulletjme64", true, false);
                break;
            }
            case Windows32: {
                if (needLWJGL) {
                    Natives.extractNativeLib("windows", "lwjgl");
                }
                if (needOAL) {
                    Natives.extractNativeLib("windows", "OpenAL32");
                }
                if (needJInput) {
                    Natives.extractNativeLib("windows", "jinput-dx8");
                    Natives.extractNativeLib("windows", "jinput-raw");
                }
                if (!needNativeBullet) break;
                Natives.extractNativeLib("windows", "bulletjme", true, false);
                break;
            }
            case Linux64: {
                if (needLWJGL) {
                    Natives.extractNativeLib("linux", "lwjgl64");
                }
                if (needJInput) {
                    Natives.extractNativeLib("linux", "jinput-linux64");
                }
                if (needOAL) {
                    Natives.extractNativeLib("linux", "openal64");
                }
                if (!needNativeBullet) break;
                Natives.extractNativeLib("linux", "bulletjme64", true, false);
                break;
            }
            case Linux32: {
                if (needLWJGL) {
                    Natives.extractNativeLib("linux", "lwjgl");
                }
                if (needJInput) {
                    Natives.extractNativeLib("linux", "jinput-linux");
                }
                if (needOAL) {
                    Natives.extractNativeLib("linux", "openal");
                }
                if (!needNativeBullet) break;
                Natives.extractNativeLib("linux", "bulletjme", true, false);
                break;
            }
            case SolarisAMD64: {
                if (needLWJGL) {
                    Natives.extractNativeLib("solaris", "lwjgl64");
                }
                if (needOAL) {
                    Natives.extractNativeLib("solaris", "openal64");
                }
                if (!needNativeBullet) break;
                Natives.extractNativeLib("solaris", "bulletjme64", true, false);
                break;
            }
            case SolarisX86: {
                if (needLWJGL) {
                    Natives.extractNativeLib("solaris", "lwjgl");
                }
                if (needOAL) {
                    Natives.extractNativeLib("solaris", "openal");
                }
                if (!needNativeBullet) break;
                Natives.extractNativeLib("solaris", "bulletjme", true, false);
                break;
            }
            case MacOSX_PPC32: 
            case MacOSX32: 
            case MacOSX_PPC64: 
            case MacOSX64: {
                if (needLWJGL) {
                    Natives.extractNativeLib("macosx", "lwjgl");
                }
                if (needJInput) {
                    Natives.extractNativeLib("macosx", "jinput-osx");
                }
                if (!needNativeBullet) break;
                Natives.extractNativeLib("macosx", "bulletjme", true, false);
            }
        }
    }
}

