/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.lodcalc.LodThreshold;
import java.io.IOException;

public class SimpleLodThreshold
implements LodThreshold {
    private int size;
    private float lodMultiplier = 2.0f;

    public SimpleLodThreshold() {
    }

    public SimpleLodThreshold(Terrain terrain) {
        if (terrain instanceof TerrainQuad) {
            this.size = ((TerrainQuad)terrain).getPatchSize();
        }
    }

    public SimpleLodThreshold(int patchSize, float lodMultiplier) {
        this.size = patchSize;
    }

    public float getLodMultiplier() {
        return this.lodMultiplier;
    }

    public void setLodMultiplier(float lodMultiplier) {
        this.lodMultiplier = lodMultiplier;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public float getLodDistanceThreshold() {
        return (float)this.size * this.lodMultiplier;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.size, "size", 16);
        oc.write(this.lodMultiplier, "lodMultiplier", 2.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.size = ic.readInt("size", 16);
        this.lodMultiplier = ic.readInt("lodMultiplier", 2);
    }

    public LodThreshold clone() {
        SimpleLodThreshold clone = new SimpleLodThreshold();
        clone.size = this.size;
        clone.lodMultiplier = this.lodMultiplier;
        return clone;
    }

    public String toString() {
        return "SimpleLodThreshold " + this.size + ", " + this.lodMultiplier;
    }
}

