/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.Image;
import java.io.IOException;
import java.util.ArrayList;

public class BloomFilter
extends Filter {
    private GlowMode glowMode = GlowMode.Scene;
    private float blurScale = 1.5f;
    private float exposurePower = 5.0f;
    private float exposureCutOff = 0.0f;
    private float bloomIntensity = 2.0f;
    private float downSamplingFactor = 1.0f;
    private Filter.Pass preGlowPass;
    private Filter.Pass extractPass;
    private Filter.Pass horizontalBlur = new Filter.Pass();
    private Filter.Pass verticalalBlur = new Filter.Pass();
    private Material extractMat;
    private Material vBlurMat;
    private Material hBlurMat;
    private int screenWidth;
    private int screenHeight;
    private RenderManager renderManager;
    private ViewPort viewPort;

    public BloomFilter() {
        super("BloomFilter");
    }

    public BloomFilter(GlowMode glowMode) {
        this();
        this.glowMode = glowMode;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.renderManager = renderManager;
        this.viewPort = vp;
        this.screenWidth = (int)Math.max(1.0f, (float)w / this.downSamplingFactor);
        this.screenHeight = (int)Math.max(1.0f, (float)h / this.downSamplingFactor);
        if (this.glowMode != GlowMode.Scene) {
            this.preGlowPass = new Filter.Pass();
            this.preGlowPass.init(renderManager.getRenderer(), this.screenWidth, this.screenHeight, Image.Format.RGBA8, Image.Format.Depth);
        }
        this.postRenderPasses = new ArrayList();
        this.extractMat = new Material(manager, "Common/MatDefs/Post/BloomExtract.j3md");
        this.extractPass = new Filter.Pass(){

            public boolean requiresSceneAsTexture() {
                return true;
            }

            public void beforeRender() {
                BloomFilter.this.extractMat.setFloat("ExposurePow", BloomFilter.this.exposurePower);
                BloomFilter.this.extractMat.setFloat("ExposureCutoff", BloomFilter.this.exposureCutOff);
                if (BloomFilter.this.glowMode != GlowMode.Scene) {
                    BloomFilter.this.extractMat.setTexture("GlowMap", BloomFilter.this.preGlowPass.getRenderedTexture());
                }
                BloomFilter.this.extractMat.setBoolean("Extract", BloomFilter.this.glowMode != GlowMode.Objects);
            }
        };
        this.extractPass.init(renderManager.getRenderer(), this.screenWidth, this.screenHeight, Image.Format.RGBA8, Image.Format.Depth, 1, this.extractMat);
        this.postRenderPasses.add(this.extractPass);
        this.hBlurMat = new Material(manager, "Common/MatDefs/Blur/HGaussianBlur.j3md");
        this.horizontalBlur = new Filter.Pass(){

            public void beforeRender() {
                BloomFilter.this.hBlurMat.setTexture("Texture", BloomFilter.this.extractPass.getRenderedTexture());
                BloomFilter.this.hBlurMat.setFloat("Size", BloomFilter.this.screenWidth);
                BloomFilter.this.hBlurMat.setFloat("Scale", BloomFilter.this.blurScale);
            }
        };
        this.horizontalBlur.init(renderManager.getRenderer(), this.screenWidth, this.screenHeight, Image.Format.RGBA8, Image.Format.Depth, 1, this.hBlurMat);
        this.postRenderPasses.add(this.horizontalBlur);
        this.vBlurMat = new Material(manager, "Common/MatDefs/Blur/VGaussianBlur.j3md");
        this.verticalalBlur = new Filter.Pass(){

            public void beforeRender() {
                BloomFilter.this.vBlurMat.setTexture("Texture", BloomFilter.this.horizontalBlur.getRenderedTexture());
                BloomFilter.this.vBlurMat.setFloat("Size", BloomFilter.this.screenHeight);
                BloomFilter.this.vBlurMat.setFloat("Scale", BloomFilter.this.blurScale);
            }
        };
        this.verticalalBlur.init(renderManager.getRenderer(), this.screenWidth, this.screenHeight, Image.Format.RGBA8, Image.Format.Depth, 1, this.vBlurMat);
        this.postRenderPasses.add(this.verticalalBlur);
        this.material = new Material(manager, "Common/MatDefs/Post/BloomFinal.j3md");
        this.material.setTexture("BloomTex", this.verticalalBlur.getRenderedTexture());
    }

    protected Material getMaterial() {
        this.material.setFloat("BloomIntensity", this.bloomIntensity);
        return this.material;
    }

    protected void postQueue(RenderQueue queue) {
        if (this.glowMode != GlowMode.Scene) {
            this.renderManager.getRenderer().setBackgroundColor(ColorRGBA.BlackNoAlpha);
            this.renderManager.getRenderer().setFrameBuffer(this.preGlowPass.getRenderFrameBuffer());
            this.renderManager.getRenderer().clearBuffers(true, true, true);
            this.renderManager.setForcedTechnique("Glow");
            this.renderManager.renderViewPortQueues(this.viewPort, false);
            this.renderManager.setForcedTechnique(null);
            this.renderManager.getRenderer().setFrameBuffer(this.viewPort.getOutputFrameBuffer());
        }
    }

    public float getBloomIntensity() {
        return this.bloomIntensity;
    }

    public void setBloomIntensity(float bloomIntensity) {
        this.bloomIntensity = bloomIntensity;
    }

    public float getBlurScale() {
        return this.blurScale;
    }

    public void setBlurScale(float blurScale) {
        this.blurScale = blurScale;
    }

    public float getExposureCutOff() {
        return this.exposureCutOff;
    }

    public void setExposureCutOff(float exposureCutOff) {
        this.exposureCutOff = exposureCutOff;
    }

    public float getExposurePower() {
        return this.exposurePower;
    }

    public void setExposurePower(float exposurePower) {
        this.exposurePower = exposurePower;
    }

    public float getDownSamplingFactor() {
        return this.downSamplingFactor;
    }

    public void setDownSamplingFactor(float downSamplingFactor) {
        this.downSamplingFactor = downSamplingFactor;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.glowMode, "glowMode", GlowMode.Scene);
        oc.write(this.blurScale, "blurScale", 1.5f);
        oc.write(this.exposurePower, "exposurePower", 5.0f);
        oc.write(this.exposureCutOff, "exposureCutOff", 0.0f);
        oc.write(this.bloomIntensity, "bloomIntensity", 2.0f);
        oc.write(this.downSamplingFactor, "downSamplingFactor", 1.0f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.glowMode = ic.readEnum("glowMode", GlowMode.class, GlowMode.Scene);
        this.blurScale = ic.readFloat("blurScale", 1.5f);
        this.exposurePower = ic.readFloat("exposurePower", 5.0f);
        this.exposureCutOff = ic.readFloat("exposureCutOff", 0.0f);
        this.bloomIntensity = ic.readFloat("bloomIntensity", 2.0f);
        this.downSamplingFactor = ic.readFloat("downSamplingFactor", 1.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowMode {
        Scene,
        Objects,
        SceneAndObjects;

    }
}

