/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;

public abstract class Modifier {
    public static final String ARRAY_MODIFIER_DATA = "ArrayModifierData";
    public static final String ARMATURE_MODIFIER_DATA = "ArmatureModifierData";
    public static final String PARTICLE_MODIFIER_DATA = "ParticleSystemModifierData";
    public static final String MIRROR_MODIFIER_DATA = "MirrorModifierData";
    public static final String SUBSURF_MODIFIER_DATA = "SubsurfModifierData";
    public static final String OBJECT_ANIMATION_MODIFIER_DATA = "ObjectAnimationModifierData";
    protected boolean invalid;
    protected boolean modifying = true;

    public abstract Node apply(Node var1, BlenderContext var2);

    public static boolean canBeAppliedMultipleTimes(String modifierType) {
        return !ARMATURE_MODIFIER_DATA.equals(modifierType) && !OBJECT_ANIMATION_MODIFIER_DATA.equals(modifierType);
    }

    protected boolean validate(Structure modifierStructure, BlenderContext blenderContext) {
        Structure modifierData = (Structure)modifierStructure.getFieldValue("modifier");
        Pointer pError = (Pointer)modifierData.getFieldValue("error");
        this.invalid = pError.isNotNull();
        return !this.invalid;
    }

    public boolean isModifying() {
        return this.modifying;
    }
}

