/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.system.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.Sys;

public class LwjglTimer
extends Timer {
    private static final Logger logger = Logger.getLogger(LwjglTimer.class.getName());
    private long oldTime;
    private long startTime;
    private float lastTPF;
    private float lastFPS;
    private static final long LWJGL_TIMER_RES = Sys.getTimerResolution();
    private static final float INV_LWJGL_TIMER_RES = 1.0f / (float)LWJGL_TIMER_RES;
    public static final long LWJGL_TIME_TO_NANOS = 1000000000L / LWJGL_TIMER_RES;

    public LwjglTimer() {
        this.reset();
        logger.log(Level.INFO, "Timer resolution: {0} ticks per second", LWJGL_TIMER_RES);
    }

    public void reset() {
        this.startTime = Sys.getTime();
        this.oldTime = this.getTime();
    }

    public float getTimeInSeconds() {
        return (float)this.getTime() * INV_LWJGL_TIMER_RES;
    }

    public long getTime() {
        return Sys.getTime() - this.startTime;
    }

    public long getResolution() {
        return LWJGL_TIMER_RES;
    }

    public float getFrameRate() {
        return this.lastFPS;
    }

    public float getTimePerFrame() {
        return this.lastTPF;
    }

    public void update() {
        long curTime = this.getTime();
        this.lastTPF = (float)(curTime - this.oldTime) * (1.0f / (float)LWJGL_TIMER_RES);
        this.lastFPS = 1.0f / this.lastTPF;
        this.oldTime = curTime;
    }

    public String toString() {
        String string2 = super.toString();
        string2 = string2 + "\nTime: " + this.oldTime;
        string2 = string2 + "\nFPS: " + this.getFrameRate();
        return string2;
    }
}

