/**
 * httpdサーバのサンプルです。
 * ROMにある定義済みファイルの入出力と、クロスドメインRESTが確認できます。
 */
#define SKETCH_STACK_SIZE (512+256)
#include "boot/sketch.h"

#include "NyLPC_net.h"
#include "NyLPC_http.h"
#include "NyLPC_utils.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"
#include <stdio.h>
#include <string.h>
/**
 * httpcl test
 */
const struct NyLPC_TiNetInterface_Interface* netif;
NyLPC_TcHttpClient_t http;
NyLPC_TcNetConfig_t c2;
struct NyLPC_TIPv4Addr client_addr;
char buf[512];
char buftx[512];
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	netif=NyLPC_cMiMicIpNetIf_getNetInterface();
	NyLPC_cNet_initialize(netif);
	NyLPC_cHttpClient_initialize(&http,buf,512);
}


void loop(void)
{
	NyLPC_TChar rx[16];
	NyLPC_TInt16 rs;
	NyLPC_TIPv4Addr_set(&client_addr,192,168,128,196);

	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNetConfig_setIpAddr(&c2,192,168,128,39);
	NyLPC_cNetConfig_setGateway(&c2,192,168,128,254);
	NyLPC_cNet_start(&(c2.super));

	for(;;)
	{
/*		//check get method
		printf("CONNECT\n");
		if(NyLPC_cHttpClient_connect(&http,&client_addr,80)){
			if(NyLPC_cHttpClient_sendMethod(
					&http,NyLPC_THttpMethodType_GET,"/mimic/a.php",0,"",NULL)){
			}
			s=NyLPC_cHttpClient_getStatus(&http);
			do{
				if(NyLPC_cHttpClient_read(&http,rx,16,&rs)){
					printf("%.*s",rx,rs);
				}else{
					printf("ERROR!");
				}
			}while(rs>0);
			NyLPC_cHttpClient_close(&http);
		}
		printf("DONE\n");
*/
//check get method
	printf("CONNECT\n");
	if(NyLPC_cHttpClient_connect(&http,&client_addr,80)){
		if(NyLPC_cHttpClient_sendMethod(
				&http,NyLPC_THttpMethodType_POST,"/mimic/a.php",0xffffffff,"text/plain",NULL)){
			if(!NyLPC_cHttpClient_write(&http,"0123456789",10)){
				break;
			}
			if(!NyLPC_cHttpClient_write(&http,"0123456789",10)){
				break;
			}
			NyLPC_cHttpClient_getStatus(&http);
			do{
				if(NyLPC_cHttpClient_read(&http,rx,16,&rs)){
					printf("%.*s",rx,rs);
				}else{
					printf("ERROR!");
				}
			}while(rs>0);
		}
		NyLPC_cHttpClient_close(&http);
		NyLPC_cThread_sleep(1000);
	}
	printf("DONE\n");
	}
}


