/**
 * POSTリクエスト受信サンプルです。
 * 受信したPOSTリクエストをエコーバックします。
 */
#include "boot/sketch.h"
#include "NyLPC_net.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"
#include "NyLPC_http.h"
#include "NyLPC_utils.h"


const struct NyLPC_TiNetInterface_Interface* netif;
struct MyHttpd{
	NyLPC_TcHttpd_t super;
}httpd;

#define NUM_OF_FSDATA 4
extern struct NyLPC_TRomFileData fsdata[];


void handler(NyLPC_TcHttpdConnection_t* i_connection)
{
	NyLPC_TcModUrl_t mod;
	char url[64];
	int l;


	//SHORT URL
	NyLPC_cModUrl_initialize(&mod);
	if(!NyLPC_cModUrl_execute(&mod,i_connection,url,64)){
		NyLPC_cModUrl_finalize(&mod);
		return;
	}
	if(NyLPC_cModUrl_getMethod(&mod)==NyLPC_THttpMethodType_POST){
		NyLPC_cHttpdConnection_sendResponseHeader(i_connection,200,"text/html",NULL);
		NyLPC_cHttpdConnection_sendResponseBodyF(i_connection,"<html><h1>Your post message</h1><textarea>");
		//NyLPC_TInt16 NyLPC_cModUrl_readBody(NyLPC_TcModUrl_t* i_inst,NyLPC_TcHttpdConnection_t* i_connection,void* i_buf,NyLPC_TInt16 i_buf_size)
		l=NyLPC_cModUrl_readBody(&mod,i_connection,url,10);
		while(l>0){
			NyLPC_cHttpdConnection_sendResponseBody(i_connection,url,l);
			l=NyLPC_cModUrl_readBody(&mod,i_connection,url,10);
		}
		NyLPC_cHttpdConnection_sendResponseBodyF(i_connection,"</textarea></html>");
		NyLPC_cModUrl_finalize(&mod);
	}
	return;
}
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	NyLPC_cNet_initialize(&net);

	NyLPC_cHttpd_initialize(&httpd.super,80);
	httpd.super.function.onRequest=handler;

}


void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	//192.168.0.39
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNetConfig_setIpAddr(&c2,192,168,128,39);
	NyLPC_cNetConfig_setGateway(&c2,192,168,128,254);
	NyLPC_cNet_start(&net,&c2);
	NyLPC_cHttpd_loop(&httpd.super);
	for(;;);
}


