/******************************************************************************/
/* src/kernel/InitCtrl/InitCtrlInit.c                                         */
/*                                                                 2017/03/18 */
/* Copyright (C) 2016-2017 Mochi.                                             */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 共通ヘッダ */
#include <stdarg.h>
#include <kernel/MochiKernel.h>
#include <hardware/IA32/IA32Instruction.h>

/* 外部モジュールヘッダ */
#include <Cmn.h>
#include <Debug.h>
#include <IntMng.h>
#include <MemMng.h>
#include <ProcMng.h>
#include <TimerMng.h>

/* 内部モジュールヘッダ */


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/* デバッグトレースログ出力マクロ */
#ifdef DEBUG_LOG_ENABLE
#define DEBUG_LOG( ... )                    \
    DebugLogOutput( CMN_MODULE_INIT_INIT,   \
                    __LINE__,               \
                    __VA_ARGS__ )
#else
#define DEBUG_LOG( ... )
#endif


/******************************************************************************/
/* グローバル関数定義                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       Mochi Kernel起動
 * @details     Mochi Kernelのエントリ関数。各モジュールの初期化を行う。
 */
/******************************************************************************/
void InitCtrlInit( void )
{
    /* [TODO]カーネル起動引数対応まで仮 */
    MochiKernelMemoryMap_t map = {
        ( void * ) 0x03000000,
        0x500000,
        MOCHIKERNEL_MEMORY_TYPE_AVAILABLE };
    
    /* デバッグ制御初期化 */
    DebugInit();
    
    /* デバッグトレースログ出力 */
    DEBUG_LOG( "Mochi Kernel start!!!" );
    
    /* メモリ管理モジュール初期化 */
    MemMngInit( &map, 1 );
    
    /* プロセス管理モジュール初期化 */
    ProcMngInit();
    
    /* 割込み管理モジュール初期化 */
    IntMngInit();
    
    /* タイマ管理モジュール初期化 */
    TimerMngInit();
    
    /* 割込み有効化 */
    IntMngPicEnable();
    IA32InstructionSti();
    
    /* デバッグトレースログ出力 */
    DEBUG_LOG( "Idle running." );
    
    /* アイドル（仮） */
    while ( 1 ) {
        /* hlt */
        IA32InstructionHlt();
    }
    
    /* not retern */
}


/******************************************************************************/
