/**
 * @file AnnotationElement
 * @brief Annotation Element Control
 *
 * @author M.Fukuda
 * @date 2013.03.08
 *
 * Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
 */

#pragma once

#include <string>
#include <vector>

// -- Forward declaration --
namespace kome {
	namespace objects {
		class Spectrum;
	}
}

// -----
namespace kome {
namespace massbank {
namespace wizard {

const double kPPMVal = 0.0000001;

class AnnotationElement {

	struct AnnoElem {
		double mz,rt,prc;
		double lmz,hmz,lrt,hrt,lprc,hprc;
		int nCnt; // JE^BY邽тɃCNgB
		std::string sType,sFormula;
		AnnoElem() {
			mz = lmz = hmz = -1.0;
			rt = prc = -1.0;
			lrt = lprc = -1.0;    // nega infinity
			hrt = hprc = DBL_MAX; // true infinity
			nCnt = 0;
		}
	};
public:
	// constructor
	AnnotationElement(){}
	// destructor
	~AnnotationElement(){}

	// StringƂăAme[V擾AB
	// checkonly (T/F) T : ͋K̃`FbN / F : `FbNʂo^B
	const bool getSplitAnnoInfo(
		const std::string& src, 
		const bool checkonly
		);

	// mz̔zART, Precursor Ƃ
	// ̃Ame[Vƈv邩ۂׂB
	// checkonly (T/F) T : YAme[V̗L𒲂ׂB/ F {MassBankRecordƂďo͂𓾂B
	const std::string checkFitAnnoInfo(
		const std::vector<double>& mzArr,
		const double rt, 
		const double prc, 
		const bool checkonly
		);

	// SpectraAAnnotationK
	void doSpectrumFitAnnotation(const std::vector<kome::objects::Spectrum*>& specArr);

	// gȂAme[V邩ǂׂB
	// ꍇ͏JB₢킹B
	const bool isNotUseAnnotationElements();

private:

	// JE^NAB
	void onClearCnt();
	// Ame[V(Formulaj̕𐶐ĕԂB
	const std::string onGetAnnotationBlock(
		const double rt, 
		const AnnoElem& elm
		);

	// dstL = src - tol, dstH = src + tol ƂĕԂBppm = true tolPPM̗vfƂĈB
	void toTolval(
		const double src, 
		const double _tol, 
		double& dstL, 
		double& dstC, 
		double& dstH, 
		bool ppm = false
		);

	const std::string onNotUsedInfo(const AnnoElem& elm);

	std::vector<AnnoElem> annoArr_;
};

} // end of namespace
}
}
