/*********************************************************/
/*!
 @addtoGroup AB3D
 @file DbController.h
 @brief AB3D Peak Position DB Controller
 
 @date 2013.07.01
 @author M.Fukuda
 @varsion 1.0.0

 -------------------------------------------------------
 Copyright(C) 2006-2014
 Eisai Co., Ltd. All rights reserved.
 -------------------------------------------------------
 @note
    AB3D PositionĂ΂āADB̈Ȃ㗝B
 */
/*********************************************************/
#pragma once

//O錾
namespace kome {
	namespace core{
		class Buffer;
	}
	namespace objects{
		class DataSet;
		class DataGroupNode;
	}
	namespace db{
		class Statement;
	}
}

namespace AB3D {
	class TmpTblCtrl;
	class DbProxyClass;
	struct TmpPeakVal;
}

namespace AB3D {
/*!--------------------------------------------------------
    @name   DbController
    @brief  Data Base  AB3D Rg[
    @date   2013.07.01
    @par    AB3D{̂Ă΂
            Matrixɐݒ肳ꂽTv̊Ǘ(Next)sB
-----------------------------------------------------------*/
	class DbController {

	public:
		// constructor
		DbController();
		// destructor
		~DbController();
		
		// Uncopyable
		DbController(const DbController&);
		DbController& operator=(const DbController&);

	private:
		// Temp Table ̃IuWFNg
		std::unique_ptr<TmpTblCtrl> tblPtr_;

		// Table ̃IuWFNg(Proxy)
//		std::unique_ptr<DbProxyClass> pxyPtr_;

		// gpMatrixID
		int matrixId_;
		// ݌vZ̃TvID
		int nowSampleId_;
		//// TvŜ̌oߐ
		//unsigned int nowCount_;
		//// Tv̔z(IDQ)
		//std::vector<int>sampleIds_;

	public:
		/*!
		 * @brief  DBZbgAbvł邩AԂ`FbN
		 * @retval DBgȂꍇFalseԂ
		 */
		//const bool checkDBStatus();

		/*!
		 * @brief  ƗpTempTable쐬
		 * @retval 쐬ɃG[fƂFalseԂ
		 */
		const bool setupTempTables();

		/*!
		 * @brief  Temp TablẽXe[ggZbgAbv
		 * @retval oȂꍇFalseԂ
		 */
		const bool setupTempSTMT();

		///*!
		// * @brief  EMS/Mass++ TablẽXe[ggZbgAbv
		// * @retval oȂꍇFalseԂ
		// * @note
		//      Mass++ł͖{Xe[gg͎gpȂ
		// */
		//const bool setupMsppSTMT();

		//// ĂTvTCYԂ(Proguressׂ̈)
		//unsigned int getSampleNumbers() const {
		//	return sampleIds_.size();
		//}

		///*!
		// * @brief  ̃TvɑJڂ
		// * @retval  False.
		// * @note
		//      IɃ|C^i߂ĎANeBuɂ
		// */
		//const bool doNextSample();

		void setSampleId(const int spId);

		///*!
		// * @brief      ݂̃TvXYDataĂі߂
		// * @param[out] (I)ANeBuȃTvDataSet
		// */
		//const bool getNowDataGroup(
		//	kome::objects::DataSet& refDataSet);

		///*!
		// * @brief  ݂̃TviJĂ΁j
		// */
		//void onCloseActivegroup();

		/*!
		 * @brief      XICTempTableɏ
		 * @param[in]  ^[Qbg̃s[N
		 * @param[in]  XICƂĂ̎f[^(XYPoints)
		 * @param[in]  XIC̃s[ŇB
		 * @retval     TempTableɏ񂾌ID(PeakID)߂
		 * @note
		      AB3Dnꂽ_ŁAs[Ň̒
			  ^[Qbg̃s[N邩Ȃ肵ĂȂ̂ŁA
			  Ŕ肷KvL
		 */
		const int setXICData(
			const std::vector<std::pair<double, double>>& xicXyDatas,
			const double rt,
			const double mz,
			const double value,
			const double peak_top_x,
			const double peak_top_y,
			const double peak_left_x,
			const double peak_left_y,
			const double peak_right_x,
			const double peak_right_y
			);

		/*!
		 * @brief      Charge̒lAbvf[g
		 * @param[in]  ΏۂPeak ID
		 * @param[in]  Charge
		 */
		void updateCharge(
			const int peakId,
			const int charge);

		/*!
		 * @brief      TempTableYf[^擾
		 * @param[out] vTempPeakQ
		 * @result     擾̐
		 */
		const bool getMatchDataFromTemp(
			std::vector<TmpPeakVal*>& tpvArr);

		///*!
		// * @brief      TableRow(Peak)+Value
		// * @param[in]  M/Z
		// * @param[in]  Retention Time(Min)
		// * @param[in]  Charge
		// * @param[in]  ROWɑValueQ
		// */
		//void writeRowLine(
		//	const double mz,
		//	const double rt,
		//	const int charge,
		//	std::vector<AB3D::TmpPeakVal*>& tpvArr);

		void getDataPointsFromTemp(
			const int tmpProfId,
			kome::core::DataPoints& dps);

		/*!
		 * @brief ItF[Y𑖂点
		 */
		void finishMakeMatrix(const bool ret);

	private:
		/*!
		 * @brief  ݂̃TviJĂ΁j
		 * @retval DB̃IuWFNgԂ
		 */
		kome::db::Database* onGetDB();

		const int setTempProfile(
			const std::vector<std::pair<double, double>>& xicXyData
			);


		/*!
		 * @brief      XYPointsBufferɕϊ
		 * @param[in]  XYPoints Data
		 * @param[out] Buffer IuWFNg
		 * @retval     ϊɃG[False
		 */
		const bool tranceToBuffer(
			const std::vector<std::pair<double, double>>& xicXyData,
			kome::core::Buffer& rstBuffer);

		///*!
		// * @brief      Temp ProfileBuffero^
		// * @param[in]  Buffer IuWFNg
		// * @retval     o^temp profile ID
		// */
		//const int onSetTmpProfile(
		//	kome::core::Buffer& buffer);
	};
}
