/*********************************************************/
/*!
 @addtoGroup AB3D
 @file progressAB3D.cpp
 @brief progress adapter (for AB3D)
 
 @date 2013.07.01
 @author M.Fukuda
 @varsion 1.0.0

 -------------------------------------------------------
 Copyright(C) 2006-2014
 Eisai Co., Ltd. All rights reserved.
 -------------------------------------------------------
 @note
 */
/*********************************************************/

#include "../stdafx.h"
#include "progressAB3D.h"

// AB3D̐is󋵂̃vOXłB
// Detector̐is󋵃bZ[WApx
// onNextStepKXĂB
// px߂Ƃꎩ̂{glbNɂȂ܂B
// IɁA30JEgŗpӂĂ܂B
// nextstepĂԂтɁAPJEg܂B
// PeakDetector25JEg
// ȊǑʂ̃tF[Y5Ă΂Ă܂B

// Close(Fill)ĂԂƕs͕⊮ăN[YĂ܂B
// ͈͂I[o[Ɓ@̂ňɒӂĉB

AB3DProg::AB3DProg(
	kome::core::Progress* _progress,
	const int lastcount
	) : ProgressAdapter(_progress, lastcount)
{
	this->initMe();
}

void AB3DProg::onInitMe()
{
	nowCount_ = firstCount_;
	// Progress͈̔͂łBsetPositionŃQ[Wʒuς܂B
	progress_->setRange(firstCount_, lastCount_);
	progress_->setPosition(firstCount_);
}

const bool AB3DProg::onNextStep()
{
	std::string msg = FMT("AB3D Peak Detect.. %02d", nowCount_ * 4);
	msg += "%";
	onShowStatus(msg);
	return true;
}

void AB3DProg::onCloseMe()
{
}
