<?php
// $Id: functions.php,v 1.6 2008/10/03 03:23:27 mumincacao Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

// ################## Various functions from here ################

function xoops_refcheck($docheck=1)
{
    $ref = xoops_getenv('HTTP_REFERER');
    if ($docheck == 0) {
        return true;
    }
    if ($ref == '') {
        return false;
    }
    if (strpos($ref, XOOPS_URL) !== 0 ) {
        return false;
    }
    return true;
}

function xoops_getUserTimestamp($time, $timeoffset="")
{
    $xoopsConfig = XCube_Root::getSingleton()->mContext->mXoopsConfig;
    $xoopsUser =& XCube_Root::getSingleton()->mContext->mXoopsUser;
    if ($timeoffset == '') {
        if ($xoopsUser) {
            $timeoffset = $xoopsUser->getVar("timezone_offset");
        } else {
            $timeoffset = $xoopsConfig['default_TZ'];
        }
    }

    return intval($time) + (intval($timeoffset) - $xoopsConfig['server_TZ'])*3600;
}

/*
 * Function to display formatted times in user timezone
 */
function formatTimestamp($time, $format="l", $timeoffset="")
{
    $usertimestamp = xoops_getUserTimestamp($time, $timeoffset);
    return _formatTimeStamp($usertimestamp, $format);
}

function _formatTimeStamp($time, $format="l")
{
    switch (strtolower($format)) {
    case 's':
        $datestring = _SHORTDATESTRING;
        break;
    case 'm':
        $datestring = _MEDIUMDATESTRING;
        break;
    case 'mysql':
        $datestring = "Y-m-d H:i:s";
        break;
    case 'rss':
        $datestring = "r";
        break;
    case 'l':
        $datestring = _DATESTRING;
        break;
    default:
        if ($format != '') {
            $datestring = $format;
        } else {
            $datestring = _DATESTRING;
        }
        break;
    }
    return ucfirst(date($datestring, $time));
}

function xoops_makepass() {
    $makepass = '';
    $syllables = array("er","in","tia","wol","fe","pre","vet","jo","nes","al","len","son","cha","ir","ler","bo","ok","tio","nar","sim","ple","bla","ten","toe","cho","co","lat","spe","ak","er","po","co","lor","pen","cil","li","ght","wh","at","the","he","ck","is","mam","bo","no","fi","ve","any","way","pol","iti","cs","ra","dio","sou","rce","sea","rch","pa","per","com","bo","sp","eak","st","fi","rst","gr","oup","boy","ea","gle","tr","ail","bi","ble","brb","pri","dee","kay","en","be","se");
    srand((double)microtime()*1000000);
    for ($count = 1; $count <= 4; $count++) {
        if (rand()%10 == 1) {
            $makepass .= sprintf("%0.0f",(rand()%50)+1);
        } else {
            $makepass .= sprintf("%s",$syllables[rand()%62]);
        }
    }
    return $makepass;
}

function xoops_getenv($key)
{
    $ret = null;
    //$phpv = explode(".", PHP_VERSION);
    //if ($phpv[0] > 3 && $phpv[1] > 0) {
    //  $ret = isset($_SERVER[$key]) ? $_SERVER[$key] : $_ENV[$key];
    //} else {
		if (isset($_SERVER[$key]) || isset($_ENV[$key])) {
            $ret = isset($_SERVER[$key]) ? $_SERVER[$key] : $_ENV[$key];
		}
    //}

    switch($key) {
        case 'PHP_SELF':
        case 'PATH_INFO':
        case 'PATH_TRANSLATED':
            $ret = htmlspecialchars($ret,ENT_QUOTES);
            break;
    }

    return $ret;
}

function &getMailer()
{
    $xoopsConfig = XCube_Root::getSingleton()->mContext->mXoopsConfig;
	$ret = null;
    require_once XOOPS_ROOT_PATH."/class/xoopsmailer.php";
    if ( file_exists(XOOPS_ROOT_PATH."/language/".$xoopsConfig['language']."/xoopsmailerlocal.php") ) {
        require_once XOOPS_ROOT_PATH."/language/".$xoopsConfig['language']."/xoopsmailerlocal.php";
        if ( XC_CLASS_EXISTS("XoopsMailerLocal") ) {
            $ret = new XoopsMailerLocal();
			return $ret;
        }
    }
    $ret = new XoopsMailer();
	return $ret;
}

/**
 * This function is Fly-Weight to get an instance of XoopsObject in Legacy
 * Kernel.
 */
function &xoops_gethandler($name, $optional = false )
{
    static $handlers;
    $name = strtolower(trim($name));
    if (!isset($handlers[$name])) {
		//
		// The following delegate is test at Alpha4-c.
		//
		$handler = null;
		XCube_DelegateUtils::call('Legacy.Event.GetHandler', new XCube_Ref($handler), $name, $optional);
		if (is_object($handler)) {
			$handlers[$name] =& $handler;
			return $handlers[$name];
		}
		
        if ( file_exists( $hnd_file = XOOPS_ROOT_PATH.'/kernel/'.$name.'.php' ) ) {
            require_once $hnd_file;
        }
        $class = 'Xoops'.ucfirst($name).'Handler';
        if (XC_CLASS_EXISTS($class)) {
            $handlers[$name] = new $class(XoopsDatabaseFactory::getDatabaseConnection());
        }
    }
    if (!isset($handlers[$name]) && !$optional ) {
        trigger_error('Class <b>'.$class.'</b> does not exist<br />Handler Name: '.$name, E_USER_ERROR);
    }
	
	$falseRet = false;
	
    if (isset($handlers[$name]))
        return $handlers[$name];
	else
        return $falseRet;
}

function &xoops_getmodulehandler($name = null, $module_dir = null, $optional = false)
{
    static $handlers;
    // if $module_dir is not specified
    if ($module_dir == null) {
        //if a module is loaded
        $module =& XCube_Root::getSingleton()->mContext->mXoopsModule;
        if (is_object($module)) {
            $module_dir = $module->getVar('dirname');
        } else {
            trigger_error('No Module is loaded', E_USER_ERROR);
        }
    } else {
        $module_dir = trim($module_dir);
    }
    $name = (!isset($name)) ? $module_dir : trim($name);
    if (!isset($handlers[$module_dir][$name])) {
		//
		// Cube Style
		//
		if (file_exists($hnd_file = XOOPS_ROOT_PATH . "/modules/{$module_dir}/class/handler/" . ucfirst($name) . ".class.php")) {
			include_once $hnd_file;
		}
		elseif ( file_exists( $hnd_file = XOOPS_ROOT_PATH . "/modules/{$module_dir}/class/{$name}.php" ) ) {
            include_once $hnd_file;
        }
		
		$className = ucfirst(strtolower($module_dir)) . "_" . ucfirst($name) . 'Handler';
		if (XC_CLASS_EXISTS($className)) {
			$handlers[$module_dir][$name] = new $className(XoopsDatabaseFactory::getDatabaseConnection());
		}
		else {
			$className = ucfirst(strtolower($module_dir)) . ucfirst($name) . 'Handler';
			if (XC_CLASS_EXISTS($className)) {
				$handlers[$module_dir][$name] = new $className(XoopsDatabaseFactory::getDatabaseConnection());
			}
		}
    }
    if (!isset($handlers[$module_dir][$name]) && !$optional) {
        trigger_error('Handler does not exist<br />Module: '.$module_dir.'<br />Name: '.$name, E_USER_ERROR);
    }
	
    return $handlers[$module_dir][$name];
}

/**
* Returns the portion of string specified by the start and length parameters. If $trimmarker is supplied, it is appended to the return string. This function works fine with multi-byte characters if mb_* functions exist on the server.
*
* @param    string    $str
* @param    int       $start
* @param    int       $length
* @param    string    $trimmarker
*
* @return   string
*/
function xoops_substr($str, $start, $length, $trimmarker = '...')
{
    if ( !XOOPS_USE_MULTIBYTES ) {
        return ( strlen($str) - $start <= $length ) ? substr( $str, $start, $length ) : substr( $str, $start, $length - strlen($trimmarker) ) . $trimmarker;
    }
    if (function_exists('mb_internal_encoding') && @mb_internal_encoding(_CHARSET)) {
        $str2 = mb_strcut( $str , $start , $length - strlen( $trimmarker ) );
        return $str2 . ( mb_strlen($str)!=mb_strlen($str2) ? $trimmarker : '' );
    }
    // phppp patch
    $DEP_CHAR=127;
    $pos_st=0;
    $action = false;
    for ( $pos_i = 0; $pos_i < strlen($str); $pos_i++ ) {
        if ( ord( substr( $str, $pos_i, 1) ) > 127 ) {
            $pos_i++;
        }
        if ($pos_i<=$start) {
            $pos_st=$pos_i;
        }
        if ($pos_i>=$pos_st+$length) {
            $action = true;
            break;
        }
    }
    return ($action) ? substr( $str, $pos_st, $pos_i - $pos_st - strlen($trimmarker) ) . $trimmarker : $str;
}

?>
