<?php
// $Id: textsanitizer.php,v 1.1 2007/05/15 02:35:13 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (http://www.myweb.ne.jp/, http://jp.xoops.org/)        //
//         Goghs Cheng (http://www.eqiao.com, http://www.devbeez.com/)       //
// Project: The XOOPS Project (http://www.xoops.org/)                        //
// ------------------------------------------------------------------------- //
// This is subset and modified version of module.textsanitizer.php
set_magic_quotes_runtime(0);

class TextSanitizer
{

    /*
    * Constructor of this class
    * Gets allowed html tags from admin config settings
    * <br> should not be allowed since nl2br will be used
    * when storing data
    */
    function TextSanitizer()
    {

    }

    function &getInstance()
    {
        static $instance;
        if (!isset($instance)) {
            $instance = new TextSanitizer();
        }
        return $instance;
    }

    function &makeClickable(&$text)
    {
        $patterns = array("/([^]_a-z0-9-=\"'\/])([a-z]+?):\/\/([^, \r\n\"\(\)'<>]+)/i", "/([^]_a-z0-9-=\"'\/])www\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i", "/([^]_a-z0-9-=\"'\/])([a-z0-9\-_.]+?)@([^, \r\n\"\(\)'<>]+)/i");
        $replacements = array("\\1<a href=\"\\2://\\3\" target=\"_blank\">\\2://\\3</a>", "\\1<a href=\"http://www.\\2.\\3\" target=\"_blank\">www.\\2.\\3</a>", "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>");
        $ret = preg_replace($patterns, $replacements, $text);
        return $ret;
    }

    function &nl2Br($text)
    {
        $ret = preg_replace("/(\015\012)|(\015)|(\012)/","<br />",$text);
        return $ret;
    }

    function &addSlashes($text, $force=false)
    {
        if ($force) {
            $ret = addslashes($text);
            return $ret;
        }
        if (!get_magic_quotes_gpc()) {
            $text = addslashes($text);
        }
        return $text;
    }

    /*
    * if magic_quotes_gpc is on, stirip back slashes
    */
    function &stripSlashesGPC($text)
    {
        if (get_magic_quotes_gpc()) {
            $text = stripslashes($text);
        }
        return $text;
    }

    /*
    *  for displaying data in html textbox forms
    */
    function &htmlSpecialChars($text)
    {
        $text = preg_replace("/&amp;/i", '&', htmlspecialchars($text, ENT_QUOTES));
        return $text;
    }

    function &undoHtmlSpecialChars(&$text)
    {
        $ret = preg_replace(array("/&gt;/i", "/&lt;/i", "/&quot;/i", "/&#039;/i"), array(">", "<", '"', "'"), $text);
        return $ret;
    }

    /*
    *  Filters textarea form data in DB for display
    */
    function &displayText($text, $html=false)
    {
        if (! $html) {
            // html not allowed
            $text =& $this->htmlSpecialChars($text);
        }
        $text =& $this->makeClickable($text);
        $text =& $this->nl2Br($text);
        return $text;
    }

    /*
    *  Filters textarea form data submitted for preview
    */
    function &previewText($text, $html=false)
    {
        $text =& $this->stripSlashesGPC($text);
        return $this->displayText($text, $html);
    }
}
?>