<?php
/**
 *
 * @package Legacy
 * @version $Id: Legacy_AdminControllerStrategy.class.php,v 1.5 2008/09/25 15:11:56 kilica Exp $
 * @copyright Copyright 2005-2007 XOOPS Cube Project  <http://xoopscube.sourceforge.net/> 
 * @license http://xoopscube.sourceforge.net/license/GPL_V2.txt GNU GENERAL PUBLIC LICENSE Version 2
 *
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * @internal
 */ 
class Legacy_AdminControllerStrategy extends Legacy_AbstractControllerStrategy
{
	var $mStatusFlag = LEGACY_CONTROLLER_STATE_ADMIN;
	
	/**
	 * @var XCube_Delegate
	 * @param XCube_Controller &$controller
	 */
	var $mSetupBlock = null;
	
	/**
	 *  If this array includes current action, getVirtualCurrentModule() returns
	 * the module object that specified by dirname.
	 * 
	 * @access private
	 */
	var $_mSpecialActions = array("Help");

	function __construct(&$controller)
	{
		parent::__construct($controller);
		
		//
		// TODO We have to develop complated-switching-controller-mechanizm.
		//
		if (!defined("LEGACY_DEPENDENCE_RENDERER")) {
			define("LEGACY_DEPENDENCE_RENDERER", "Legacy_AdminRenderSystem");
		}
		
		$controller->mRoot->mContext->mBaseRenderSystemName = "Legacy_AdminRenderSystem";
		
		$this->mSetupBlock = new XCube_Delegate();
		$this->mSetupBlock->register('Legacy_AdminControllerStrategy.SetupBlock');
	}

	function _setupFilterChain()
	{
		parent::_setupFilterChain();

		//
		// Auto pre-loading.
		//
		if($this->mController->mRoot->getSiteConfig('Legacy', 'AutoPreload') == 1) {
			$this->mController->_processPreload(XOOPS_ROOT_PATH . "/preload/admin");
		}
	}
	
	function setupModuleContext(&$context, $dirname)
	{
		if ($dirname == null) {
			$dirname = 'legacy';
		}
		
		parent::setupModuleContext($context, $dirname);
	}
	
	function setupBlock()
	{
		require_once XOOPS_LEGACY_PATH . "/admin/blocks/AdminActionSearch.class.php";
		require_once XOOPS_LEGACY_PATH . "/admin/blocks/AdminSideMenu.class.php";
		$this->mController->_mBlockChain[] = new Legacy_AdminActionSearch();
		$this->mController->_mBlockChain[] = new Legacy_AdminSideMenu();
		
		$this->mSetupBlock->call(new XCube_Ref($this->mController));
	}

	function _processPreBlockFilter()
	{
		parent::_processPreBlockFilter();
		$this->mController->_processModulePreload('/admin/preload');
	}

	function &getVirtualCurrentModule()
	{
		static $ret_module;
		if (is_object($ret_module)) {
			return $ret_module;
		}
		
		if ($this->mController->mRoot->mContext->mModule != null) {
			$module =& $this->mController->mRoot->mContext->mXoopsModule;
			
			if ($module->get('dirname') == "legacy" && isset($_REQUEST['dirname'])) {
				if (in_array($this->mController->mRoot->mContext->mRequest->getRequest('action'), $this->_mSpecialActions)) {
					$handler =& xoops_gethandler('module');
					$t_xoopsModule =& $handler->getByDirname($this->mController->mRoot->mContext->mRequest->getRequest('dirname'));
					$ret_module =& Legacy_Utils::createModule($t_xoopsModule);
				}
			}
			elseif ($module->get('dirname') == "legacy" && $this->mController->mRoot->mContext->mRequest->getRequest('action') == 'PreferenceEdit' && isset($_REQUEST['confmod_id'])) {
				$handler =& xoops_gethandler('module');
				$t_xoopsModule =& $handler->get(intval($this->mController->mRoot->mContext->mRequest->getRequest('confmod_id')));
				$ret_module =& Legacy_Utils::createModule($t_xoopsModule);
			}
			
			if (!is_object($ret_module)) {
				$ret_module =& Legacy_Utils::createModule($module);
			}
		}
		
		return $ret_module;
	}

	function &getMainThemeObject()
	{
		$handler =& xoops_getmodulehandler('theme', 'legacy');
		$theme =& $handler->create();
		
		//
		// TODO Load manifesto here.
		//
		$theme->set('dirname', $this->mController->mRoot->mSiteConfig['Legacy']['Theme']);
		$theme->set('render_system', 'Legacy_AdminRenderSystem');
		
		return $theme;
	}
	
	function isEnableCacheFeature()
	{
		return false;
	}
	
	function enableAccess()
	{
		$principal =& $this->mController->mRoot->mContext->mUser;
		
		if (!$principal->mIdentity->isAuthenticated()) {
			return false;
		}
		
		if ($this->mController->mRoot->mContext->mModule != null) {
			$dirname = $this->mController->mRoot->mContext->mXoopsModule->get('dirname');
			
			if ($dirname == 'legacy') {
				return $principal->isInRole('Site.Administrator');
			} elseif ( defined('_LEGACY_ALLOW_ACCESS_FROM_ANY_ADMINS_') ) {
				return $this->mController->mRoot->mContext->mXoopsUser->isAdmin(0);
			}
			
			return $principal->isInRole("Module.${dirname}.Admin");
		}
		else {
			return $principal->isInRole('Site.Administrator');
		}
		
		return false;
	}
	
	function setupModuleLanguage()
	{
		$root =& XCube_Root::getSingleton();
		
		$root->mContext->mXoopsModule->loadInfo($root->mContext->mXoopsModule->get('dirname'));
		
		if (isset($root->mContext->mXoopsModule->modinfo['cube_style']) && $root->mContext->mXoopsModule->modinfo['cube_style'] != false) {
			$root->mLanguageManager->loadModuleMessageCatalog($root->mContext->mXoopsModule->get('dirname'));
		}
		$root->mLanguageManager->loadModuleAdminMessageCatalog($root->mContext->mXoopsModule->get('dirname'));
		$root->mLanguageManager->loadModinfoMessageCatalog($root->mContext->mXoopsModule->get('dirname'));
	}
}

?>
