<?php
/**
 * @package user
 * @version $Id: GroupFilterForm.class.php,v 1.1 2007/05/15 02:34:39 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";

define('GROUP_SORT_KEY_GROUPID', 1);
define('GROUP_SORT_KEY_NAME', 2);
define('GROUP_SORT_KEY_DESCRIPTION', 3);
define('GROUP_SORT_KEY_GROUP_TYPE', 4);
define('GROUP_SORT_KEY_MAXVALUE', 4);

define('GROUP_SORT_KEY_DEFAULT', GROUP_SORT_KEY_GROUPID);

class User_GroupFilterForm extends User_AbstractFilterForm
{
	var $mSortKeys = array(
		GROUP_SORT_KEY_DEFAULT => 'groupid',
		GROUP_SORT_KEY_GROUPID => 'groupid',
		GROUP_SORT_KEY_NAME => 'name',
		GROUP_SORT_KEY_DESCRIPTION => 'description',
		GROUP_SORT_KEY_GROUP_TYPE => 'group_type'
	);

	function getDefaultSortKey()
	{
		return GROUP_SORT_KEY_DEFAULT;
	}
	
	function fetch()
	{
		parent::fetch();
        $request =& XCube_Root::getSingleton()->mContext->mRequest;
	
		if (($value = $request->getRequest('groupid')) !== null) {
			$this->mNavi->addExtra('groupid', $value);
			$this->_mCriteria->add(new Criteria('groupid', $value));
		}
	
		if (($value = $request->getRequest('name')) !== null) {
			$this->mNavi->addExtra('name', $value);
			$this->_mCriteria->add(new Criteria('name', $value));
		}
	
		if (($value = $request->getRequest('group_type')) !== null) {
			$this->mNavi->addExtra('group_type', $value);
			$this->_mCriteria->add(new Criteria('group_type', $value));
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
