<?php
/**
 * @package user
 * @version $Id: UserAdminEditForm.class.php,v 1.2 2007/06/07 05:27:37 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_ActionForm.class.php";

/***
 * @internal
 * This class is generated by makeActionForm tool.
 * 
 * @todo We may have to check the format of URL.
 */
class User_UserAdminEditForm extends XCube_ActionForm
{
	var $_mIsNew;
	
	function getTokenName()
	{
		return "module.user.UserAdminEditForm.Token" . $this->get('uid');
	}
	
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['uid'] = new XCube_IntProperty('uid');
		$this->mFormProperties['name'] = new XCube_StringProperty('name');
		$this->mFormProperties['uname'] = new XCube_StringProperty('uname');
		$this->mFormProperties['email'] = new XCube_StringProperty('email');
		$this->mFormProperties['user_viewemail'] = new XCube_IntProperty('user_viewemail');
		$this->mFormProperties['pass'] = new XCube_StringProperty('pass');
		$this->mFormProperties['vpass'] = new XCube_StringProperty('vpass');
		$this->mFormProperties['level'] = new XCube_IntProperty('level');
		$this->mFormProperties['timezone_offset'] = new XCube_FloatProperty('timezone_offset');
		$this->mFormProperties['user_mailok'] = new XCube_IntProperty('user_mailok');
		$this->mFormProperties['groups'] = new XCube_IntArrayProperty('groups');

		//
		// Set field properties
		//
		$this->mFieldProperties['uid'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['uid']->setDependsByArray(array('required'));
		$this->mFieldProperties['uid']->addMessage('required', _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_UID);

		$this->mFieldProperties['name'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['name']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_NAME, '60');
		$this->mFieldProperties['name']->addVar('maxlength', 60);

		$this->mFieldProperties['uname'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['uname']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['uname']->addMessage('required', _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_UNAME, '25');
		$this->mFieldProperties['uname']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_UNAME, '25');
		$this->mFieldProperties['uname']->addVar('maxlength', 25);

		$this->mFieldProperties['email'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['email']->addMessage('required', _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_EMAIL, '60');
		$this->mFieldProperties['email']->setDependsByArray(array('required', 'maxlength', 'email'));
		$this->mFieldProperties['email']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_EMAIL, '60');
		$this->mFieldProperties['email']->addVar('maxlength', 60);
		$this->mFieldProperties['email']->addMessage('email', _MD_USER_ERROR_EMAIL, _MD_USER_LANG_EMAIL);

		$this->mFieldProperties['pass'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['pass']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['pass']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_PASS, '32');
		$this->mFieldProperties['pass']->addVar('maxlength', 32);

		$this->mFieldProperties['vpass'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['vpass']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['vpass']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_PASS, '32');
		$this->mFieldProperties['vpass']->addVar('maxlength', 32);

		$this->mFieldProperties['level'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['level']->setDependsByArray(array('required'));
		$this->mFieldProperties['level']->addMessage('required', _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_LEVEL);

		$this->mFieldProperties['timezone_offset'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['timezone_offset']->setDependsByArray(array('required'));
		$this->mFieldProperties['timezone_offset']->addMessage('required', _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_TIMEZONE_OFFSET);
	}
	
	function validateUname()
	{
		if ($this->get('uname') != null) {
			$handler =& xoops_gethandler('user');
			$criteria = new CriteriaCompo(new Criteria('uname', $this->get('uname')));
			if ($this->get('uid')) {
				$criteria->add(new Criteria('uid', $this->get('uid'), '<>'));
			}
			if ($handler->getCount($criteria) > 0) {
				$this->addErrorMessage(_AD_USER_ERROR_UNAME_NO_UNIQUE);
			}
		}
	}
	
	function validateEmail()
	{
		if (strlen($this->get('email')) > 0) {
			//
			// email unique check
			//
			$userHandler=&xoops_gethandler('user');
			$criteria = new CriteriaCompo(new Criteria('email', $this->get('email')));
			if ($this->get('uid') > 0) {
				$criteria->add(new Criteria('uid', $this->get('uid'), '<>'));
			}
			if ($userHandler->getCount($criteria) > 0) {
				$this->addErrorMessage(_MD_USER_ERROR_EMAILTAKEN);
			}
		}
	}
	
	function validateGroups()
	{
		$groupHandler =& xoops_gethandler('group');
		foreach ($this->get('groups') as $gid) {
			$group =& $groupHandler->get($gid);
			if (!is_object($group)) {
				$this->addErrorMessage(_AD_USER_ERROR_GROUP_VALUE);
			}
		}
	}
	
	/**
	 * Checks the password field and the confirm password field. If it's a new
	 * user registration, password is must. And, if password isn't empty, the
	 * password and the confirm password have to be the same value.
	 */
	function validatePass()
	{
		if (strlen($this->get('pass'))) {
			if ($this->get('pass') != $this->get('vpass')) {
				$this->addErrorMessage(_MD_USER_ERROR_PASSWORD);
				$this->set('pass', '');
				$this->set('vpass', '');
			}
		}
		elseif($this->_mIsNew) {
				$this->addErrorMessage(XCube_Utils::formatMessage(_MD_USER_ERROR_REQUIRED, _MD_USER_LANG_PASS));
		}
	}
	
	function load(&$obj)
	{
		$this->set('uid', $obj->get('uid'));
		$this->set('name', $obj->get('name'));
		$this->set('uname', $obj->get('uname'));
		$this->set('email', $obj->get('email'));
		$this->set('user_viewemail', $obj->get('user_viewemail'));
		$this->set('level', $obj->get('level'));
		$this->set('timezone_offset', $obj->get('timezone_offset'));
		$this->set('user_mailok', $obj->get('user_mailok'));
		
		$this->_mIsNew = $obj->isNew();

		$groups = $obj->getGroups();
		
		if ($this->_mIsNew) {
			$this->set('groups', 0, XOOPS_GROUP_USERS);
		}
		else {
			$i = 0;
			foreach ($groups as $gid) {
				$this->set('groups', $i++, $gid);
			}
		}
	}

	function update(&$obj)
	{
		$obj->set('uid', $this->get('uid'));
		$obj->set('name', $this->get('name'));
		$obj->set('uname', $this->get('uname'));
		$obj->set('email', $this->get('email'));
		$obj->set('user_viewemail', $this->get('user_viewemail'));

		if (strlen($this->get('pass'))) {
			$obj->set('pass', md5($this->get('pass')));
		}

		$obj->set('level', $this->get('level'));
		$obj->set('timezone_offset', $this->get('timezone_offset'));
		$obj->set('user_mailok', $this->get('user_mailok'));
		
		$obj->Groups = array();
		$groups = $this->get('groups');
		
		foreach ($groups as $gid) {
			$obj->Groups[] = $gid;
		}
	}
}

?>
