<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/forms/AbstractUserEditForm.class.php";

/***
 * @internal
 */
class User_EditUserForm extends User_AbstractUserEditForm 
{
	function getTokenName()
	{
		return "Module.User.EditUserForm.Token." . $this->get('uid');
	}
	
	/**
	 * TODO The argument of this member property may be moved to constructor.
	 */
	function prepare()
	{
		parent::prepare();
		
		//
		// set properties
		//
		$this->mFormProperties['uid'] =& new XCube_IntProperty('uid');
		$this->mFormProperties['name'] =& new XCube_StringProperty('name');
		
		if ($this->mConfig['allow_chgmail']) {
			$this->mFormProperties['email'] =& new XCube_StringProperty('email');
		}

		$this->mFormProperties['user_viewemail'] =& new XCube_BoolProperty('user_viewemail');
		$this->mFormProperties['timezone_offset'] =& new XCube_FloatProperty('timezone_offset');
		$this->mFormProperties['pass'] =& new XCube_StringProperty('pass');
		$this->mFormProperties['vpass'] =& new XCube_StringProperty('vpass');
		$this->mFormProperties['user_mailok'] =& new XCube_BoolProperty('user_mailok');

		//
		// set fields
		//
		$this->mFieldProperties['name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['name']->addMessage("maxlength", _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_NAME, "60");
		$this->mFieldProperties['name']->addVar("maxlength", 60);

		if ($this->mConfig['allow_chgmail']) {
			$this->mFieldProperties['email'] =& new XCube_FieldProperty($this);
			$this->mFieldProperties['email']->setDependsByArray(array('required', 'maxlength', 'email'));
			$this->mFieldProperties['email']->addMessage("required", _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_EMAIL, "60");
			$this->mFieldProperties['email']->addMessage("maxlength", _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_EMAIL, "60");
			$this->mFieldProperties['email']->addVar("maxlength", 60);
			$this->mFieldProperties['email']->addMessage('email', _MD_USER_ERROR_EMAIL, _MD_USER_LANG_EMAIL);
		}

		$this->mFieldProperties['pass'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['pass']->setDependsByArray(array('minlength', 'maxlength'));
		$this->mFieldProperties['pass']->addMessage('minlength', _MD_USER_ERROR_MINLENGTH, _MD_USER_LANG_PASS, $this->mConfig['minpass']);
		$this->mFieldProperties['pass']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_PASS, '32');
		$this->mFieldProperties['pass']->addVar('minlength', $this->mConfig['minpass']);
		$this->mFieldProperties['pass']->addVar('maxlength', 32);

		$this->mFieldProperties['vpass'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['vpass']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['vpass']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _MD_USER_LANG_VERIFYPASS, '32');
		$this->mFieldProperties['vpass']->addVar('maxlength', 32);
		
		$this->mFieldProperties['timezone_offset'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['timezone_offset']->setDependsByArray(array('required'));
		$this->mFieldProperties['timezone_offset']->addMessage('required', _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_TIMEZONE_OFFSET);
	}
	
	function load(&$obj)
	{
		$this->set('uid', $obj->get('uid'));
		$this->set('name', $obj->get('name'));
		
		if ($this->mConfig['allow_chgmail']) {
			$this->set('email', $obj->get('email'));
		}

		$this->set('user_viewemail', $obj->get('user_viewemail'));
		$this->set('timezone_offset', $obj->get('timezone_offset'));
		$this->set('user_mailok', $obj->get('user_mailok'));
		
		$this->set('pass', null);
		$this->set('vpass', null);
	}
	
	function update(&$obj)
	{
		$obj->set('name', $this->get('name'));
		
		if ($this->mConfig['allow_chgmail']) {
			$obj->set('email', $this->get('email'));
		}

		$obj->set('user_viewemail', $this->get('user_viewemail'));

		if (strlen($this->get('pass'))) {
			$obj->set('pass', md5($this->get('pass')));
		}

		$obj->set('timezone_offset', $this->get('timezone_offset'));
		$obj->set('user_mailok', $this->get('user_mailok'));
	}
}

?>
