/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart;

import java.io.Serializable;
import java.text.AttributedString;
import java.text.CharacterIterator;
import org.afree.data.general.Dataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.StandardGradientShaderFactory;

public class LegendItem
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -797214582948827144L;
    private Dataset dataset;
    private Comparable seriesKey;
    private int datasetIndex;
    private int series;
    private String label;
    private Font labelFont;
    private transient PaintType labelPaintType;
    private transient AttributedString attributedLabel;
    private String description;
    private String toolTipText;
    private String urlText;
    private boolean shapeVisible;
    private transient Shape shape;
    private boolean shapeFilled;
    private transient PaintType fillPaintType;
    private GradientShaderFactory fillShaderFactory;
    private boolean shapeOutlineVisible;
    private transient PaintType outlinePaintType;
    private transient float outlineStroke;
    private boolean lineVisible;
    private transient Shape line;
    private transient float lineStroke;
    private transient PaintType linePaintType;
    private static final Shape UNUSED_SHAPE = new LineShape();
    private static final float UNUSED_STROKE = 0.0f;

    public LegendItem(String label) {
        this(label, new SolidColor(-16777216));
    }

    public LegendItem(String label, PaintType color) {
        this(label, null, null, null, (Shape)new RectShape(-4.0, -4.0, 8.0, 8.0), color);
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, Shape shape, PaintType fillColor) {
        this(label, description, toolTipText, urlText, true, shape, true, fillColor, false, (PaintType)new SolidColor(-16777216), 0.0f, false, UNUSED_SHAPE, 0.0f, (PaintType)new SolidColor(-16777216));
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, Shape shape, PaintType fillPaint, float outlineStroke, PaintType outlinePaint) {
        this(label, description, toolTipText, urlText, true, shape, true, fillPaint, true, outlinePaint, outlineStroke, false, UNUSED_SHAPE, 0.0f, (PaintType)new SolidColor(-16777216));
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, Shape line, float lineStroke, PaintType linePaint) {
        this(label, description, toolTipText, urlText, false, UNUSED_SHAPE, false, (PaintType)new SolidColor(-16777216), false, (PaintType)new SolidColor(-16777216), 0.0f, true, line, lineStroke, linePaint);
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, boolean shapeVisible, Shape shape, boolean shapeFilled, PaintType fillPaint, boolean shapeOutlineVisible, PaintType outlinePaint, float outlineStroke, boolean lineVisible, Shape line, float lineStroke, PaintType linePaint) {
        if (label == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        this.label = label;
        this.labelPaintType = null;
        this.attributedLabel = null;
        this.description = description;
        this.shapeVisible = shapeVisible;
        this.shape = shape;
        this.shapeFilled = shapeFilled;
        this.fillPaintType = fillPaint;
        this.fillShaderFactory = new StandardGradientShaderFactory();
        this.shapeOutlineVisible = shapeOutlineVisible;
        this.outlinePaintType = outlinePaint;
        this.outlineStroke = outlineStroke;
        this.lineVisible = lineVisible;
        this.line = line;
        this.lineStroke = lineStroke;
        this.linePaintType = linePaint;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, Shape shape, PaintType fillPaint) {
        this(label, description, toolTipText, urlText, true, shape, true, fillPaint, false, (PaintType)new SolidColor(-16777216), 0.0f, false, UNUSED_SHAPE, 0.0f, (PaintType)new SolidColor(-16777216));
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, Shape shape, PaintType fillPaint, float outlineStroke, PaintType outlinePaint) {
        this(label, description, toolTipText, urlText, true, shape, true, fillPaint, true, outlinePaint, outlineStroke, false, UNUSED_SHAPE, 0.0f, (PaintType)new SolidColor(-16777216));
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, Shape line, float lineStroke, PaintType linePaint) {
        this(label, description, toolTipText, urlText, false, UNUSED_SHAPE, false, (PaintType)new SolidColor(-16777216), false, (PaintType)new SolidColor(-16777216), 0.0f, true, line, lineStroke, linePaint);
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, boolean shapeVisible, Shape shape, boolean shapeFilled, PaintType fillPaint, boolean shapeOutlineVisible, PaintType outlinePaint, float outlineStroke, boolean lineVisible, Shape line, float lineStroke, PaintType linePaint) {
        if (label == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        if (line == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.label = this.characterIteratorToString(label.getIterator());
        this.attributedLabel = label;
        this.description = description;
        this.shapeVisible = shapeVisible;
        this.shape = shape;
        this.shapeFilled = shapeFilled;
        this.fillPaintType = fillPaint;
        this.fillShaderFactory = new StandardGradientShaderFactory();
        this.shapeOutlineVisible = shapeOutlineVisible;
        this.outlinePaintType = outlinePaint;
        this.outlineStroke = outlineStroke;
        this.lineVisible = lineVisible;
        this.line = line;
        this.lineStroke = lineStroke;
        this.linePaintType = linePaint;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    private String characterIteratorToString(CharacterIterator iterator) {
        int beginIndex;
        int endIndex = iterator.getEndIndex();
        int count = endIndex - (beginIndex = iterator.getBeginIndex());
        if (count <= 0) {
            return "";
        }
        char[] chars = new char[count];
        int i = 0;
        char c = iterator.first();
        while (c != '\uffff') {
            chars[i] = c;
            ++i;
            c = iterator.next();
        }
        return new String(chars);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int index) {
        this.datasetIndex = index;
    }

    public Comparable getSeriesKey() {
        return this.seriesKey;
    }

    public void setSeriesKey(Comparable key) {
        this.seriesKey = key;
    }

    public int getSeriesIndex() {
        return this.series;
    }

    public void setSeriesIndex(int index) {
        this.series = index;
    }

    public String getLabel() {
        return this.label;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public PaintType getLabelPaintType() {
        return this.labelPaintType;
    }

    public void setLabelPaintType(PaintType paintType) {
        this.labelPaintType = paintType;
    }

    public AttributedString getAttributedLabel() {
        return this.attributedLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getURLText() {
        return this.urlText;
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public PaintType getFillPaintType() {
        return this.fillPaintType;
    }

    public void setFillPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fillPaintType = paintType;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public float getLineStroke() {
        return this.lineStroke;
    }

    public PaintType getLinePaintType() {
        return this.linePaintType;
    }

    public void setLinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.linePaintType = paintType;
    }

    public PaintType getOutlinePaintType() {
        return this.outlinePaintType;
    }

    public void setOutlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaintType = paintType;
    }

    public float getOutlineStroke() {
        return this.outlineStroke;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public Shape getLine() {
        return this.line;
    }

    public GradientShaderFactory getFillShaderFactory() {
        return this.fillShaderFactory;
    }

    public void setFillShaderFactory(GradientShaderFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null 'transformer' attribute.");
        }
        this.fillShaderFactory = factory;
    }
}

