/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import java.io.Serializable;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;

public class AxisSpace
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2490732595134766305L;
    private double top = 0.0;
    private double bottom = 0.0;
    private double left = 0.0;
    private double right = 0.0;

    public double getTop() {
        return this.top;
    }

    public void setTop(double space) {
        this.top = space;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double space) {
        this.bottom = space;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double space) {
        this.left = space;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double space) {
        this.right = space;
    }

    public void add(double space, RectangleEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Null 'edge' argument.");
        }
        if (edge == RectangleEdge.TOP) {
            this.top += space;
        } else if (edge == RectangleEdge.BOTTOM) {
            this.bottom += space;
        } else if (edge == RectangleEdge.LEFT) {
            this.left += space;
        } else if (edge == RectangleEdge.RIGHT) {
            this.right += space;
        } else {
            throw new IllegalStateException("Unrecognised 'edge' argument.");
        }
    }

    public void ensureAtLeast(AxisSpace space) {
        this.top = Math.max(this.top, space.top);
        this.bottom = Math.max(this.bottom, space.bottom);
        this.left = Math.max(this.left, space.left);
        this.right = Math.max(this.right, space.right);
    }

    public void ensureAtLeast(double space, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            if (this.top < space) {
                this.top = space;
            }
        } else if (edge == RectangleEdge.BOTTOM) {
            if (this.bottom < space) {
                this.bottom = space;
            }
        } else if (edge == RectangleEdge.LEFT) {
            if (this.left < space) {
                this.left = space;
            }
        } else if (edge == RectangleEdge.RIGHT) {
            if (this.right < space) {
                this.right = space;
            }
        } else {
            throw new IllegalStateException("AxisSpace.ensureAtLeast(): unrecognised AxisLocation.");
        }
    }

    public RectShape shrink(RectShape area, RectShape result) {
        if (result == null) {
            result = new RectShape();
        }
        result.setRect((double)area.getX() + this.left, (double)area.getY() + this.top, (double)area.getWidth() - this.left - this.right, (double)area.getHeight() - this.top - this.bottom);
        return result;
    }

    public RectShape expand(RectShape area, RectShape result) {
        if (result == null) {
            result = new RectShape();
        }
        result.setRect((double)area.getX() - this.left, (double)area.getY() - this.top, (double)area.getWidth() + this.left + this.right, (double)area.getHeight() + this.top + this.bottom);
        return result;
    }

    public RectShape reserved(RectShape area, RectangleEdge edge) {
        RectShape result = null;
        if (edge == RectangleEdge.TOP) {
            result = new RectShape((double)area.getX(), (double)area.getY(), (double)area.getWidth(), this.top);
        } else if (edge == RectangleEdge.BOTTOM) {
            result = new RectShape((double)area.getX(), (double)area.getMaxY() - this.top, (double)area.getWidth(), this.bottom);
        } else if (edge == RectangleEdge.LEFT) {
            result = new RectShape((double)area.getX(), (double)area.getY(), this.left, (double)area.getHeight());
        } else if (edge == RectangleEdge.RIGHT) {
            result = new RectShape((double)area.getMaxX() - this.right, (double)area.getY(), this.right, (double)area.getHeight());
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AxisSpace)) {
            return false;
        }
        AxisSpace that = (AxisSpace)obj;
        if (this.top != that.top) {
            return false;
        }
        if (this.bottom != that.bottom) {
            return false;
        }
        if (this.left != that.left) {
            return false;
        }
        return this.right == that.right;
    }

    public int hashCode() {
        int result = 23;
        long l = Double.doubleToLongBits(this.top);
        result = 37 * result + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.bottom);
        result = 37 * result + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.left);
        result = 37 * result + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.right);
        result = 37 * result + (int)(l ^ l >>> 32);
        return result;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[left=" + this.left + ",right=" + this.right + ",top=" + this.top + ",bottom=" + this.bottom + "]";
    }
}

