/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.afree.chart.axis.AxisSpace;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.NumberTick;
import org.afree.chart.axis.PeriodAxisLabelInfo;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.event.AxisChangeEvent;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.ValueAxisPlot;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.data.time.Day;
import org.afree.data.time.Month;
import org.afree.data.time.RegularTimePeriod;
import org.afree.data.time.Year;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.io.SerialUtilities;
import org.afree.ui.RectangleEdge;
import org.afree.ui.TextAnchor;
import org.afree.util.PublicCloneable;

public class PeriodAxis
extends ValueAxis
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 8353295532075872069L;
    private RegularTimePeriod first;
    private RegularTimePeriod last;
    private TimeZone timeZone;
    private Locale locale;
    private Calendar calendar;
    private Class autoRangeTimePeriodClass;
    private Class majorTickTimePeriodClass;
    private boolean minorTickMarksVisible;
    private Class minorTickTimePeriodClass;
    private float minorTickMarkInsideLength = 0.0f;
    private float minorTickMarkOutsideLength = 2.0f;
    private transient float minorTickMarkStroke = 0.5f;
    private transient PaintType minorTickMarkPaintType = new SolidColor(-16777216);
    private transient PathEffect minorTickMarkEffect = null;
    private PeriodAxisLabelInfo[] labelInfo;

    public PeriodAxis(String label) {
        this(label, new Day(), new Day());
    }

    public PeriodAxis(String label, RegularTimePeriod first, RegularTimePeriod last) {
        this(label, first, last, TimeZone.getDefault(), Locale.getDefault());
    }

    public PeriodAxis(String label, RegularTimePeriod first, RegularTimePeriod last, TimeZone timeZone, Locale locale) {
        super(label, null);
        if (timeZone == null) {
            throw new IllegalArgumentException("Null 'timeZone' argument.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Null 'locale' argument.");
        }
        this.first = first;
        this.last = last;
        this.timeZone = timeZone;
        this.locale = locale;
        this.calendar = Calendar.getInstance(timeZone, locale);
        this.first.peg(this.calendar);
        this.last.peg(this.calendar);
        this.autoRangeTimePeriodClass = first.getClass();
        this.majorTickTimePeriodClass = first.getClass();
        this.minorTickMarksVisible = false;
        this.minorTickTimePeriodClass = RegularTimePeriod.downsize(this.majorTickTimePeriodClass);
        this.setAutoRange(true);
        this.labelInfo = new PeriodAxisLabelInfo[2];
        this.labelInfo[0] = new PeriodAxisLabelInfo(Month.class, new SimpleDateFormat("MMM", locale));
        this.labelInfo[1] = new PeriodAxisLabelInfo(Year.class, new SimpleDateFormat("yyyy", locale));
    }

    public RegularTimePeriod getFirst() {
        return this.first;
    }

    public void setFirst(RegularTimePeriod first) {
        if (first == null) {
            throw new IllegalArgumentException("Null 'first' argument.");
        }
        this.first = first;
        this.first.peg(this.calendar);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public RegularTimePeriod getLast() {
        return this.last;
    }

    public void setLast(RegularTimePeriod last) {
        if (last == null) {
            throw new IllegalArgumentException("Null 'last' argument.");
        }
        this.last = last;
        this.last.peg(this.calendar);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone zone) {
        if (zone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        this.timeZone = zone;
        this.calendar = Calendar.getInstance(zone, this.locale);
        this.first.peg(this.calendar);
        this.last.peg(this.calendar);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Class getAutoRangeTimePeriodClass() {
        return this.autoRangeTimePeriodClass;
    }

    public void setAutoRangeTimePeriodClass(Class c) {
        if (c == null) {
            throw new IllegalArgumentException("Null 'c' argument.");
        }
        this.autoRangeTimePeriodClass = c;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Class getMajorTickTimePeriodClass() {
        return this.majorTickTimePeriodClass;
    }

    public void setMajorTickTimePeriodClass(Class c) {
        if (c == null) {
            throw new IllegalArgumentException("Null 'c' argument.");
        }
        this.majorTickTimePeriodClass = c;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isMinorTickMarksVisible() {
        return this.minorTickMarksVisible;
    }

    public void setMinorTickMarksVisible(boolean visible) {
        this.minorTickMarksVisible = visible;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Class getMinorTickTimePeriodClass() {
        return this.minorTickTimePeriodClass;
    }

    public void setMinorTickTimePeriodClass(Class c) {
        if (c == null) {
            throw new IllegalArgumentException("Null 'c' argument.");
        }
        this.minorTickTimePeriodClass = c;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMinorTickMarkStroke() {
        return this.minorTickMarkStroke;
    }

    public void setMinorTickMarkStroke(float stroke) {
        if (stroke == 0.0f) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.minorTickMarkStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public PaintType getMinorTickMarkPaintType() {
        return this.minorTickMarkPaintType;
    }

    public void setMinorTickMarkPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.minorTickMarkPaintType = paintType;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public PathEffect getMinorTickMarkEffect() {
        return this.minorTickMarkEffect;
    }

    public void setMinorTickMarkEffect(PathEffect pathEffect) {
        this.minorTickMarkEffect = pathEffect;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMinorTickMarkInsideLength() {
        return this.minorTickMarkInsideLength;
    }

    public void setMinorTickMarkInsideLength(float length) {
        this.minorTickMarkInsideLength = length;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMinorTickMarkOutsideLength() {
        return this.minorTickMarkOutsideLength;
    }

    public void setMinorTickMarkOutsideLength(float length) {
        this.minorTickMarkOutsideLength = length;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public PeriodAxisLabelInfo[] getLabelInfo() {
        return this.labelInfo;
    }

    public void setLabelInfo(PeriodAxisLabelInfo[] info) {
        this.labelInfo = info;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setRange(Range range, boolean turnOffAutoRange, boolean notify) {
        long upper = Math.round(range.getUpperBound());
        long lower = Math.round(range.getLowerBound());
        this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(lower), this.timeZone, this.locale);
        this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(upper), this.timeZone, this.locale);
        super.setRange(new Range(this.first.getFirstMillisecond(), (double)this.last.getLastMillisecond() + 1.0), turnOffAutoRange, notify);
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public AxisSpace reserveSpace(Canvas canvas, Plot plot, RectShape plotArea, RectangleEdge edge, AxisSpace space) {
        if (space == null) {
            space = new AxisSpace();
        }
        if (!this.isVisible()) {
            return space;
        }
        double dimension = this.getFixedDimension();
        if (dimension > 0.0) {
            space.ensureAtLeast(dimension, edge);
        }
        RectShape labelEnclosure = this.getLabelEnclosure(canvas, edge);
        double labelHeight = 0.0;
        double labelWidth = 0.0;
        double tickLabelBandsDimension = 0.0;
        int i = 0;
        while (i < this.labelInfo.length) {
            PeriodAxisLabelInfo info = this.labelInfo[i];
            Paint paint = PaintUtility.createPaint(1, info.getLabelPaintType(), info.getLabelFont());
            Paint.FontMetrics fm = paint.getFontMetrics();
            tickLabelBandsDimension += info.getPadding().extendHeight(fm.bottom - fm.top);
            ++i;
        }
        if (RectangleEdge.isTopOrBottom(edge)) {
            labelHeight = labelEnclosure.getHeight();
            space.add(labelHeight + tickLabelBandsDimension, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            labelWidth = labelEnclosure.getWidth();
            space.add(labelWidth + tickLabelBandsDimension, edge);
        }
        double tickMarkSpace = 0.0;
        if (this.isTickMarksVisible()) {
            tickMarkSpace = this.getTickMarkOutsideLength();
        }
        if (this.minorTickMarksVisible) {
            tickMarkSpace = Math.max(tickMarkSpace, (double)this.minorTickMarkOutsideLength);
        }
        space.add(tickMarkSpace, edge);
        return space;
    }

    public AxisState draw(Canvas canvas, double cursor, RectShape plotArea, RectShape dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        AxisState axisState = new AxisState(cursor);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(canvas, cursor, dataArea, edge);
        }
        if (this.isTickMarksVisible()) {
            this.drawTickMarks(canvas, axisState, dataArea, edge);
        }
        if (this.isTickLabelsVisible()) {
            int band = 0;
            while (band < this.labelInfo.length) {
                axisState = this.drawTickLabels(band, canvas, axisState, dataArea, edge);
                ++band;
            }
        }
        axisState = this.drawLabel(this.getLabel(), canvas, plotArea, dataArea, edge, axisState);
        return axisState;
    }

    protected void drawTickMarks(Canvas canvas, AxisState state, RectShape dataArea, RectangleEdge edge) {
        if (RectangleEdge.isTopOrBottom(edge)) {
            this.drawTickMarksHorizontal(canvas, state, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            this.drawTickMarksVertical(canvas, state, dataArea, edge);
        }
    }

    protected void drawTickMarksHorizontal(Canvas canvas, AxisState state, RectShape dataArea, RectangleEdge edge) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        double x0 = dataArea.getX();
        double y0 = state.getCursor();
        double insideLength = this.getTickMarkInsideLength();
        double outsideLength = this.getTickMarkOutsideLength();
        RegularTimePeriod t = this.createInstance(this.majorTickTimePeriodClass, this.first.getStart(), this.getTimeZone(), this.locale);
        long t0 = t.getFirstMillisecond();
        LineShape inside = null;
        LineShape outside = null;
        long firstOnAxis = this.getFirst().getFirstMillisecond();
        long lastOnAxis = this.getLast().getLastMillisecond() + 1L;
        while (t0 <= lastOnAxis) {
            ticks.add(new NumberTick(new Double(t0), "", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            x0 = this.valueToJava2D(t0, dataArea, edge);
            if (edge == RectangleEdge.TOP) {
                inside = new LineShape(x0, y0, x0, y0 + insideLength);
                outside = new LineShape(x0, y0, x0, y0 - outsideLength);
            } else if (edge == RectangleEdge.BOTTOM) {
                inside = new LineShape(x0, y0, x0, y0 - insideLength);
                outside = new LineShape(x0, y0, x0, y0 + outsideLength);
            }
            if (t0 >= firstOnAxis) {
                Paint paint = PaintUtility.createPaint(1, this.getTickMarkPaintType(), this.getTickMarkStroke(), this.getTickMarkEffect());
                canvas.drawLine(inside.getX1(), inside.getY1(), inside.getX2(), inside.getY2(), paint);
                canvas.drawLine(outside.getX1(), outside.getY1(), outside.getX2(), outside.getY2(), paint);
            }
            if (this.minorTickMarksVisible) {
                RegularTimePeriod tminor = this.createInstance(this.minorTickTimePeriodClass, new Date(t0), this.getTimeZone(), this.locale);
                long tt0 = tminor.getFirstMillisecond();
                while (tt0 < t.getLastMillisecond() && tt0 < lastOnAxis) {
                    double xx0 = this.valueToJava2D(tt0, dataArea, edge);
                    if (edge == RectangleEdge.TOP) {
                        inside = new LineShape(xx0, y0, xx0, y0 + (double)this.minorTickMarkInsideLength);
                        outside = new LineShape(xx0, y0, xx0, y0 - (double)this.minorTickMarkOutsideLength);
                    } else if (edge == RectangleEdge.BOTTOM) {
                        inside = new LineShape(xx0, y0, xx0, y0 - (double)this.minorTickMarkInsideLength);
                        outside = new LineShape(xx0, y0, xx0, y0 + (double)this.minorTickMarkOutsideLength);
                    }
                    if (tt0 >= firstOnAxis) {
                        Paint paint = PaintUtility.createPaint(1, this.getMinorTickMarkPaintType(), this.getMinorTickMarkStroke(), this.getMinorTickMarkEffect());
                        canvas.drawLine(inside.getX1(), inside.getY1(), inside.getX2(), inside.getY2(), paint);
                        canvas.drawLine(outside.getX1(), outside.getY1(), outside.getX2(), outside.getY2(), paint);
                    }
                    tminor = tminor.next();
                    tminor.peg(this.calendar);
                    tt0 = tminor.getFirstMillisecond();
                }
            }
            t = t.next();
            t.peg(this.calendar);
            t0 = t.getFirstMillisecond();
        }
        if (edge == RectangleEdge.TOP) {
            state.cursorUp(Math.max(outsideLength, (double)this.minorTickMarkOutsideLength));
        } else if (edge == RectangleEdge.BOTTOM) {
            state.cursorDown(Math.max(outsideLength, (double)this.minorTickMarkOutsideLength));
        }
        state.setTicks(ticks);
    }

    protected void drawTickMarksVertical(Canvas canvas, AxisState state, RectShape dataArea, RectangleEdge edge) {
    }

    protected AxisState drawTickLabels(int band, Canvas canvas, AxisState state, RectShape dataArea, RectangleEdge edge) {
        double delta1 = 0.0;
        Paint paint = PaintUtility.createPaint(1, this.labelInfo[band].getLabelPaintType(), this.labelInfo[band].getLabelFont());
        Paint.FontMetrics fm = paint.getFontMetrics();
        if (edge == RectangleEdge.BOTTOM) {
            delta1 = this.labelInfo[band].getPadding().calculateTopOutset(fm.bottom - fm.top);
        } else if (edge == RectangleEdge.TOP) {
            delta1 = this.labelInfo[band].getPadding().calculateBottomOutset(fm.bottom - fm.top);
        }
        state.moveCursor(delta1, edge);
        long axisMin = this.first.getFirstMillisecond();
        long axisMax = this.last.getLastMillisecond();
        RegularTimePeriod p1 = this.labelInfo[band].createInstance(new Date(axisMin), this.timeZone, this.locale);
        RegularTimePeriod p2 = this.labelInfo[band].createInstance(new Date(axisMax), this.timeZone, this.locale);
        String label1 = this.labelInfo[band].getDateFormat().format(new Date(p1.getMiddleMillisecond()));
        String label2 = this.labelInfo[band].getDateFormat().format(new Date(p2.getMiddleMillisecond()));
        RectShape b1 = TextUtilities.getTextBounds(label1, paint);
        RectShape b2 = TextUtilities.getTextBounds(label2, paint);
        double w = Math.max(b1.getWidth(), b2.getWidth());
        long ww = Math.round(this.java2DToValue((double)dataArea.getX() + w + 5.0, dataArea, edge));
        ww = this.isInverted() ? axisMax - ww : (ww -= axisMin);
        long length = p1.getLastMillisecond() - p1.getFirstMillisecond();
        int periods = (int)(ww / length) + 1;
        RegularTimePeriod p = this.labelInfo[band].createInstance(new Date(axisMin), this.timeZone, this.locale);
        RectShape b = null;
        long lastXX = 0L;
        float y = (float)state.getCursor();
        TextAnchor anchor = TextAnchor.TOP_CENTER;
        float yDelta = b1.getHeight();
        if (edge == RectangleEdge.TOP) {
            anchor = TextAnchor.BOTTOM_CENTER;
            yDelta = -yDelta;
        }
        while (p.getFirstMillisecond() <= axisMax) {
            RectShape bb;
            float x = (float)this.valueToJava2D(p.getMiddleMillisecond(), dataArea, edge);
            DateFormat df = this.labelInfo[band].getDateFormat();
            String label = df.format(new Date(p.getMiddleMillisecond()));
            long first = p.getFirstMillisecond();
            long last = p.getLastMillisecond();
            if (last > axisMax && x + (bb = TextUtilities.getTextBounds(label, paint)).getWidth() / 2.0f > dataArea.getMaxX()) {
                float xstart = (float)this.valueToJava2D(Math.max(first, axisMin), dataArea, edge);
                if (bb.getWidth() < dataArea.getMaxX() - xstart) {
                    x = (dataArea.getMaxX() + xstart) / 2.0f;
                } else {
                    label = null;
                }
            }
            if (first < axisMin && x - (bb = TextUtilities.getTextBounds(label, paint)).getWidth() / 2.0f < dataArea.getX()) {
                float xlast = (float)this.valueToJava2D(Math.min(last, axisMax), dataArea, edge);
                if (bb.getWidth() < xlast - dataArea.getX()) {
                    x = (xlast + dataArea.getX()) / 2.0f;
                } else {
                    label = null;
                }
            }
            if (label != null) {
                PaintUtility.updatePaint(paint, this.labelInfo[band].getLabelPaintType());
                b = TextUtilities.drawAlignedString(label, canvas, x, y, anchor, paint);
            }
            if (lastXX > 0L && this.labelInfo[band].getDrawDividers()) {
                long nextXX = p.getFirstMillisecond();
                long mid = (lastXX + nextXX) / 2L;
                float mid2d = (float)this.valueToJava2D(mid, dataArea, edge);
                paint.setStrokeWidth(this.labelInfo[band].getDividerStroke());
                PaintUtility.updatePaint(paint, this.labelInfo[band].getDividerPaintType());
                canvas.drawLine(mid2d, y, mid2d, y + yDelta, paint);
            }
            lastXX = last;
            int i = 0;
            while (i < periods) {
                p = p.next();
                ++i;
            }
            p.peg(this.calendar);
        }
        double used = 0.0;
        if (b != null) {
            used = b.getHeight();
            if (edge == RectangleEdge.BOTTOM) {
                used += this.labelInfo[band].getPadding().calculateBottomOutset(fm.bottom - fm.top);
            } else if (edge == RectangleEdge.TOP) {
                used += this.labelInfo[band].getPadding().calculateTopOutset(fm.bottom - fm.top);
            }
        }
        state.moveCursor(used, edge);
        return state;
    }

    public List refreshTicks(Canvas canvas, AxisState state, RectShape dataArea, RectangleEdge edge) {
        return Collections.EMPTY_LIST;
    }

    public double valueToJava2D(double value, RectShape area, RectangleEdge edge) {
        double result = Double.NaN;
        double axisMin = this.first.getFirstMillisecond();
        double axisMax = this.last.getLastMillisecond();
        if (RectangleEdge.isTopOrBottom(edge)) {
            double minX = area.getX();
            double maxX = area.getMaxX();
            result = this.isInverted() ? maxX + (value - axisMin) / (axisMax - axisMin) * (minX - maxX) : minX + (value - axisMin) / (axisMax - axisMin) * (maxX - minX);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            double minY = area.getMinY();
            double maxY = area.getMaxY();
            result = this.isInverted() ? minY + (value - axisMin) / (axisMax - axisMin) * (maxY - minY) : maxY - (value - axisMin) / (axisMax - axisMin) * (maxY - minY);
        }
        return result;
    }

    public double java2DToValue(double java2DValue, RectShape area, RectangleEdge edge) {
        double result = Double.NaN;
        double min = 0.0;
        double max = 0.0;
        double axisMin = this.first.getFirstMillisecond();
        double axisMax = this.last.getLastMillisecond();
        if (RectangleEdge.isTopOrBottom(edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            min = area.getMaxY();
            max = area.getY();
        }
        result = this.isInverted() ? axisMax - (java2DValue - min) / (max - min) * (axisMax - axisMin) : axisMin + (java2DValue - min) / (max - min) * (axisMax - axisMin);
        return result;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot vap = (ValueAxisPlot)((Object)plot);
            Range r = vap.getDataRange(this);
            if (r == null) {
                r = this.getDefaultAutoRange();
            }
            long upper = Math.round(r.getUpperBound());
            long lower = Math.round(r.getLowerBound());
            this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(lower), this.timeZone, this.locale);
            this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(upper), this.timeZone, this.locale);
            this.setRange(r, false, false);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PeriodAxis)) {
            return false;
        }
        PeriodAxis that = (PeriodAxis)obj;
        if (!this.first.equals(that.first)) {
            return false;
        }
        if (!this.last.equals(that.last)) {
            return false;
        }
        if (!this.timeZone.equals(that.timeZone)) {
            return false;
        }
        if (!this.locale.equals(that.locale)) {
            return false;
        }
        if (!this.autoRangeTimePeriodClass.equals(that.autoRangeTimePeriodClass)) {
            return false;
        }
        if (this.isMinorTickMarksVisible() != that.isMinorTickMarksVisible()) {
            return false;
        }
        if (!this.majorTickTimePeriodClass.equals(that.majorTickTimePeriodClass)) {
            return false;
        }
        if (!this.minorTickTimePeriodClass.equals(that.minorTickTimePeriodClass)) {
            return false;
        }
        if (!this.minorTickMarkPaintType.equals(that.minorTickMarkPaintType)) {
            return false;
        }
        if (this.minorTickMarkStroke != that.minorTickMarkStroke) {
            return false;
        }
        if (!Arrays.equals(this.labelInfo, that.labelInfo)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getLabel() != null) {
            return this.getLabel().hashCode();
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        PeriodAxis clone = (PeriodAxis)super.clone();
        clone.timeZone = (TimeZone)this.timeZone.clone();
        clone.labelInfo = new PeriodAxisLabelInfo[this.labelInfo.length];
        int i = 0;
        while (i < this.labelInfo.length) {
            clone.labelInfo[i] = this.labelInfo[i];
            ++i;
        }
        return clone;
    }

    private RegularTimePeriod createInstance(Class periodClass, Date millisecond, TimeZone zone, Locale locale) {
        RegularTimePeriod result = null;
        try {
            Constructor c = periodClass.getDeclaredConstructor(Date.class, TimeZone.class, Locale.class);
            result = (RegularTimePeriod)c.newInstance(millisecond, zone, locale);
        }
        catch (Exception e) {
            try {
                Constructor c = periodClass.getDeclaredConstructor(Date.class);
                result = (RegularTimePeriod)c.newInstance(millisecond);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.minorTickMarkPaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.minorTickMarkPaintType = SerialUtilities.readPaintType(stream);
    }
}

