/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.NumberAxis;
import org.afree.chart.axis.NumberTick;
import org.afree.chart.axis.ValueTick;
import org.afree.chart.event.AxisChangeEvent;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.ValueAxisPlot;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;
import org.afree.ui.TextAnchor;
import org.afree.util.PaintTypeUtilities;

public class SymbolAxis
extends NumberAxis
implements Serializable {
    private static final long serialVersionUID = 7216330468770619716L;
    public static final PaintType DEFAULT_GRID_BAND_PAINT_TYPE = new SolidColor(Color.argb((int)128, (int)232, (int)234, (int)232));
    public static final PaintType DEFAULT_GRID_BAND_ALTERNATE_PAINT_TYPE = new SolidColor(Color.argb((int)0, (int)0, (int)0, (int)0));
    private List symbols;
    private boolean gridBandsVisible;
    private transient PaintType gridBandPaintType;
    private transient PaintType gridBandAlternatePaintType;

    public SymbolAxis(String label, String[] sv) {
        super(label);
        this.symbols = Arrays.asList(sv);
        this.gridBandsVisible = true;
        this.gridBandPaintType = DEFAULT_GRID_BAND_PAINT_TYPE;
        this.gridBandAlternatePaintType = DEFAULT_GRID_BAND_ALTERNATE_PAINT_TYPE;
        this.setAutoTickUnitSelection(false, false);
        this.setAutoRangeStickyZero(false);
    }

    public String[] getSymbols() {
        String[] result = new String[this.symbols.size()];
        result = this.symbols.toArray(result);
        return result;
    }

    public boolean isGridBandsVisible() {
        return this.gridBandsVisible;
    }

    public void setGridBandsVisible(boolean flag) {
        if (this.gridBandsVisible != flag) {
            this.gridBandsVisible = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public PaintType getGridBandPaintType() {
        return this.gridBandPaintType;
    }

    public void setGridBandPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandPaintType = paintType;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public PaintType getGridBandAlternatePaintType() {
        return this.gridBandAlternatePaintType;
    }

    public void setGridBandAlternatePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandAlternatePaintType = paintType;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void selectAutoTickUnit(Canvas canvas, RectShape dataArea, RectangleEdge edge) {
        throw new UnsupportedOperationException();
    }

    public AxisState draw(Canvas canvas, double cursor, RectShape plotArea, RectShape dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        AxisState info = new AxisState(cursor);
        if (this.isVisible()) {
            info = super.draw(canvas, cursor, plotArea, dataArea, edge, plotState);
        }
        if (this.gridBandsVisible) {
            this.drawGridBands(canvas, plotArea, dataArea, edge, info.getTicks());
        }
        return info;
    }

    protected void drawGridBands(Canvas canvas, RectShape plotArea, RectShape dataArea, RectangleEdge edge, List ticks) {
        canvas.save();
        canvas.clipRect(dataArea.getRectF());
        if (RectangleEdge.isTopOrBottom(edge)) {
            this.drawGridBandsHorizontal(canvas, plotArea, dataArea, true, ticks);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            this.drawGridBandsVertical(canvas, plotArea, dataArea, true, ticks);
        }
        canvas.restore();
    }

    protected void drawGridBandsHorizontal(Canvas canvas, RectShape plotArea, RectShape dataArea, boolean firstGridBandIsDark, List ticks) {
        boolean currentGridBandIsDark = firstGridBandIsDark;
        double yy = dataArea.getY();
        float outlineStrokeWidth = this.getPlot().getOutlineStroke() != 0.0f ? this.getPlot().getOutlineStroke() : 1.0f;
        for (ValueTick tick : ticks) {
            double xx1 = this.valueToJava2D(tick.getValue() - 0.5, dataArea, RectangleEdge.BOTTOM);
            double xx2 = this.valueToJava2D(tick.getValue() + 0.5, dataArea, RectangleEdge.BOTTOM);
            PaintType paintType = currentGridBandIsDark ? this.gridBandPaintType : this.gridBandAlternatePaintType;
            Paint paint = PaintUtility.createPaint(1, paintType);
            RectShape band = new RectShape(xx1, yy + (double)outlineStrokeWidth, xx2 - xx1, (double)dataArea.getMaxY() - yy - (double)outlineStrokeWidth);
            band.fill(canvas, paint);
            boolean bl = currentGridBandIsDark = !currentGridBandIsDark;
        }
    }

    protected void drawGridBandsVertical(Canvas canvas, RectShape drawArea, RectShape plotArea, boolean firstGridBandIsDark, List ticks) {
        boolean currentGridBandIsDark = firstGridBandIsDark;
        double xx = plotArea.getX();
        float outlineStroke = this.getPlot().getOutlineStroke();
        double outlineStrokeWidth = outlineStroke != 0.0f ? (double)outlineStroke : 1.0;
        for (ValueTick tick : ticks) {
            double yy1 = this.valueToJava2D(tick.getValue() + 0.5, plotArea, RectangleEdge.LEFT);
            double yy2 = this.valueToJava2D(tick.getValue() - 0.5, plotArea, RectangleEdge.LEFT);
            PaintType paintType = currentGridBandIsDark ? this.gridBandPaintType : this.gridBandAlternatePaintType;
            Paint paint = PaintUtility.createPaint(1, paintType);
            RectShape band = new RectShape(xx + outlineStrokeWidth, yy1, (double)plotArea.getMaxX() - xx - outlineStrokeWidth, yy2 - yy1);
            band.fill(canvas, paint);
            boolean bl = currentGridBandIsDark = !currentGridBandIsDark;
        }
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double minRange;
            double lower;
            double upper = this.symbols.size() - 1;
            double range = upper - (lower = 0.0);
            if (range < (minRange = this.getAutoRangeMinimumSize())) {
                upper = (upper + lower + minRange) / 2.0;
                lower = (upper + lower - minRange) / 2.0;
            }
            double upperMargin = 0.5;
            double lowerMargin = 0.5;
            if (this.getAutoRangeIncludesZero()) {
                if (this.getAutoRangeStickyZero()) {
                    upper = upper <= 0.0 ? 0.0 : (upper += upperMargin);
                    lower = lower >= 0.0 ? 0.0 : (lower -= lowerMargin);
                } else {
                    upper = Math.max(0.0, upper + upperMargin);
                    lower = Math.min(0.0, lower - lowerMargin);
                }
            } else if (this.getAutoRangeStickyZero()) {
                upper = upper <= 0.0 ? Math.min(0.0, upper + upperMargin) : (upper += upperMargin * range);
                lower = lower >= 0.0 ? Math.max(0.0, lower - lowerMargin) : (lower -= lowerMargin);
            } else {
                upper += upperMargin;
                lower -= lowerMargin;
            }
            this.setRange(new Range(lower, upper), false, false);
        }
    }

    public List refreshTicks(Canvas canvas, AxisState state, RectShape dataArea, RectangleEdge edge) {
        List ticks = null;
        if (RectangleEdge.isTopOrBottom(edge)) {
            ticks = this.refreshTicksHorizontal(canvas, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            ticks = this.refreshTicksVertical(canvas, dataArea, edge);
        }
        return ticks;
    }

    protected List refreshTicksHorizontal(Canvas canvas, RectShape dataArea, RectangleEdge edge) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        Paint labelPaint = PaintUtility.createPaint(1, this.getTickLabelPaintType(), this.getTickLabelFont());
        double size = this.getTickUnit().getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        double previousDrawnTickLabelPos = 0.0;
        double previousDrawnTickLabelLength = 0.0;
        if (count <= 500) {
            int i = 0;
            while (i < count) {
                double currentTickValue = lowestTickValue + (double)i * size;
                double xx = this.valueToJava2D(currentTickValue, dataArea, edge);
                NumberFormat formatter = this.getNumberFormatOverride();
                String tickLabel = formatter != null ? formatter.format(currentTickValue) : this.valueToString(currentTickValue);
                RectShape bounds = TextUtilities.getTextBounds(tickLabel, labelPaint);
                double tickLabelLength = this.isVerticalTickLabels() ? bounds.getHeight() : bounds.getWidth();
                boolean tickLabelsOverlapping = false;
                if (i > 0) {
                    double avgTickLabelLength = (previousDrawnTickLabelLength + tickLabelLength) / 2.0;
                    if (Math.abs(xx - previousDrawnTickLabelPos) < avgTickLabelLength) {
                        tickLabelsOverlapping = true;
                    }
                }
                if (tickLabelsOverlapping) {
                    tickLabel = "";
                } else {
                    previousDrawnTickLabelPos = xx;
                    previousDrawnTickLabelLength = tickLabelLength;
                }
                TextAnchor anchor = null;
                TextAnchor rotationAnchor = null;
                double angle = 0.0;
                if (this.isVerticalTickLabels()) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                    angle = edge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (edge == RectangleEdge.TOP) {
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    anchor = TextAnchor.TOP_CENTER;
                    rotationAnchor = TextAnchor.TOP_CENTER;
                }
                NumberTick tick = new NumberTick(new Double(currentTickValue), tickLabel, anchor, rotationAnchor, angle);
                ticks.add(tick);
                ++i;
            }
        }
        return ticks;
    }

    protected List refreshTicksVertical(Canvas canvas, RectShape dataArea, RectangleEdge edge) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        Paint labelPaint = PaintUtility.createPaint(1, this.getTickLabelPaintType(), this.getTickLabelFont());
        double size = this.getTickUnit().getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        double previousDrawnTickLabelPos = 0.0;
        double previousDrawnTickLabelLength = 0.0;
        if (count <= 500) {
            int i = 0;
            while (i < count) {
                double currentTickValue = lowestTickValue + (double)i * size;
                double yy = this.valueToJava2D(currentTickValue, dataArea, edge);
                NumberFormat formatter = this.getNumberFormatOverride();
                String tickLabel = formatter != null ? formatter.format(currentTickValue) : this.valueToString(currentTickValue);
                RectShape bounds = TextUtilities.getTextBounds(tickLabel, labelPaint);
                double tickLabelLength = this.isVerticalTickLabels() ? bounds.getWidth() : bounds.getHeight();
                boolean tickLabelsOverlapping = false;
                if (i > 0) {
                    double avgTickLabelLength = (previousDrawnTickLabelLength + tickLabelLength) / 2.0;
                    if (Math.abs(yy - previousDrawnTickLabelPos) < avgTickLabelLength) {
                        tickLabelsOverlapping = true;
                    }
                }
                if (tickLabelsOverlapping) {
                    tickLabel = "";
                } else {
                    previousDrawnTickLabelPos = yy;
                    previousDrawnTickLabelLength = tickLabelLength;
                }
                TextAnchor anchor = null;
                TextAnchor rotationAnchor = null;
                double angle = 0.0;
                if (this.isVerticalTickLabels()) {
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                    angle = edge == RectangleEdge.LEFT ? -1.5707963267948966 : 1.5707963267948966;
                } else if (edge == RectangleEdge.LEFT) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    anchor = TextAnchor.CENTER_LEFT;
                    rotationAnchor = TextAnchor.CENTER_LEFT;
                }
                NumberTick tick = new NumberTick(new Double(currentTickValue), tickLabel, anchor, rotationAnchor, angle);
                ticks.add(tick);
                ++i;
            }
        }
        return ticks;
    }

    public String valueToString(double value) {
        String strToReturn;
        try {
            strToReturn = (String)this.symbols.get((int)value);
        }
        catch (IndexOutOfBoundsException ex) {
            strToReturn = "";
        }
        return strToReturn;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SymbolAxis)) {
            return false;
        }
        SymbolAxis that = (SymbolAxis)obj;
        if (!this.symbols.equals(that.symbols)) {
            return false;
        }
        if (this.gridBandsVisible != that.gridBandsVisible) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.gridBandPaintType, that.gridBandPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.gridBandAlternatePaintType, that.gridBandAlternatePaintType)) {
            return false;
        }
        return super.equals(obj);
    }
}

