/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import java.io.Serializable;
import java.util.List;
import org.afree.chart.axis.Axis;
import org.afree.chart.axis.AxisSpace;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.Tick;
import org.afree.chart.axis.TickType;
import org.afree.chart.axis.TickUnitSource;
import org.afree.chart.axis.ValueTick;
import org.afree.chart.event.AxisChangeEvent;
import org.afree.chart.plot.Plot;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.Polygon;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;

public abstract class ValueAxis
extends Axis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3698345477322391456L;
    public static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final boolean DEFAULT_INVERTED = false;
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE = 1.0E-8;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;
    public static final int MAXIMUM_TICK_COUNT = 500;
    private boolean positiveArrowVisible = false;
    private boolean negativeArrowVisible = false;
    private transient Shape upArrow;
    private transient Shape downArrow;
    private transient Shape leftArrow;
    private transient Shape rightArrow;
    protected boolean mInverted = false;
    protected Range mRange;
    private boolean autoRange = true;
    private double autoRangeMinimumSize = 1.0E-8;
    private Range defaultAutoRange;
    private double upperMargin = 0.05;
    private double lowerMargin = 0.05;
    private double fixedAutoRange = 0.0;
    private boolean autoTickUnitSelection = true;
    private TickUnitSource standardTickUnits;
    private int autoTickIndex;
    private int minorTickCount;
    private boolean verticalTickLabels;
    private boolean limitAble = false;
    private Range limitRange = null;
    private LineShape mWorkLineShape = new LineShape();

    protected ValueAxis(String label, TickUnitSource standardTickUnits) {
        super(label);
        this.mRange = DEFAULT_RANGE;
        this.defaultAutoRange = DEFAULT_RANGE;
        this.standardTickUnits = standardTickUnits;
        Polygon p1 = new Polygon();
        p1.addPoint(0.0f, 0.0f);
        p1.addPoint(-2.0f, 2.0f);
        p1.addPoint(2.0f, 2.0f);
        this.upArrow = p1;
        Polygon p2 = new Polygon();
        p2.addPoint(0.0f, 0.0f);
        p2.addPoint(-2.0f, -2.0f);
        p2.addPoint(2.0f, -2.0f);
        this.downArrow = p2;
        Polygon p3 = new Polygon();
        p3.addPoint(0.0f, 0.0f);
        p3.addPoint(-2.0f, -2.0f);
        p3.addPoint(-2.0f, 2.0f);
        this.rightArrow = p3;
        Polygon p4 = new Polygon();
        p4.addPoint(0.0f, 0.0f);
        p4.addPoint(2.0f, -2.0f);
        p4.addPoint(2.0f, 2.0f);
        this.leftArrow = p4;
        this.verticalTickLabels = false;
        this.minorTickCount = 0;
    }

    public boolean isVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean flag) {
        if (this.verticalTickLabels != flag) {
            this.verticalTickLabels = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isPositiveArrowVisible() {
        return this.positiveArrowVisible;
    }

    public void setPositiveArrowVisible(boolean visible) {
        this.positiveArrowVisible = visible;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isNegativeArrowVisible() {
        return this.negativeArrowVisible;
    }

    public void setNegativeArrowVisible(boolean visible) {
        this.negativeArrowVisible = visible;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getUpArrow() {
        return this.upArrow;
    }

    public void setUpArrow(Shape arrow) {
        if (arrow == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.upArrow = arrow;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getDownArrow() {
        return this.downArrow;
    }

    public void setDownArrow(Shape arrow) {
        if (arrow == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.downArrow = arrow;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getLeftArrow() {
        return this.leftArrow;
    }

    public void setLeftArrow(Shape arrow) {
        if (arrow == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.leftArrow = arrow;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getRightArrow() {
        return this.rightArrow;
    }

    public void setRightArrow(Shape arrow) {
        if (arrow == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.rightArrow = arrow;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void drawAxisLine(Canvas canvas, double cursor, RectShape dataArea, RectangleEdge edge) {
        Shape shape;
        Matrix mat;
        Shape arrow;
        double y;
        double x;
        LineShape axisLine = this.mWorkLineShape;
        if (edge == RectangleEdge.TOP) {
            axisLine.setLine((double)dataArea.getX(), cursor, (double)dataArea.getMaxX(), cursor);
        } else if (edge == RectangleEdge.BOTTOM) {
            axisLine.setLine((double)dataArea.getX(), cursor, (double)dataArea.getMaxX(), cursor);
        } else if (edge == RectangleEdge.LEFT) {
            axisLine.setLine(cursor, (double)dataArea.getY(), cursor, (double)dataArea.getMaxY());
        } else if (edge == RectangleEdge.RIGHT) {
            axisLine.setLine(cursor, (double)dataArea.getY(), cursor, (double)dataArea.getMaxY());
        }
        Paint p = PaintUtility.createPaint(this.getAxisLinePaintType(), this.getAxisLineStroke(), this.getAxisLineEffect());
        axisLine.draw(canvas, p);
        boolean drawUpOrRight = false;
        boolean drawDownOrLeft = false;
        if (this.positiveArrowVisible) {
            if (this.mInverted) {
                drawDownOrLeft = true;
            } else {
                drawUpOrRight = true;
            }
        }
        if (this.negativeArrowVisible) {
            if (this.mInverted) {
                drawUpOrRight = true;
            } else {
                drawDownOrLeft = true;
            }
        }
        if (drawUpOrRight) {
            x = 0.0;
            y = 0.0;
            arrow = null;
            if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
                x = dataArea.getMaxX();
                y = cursor;
                arrow = this.rightArrow;
            } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
                x = cursor;
                y = dataArea.getMinY();
                arrow = this.upArrow;
            }
            mat = new Matrix();
            mat.postTranslate((float)x, (float)y);
            shape = arrow.clone();
            shape.getPath().transform(mat);
            shape.draw(canvas, p);
        }
        if (drawDownOrLeft) {
            x = 0.0;
            y = 0.0;
            arrow = null;
            if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
                x = dataArea.getMinX();
                y = cursor;
                arrow = this.leftArrow;
            } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
                x = cursor;
                y = dataArea.getMaxY();
                arrow = this.downArrow;
            }
            mat = new Matrix();
            mat.postTranslate((float)x, (float)y);
            shape = arrow.clone();
            shape.getPath().transform(mat);
            shape.draw(canvas, p);
        }
    }

    protected float[] calculateAnchorPoint(ValueTick tick, double cursor, RectShape dataArea, RectangleEdge edge, Paint paint) {
        RectangleInsets insets = this.getTickLabelInsets();
        float[] result = new float[2];
        if (edge == RectangleEdge.TOP) {
            result[0] = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
            result[1] = (float)(cursor - insets.getBottom() - 2.0);
        } else if (edge == RectangleEdge.BOTTOM) {
            result[0] = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
            result[1] = (float)(cursor + insets.getTop() + 2.0);
        } else if (edge == RectangleEdge.LEFT) {
            result[0] = (float)(cursor - insets.getLeft() - 2.0);
            result[1] = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
        } else if (edge == RectangleEdge.RIGHT) {
            result[0] = (float)(cursor + insets.getRight() + 2.0);
            result[1] = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
        }
        return result;
    }

    protected AxisState drawTickMarksAndLabels(Canvas canvas, double cursor, RectShape plotArea, RectShape dataArea, RectangleEdge edge) {
        AxisState state = new AxisState(cursor);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(canvas, cursor, dataArea, edge);
        }
        List ticks = this.refreshTicks(canvas, state, dataArea, edge);
        state.setTicks(ticks);
        Paint tickPaint = PaintUtility.createPaint(1, this.getTickLabelPaintType(), this.getTickLabelFont());
        Paint tickMark = PaintUtility.createPaint(1, this.getTickMarkPaintType(), this.getTickMarkStroke(), this.getTickMarkEffect());
        for (ValueTick tick : ticks) {
            if (this.isTickLabelsVisible()) {
                float[] anchorPoint = this.calculateAnchorPoint(tick, cursor, dataArea, edge, tickPaint);
                TextUtilities.drawRotatedString(tick.getText(), canvas, anchorPoint[0], anchorPoint[1], tick.getTextAnchor(), tick.getAngle(), tick.getRotationAnchor(), tickPaint);
            }
            if ((!this.isTickMarksVisible() || !tick.getTickType().equals(TickType.MAJOR)) && (!this.isMinorTickMarksVisible() || !tick.getTickType().equals(TickType.MINOR))) continue;
            double ol = tick.getTickType().equals(TickType.MINOR) ? this.getMinorTickMarkOutsideLength() : this.getTickMarkOutsideLength();
            double il = tick.getTickType().equals(TickType.MINOR) ? this.getMinorTickMarkInsideLength() : this.getTickMarkInsideLength();
            float xx = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
            LineShape mark = this.mWorkLineShape;
            if (edge == RectangleEdge.LEFT) {
                mark.setLine(cursor - ol, (double)xx, cursor + il, (double)xx);
            } else if (edge == RectangleEdge.RIGHT) {
                mark.setLine(cursor + ol, (double)xx, cursor - il, (double)xx);
            } else if (edge == RectangleEdge.TOP) {
                mark.setLine((double)xx, cursor - ol, (double)xx, cursor + il);
            } else if (edge == RectangleEdge.BOTTOM) {
                mark.setLine((double)xx, cursor + ol, (double)xx, cursor - il);
            }
            mark.draw(canvas, tickMark);
        }
        double used = 0.0;
        if (this.isTickLabelsVisible()) {
            if (edge == RectangleEdge.LEFT) {
                state.cursorLeft(used += this.findMaximumTickLabelWidth(ticks, canvas, plotArea, this.isVerticalTickLabels()));
            } else if (edge == RectangleEdge.RIGHT) {
                used = this.findMaximumTickLabelWidth(ticks, canvas, plotArea, this.isVerticalTickLabels());
                state.cursorRight(used);
            } else if (edge == RectangleEdge.TOP) {
                used = this.findMaximumTickLabelHeight(ticks, canvas, plotArea, this.isVerticalTickLabels());
                state.cursorUp(used);
            } else if (edge == RectangleEdge.BOTTOM) {
                used = this.findMaximumTickLabelHeight(ticks, canvas, plotArea, this.isVerticalTickLabels());
                state.cursorDown(used);
            }
        }
        return state;
    }

    public AxisSpace reserveSpace(Canvas canvas, Plot plot, RectShape plotArea, RectangleEdge edge, AxisSpace space) {
        if (space == null) {
            space = new AxisSpace();
        }
        if (!this.isVisible()) {
            return space;
        }
        double dimension = this.getFixedDimension();
        if (dimension > 0.0) {
            space.ensureAtLeast(dimension, edge);
        }
        double tickLabelHeight = 0.0;
        double tickLabelWidth = 0.0;
        if (this.isTickLabelsVisible()) {
            List ticks = this.refreshTicks(canvas, new AxisState(), plotArea, edge);
            if (RectangleEdge.isTopOrBottom(edge)) {
                tickLabelHeight = this.findMaximumTickLabelHeight(ticks, canvas, plotArea, this.isVerticalTickLabels());
            } else if (RectangleEdge.isLeftOrRight(edge)) {
                tickLabelWidth = this.findMaximumTickLabelWidth(ticks, canvas, plotArea, this.isVerticalTickLabels());
            }
        }
        RectShape labelEnclosure = this.getLabelEnclosure(canvas, edge);
        double labelHeight = 0.0;
        double labelWidth = 0.0;
        if (RectangleEdge.isTopOrBottom(edge)) {
            labelHeight = labelEnclosure.getHeight();
            space.add(labelHeight + tickLabelHeight, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            labelWidth = labelEnclosure.getWidth();
            space.add(labelWidth + tickLabelWidth, edge);
        }
        return space;
    }

    protected double findMaximumTickLabelHeight(List ticks, Canvas canvas, RectShape drawArea, boolean vertical) {
        RectangleInsets insets = this.getTickLabelInsets();
        double maxHeight = 0.0;
        Paint paint = PaintUtility.createPaint(1, this.getTickLabelPaintType(), this.getTickLabelFont());
        if (vertical) {
            for (Tick tick : ticks) {
                RectShape labelBounds = TextUtilities.getTextBounds(tick.getText(), paint);
                if (!((double)labelBounds.getWidth() + insets.getTop() + insets.getBottom() > maxHeight)) continue;
                maxHeight = (double)labelBounds.getWidth() + insets.getTop() + insets.getBottom();
            }
        } else {
            RectShape labelBounds = TextUtilities.getTextBounds("ABCxyz", paint);
            maxHeight = (double)labelBounds.getHeight() + insets.getTop() + insets.getBottom();
        }
        return maxHeight;
    }

    protected double findMaximumTickLabelWidth(List ticks, Canvas canvas, RectShape drawArea, boolean vertical) {
        Paint paint = PaintUtility.createPaint(1, this.getTickLabelPaintType(), this.getTickLabelFont());
        RectangleInsets insets = this.getTickLabelInsets();
        double maxWidth = 0.0;
        if (!vertical) {
            for (Tick tick : ticks) {
                float labelWidth = TextUtilities.getTextWidth(tick.getText(), paint);
                if (!((double)labelWidth + insets.getLeft() + insets.getRight() > maxWidth)) continue;
                maxWidth = (double)labelWidth + insets.getLeft() + insets.getRight();
            }
        } else {
            RectShape labelBounds = TextUtilities.getTextBounds("ABCxyz", paint);
            maxWidth = (double)labelBounds.getHeight() + insets.getTop() + insets.getBottom();
        }
        return maxWidth;
    }

    public boolean isInverted() {
        return this.mInverted;
    }

    public void setInverted(boolean flag) {
        if (this.mInverted != flag) {
            this.mInverted = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean auto) {
        this.setAutoRange(auto, true);
    }

    protected void setAutoRange(boolean auto, boolean notify) {
        if (this.autoRange != auto) {
            this.autoRange = auto;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (notify) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(double size) {
        this.setAutoRangeMinimumSize(size, true);
    }

    public void setAutoRangeMinimumSize(double size, boolean notify) {
        if (size <= 0.0) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(double): must be > 0.0.");
        }
        if (this.autoRangeMinimumSize != size) {
            this.autoRangeMinimumSize = size;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (notify) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public Range getDefaultAutoRange() {
        return this.defaultAutoRange;
    }

    public void setDefaultAutoRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        this.defaultAutoRange = range;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double length) {
        this.fixedAutoRange = length;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerBound() {
        return this.mRange.getLowerBound();
    }

    public void setLowerBound(double min) {
        if (this.mRange.getUpperBound() > min) {
            this.setRange(new Range(min, this.mRange.getUpperBound()));
        } else {
            this.setRange(new Range(min, min + 1.0));
        }
    }

    public double getUpperBound() {
        return this.mRange.getUpperBound();
    }

    public void setUpperBound(double max) {
        if (this.mRange.getLowerBound() < max) {
            this.setRange(new Range(this.mRange.getLowerBound(), max));
        } else {
            this.setRange(max - 1.0, max);
        }
    }

    public Range getRange() {
        return this.mRange;
    }

    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    public void setRange(Range range, boolean turnOffAutoRange, boolean notify) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        if (turnOffAutoRange) {
            this.autoRange = false;
        }
        this.mRange = range;
        if (notify) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setRange(double lower, double upper) {
        this.setRange(new Range(lower, upper));
    }

    public void setRangeWithMargins(Range range) {
        this.setRangeWithMargins(range, true, true);
    }

    public void setRangeWithMargins(Range range, boolean turnOffAutoRange, boolean notify) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        this.setRange(Range.expand(range, this.getLowerMargin(), this.getUpperMargin()), turnOffAutoRange, notify);
    }

    public void setRangeWithMargins(double lower, double upper) {
        this.setRangeWithMargins(new Range(lower, upper));
    }

    public void setRangeAboutValue(double value, double length) {
        this.setRange(new Range(value - length / 2.0, value + length / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean flag) {
        this.setAutoTickUnitSelection(flag, true);
    }

    public void setAutoTickUnitSelection(boolean flag, boolean notify) {
        if (this.autoTickUnitSelection != flag) {
            this.autoTickUnitSelection = flag;
            if (notify) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnitSource source) {
        this.standardTickUnits = source;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int count) {
        this.minorTickCount = count;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isLimitAble() {
        return this.limitAble;
    }

    public void setLimitAble(boolean limitAble) {
        this.limitAble = limitAble;
    }

    public void setLimitRange(Range range) {
        this.limitRange = range;
    }

    public void setLimitRange(double lower, double upper) {
        this.limitRange = new Range(lower, upper);
    }

    public Range getLimitRange() {
        return this.limitRange;
    }

    public abstract double valueToJava2D(double var1, RectShape var3, RectangleEdge var4);

    public double lengthToJava2D(double length, RectShape area, RectangleEdge edge) {
        double zero = this.valueToJava2D(0.0, area, edge);
        double l = this.valueToJava2D(length, area, edge);
        return Math.abs(l - zero);
    }

    public abstract double java2DToValue(double var1, RectShape var3, RectangleEdge var4);

    protected abstract void autoAdjustRange();

    public void centerRange(double value) {
        double central = this.mRange.getCentralValue();
        Range adjusted = new Range(this.mRange.getLowerBound() + value - central, this.mRange.getUpperBound() + value - central);
        this.setRange(adjusted);
    }

    public void resizeRange(double percent) {
        this.resizeRange(percent, this.mRange.getCentralValue());
    }

    public void resizeRange(double percent, double anchorValue) {
        if (percent > 0.0) {
            double halfLength = this.mRange.getLength() * percent / 2.0;
            double lower = anchorValue - halfLength;
            double upper = anchorValue + halfLength;
            if (this.isLimitAble() && this.limitRange != null) {
                double tmp = this.limitRange.getUpperBound();
                if (upper > tmp) {
                    upper = tmp;
                }
                if (lower < (tmp = this.limitRange.getLowerBound())) {
                    lower = tmp;
                }
            }
            Range adjusted = new Range(lower, upper);
            this.setRange(adjusted);
        } else {
            this.setAutoRange(true);
        }
    }

    public void resizeRange2(double percent, double anchorValue) {
        if (percent > 0.0) {
            double left = anchorValue - this.getLowerBound();
            double right = this.getUpperBound() - anchorValue;
            Range adjusted = new Range(anchorValue - left * percent, anchorValue + right * percent);
            this.setRange(adjusted);
        } else {
            this.setAutoRange(true);
        }
    }

    public void zoomRange(double lowerPercent, double upperPercent) {
        double start = this.mRange.getLowerBound();
        double length = this.mRange.getLength();
        Range adjusted = null;
        adjusted = this.isInverted() ? new Range(start + length * (1.0 - upperPercent), start + length * (1.0 - lowerPercent)) : new Range(start + length * lowerPercent, start + length * upperPercent);
        this.setRange(adjusted);
    }

    public void pan(double percent) {
        Range range = this.getRange();
        double length = range.getLength();
        double adj = length * percent;
        double lower = range.getLowerBound() + adj;
        double upper = range.getUpperBound() + adj;
        this.setRange(lower, upper);
    }

    protected int getAutoTickIndex() {
        return this.autoTickIndex;
    }

    protected void setAutoTickIndex(int index) {
        this.autoTickIndex = index;
    }

    public void moveRange(double movePercent) {
        double upper;
        double lower;
        double start = this.mRange.getLowerBound();
        double end = this.mRange.getUpperBound();
        double length = this.mRange.getLength();
        Range adjusted = null;
        if (this.isInverted()) {
            double moveBound = movePercent * length;
            lower = start - moveBound;
            upper = end - moveBound;
        } else {
            double moveBound = movePercent * length;
            lower = start + moveBound;
            upper = end + moveBound;
        }
        if (this.isLimitAble() && this.limitRange != null) {
            double tmp = this.limitRange.getLowerBound();
            if (lower < tmp) {
                lower = tmp;
                upper = tmp + (end - start);
            }
            if (upper > (tmp = this.limitRange.getUpperBound())) {
                upper = tmp;
                lower = tmp - (end - start);
            }
        }
        adjusted = new Range(lower, upper);
        this.setRange(adjusted);
    }

    public Object clone() throws CloneNotSupportedException {
        ValueAxis clone = (ValueAxis)super.clone();
        return clone;
    }
}

